Imports System
Imports System.Data
Imports System.Data.SqlClient
Partial Public Class detail
    Inherits System.Web.UI.Page
    Dim Conn As SqlConnection = New SqlConnection
    Dim dt As Date
    Dim ds As DataSet
    Dim ActiveDt As Date
    Dim Path As String

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Conn.ConnectionString = ConfigurationManager.ConnectionStrings("CalendarConnStr").ConnectionString
        Session("UseSessionActiveDt") = True
        If Not IsPostBack Then
            'Dim i = 0
            'For i = 0 To 10
            '    DDYear.Items.Add(New ListItem(Now.Year + i, Now.Year + i))
            'Next
        End If
        If Request.QueryString("EventId") <> Nothing And Session("ActiveDt").ToString <> "" Then

            ActiveDt = Session("ActiveDt")
            GetHolidaysFromDB()
            SetDatesForMonthYear()
            lnkBackToCalendar.Text = "< Back to " & FormatDateTime(ActiveDt, 1)
            Dim EventId As Integer
            EventId = Request.QueryString("EventId")
            Bind_Events_Detail_View(EventId)
            Bind_Event_Url(EventId)
            Bind_Events_Detail_Dates(EventId)
            Bind_Events_Detail_Contacts(EventId)
            Bind_For_DisplaySponsorLogo(EventId)
            Bind_For_DisplayEventsLogo(EventId)
            Bind_Daily()
        Else
            Response.Redirect("calendar.aspx")
        End If

    End Sub
    Protected Sub Bind_Events_Detail_View(ByVal EventID As Integer)
        Conn.Open()
        Dim EventDetailDataSet As New DataSet()
        Dim EventDetailSql As String = "Select c.category_text,e.event_title,e.short_description,e.long_description,e.timing" & _
        " From event_master e,event_category c" & _
        " Where(e.event_category = c.category_id And e.event_id = " & EventID & ")"
        Dim EventDetailAdapter As New SqlDataAdapter(EventDetailSql, Conn)
        EventDetailAdapter.Fill(EventDetailDataSet)
        If (EventDetailDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrEventDetail.DataSource = EventDetailDataSet
            Me.rptrEventDetail.DataBind()
            If IsDBNull(EventDetailDataSet.Tables(0).Rows(0)("timing")) Or EventDetailDataSet.Tables(0).Rows(0)("timing") = "" Then
                lblTime.Text = ""
                lblTimeDate.Text = ""
            Else
                lblTime.Text = "Time"
                lblTimeDate.Text = EventDetailDataSet.Tables(0).Rows(0)("timing")
            End If

        End If
        Conn.Close()
    End Sub
    Protected Sub Bind_Events_Detail_Dates(ByVal EventID As Integer)
        Conn.Open()
        Dim EventDateDataSet As New DataSet()
        Dim EventDateSql As String = "Select DATENAME(weekday, d.start_date)+', '+DATENAME( MM, d.start_date) + RIGHT(CONVERT(VARCHAR(12), d.start_date, 107), 9) AS Start_date," & _
        " DATENAME(weekday, d.end_date)+', '+DATENAME( MM, d.end_date) + RIGHT(CONVERT(VARCHAR(12), d.end_date, 107), 9) AS end_date" & _
        " From event_daterange d Where event_id= " & EventID & ""
        Dim EventDateAdapter As New SqlDataAdapter(EventDateSql, Conn)
        EventDateAdapter.Fill(EventDateDataSet)
        If (EventDateDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrEventDates.DataSource = EventDateDataSet
            Me.rptrEventDates.DataBind()
        End If
        Conn.Close()
    End Sub
    Protected Sub Bind_Events_Detail_Contacts(ByVal EventID As Integer)
        Conn.Open()
        Dim EventContactDataSet As New DataSet()
        Dim EventContactSql As String = "Select contact_name,contact_emailid,contact_phoneno" & _
        " From event_contacts  Where event_id= " & EventID & ""
        Dim EventContactAdapter As New SqlDataAdapter(EventContactSql, Conn)
        EventContactAdapter.Fill(EventContactDataSet)
        If (EventContactDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrEventContacts.DataSource = EventContactDataSet
            Me.rptrEventContacts.DataBind()
        End If
        Conn.Close()
    End Sub
    Protected Sub Bind_For_DisplaySponsorLogo(ByVal EventID As Integer)
        Dim sponsorLogoSql As String
        sponsorLogoSql = "SELECT * FROM event_sponsors_logo WHERE event_id=" & EventID & ""
        Dim sponsorLogoAdapter As New SqlDataAdapter(sponsorLogoSql, Conn)
        Dim sponsorLogoDataTable As New DataTable
        sponsorLogoAdapter.Fill(sponsorLogoDataTable)
        If (sponsorLogoDataTable.Rows.Count > 0) Then
            dlSponsorLogo.DataSource = sponsorLogoDataTable
            dlSponsorLogo.DataBind()
            lblSponsor.Visible = True
        Else
            lblSponsor.Visible = False
        End If
    End Sub
    Protected Sub Bind_For_DisplayEventsLogo(ByVal EventID As Integer)
        Dim eventLogoSql As String
        eventLogoSql = "SELECT * FROM event_logo WHERE event_id=" & EventID & ""
        Dim eventLogoAdapter As New SqlDataAdapter(eventLogoSql, Conn)
        Dim eventLogoDataTable As New DataTable
        eventLogoAdapter.Fill(eventLogoDataTable)
        dlEventLogo.DataSource = eventLogoDataTable
        dlEventLogo.DataBind()
    End Sub

    Protected Sub Bind_Daily()
        Conn.Open()
        Dim DailyDataSet As New DataSet()
        Dim DailySql As String = "Select e.event_id,e.event_title,e.short_description" & _
        " From event_master e,event_daterange d " & _
        " Where e.event_id=d.event_id and e.status='True' and e.del_status='True' and is_everyday='True' " & _
        " Order by d.start_date"
        Dim DailyAdapter As New SqlDataAdapter(DailySql, Conn)
        DailyAdapter.Fill(DailyDataSet)
        If (DailyDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrDaily.DataSource = DailyDataSet
            Me.rptrDaily.DataBind()
        End If
        Conn.Close()
    End Sub
    Protected Sub Bind_Event_Url(ByVal EventID As Integer)
        Conn.Open()
        Dim EventUrlDataSet As New DataSet()
        Dim EventUrlSql As String = "Select url_title,url_link" & _
        " From event_urls  Where event_id= " & EventID & ""
        Dim EventUrlAdapter As New SqlDataAdapter(EventUrlSql, Conn)
        EventUrlAdapter.Fill(EventUrlDataSet)
        If (EventUrlDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrEventUrl.DataSource = EventUrlDataSet
            Me.rptrEventUrl.DataBind()
        End If
        Conn.Close()
    End Sub

#Region "MiniCalendar"

    Private Sub SetDatesForMonthYear()
        ' Dim MarkCurrentDateActive As Boolean = False
        If ActiveDt = Nothing Then
            ActiveDt = Now.Date
            ' MarkCurrentDateActive = True
        End If

        Dim yr As Integer = ActiveDt.Year
        Dim mnth As Integer = ActiveDt.Month
        Dim dt As New Date(yr, mnth, 1)
        Dim add As Date = DateAdd(DateInterval.Day, 30, dt)
        Dim LastDt As Date
        Dim firstday As Integer
        Dim k As Integer = 1
        RepaintCalendar()
        If add.Month <> dt.Month Then
            LastDt = DateAdd(DateInterval.Day, -add.Day, add)
        Else
            LastDt = add
        End If

        Dim arrLast() As Integer = GetWeekandDayFromDate(LastDt)
        Select Case arrLast(0)
            Case 6
                ShowInvisibleRows(6)
            Case 5
                HideEmptyRows(6)
                ShowInvisibleRows(5)
            Case 4
                HideEmptyRows(5)
        End Select

        'Dim arrNow() As Integer = GetWeekandDayFromDate(ActiveDt)
        Dim arrFirst() As Integer = GetWeekandDayFromDate(dt)
        Dim arrExcepDt() As Date
        Dim arrExcepSt() As Integer
        Dim arrExcepFn() As Integer

        Select Case dt.DayOfWeek
            Case DayOfWeek.Sunday
                s11.Text = 1
                firstday = 1
            Case DayOfWeek.Monday
                m12.Text = 1
                firstday = 2
            Case DayOfWeek.Tuesday
                t13.Text = 1
                firstday = 3
            Case DayOfWeek.Wednesday
                w14.Text = 1
                firstday = 4
            Case DayOfWeek.Thursday
                th15.Text = 1
                firstday = 5
            Case DayOfWeek.Friday
                f16.Text = 1
                firstday = 6
            Case DayOfWeek.Saturday
                sa17.Text = 1
                firstday = 7
        End Select


        For i As Integer = 1 To 6
            For j As Integer = 1 To 7
                Dim Holidaycleared As Boolean = False
                For Each hyp As Control In Me.calendarTable.Rows(i).Cells(j - 1).Controls
                    For Each dr As DataRow In ds.Tables(0).Rows
                        If dr("Holiday_Day_No") = j Then
                            arrExcepDt = HolidayExceptionsThisMonth(LastDt, dr)
                            If Not arrExcepDt Is Nothing Then
                                arrExcepSt = GetWeekandDayFromDate(arrExcepDt(0))
                                arrExcepFn = GetWeekandDayFromDate(arrExcepDt(1))
                                If ClearHoliday(i, j, arrExcepSt, arrExcepFn) Then
                                    Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Clear()
                                    Holidaycleared = True
                                ElseIf Not Holidaycleared Then
                                    Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                                End If
                            ElseIf Not Holidaycleared Then
                                Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                            End If
                        End If
                    Next

                    If arrLast(0) = i And arrLast(1) < j And arrLast(1) > 0 Then
                        Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                    ElseIf arrFirst(0) = i And arrFirst(1) > j Then
                        Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                    End If

                    If hyp.GetType.Name = "LinkButton" Then
                        If hyp.ID.EndsWith(i & j) Then
                            If k <= LastDt.Day Then
                                If i > 1 Or (i = 1 And j >= firstday) Then
                                    CType(hyp, LinkButton).Text = k
                                    CType(hyp, LinkButton).CommandArgument = New Date(ActiveDt.Year, ActiveDt.Month, k).ToString
                                    k = k + 1
                                End If
                            End If
                        End If
                    End If
                Next
            Next
        Next
        Me.HiddenField1.Value = ActiveDt
        ChangeCurrDateLabelText()

    End Sub

    Private Function ClearHoliday(ByVal i As Integer, ByVal j As Integer, ByVal arrSt As Integer(), ByVal arrFn As Integer()) As Boolean
        If i = arrSt(0) Then
            If i < arrFn(0) Then
                If j < arrSt(1) Then
                    Return False
                Else
                    Return True
                End If
            ElseIf i = arrFn(0) Then
                If j >= arrSt(1) And j <= arrFn(1) Then
                    Return True
                Else
                    Return False
                End If
            Else
                Return False
            End If
        ElseIf i > arrSt(0) Then
            If i < arrFn(0) Then
                Return True
            ElseIf i = arrFn(0) Then
                If j <= arrFn(1) Then
                    Return True
                Else
                    Return False
                End If
            End If
        End If
        Return False
    End Function

    Private Sub RepaintCalendar()
        For i As Integer = 1 To 6
            For j As Integer = 1 To 7
                For Each hyp As Control In Me.calendarTable.Rows(i).Cells(j - 1).Controls
                    If hyp.GetType.Name = "LinkButton" Then
                        CType(hyp, LinkButton).Text = ""
                    End If
                    Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Clear()
                Next
            Next
        Next
    End Sub

    Private Function HolidayExceptionsThisMonth(ByVal MF As Date, ByVal dr As DataRow) As Date()
        If IsDBNull(dr("startdate")) Or IsDBNull(dr("enddate")) Then Return Nothing

        Dim MB As New Date(ActiveDt.Year, ActiveDt.Month, 1)
        Dim HB As Date = dr("startdate")
        Dim HF As Date = dr("enddate")
        Dim arrExcep(1) As Date

        If MB >= HB Then
            If MB <= HF Then
                arrExcep(0) = MB
                If MF <= HF Then
                    arrExcep(1) = MF
                    Return arrExcep
                Else
                    arrExcep(1) = HF
                    Return arrExcep
                End If
            Else
                Return Nothing
            End If
        Else
            arrExcep(0) = HB
            If MF < HB Then
                Return Nothing
            Else
                If MF >= HF Then
                    arrExcep(1) = HF
                    Return arrExcep
                Else
                    arrExcep(1) = MF
                    Return arrExcep
                End If
            End If
        End If
        Return Nothing
    End Function

    Private Function GetWeekandDayFromDate(ByVal dt As Date) As Integer()
        Dim firstDay As New Date(dt.Year, dt.Month, 1)
        Dim AddDays As Integer = firstDay.DayOfWeek
        Dim days As Integer
        Dim Day As Integer = -1
        Dim Week As Integer = -1

        days = dt.Day + AddDays

        Week = Math.Ceiling(days / 7)
        Day = days Mod 7

        If Day = 0 Then Day = 7
        Dim arrWD() As Integer = {Week, Day}
        Return arrWD

    End Function

    Private Sub GetHolidaysFromDB()
        ds = New DataSet
        Dim str As String = "SELECT H.Holiday_Day_No, E.startdate,E.enddate FROM WeekDayHolidays H LEFT JOIN holiday_exception E on H.Holiday_ID = e.weekday_id"
        Dim adap As New SqlDataAdapter(str, conn)
        conn.Open()
        adap.Fill(ds)
        Conn.Close()
    End Sub

    Protected Sub LeftArrow_Click(ByVal s As Object, ByVal e As System.Web.UI.ImageClickEventArgs)
        Dim frstDt As New Date(ActiveDt.Year, ActiveDt.Month, 1)
        Session("ActiveDt") = DateAdd(DateInterval.Month, -1, frstDt)
        Response.Redirect("calendar.aspx")

    End Sub

    Private Sub RightArrow_Click(ByVal s As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles RightArrow.Click
        Dim frstDt As New Date(ActiveDt.Year, ActiveDt.Month, 1)
        Session("ActiveDt") = DateAdd(DateInterval.Month, 1, frstDt)
        Response.Redirect("calendar.aspx")

    End Sub

    Protected Sub MiniCalendarDate_Command(ByVal s As Object, ByVal e As CommandEventArgs) Handles s11.Command, m12.Command, t13.Command, w14.Command, th15.Command, f16.Command, sa17.Command, s21.Command, m22.Command, t23.Command, w24.Command, th25.Command, f26.Command, sa27.Command, s31.Command, m32.Command, t33.Command, w34.Command, th35.Command, f36.Command, sa37.Command, s41.Command, m42.Command, t43.Command, w44.Command, th45.Command, f46.Command, sa47.Command, s51.Command, m52.Command, t53.Command, w54.Command, th55.Command, f56.Command, sa57.Command, s61.Command, m62.Command, t63.Command, w64.Command, th65.Command, f66.Command, sa67.Command
        Session("ActiveDt") = CType(e.CommandArgument, Date)
        Response.Redirect("calendar.aspx")

    End Sub

    Protected Sub LinkBack_Click(ByVal s As Object, ByVal e As EventArgs) Handles lnkBackToCalendar.Click
        Response.Redirect("calendar.aspx")
    End Sub

    Private Sub ChangeCurrDateLabelText()
        Me.LblCurrMnth.Text = " " & GetMnthText(ActiveDt.Month) & " " & ActiveDt.Year & " "
    End Sub

    Private Sub ShowInvisibleRows(ByVal Rno As Integer)

        Me.TD51.Visible = True
        Me.TD52.Visible = True
        Me.TD53.Visible = True
        Me.TD54.Visible = True
        Me.TD55.Visible = True
        Me.TD56.Visible = True
        Me.TD57.Visible = True

        Me.s51.Visible = True
        Me.m52.Visible = True
        Me.t53.Visible = True
        Me.w54.Visible = True
        Me.th55.Visible = True
        Me.f56.Visible = True
        Me.sa57.Visible = True

        If Rno = 6 Then
            Me.TD61.Visible = True
            Me.TD62.Visible = True
            Me.TD63.Visible = True
            Me.TD64.Visible = True
            Me.TD65.Visible = True
            Me.TD66.Visible = True
            Me.TD67.Visible = True

            Me.s61.Visible = True
            Me.m62.Visible = True
            Me.t63.Visible = True
            Me.w64.Visible = True
            Me.th65.Visible = True
            Me.f66.Visible = True
            Me.sa67.Visible = True
        End If
    End Sub

    Private Sub HideEmptyRows(ByVal Rno As Integer)
        Me.TD61.Visible = False
        Me.TD62.Visible = False
        Me.TD63.Visible = False
        Me.TD64.Visible = False
        Me.TD65.Visible = False
        Me.TD66.Visible = False
        Me.TD67.Visible = False

        Me.s61.Visible = False
        Me.m62.Visible = False
        Me.t63.Visible = False
        Me.w64.Visible = False
        Me.th65.Visible = False
        Me.f66.Visible = False
        Me.sa67.Visible = False

        If Rno = 5 Then
            Me.TD51.Visible = False
            Me.TD52.Visible = False
            Me.TD53.Visible = False
            Me.TD54.Visible = False
            Me.TD55.Visible = False
            Me.TD56.Visible = False
            Me.TD57.Visible = False

            Me.s51.Visible = False
            Me.m52.Visible = False
            Me.t53.Visible = False
            Me.w54.Visible = False
            Me.th55.Visible = False
            Me.f56.Visible = False
            Me.sa57.Visible = False
        End If
    End Sub

    Private Function GetMnthText(ByVal mnth As Integer) As String
        Select Case mnth
            Case "1"
                Return "January"
            Case "2"
                Return "February"
            Case "3"
                Return "March"
            Case "4"
                Return "April"
            Case "5"
                Return "May"
            Case "6"
                Return "June"
            Case "7"
                Return "July"
            Case "8"
                Return "August"
            Case "9"
                Return "September"
            Case "10"
                Return "October"
            Case "11"
                Return "November"
            Case "12"
                Return "December"
            Case Else
                Return ""
        End Select
    End Function

    Private Function DayOfEdVentureWeek(ByVal dt As Date) As Integer
        Select Case dt.DayOfWeek
            Case DayOfWeek.Sunday
                Return 1
            Case DayOfWeek.Monday
                Return 2
            Case DayOfWeek.Tuesday
                Return 3
            Case DayOfWeek.Wednesday
                Return 4
            Case DayOfWeek.Thursday
                Return 5
            Case DayOfWeek.Friday
                Return 6
            Case DayOfWeek.Saturday
                Return 7
        End Select
    End Function

    Private Sub DDButton_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles DDButton.Click
        Try
            Session("ActiveDt") = New Date(DDYear.SelectedValue, DDMonth.SelectedValue, DDDay.SelectedValue)
        Catch ex As Exception
            Response.Redirect("detail.aspx")
        End Try
        Response.Redirect("calendar.aspx")
    End Sub
#End Region

End Class