Imports System
Imports System.Data
Imports System.Data.SqlClient
Partial Public Class calendar
    Inherits System.Web.UI.Page
    Dim Conn As SqlConnection = New SqlConnection
    Dim dt As Date
    Dim dsWeekDayHolidays As DataSet
    Dim dsSingleDayHolidays As DataSet
    Dim ActiveDt As Date
    Dim isActiveDtClosed As Boolean = False

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Conn.ConnectionString = ConfigurationManager.ConnectionStrings("CalendarConnStr").ConnectionString
        GetHolidaysFromDB()
        GetSingleDayClosingForThisMonth()
        If Session("ActiveDt").ToString <> "" Then
            ActiveDt = Session("ActiveDt")
        Else
            ActiveDt = Now.Date
        End If
        If Not IsPostBack Then
            SetDatesForMonthYear()
            Events_Bind(ActiveDt)
        End If
    End Sub
    
    Private Sub LimitYears()
        Dim minDt As Date = Now.Date
        Dim maxDt As New Date(2018, 12, 31)

        If ActiveDt < Now.Date Then
            Me.lblChooseDtError.Visible = True
        Else
            Me.lblChooseDtError.Visible = False
        End If

        If ActiveDt <= minDt Then
            ActiveDt = minDt
            Me.btnPrevDay.Enabled = False
            Me.btnPrevDay.Style.Add("cursor", "text")
        ElseIf ActiveDt >= maxDt Then
            ActiveDt = maxDt
            Me.btnNextDay.Enabled = False
            Me.btnNextDay.Style.Add("cursor", "text")
        End If
        If ActiveDt.Month = Now.Month And ActiveDt.Year = Now.Year Then
            Me.LeftArrow.Enabled = False
            Me.LeftArrow.Style.Add("cursor", "text")
        ElseIf ActiveDt.Month = maxDt.Month And ActiveDt.Year = maxDt.Year Then
            Me.RightArrow.Enabled = False
            Me.RightArrow.Style.Add("cursor", "text")
        End If

    End Sub
    Protected Sub MiniCalendarDate_Command(ByVal s As Object, ByVal e As CommandEventArgs) Handles s11.Command, m12.Command, t13.Command, w14.Command, th15.Command, f16.Command, sa17.Command, s21.Command, m22.Command, t23.Command, w24.Command, th25.Command, f26.Command, sa27.Command, s31.Command, m32.Command, t33.Command, w34.Command, th35.Command, f36.Command, sa37.Command, s41.Command, m42.Command, t43.Command, w44.Command, th45.Command, f46.Command, sa47.Command, s51.Command, m52.Command, t53.Command, w54.Command, th55.Command, f56.Command, sa57.Command, s61.Command, m62.Command, t63.Command, w64.Command, th65.Command, f66.Command, sa67.Command
        ActiveDt = CType(e.CommandArgument, Date)
        SetDatesForMonthYear()
        Events_Bind(ActiveDt)
    End Sub

    Protected Sub Events_Bind(ByVal ActiveDate As Date)
        dt = ActiveDate
        'Dim suffix As String
        'If (Now.Day = 1) Then : suffix = "st"
        'ElseIf (Now.Day = 2) Then : suffix = "nd"
        'ElseIf (Now.Day = 3) Then : suffix = "rd"
        'ElseIf (Now.Day = 21) Then : suffix = "st"
        'ElseIf (Now.Day = 22) Then : suffix = "nd"
        'ElseIf (Now.Day = 23) Then : suffix = "rd"
        'ElseIf (Now.Day = 31) Then : suffix = "st"
        'Else : suffix = "th"
        'End If
        'lblToday.Text = Format(dt.Date, "MMMM ") & dt.Day & "<sup>" & suffix & "</sup>" & Format(dt.Date, ", yyyy")
        lblToday.Text = Format(dt.Date, "MMMM ") & dt.Day & Format(dt.Date, ", yyyy")
        lblCurrentDate.Text = FormatDateTime(dt, 1)
        DDMonth.SelectedValue = dt.Month
        DDDay.SelectedValue = dt.Day
        DDYear.SelectedValue = dt.Year
        Bind_Daily(dt)
        Bind_Comming_Soon(dt)

        If ShowHolidayMessageFromDB() Then Exit Sub
        Bind_Default_View(ActiveDate)
        'Bind_Active_Events(dt)

    End Sub

    Protected Sub Bind_Default_View(ByVal ActiveDate As Date)
        Conn.Open()
        Dim FieldName As String = ""
        If DayOfEdVentureWeek(ActiveDate) = 1 Then
            FieldName = "on_sundays"
        ElseIf DayOfEdVentureWeek(ActiveDate) = 2 Then
            FieldName = "on_mondays"
        ElseIf DayOfEdVentureWeek(ActiveDate) = 3 Then
            FieldName = "on_tuesdays"
        ElseIf DayOfEdVentureWeek(ActiveDate) = 4 Then
            FieldName = "on_wednesdays"
        ElseIf DayOfEdVentureWeek(ActiveDate) = 5 Then
            FieldName = "on_thursdays"
        ElseIf DayOfEdVentureWeek(ActiveDate) = 6 Then
            FieldName = "on_fridays"
        ElseIf DayOfEdVentureWeek(ActiveDate) = 7 Then
            FieldName = "on_saturdays"
        End If
        Dim DefaultViewDataSet As New DataSet()
        Dim strCategories As String = "DECLARE @tbl1 TABLE(event_id int,st_dt datetime,end_dt datetime)" & _
                                        "INSERT INTO @tbl1 " & _
                                        "SELECT e.event_id,d.start_date,d.end_date " & _
                                        "FROM event_master e JOIN event_daterange d " & _
                                        "ON e.event_id=d.event_id " & _
                                        "WHERE(d.start_date <='" & ActiveDt & "' And d.end_date >='" & ActiveDt & "') " & _
                                        "DECLARE @tbl2 TABLE(event_id int, max_Dt int) " & _
                                        "INSERT INTO @tbl2 " & _
                                        "SELECT T.event_id,MAX(DATEDIFF(dd,'" & ActiveDt & "',T.end_dt)) " & _
                                        "FROM @tbl1 T " & _
                                        "GROUP BY T.event_id " & _
                                        "SELECT DISTINCT e1.event_category,c1.Category_text,c1.Display_order " & _
                                        "FROM event_master e1 JOIN event_category c1 ON e1.event_category=c1.category_id " & _
                                        "JOIN event_daterange d1 on e1.event_id=d1.event_id JOIN @tbl2 T2 on d1.event_id=T2.event_id " & _
                                        "WHERE e1.status='True' and e1.del_status='True' and e1." & FieldName & "='True' and e1.is_everyday='False'  And DATEDIFF(dd,'" & ActiveDt & "',d1.end_date)=T2.max_Dt " & _
                                        "ORDER BY c1.Display_order"
        Dim CategoryAdapter As New SqlDataAdapter(strCategories, Conn)
        CategoryAdapter.Fill(DefaultViewDataSet, "Category")
        Dim DefaultViewSql As String = "DECLARE @tbl1 TABLE(event_id int,st_dt datetime,end_dt datetime)" & _
                                        "INSERT INTO @tbl1 " & _
                                        "SELECT e.event_id,d.start_date,d.end_date " & _
                                        "FROM event_master e JOIN event_daterange d " & _
                                        "ON e.event_id=d.event_id " & _
                                        "WHERE(d.start_date <='" & ActiveDt & "' And d.end_date >='" & ActiveDt & "') " & _
                                        "DECLARE @tbl2 TABLE(event_id int, max_Dt int) " & _
                                        "INSERT INTO @tbl2 " & _
                                        "SELECT T.event_id,MAX(DATEDIFF(dd,'" & ActiveDt & "',T.end_dt)) " & _
                                        "FROM @tbl1 T " & _
                                        "GROUP BY T.event_id " & _
                                        "SELECT DISTINCT e1.event_id,e1.event_title,e1.short_description,e1.event_category,c1.Category_text,c1.Display_order, " & _
                                        "CASE(e1.dt_range_status) WHEN 'True' THEN ' ' Else " & _
                                        "DATENAME(weekday,d1.start_date) + ', ' + DATENAME(MM,d1.start_date) + ' ' + CAST(DATEPART(dd,d1.start_date) as CHAR(2)) + ', ' + CAST(DATEPART(yyyy,d1.start_date) as CHAR(4)) + ' - ' + DATENAME(weekday,d1.end_date) + ', ' + DATENAME(MM,d1.end_date) + ' ' + CAST(DATEPART(dd,d1.end_date) as CHAR(2)) + ', ' + CAST(DATEPART(yyyy,d1.end_date) as CHAR(4)) END as event_dt " & _
                                        "FROM event_master e1 JOIN event_category c1 ON e1.event_category=c1.category_id " & _
                                        "JOIN event_daterange d1 on e1.event_id=d1.event_id JOIN @tbl2 T2 on d1.event_id=T2.event_id " & _
                                        "WHERE e1.status='True' and e1.del_status='True' and e1." & FieldName & "='True' and e1.is_everyday='False' And DATEDIFF(dd,'" & ActiveDt & "',d1.end_date)=T2.max_Dt " & _
                                        "ORDER BY c1.Display_order"

        ''Dim DefaultViewSql As String = "SELECT Distinct c.display_order,e.event_id, e.event_category,e.event_title,e.short_description,c.category_text, DATENAME(weekday,d.start_date) + ', ' + DATENAME(MM,d.start_date) + ' ' + CAST(DATEPART(dd,d.start_date) as CHAR(2)) + ', ' + CAST(DATEPART(yyyy,d.start_date) as CHAR(4)) + ' - ' + DATENAME(weekday,d.end_date) + ', ' + DATENAME(MM,d.end_date) + ' ' + CAST(DATEPART(dd,d.end_date) as CHAR(2)) + ', ' + CAST(DATEPART(yyyy,d.end_date) as CHAR(4)) as event_dt from event_master e JOIN event_daterange d on e.event_id = d.event_id JOIN  event_category c on e.event_category=c.category_id Where d.start_date<='" & ActiveDate & "' and d.end_date>='" & ActiveDate & "' and e.status='True' and e.del_status='True' and  " & FieldName & "='True' and e.is_everyday='False' order by c.display_order "
        Dim DefaultViewAdapter As New SqlDataAdapter(DefaultViewSql, Conn)
        DefaultViewAdapter.Fill(DefaultViewDataSet, "Details")
        DefaultViewDataSet.Relations.Add("Category_Details", DefaultViewDataSet.Tables("Category").Columns("event_category"), DefaultViewDataSet.Tables("Details").Columns("event_category"))

        If (DefaultViewDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrDefaultView.DataSource = DefaultViewDataSet.Tables("Category")
            Me.rptrDefaultView.DataBind()
            Me.rptrDefaultView.Visible = True
        Else
            Me.rptrDefaultView.Visible = False
        End If
        Conn.Close()
    End Sub


    Protected Sub Bind_Comming_Soon(ByVal ActiveDate As Date)
        Conn.Open()
        Dim CommingSoonDataSet As New DataSet()
        Dim MonthSql As String = "DECLARE @tbl TABLE(event_id int,minDate int) " & _
                                    "INSERT INTO @tbl SELECT d1.event_id, " & _
                                    "(DateDiff(dd,'" & ActiveDt & "', d1.start_date)) " & _
                                    "FROM event_daterange d1 " & _
                                    "WHERE(DateDiff(dd,'" & ActiveDt & "', d1.start_date)) > 0 AND DateDiff(dd,'" & ActiveDt & "', d1.start_date)<=60 " & _
                                    "DECLARE @tbl2 TABLE(event_id int, minDate int) " & _
                                    "INSERT INTO @tbl2 SELECT event_id ,MIN(minDate) " & _
                                    "FROM @tbl T GROUP BY event_id " & _
                                    "SELECT DISTINCT DATENAME(MM,d.start_date) + ', ' + CAST(DATEPART(yyyy,d.start_date) as CHAR(4)) as StartMonth, " & _
                                    "DATEADD(dd,-DATEPART(dd,d.start_date)+1,d.start_date) as mnth " & _
                                    "FROM event_daterange d JOIN @tbl2 T on DATEDIFF(dd,'" & ActiveDt & "',d.start_date)= T.minDate " & _
                                    "JOIN event_master e on d.event_id=e.event_id " & _
                                    "WHERE e.is_everyday='False' AND e.iscoming_soon='True' AND e.status='True' AND e.del_status='True' ORDER BY mnth "

        Dim MonthAdapter As New SqlDataAdapter(MonthSql, Conn)
        MonthAdapter.Fill(CommingSoonDataSet, "Months")

        Dim CommingSoonSql As String = "DECLARE @tbl TABLE(event_id int,minDate int) " & _
                                    "INSERT INTO @tbl SELECT d1.event_id, " & _
                                    "(DateDiff(dd,'" & ActiveDt & "', d1.start_date)) " & _
                                    "FROM event_daterange d1 " & _
                                    "WHERE(DateDiff(dd,'" & ActiveDt & "', d1.start_date)) > 0 AND DateDiff(dd,'" & ActiveDt & "', d1.start_date)<=60 " & _
                                    "DECLARE @tbl2 TABLE(event_id int, minDate int) " & _
                                    "INSERT INTO @tbl2 SELECT event_id ,MIN(minDate) " & _
                                    "FROM @tbl T GROUP BY event_id " & _
                                    "SELECT DISTINCT d.event_id, d.start_date, e.event_title, " & _
                                    "e.short_description, " & _
                                    "DATENAME(MM,d.start_date) + ', ' + CAST(DATEPART(yyyy,d.start_date) as CHAR(4)) as StartMonth, " & _
                                    "CASE(e.dt_range_status) WHEN 'True' THEN ' ' Else " & _
                                    "DATENAME(MM,d.start_date) + ' ' + CAST(DATEPART(dd,d.start_date) " & _
                                    "as CHAR(2)) + ', ' + CAST(DATEPART(yyyy,d.start_date) as CHAR(4)) " & _
                                    " END as event_dt,d.start_date " & _
                                    "FROM event_daterange d JOIN @tbl2 T on DATEDIFF(dd,'" & ActiveDt & "',d.start_date)= T.minDate " & _
                                    "JOIN event_master e on d.event_id=e.event_id " & _
                                    "WHERE e.is_everyday='False' AND e.iscoming_soon='True' AND e.status='True' AND e.del_status='True' Order by d.start_date "

        Dim CommingSoonAdapter As New SqlDataAdapter(CommingSoonSql, Conn)
        CommingSoonAdapter.Fill(CommingSoonDataSet, "Details")
        CommingSoonDataSet.Relations.Add("Months_Details", CommingSoonDataSet.Tables("Months").Columns("StartMonth"), CommingSoonDataSet.Tables("Details").Columns("StartMonth"))

        If (CommingSoonDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrComingsoon.DataSource = CommingSoonDataSet
            Me.rptrComingsoon.DataBind()
            Me.rptrComingsoon.Visible = True
            Me.Upcoming.Visible = True
        Else
            Me.rptrComingsoon.Visible = False
            Me.Upcoming.Visible = False
        End If
        Conn.Close()
    End Sub

    Protected Sub Bind_Daily(ByVal ActiveDate As Date)
        Conn.Open()
        Dim DailyDataSet As New DataSet()
        Dim DailySql As String = "Select e.event_id,e.event_title,e.short_description" & _
                " From event_master e Where e.status='True' and e.del_status='True' and e.is_everyday='True' "
        Dim DailyAdapter As New SqlDataAdapter(DailySql, Conn)
        DailyAdapter.Fill(DailyDataSet)
        If (DailyDataSet.Tables(0).Rows.Count > 0) Then
            Me.rptrDaily.Visible = True
            Me.rptrDaily.DataSource = DailyDataSet
            Me.rptrDaily.DataBind()
        Else
            Me.rptrDaily.Visible = False
        End If
        Conn.Close()
    End Sub

   
#Region "MiniCalendar"

    Private Sub SetDatesForMonthYear()

        If ActiveDt = Nothing Then
            ActiveDt = Now.Date
        End If
        RepaintCalendar()
        LimitYears()
        Dim yr As Integer = ActiveDt.Year
        Dim mnth As Integer = ActiveDt.Month
        Dim dt As New Date(yr, mnth, 1)
        Dim add As Date = DateAdd(DateInterval.Day, 30, dt)
        Dim LastDt As Date
        Dim firstday As Integer
        Dim k As Integer = 1

        If add.Month <> dt.Month Then
            LastDt = DateAdd(DateInterval.Day, -add.Day, add)
        Else
            LastDt = add
        End If

        Dim arrLast() As Integer = GetWeekandDayFromDate(LastDt)
        Select Case arrLast(0)
            Case 6
                ShowInvisibleRows(6)
            Case 5
                HideEmptyRows(6)
                ShowInvisibleRows(5)
            Case 4
                HideEmptyRows(5)
        End Select

        Dim arrActiveDt() As Integer = GetWeekandDayFromDate(ActiveDt)
        Dim arrFirst() As Integer = GetWeekandDayFromDate(dt)
        Dim arrExcepDt() As Date
        Dim arrExcepSt() As Integer
        Dim arrExcepFn() As Integer
        Dim arrSingleDayCl() As Integer
        Dim arrNow() As Integer = GetWeekandDayFromDate(Now.Date)

        Select Case dt.DayOfWeek
            Case DayOfWeek.Sunday
                s11.Text = 1
                firstday = 1
            Case DayOfWeek.Monday
                m12.Text = 1
                firstday = 2
            Case DayOfWeek.Tuesday
                t13.Text = 1
                firstday = 3
            Case DayOfWeek.Wednesday
                w14.Text = 1
                firstday = 4
            Case DayOfWeek.Thursday
                th15.Text = 1
                firstday = 5
            Case DayOfWeek.Friday
                f16.Text = 1
                firstday = 6
            Case DayOfWeek.Saturday
                sa17.Text = 1
                firstday = 7
        End Select

        For i As Integer = 1 To 6
            For j As Integer = 1 To 7
                Dim Holidaycleared As Boolean = False
                For Each hyp As Control In Me.calendarTable.Rows(i).Cells(j - 1).Controls
                    For Each dr As DataRow In dsWeekDayHolidays.Tables(0).Rows
                        If dr("Holiday_Day_No") = j Then
                            arrExcepDt = HolidayExceptionsThisMonth(LastDt, dr)
                            If Not arrExcepDt Is Nothing Then
                                arrExcepSt = GetWeekandDayFromDate(arrExcepDt(0))
                                arrExcepFn = GetWeekandDayFromDate(arrExcepDt(1))
                                If ClearHoliday(i, j, arrExcepSt, arrExcepFn) Then
                                    Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Clear()
                                    Holidaycleared = True
                                ElseIf Not Holidaycleared Then
                                    Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                                End If
                            ElseIf Not Holidaycleared Then
                                Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                            End If
                        End If
                    Next

                    For Each dr As DataRow In Me.dsSingleDayHolidays.Tables(0).Rows
                        If Not IsDBNull(dr("ClosedDate")) Then
                            If dr("ClosedDate") >= dt And dr("ClosedDate") <= LastDt Then
                                arrSingleDayCl = GetWeekandDayFromDate(dr("ClosedDate"))
                                If i = arrSingleDayCl(0) And j = arrSingleDayCl(1) Then
                                    Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                                End If
                            End If
                        End If
                    Next

                    If arrLast(0) = i And arrLast(1) < j And arrLast(1) > 0 Then
                        Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                    ElseIf arrFirst(0) = i And arrFirst(1) > j Then
                        Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-off")
                    End If

                    If arrActiveDt(0) = i And arrActiveDt(1) = j Then
                        If Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Count > 0 Then
                            If Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Item("class") <> "day-off" Then
                                Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-on")
                            Else
                                isActiveDtClosed = True
                                Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "currentday-off")
                            End If
                        Else
                            Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Add("class", "day-on")
                        End If
                    End If

                    If hyp.GetType.Name = "LinkButton" Then
                        If hyp.ID.EndsWith(i & j) Then
                            If k <= LastDt.Day Then
                                If i > 1 Or (i = 1 And j >= firstday) Then
                                    CType(hyp, LinkButton).Text = k
                                    CType(hyp, LinkButton).CommandArgument = New Date(ActiveDt.Year, ActiveDt.Month, k).ToString
                                    k = k + 1
                                End If
                            End If
                            If ActiveDt.Month = Now.Month And ActiveDt.Year = Now.Year Then
                                If CType(hyp, LinkButton).Text <> "" Then
                                    If CType(hyp, LinkButton).Text < Now.Day Then
                                        CType(hyp, LinkButton).Enabled = False
                                        CType(hyp, LinkButton).Attributes.Add("class", "past-date")
                                    End If
                                End If
                            End If
                        End If
                    End If
                Next
            Next
        Next
        Session("ActiveDt") = ActiveDt
        ChangeCurrDateLabelText()

    End Sub

    Private Function ClearHoliday(ByVal i As Integer, ByVal j As Integer, ByVal arrSt As Integer(), ByVal arrFn As Integer()) As Boolean
        If i = arrSt(0) Then
            If i < arrFn(0) Then
                If j < arrSt(1) Then
                    Return False
                Else
                    Return True
                End If
            ElseIf i = arrFn(0) Then
                If j >= arrSt(1) And j <= arrFn(1) Then
                    Return True
                Else
                    Return False
                End If
            Else
                Return False
            End If
        ElseIf i > arrSt(0) Then
            If i < arrFn(0) Then
                Return True
            ElseIf i = arrFn(0) Then
                If j <= arrFn(1) Then
                    Return True
                Else
                    Return False
                End If
            End If
        End If
        Return False
    End Function

    Private Sub RepaintCalendar()
        For i As Integer = 1 To 6
            For j As Integer = 1 To 7
                For Each hyp As Control In Me.calendarTable.Rows(i).Cells(j - 1).Controls
                    If hyp.GetType.Name = "LinkButton" Then
                        CType(hyp, LinkButton).Text = ""
                        CType(hyp, LinkButton).Attributes.Clear()
                        CType(hyp, LinkButton).Enabled = True
                    End If
                    Me.calendarTable.Rows(i).Cells(j - 1).Attributes.Clear()
                Next
            Next
        Next
        Me.LeftArrow.Enabled = True
        Me.LeftArrow.Style.Clear()
        Me.btnPrevDay.Enabled = True
        Me.btnPrevDay.Style.Clear()
        Me.RightArrow.Enabled = True
        Me.RightArrow.Style.Clear()
        Me.btnNextDay.Enabled = True
        Me.btnNextDay.Style.Clear()
    End Sub

    Private Function HolidayExceptionsThisMonth(ByVal MF As Date, ByVal dr As DataRow) As Date()
        If IsDBNull(dr("startdate")) Or IsDBNull(dr("enddate")) Then Return Nothing
        Dim MB As New Date(ActiveDt.Year, ActiveDt.Month, 1)
        Dim HB As Date = dr("startdate")
        Dim HF As Date = dr("enddate")
        Dim arrExcep(1) As Date

        If MB >= HB Then
            If MB <= HF Then
                arrExcep(0) = MB
                If MF <= HF Then
                    arrExcep(1) = MF
                    Return arrExcep
                Else
                    arrExcep(1) = HF
                    Return arrExcep
                End If
            Else
                Return Nothing
            End If
        Else
            arrExcep(0) = HB
            If MF < HB Then
                Return Nothing
            Else
                If MF >= HF Then
                    arrExcep(1) = HF
                    Return arrExcep
                Else
                    arrExcep(1) = MF
                    Return arrExcep
                End If
            End If
        End If
        Return Nothing
    End Function

    Private Function GetWeekandDayFromDate(ByVal dt As Date) As Integer()
        Dim firstDay As New Date(dt.Year, dt.Month, 1)
        Dim AddDays As Integer = firstDay.DayOfWeek
        Dim days As Integer
        Dim Day As Integer = -1
        Dim Week As Integer = -1

        days = dt.Day + AddDays

        Week = Math.Ceiling(days / 7)
        Day = days Mod 7

        If Day = 0 Then Day = 7
        Dim arrWD() As Integer = {Week, Day}
        Return arrWD

    End Function

    Private Sub GetHolidaysFromDB()
        dsWeekDayHolidays = New DataSet
        Dim str As String = "SELECT H.Holiday_Day_No, E.startdate,E.enddate,H.Message FROM WeekDayHolidays H LEFT JOIN holiday_exception E on H.Holiday_ID = e.weekday_id"
        Dim adap As New SqlDataAdapter(str, conn)
        conn.Open()
        adap.Fill(dsWeekDayHolidays)
        Conn.Close()
    End Sub

    Private Sub GetSingleDayClosingForThisMonth()
        dsSingleDayHolidays = New DataSet
        Dim str As String = "SELECT H.ClosedDate,H.Message FROM SingleDayClosing H"
        Dim adap As New SqlDataAdapter(str, Conn)
        Conn.Open()
        adap.Fill(Me.dsSingleDayHolidays)
        Conn.Close()
    End Sub

    Protected Sub LeftArrow_Click(ByVal s As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles LeftArrow.Click
        Dim frstDt As New Date(ActiveDt.Year, ActiveDt.Month, 1)
        ActiveDt = DateAdd(DateInterval.Month, -1, frstDt)
        SetDatesForMonthYear()
        Events_Bind(ActiveDt)

    End Sub

    Protected Sub RightArrow_Click(ByVal s As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles RightArrow.Click
        Dim frstDt As New Date(ActiveDt.Year, ActiveDt.Month, 1)
        ActiveDt = DateAdd(DateInterval.Month, 1, frstDt)
        SetDatesForMonthYear()
        Events_Bind(ActiveDt)

    End Sub

    Protected Sub btnPrevDay_Click(ByVal s As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnPrevDay.Click
        ActiveDt = DateAdd(DateInterval.Day, -1, ActiveDt)
        SetDatesForMonthYear()
        Events_Bind(ActiveDt)

    End Sub

    Protected Sub btnNextDay_Click(ByVal s As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnNextDay.Click
        ActiveDt = DateAdd(DateInterval.Day, 1, ActiveDt)
        SetDatesForMonthYear()
        Events_Bind(ActiveDt)
        ' Session("ActiveDt") = ActiveDt
    End Sub

    Private Sub ChangeCurrDateLabelText()
        Me.LblCurrMnth.Text = " " & GetMnthText(ActiveDt.Month) & " " & ActiveDt.Year & " "
    End Sub

    Private Sub ShowInvisibleRows(ByVal Rno As Integer)

        Me.TD51.Visible = True
        Me.TD52.Visible = True
        Me.TD53.Visible = True
        Me.TD54.Visible = True
        Me.TD55.Visible = True
        Me.TD56.Visible = True
        Me.TD57.Visible = True

        Me.s51.Visible = True
        Me.m52.Visible = True
        Me.t53.Visible = True
        Me.w54.Visible = True
        Me.th55.Visible = True
        Me.f56.Visible = True
        Me.sa57.Visible = True

        If Rno = 6 Then
            Me.TD61.Visible = True
            Me.TD62.Visible = True
            Me.TD63.Visible = True
            Me.TD64.Visible = True
            Me.TD65.Visible = True
            Me.TD66.Visible = True
            Me.TD67.Visible = True

            Me.s61.Visible = True
            Me.m62.Visible = True
            Me.t63.Visible = True
            Me.w64.Visible = True
            Me.th65.Visible = True
            Me.f66.Visible = True
            Me.sa67.Visible = True
        End If
    End Sub

    Private Sub HideEmptyRows(ByVal Rno As Integer)
        Me.TD61.Visible = False
        Me.TD62.Visible = False
        Me.TD63.Visible = False
        Me.TD64.Visible = False
        Me.TD65.Visible = False
        Me.TD66.Visible = False
        Me.TD67.Visible = False

        Me.s61.Visible = False
        Me.m62.Visible = False
        Me.t63.Visible = False
        Me.w64.Visible = False
        Me.th65.Visible = False
        Me.f66.Visible = False
        Me.sa67.Visible = False

        If Rno = 5 Then
            Me.TD51.Visible = False
            Me.TD52.Visible = False
            Me.TD53.Visible = False
            Me.TD54.Visible = False
            Me.TD55.Visible = False
            Me.TD56.Visible = False
            Me.TD57.Visible = False

            Me.s51.Visible = False
            Me.m52.Visible = False
            Me.t53.Visible = False
            Me.w54.Visible = False
            Me.th55.Visible = False
            Me.f56.Visible = False
            Me.sa57.Visible = False
        End If
    End Sub

    Private Function GetMnthText(ByVal mnth As Integer) As String
        Select Case mnth
            Case "1"
                Return "January"
            Case "2"
                Return "February"
            Case "3"
                Return "March"
            Case "4"
                Return "April"
            Case "5"
                Return "May"
            Case "6"
                Return "June"
            Case "7"
                Return "July"
            Case "8"
                Return "August"
            Case "9"
                Return "September"
            Case "10"
                Return "October"
            Case "11"
                Return "November"
            Case "12"
                Return "December"
            Case Else
                Return ""
        End Select
    End Function

    Private Function ShowHolidayMessageFromDB() As Boolean
        If Me.isActiveDtClosed Then
            For Each dr As DataRow In Me.dsSingleDayHolidays.Tables(0).Rows
                If Not IsDBNull(dr("ClosedDate")) Then
                    If ActiveDt = dr("ClosedDate") Then
                        If Not IsDBNull(dr("Message")) Then
                            Me.lblHolidayMsg.Text = dr("Message")
                        Else
                            Me.lblHolidayMsg.Text = ""
                        End If
                        Return True
                    End If
                End If
            Next
            For Each dr As DataRow In Me.dsWeekDayHolidays.Tables(0).Rows
                If dr("Holiday_Day_No") = Me.DayOfEdVentureWeek(ActiveDt) Then
                    If Not IsDBNull(dr("Message")) Then
                        Me.lblHolidayMsg.Text = dr("Message")
                    Else
                        Me.lblHolidayMsg.Text = ""
                    End If
                    Return True
                End If
            Next
        End If

    End Function

    Private Function DayOfEdVentureWeek(ByVal dt As Date) As Integer
        Select Case dt.DayOfWeek
            Case DayOfWeek.Sunday
                Return 1
            Case DayOfWeek.Monday
                Return 2
            Case DayOfWeek.Tuesday
                Return 3
            Case DayOfWeek.Wednesday
                Return 4
            Case DayOfWeek.Thursday
                Return 5
            Case DayOfWeek.Friday
                Return 6
            Case DayOfWeek.Saturday
                Return 7
        End Select
    End Function

#End Region
    Protected Sub DDButton_Click(ByVal sender As System.Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles DDButton.Click
        Try
            ActiveDt = New Date(DDYear.SelectedValue, DDMonth.SelectedValue, DDDay.SelectedValue)
        Catch ex As Exception
            Response.Redirect("calendar.aspx")
        End Try
        SetDatesForMonthYear()
        Events_Bind(ActiveDt)
    End Sub

End Class