Imports System
Imports System.Data
Imports System.Data.SqlClient
Partial Public Class _Event
    Inherits System.Web.UI.Page
    Dim Conn As SqlConnection = New SqlConnection

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Conn.ConnectionString = ConfigurationManager.ConnectionStrings("CalendarConnStr").ConnectionString
        If Session("user_id") = "" Then
            Response.Redirect("Login.aspx")
            Exit Sub
        End If
        If Not IsPostBack Then
            Bind_EventsList_data()      
        End If
        btnModalDelete.OnClientClick = String.Format("fnClickDelete('{0}','{1}')", btnModalDelete.UniqueID, "")
    End Sub
    Protected Sub Bind_EventsList_data()
        lblMessage.Text = ""
        Dim EventDataSet As New DataSet()
        Dim EventSql As String = "SELECT event_master.event_id,event_master.event_title, event_master.status, event_category.Category_text, " & _
                                 "DATENAME(weekday, daterange.start_date)+', '+DATENAME( MM, daterange.start_date) + RIGHT(CONVERT(VARCHAR(12), daterange.start_date, 107), 9) +'-'+  " & _
                                 "DATENAME(weekday, daterange.end_date)+', '+DATENAME( MM, daterange.end_date) + RIGHT(CONVERT(VARCHAR(12), daterange.end_date, 107), 9) AS st_end_date , " & _
                                 "event_master.is_everyday, event_master.iscoming_soon FROM event_category JOIN  " & _
                                 "event_master ON event_category.category_id = event_master.event_category  JOIN " & _
                                 "(select ed1.* from event_daterange ed1 join (" & _
                                    "select min (date_range_id) as date_range_id , event_id from " & _
                                     "(" & _
                                       "select ed.date_range_id, ed.event_id, ed.start_date, ed.end_date from event_daterange ed  inner join " & _
                                         "(" & _
                                            "SELECT MAX(event_daterange.end_date) AS end_date,event_daterange.event_id FROM event_master JOIN " & _
                                            "event_daterange ON event_master.event_id = event_daterange.event_id " & _
                                             "GROUP BY event_daterange.event_id " & _
                                         ") dv on ed.event_id = dv.event_id and ed.end_date = dv.end_date" & _
                                     ") s1 group by event_id" & _
                                ")s2 on " & _
                                "ed1.date_range_id = s2.date_range_id)daterange ON " & _
                                "daterange.event_id = event_master.event_id " & _
                                "WHERE del_status='True' ORDER BY event_master.event_id "
        Dim EventAdapter As New SqlDataAdapter(EventSql, Conn)
        Try
            EventAdapter.Fill(EventDataSet)
        Catch ex As Exception
            lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
            Exit Sub
        End Try
        If (EventDataSet.Tables(0).Rows.Count > 0) Then
            grdEvents.DataSource = EventDataSet
            Me.grdEvents.DataBind()
        Else
            ''EventDataSet.Tables(0).Rows.Add(EventDataSet.Tables(0).NewRow())

            ''grdEvents.DataSource = EventDataSet
            ''grdEvents.DataBind()

            ''Dim TotalColumns As Integer = grdEvents.Rows(0).Cells.Count
            ''grdEvents.Rows(0).Cells.Clear()
            ''grdEvents.Rows(0).Cells.Add(New TableCell())
            ''grdEvents.Rows(0).Cells(0).ColumnSpan = TotalColumns
            ''grdEvents.Rows(0).Cells(0).ForeColor = System.Drawing.Color.Red
            ''grdEvents.Rows(0).Cells(0).Text = "NO RECORDS FOUND"
        End If
    End Sub
    Protected Sub grdEvents_RowDataBound(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles grdEvents.RowDataBound
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            'editHyperLnk.Attributes
            Dim delHyperLnk As HyperLink = CType(e.Row.FindControl("delHyperLnk"), HyperLink)
            Dim editImgBtn As ImageButton = CType(e.Row.FindControl("editImgBtn"), ImageButton)
            ''Displaying the ModalPopup
            delHyperLnk.Attributes.Add("onclick", "ShowMyModalPopup('" & grdEvents.DataKeys(e.Row.RowIndex).Values(0) & "','" & Replace(grdEvents.DataKeys(e.Row.RowIndex).Values(1), "'", "\'") & "')")
            editImgBtn.Attributes.Add("onclick", "SaveEditEventId('" & grdEvents.DataKeys(e.Row.RowIndex).Values(0) & "')")
        End If
    End Sub

    Protected Sub btnModalDelete_Click(ByVal sender As System.Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnModalDelete.Click
        lblMessage.Text = ""
        Dim delEvemtId As Integer = hdnEventId.Value.Trim
        Dim delEventCmd As SqlCommand
        delEventCmd = New SqlCommand("UPDATE event_master SET del_status='False' WHERE event_id =" & delEvemtId & " ", Conn)
        Conn.Open()
        Try
            delEventCmd.ExecuteNonQuery()
        Catch ex As Exception
            lblMessage.Text = "There is some problem in connecting the database. Please try again later. "
            Exit Sub
        End Try
        Bind_EventsList_data()
    End Sub
    Protected Sub btnEvent_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEvent.Click
        Response.Redirect("Event.aspx")
    End Sub

    Protected Sub btnCategories_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCategories.Click
        Response.Redirect("Category.aspx")
    End Sub

    Protected Sub btnClosedDates_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClosedDates.Click
        Response.Redirect("ClosedDates.aspx")
    End Sub

    Protected Sub btnUsers_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUsers.Click
        Response.Redirect("Users.aspx")
    End Sub

    Protected Sub btnAddNewEvent_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAddNewEvent.Click
        Response.Redirect("EventDetail.aspx")
    End Sub

    Protected Sub grdEvents_RowUpdating(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewUpdateEventArgs) Handles grdEvents.RowUpdating

    End Sub

    Protected Sub grdEvents_RowCommand(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) Handles grdEvents.RowCommand
        If e.CommandName = "Edit" Then
            Session("EVENT_ID") = hdnEditEventId.Value
            Response.Redirect("EventDetail.aspx")
        End If
    End Sub

    Protected Sub grdEvents_RowEditing(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewEditEventArgs) Handles grdEvents.RowEditing
        'catId = grdEvents.DataKeys(e.RowIndex).Values(0)
        'grdEvents.EditIndex = e.NewEditIndex

    End Sub

    Protected Sub grdEvents_RowUpdated(ByVal sender As System.Object, ByVal e As System.Web.UI.WebControls.GridViewUpdatedEventArgs) Handles grdEvents.RowUpdated

    End Sub
    Protected Sub lnkLogout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lnkLogout.Click
        Session.Abandon()
        Response.Redirect("Login.aspx")
    End Sub

    Protected Sub editImgBtn_Click(ByVal sender As System.Object, ByVal e As System.Web.UI.ImageClickEventArgs)

    End Sub
End Class