<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

	<xsl:template match="/beanstore">
		<JobApplication>
			<xsl:attribute name="name">
				<xsl:value-of select="JobContext/oracle_install_jobapplication_name" />
   			</xsl:attribute>
			<JobList>
				<xsl:for-each
					select="JobContext/oracle_install_jobapplication_jobCollection/oracle_install_jobapplication_jobCollection_jobs/JobSettings">
					<Job>
						<xsl:attribute name="id"><xsl:value-of
							select="oracle_install_jobapplication_jobCollection_job_id" /></xsl:attribute>
						<xsl:attribute name="weightage"><xsl:value-of
							select="oracle_install_jobapplication_jobCollection_job_weightage" /></xsl:attribute>
					</Job>
				</xsl:for-each>
			</JobList>
			<xsl:call-template name="toJob">
				<xsl:with-param name="jobsList"
					select="JobContext/oracle_install_jobapplication_jobCollection/oracle_install_jobapplication_jobCollection_jobs/JobSettings" />
			</xsl:call-template>
			<Variables>
				<xsl:call-template name="toVariables">
					<xsl:with-param name="jobsList"
						select="JobContext/oracle_install_jobapplication_jobCollection/oracle_install_jobapplication_jobCollection_jobs/JobSettings" />
				</xsl:call-template>
				<xsl:variable name="numberOfJobIndependentArgs"
					select="count(JobContext/oracle_install_jobapplication_jobIndependentVars/entry)" />
				<xsl:if test="$numberOfJobIndependentArgs > 0">
					<xsl:for-each
						select="JobContext/oracle_install_jobapplication_jobIndependentVars/entry">
						<xsl:call-template name="toVariableSettings">
							<xsl:with-param name="variableSettings" select="VariableSettings" />
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</Variables>
		</JobApplication>
	</xsl:template>

	<xsl:template name="toJob">
		<xsl:param name="jobsList" />
		<xsl:for-each select="$jobsList">
			<xsl:variable name="numberOfChildJobs"
				select="count(oracle_install_jobapplication_jobCollection_job_childJobs/JobSettings)" />
			<Job>
				<xsl:attribute name="id"><xsl:value-of
					select="oracle_install_jobapplication_jobCollection_job_id" /></xsl:attribute>
				<xsl:variable name="jobType"
					select="oracle_install_jobapplication_jobCollection_job_type" />
				<xsl:if test="$jobType">
					<xsl:attribute name="jobType"><xsl:value-of
						select="$jobType" /></xsl:attribute>
				</xsl:if>

				<xsl:variable name="command"
					select="oracle_install_jobapplication_jobCollection_job_command" />
				<xsl:if test="$command">
					<xsl:attribute name="commandOrPath"><xsl:value-of
						select="$command" /></xsl:attribute>
				</xsl:if>

				<xsl:variable name="noOfArgs"
					select="count(oracle_install_jobapplication_jobCollection_job_args/entry)" />
				<xsl:if test="$noOfArgs > 0">
					<xsl:attribute name="args"><xsl:call-template
						name="argsToString">
							<xsl:with-param name="mapEntry"
						select="oracle_install_jobapplication_jobCollection_job_args/entry" />
						</xsl:call-template></xsl:attribute>
				</xsl:if>

				<xsl:variable name="noOfProperties"
					select="count(oracle_install_jobapplication_jobCollection_job_properties/entry)" />
				<xsl:if test="$noOfProperties > 0">
					<xsl:attribute name="properties"><xsl:call-template
						name="argsToString">
							<xsl:with-param name="mapEntry"
						select="oracle_install_jobapplication_jobCollection_job_properties/entry" />
						</xsl:call-template></xsl:attribute>
				</xsl:if>
				
				<xsl:variable name="noOfSecreteArgs"
					select="count(oracle_install_jobapplication_jobCollection_job_secreteArgs/entry)" />
				<xsl:if test="$noOfSecreteArgs > 0">
					<xsl:attribute name="secreteArgsNames"><xsl:call-template
						name="argsToString">
							<xsl:with-param name="mapEntry"
						select="oracle_install_jobapplication_jobCollection_job_secreteArgs/entry" />
						</xsl:call-template></xsl:attribute>
				</xsl:if>

				<xsl:attribute name="retriable"><xsl:value-of
					select="oracle_install_jobapplication_jobCollection_job_retriable" /></xsl:attribute>

				<xsl:variable name="noOfIgnorableErrors"
					select="count(oracle_install_jobapplication_jobCollection_job_ignorableErrors/value)" />
				<xsl:if test="$noOfIgnorableErrors > 0">
					<xsl:attribute name="ignorableErrors"><xsl:call-template
						name="toStringList">
							<xsl:with-param name="valueList"
						select="oracle_install_jobapplication_jobCollection_job_ignorableErrors" /></xsl:call-template></xsl:attribute>
				</xsl:if>

				<xsl:variable name="noOfEnvVars"
					select="count(oracle_install_jobapplication_jobCollection_job_envVariables/entry)" />
				<xsl:if test="$noOfEnvVars > 0">
					<xsl:attribute name="envVariablesAndValues"><xsl:call-template
						name="envsToString">
							<xsl:with-param name="envsMap"
						select="oracle_install_jobapplication_jobCollection_job_envVariables/entry" />
						</xsl:call-template></xsl:attribute>
				</xsl:if>
				<xsl:attribute name="executeJob"><xsl:value-of
					select="oracle_install_jobapplication_jobCollection_job_execute" /></xsl:attribute>
				<xsl:attribute name="status"><xsl:value-of
					select="oracle_install_jobapplication_jobCollection_job_status" /></xsl:attribute>
				<xsl:if test="$numberOfChildJobs > 0">
					<xsl:for-each
						select="oracle_install_jobapplication_jobCollection_job_childJobs/JobSettings">
						<ChildJob>
							<xsl:attribute name="id"><xsl:value-of
								select="oracle_install_jobapplication_jobCollection_job_id" /></xsl:attribute>
							<xsl:attribute name="weightage"><xsl:value-of
								select="oracle_install_jobapplication_jobCollection_job_weightage" /></xsl:attribute>
						</ChildJob>
					</xsl:for-each>
				</xsl:if>
			</Job>
			<xsl:if test="$numberOfChildJobs > 0">
				<xsl:call-template name="toJob">
					<xsl:with-param name="jobsList"
						select="oracle_install_jobapplication_jobCollection_job_childJobs/JobSettings" />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="toVariables">
		<xsl:param name="jobsList" />
		<xsl:for-each select="$jobsList">
			<xsl:variable name="numberOfargs"
				select="count(oracle_install_jobapplication_jobCollection_job_args/entry)" />
			<xsl:if test="$numberOfargs > 0">
				<xsl:for-each
					select="oracle_install_jobapplication_jobCollection_job_args/entry">
					<xsl:call-template name="toVariableSettings">
						<xsl:with-param name="variableSettings" select="VariableSettings" />
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>

			<xsl:variable name="numberOfProps"
				select="count(oracle_install_jobapplication_jobCollection_job_properties/entry)" />
			<xsl:if test="$numberOfProps > 0">
				<xsl:for-each
					select="oracle_install_jobapplication_jobCollection_job_properties/entry">
					<xsl:call-template name="toVariableSettings">
						<xsl:with-param name="variableSettings" select="VariableSettings" />
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			
			<xsl:variable name="numberOfsecreteArgs"
				select="count(oracle_install_jobapplication_jobCollection_job_secreteArgs/entry)" />
			<xsl:if test="$numberOfsecreteArgs > 0">
				<xsl:for-each
					select="oracle_install_jobapplication_jobCollection_job_secreteArgs/entry">
					<xsl:call-template name="toVariableSettings">
						<xsl:with-param name="variableSettings" select="VariableSettings" />
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>

			<xsl:variable name="numberOfChildJobs"
				select="count(oracle_install_jobapplication_jobCollection_job_childJobs/JobSettings)" />
			<xsl:if test="$numberOfChildJobs > 0">
				<xsl:call-template name="toVariables">
					<xsl:with-param name="jobsList"
						select="oracle_install_jobapplication_jobCollection_job_childJobs/JobSettings" />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="toVariableSettings">
		<xsl:param name="variableSettings" />
		<Variable>
			<xsl:attribute name="name"><xsl:value-of
				select="$variableSettings/oracle_install_jobapplication_jobCollection_job_variable_name" /></xsl:attribute>
			<xsl:variable name="isSecure"
				select="$variableSettings/oracle_install_jobapplication_jobCollection_job_variable_secure" />
			<xsl:choose>
				<xsl:when test="translate($isSecure, $smallcase, $uppercase) = 'FALSE'">
					<xsl:attribute name="value"><xsl:value-of
						select="$variableSettings/oracle_install_jobapplication_jobCollection_job_variable_value" /></xsl:attribute>
					<xsl:attribute name="valueExpected"><xsl:value-of
						select="$variableSettings/oracle_install_jobapplication_jobCollection_job_variable_isValueExpected" /></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="secure"><xsl:value-of
						select="$isSecure" /></xsl:attribute>	
					<xsl:attribute name="prmptString"><xsl:value-of
						select="$variableSettings/oracle_install_jobapplication_jobCollection_job_variable_promptString" /></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>			
			<xsl:attribute name="jobId"><xsl:value-of
				select="$variableSettings/oracle_install_jobapplication_jobCollection_job_variable_jobId" /></xsl:attribute>
			<xsl:attribute name="optional"><xsl:value-of
				select="$variableSettings/oracle_install_jobapplication_jobCollection_job_variable_isOptional" /></xsl:attribute>
		</Variable>
	</xsl:template>

	<xsl:template name="argsToString">
		<xsl:param name="mapEntry" />
		<xsl:variable name="valueCount" select="count($mapEntry)" />
		<xsl:for-each select="$mapEntry">
			<xsl:value-of select="key" />
			<xsl:if test="$valueCount > position()">
				,
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="envsToString">
		<xsl:param name="envsMap" />
		<xsl:variable name="valueCount" select="count($envsMap)" />
		<xsl:for-each select="$envsMap">
			<xsl:variable name="envName" select="key" />
			<xsl:variable name="envValue"
				select="VariableSettings/oracle_install_jobapplication_jobCollection_job_variable_value" />
			<xsl:choose>
				<xsl:when test="$envValue and string-length($envValue) > 0">
					<xsl:value-of select="concat(concat($envName,'='),$envValue)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($envName,'=')" />
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$valueCount > position()">
				,
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="toStringList">
		<xsl:param name="valueList" />
		<xsl:variable name="valueCount" select="count($valueList/value)" />
		<xsl:for-each select="$valueList/value">
			<xsl:value-of select="." />
			<xsl:if test="$valueCount > position()">
				,
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
	<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
</xsl:stylesheet>



