/* $Header: oacm.h,v 2.7 94/10/19 15:39:28 bhaghigh: Stab $ */

/*----------------------------------------------------------------------------\
|  Copyright (c) 1989, 1993 by Oracle Corporation.  All Rights Reserved.      |
\----------------------------------------------------------------------------*/

/*
NAME
  oacm - OA: cursor management
DESCRIPTION
NOTES
MODIFIED
    bhaghigh   10/18/94 -  Added oacmscs, oacmup
    bhaghigh   10/06/94 -  add oacmgcu, oacmfcu
    sgans      10/05/94 -  add new constant for server 
    bhaghigh   10/04/94 -  Further limit open cursors at Office startup.
    bgustafs   07/14/94 -  add oadt cursor range 
    bhaghigh   06/19/94 -  replace oacmdnext with oacmdmru,
			   change oacmcin to ub4.
    bhaghigh   06/16/94 -  Limit open cursors at startup for Office. 
    sgans      05/04/94 -  fix to allow caching of closed cursors 
    sgans      02/08/94 -  add new field oacmdebuf, prototype for oacmfeb()
    strabosh   08/23/93 -  add proto for oacmall() 
    strabosh   06/03/93 -  change dflt max cursors for Oracle Office to 50 
    bhaghigh   05/18/92 -  Add macro oacmbdfupi(). 
    fnazem     07/28/91 -  Created.
*/

#ifndef OACM
#define OACM

#ifndef S
#include <s.h>
#endif

#ifndef UPIDEF
#include <upidef.h>
#endif

#ifndef OERDEF
#include <oerdef.h>
#endif

#ifndef SQLDEF
#include <sqldef.h>
#endif

#ifndef OAXM
#include <oaxm.h>
#endif /* OAXM */

/*
|| The relative weight catagories
*/
#define OACMW_NUM	3
#define OACMW_LOW	(ub1)1
#define OACMW_MED	(ub1)2
#define OACMW_HIGH	(ub1)3

/*
|| State of the cache entries
*/
#define OACMS_UNLOCK	(ub1)0
#define OACMS_LOCK	(ub1)1
/* The next state is that of the cursor being open but unused */
#define OACMS_OPNFREE	(ub1)2

/*
|| Cursor id ranges for the different products
*/
#define	OACMC_CAL	0
#define	OACMC_MAIL_UI	10000
#define	OACMC_MAIL_BE	20000
#define	OACMC_MAIL_API	30000
#define	OACMC_DS	40000
#define	OACMC_DM	50000

#define OACMC_OAPR	90000
#define OACMC_OADT      91000

#define	OACMC_DYNAMIC	100000

/*
|| The following Oracle Office constants don't belong in OACORE and are
|| obsolete.  Please avoid using them or adding any new ones here!
*/ 
#define OACM_OOCNO     50	/* OBSOLETE! */
#define OACM_OOCNSRV  100	/* OBSOLETE! */

/*
|| Cursor cache entry
*/
struct	oacmc {
    ub1		oacmcwt;	/* relative weight of the cursor */
    ub1		oacmcst;	/* current state */
    ub4		oacmcin;	/* use index, higher means more recent */
    word	oacmcur;	/* Oracle cursor */
    ub4		oacmcid;	/* cursor identifier */
    dvoid      *oacmcmp;	/* Memory pointer used by upiall() */
};

typedef struct oacmc oacmc;


/*
|| Environment structure for the oacm layer.
*/

#define  OACMD_EBUF_LEN		255    /* size of Oracle error buffer */
struct	oacmd {
    struct hstdef *oacmdhst;	/* upi host definition */
    struct oacmc  *oacmdcache;	/* -> to the cache array */
    struct oacmc  *oacmdcur;	/* -> to the current cache entry */
    struct oerdef *oacmdoer;    /* upi oer definition */
    ub4		   oacmdmru;	/* index to keep track of MRU entry */
    eword	   oacmdsize;	/* number of elements in the cache */
    ub4            oacmdseq;    /* sequence number for generated cur_id's */
    oaxmctx       *oacmdlcx;    /* lcx back pointer */
    text	   oacmdebuf[OACMD_EBUF_LEN]; /* error buffer */
    eword	   oacmdinitial;/* cache size during startup */
    eword	   oacmdfinal;	/* cache size after startup is complete */
};

typedef struct oacmd oacmd;

/* Convenience functions */

/* bind and define, with execute count */
#define oacmbdfupi(uenv,curid,weight,opflags,sqlbuf,dv,bv,count)\
  oacmupi(uenv,curid,weight,opflags,(CONST text*)sqlbuf,(ub4)count,(ub4)0,\
  (ub4)(sizeof(dv)/sizeof(dv[0])),dv,(ub4)(sizeof(bv)/sizeof(bv[0])), bv)

/* bind and define */
#define oacmbdupi(uenv,curid,weight,opflags,sqlbuf,dv,bv)\
  oacmupi(uenv,curid,weight,opflags,(CONST text*)sqlbuf,(ub4)1,(ub4)0,\
  (ub4)(sizeof(dv)/sizeof(dv[0])),dv,(ub4)(sizeof(bv)/sizeof(bv[0])), bv)

/* bind only */
#define oacmbupi(uenv,curid,weight,opflags,sqlbuf,bv)\
  oacmupi(uenv,curid,weight,opflags,(CONST text*)sqlbuf,(ub4)1,(ub4)0,\
  (ub4)0,(uaddef*)0,(ub4)(sizeof(bv)/sizeof(bv[0])),bv)

/* define only */
#define oacmdupi(uenv,curid,weight,opflags,sqlbuf,dv)\
  oacmupi(uenv,curid,weight,opflags,(CONST text*)sqlbuf,(ub4)1,(ub4)0,\
  (ub4)(sizeof(dv)/sizeof(dv[0])),dv,(ub4)0,(ua2def*)0)

/*
** UPI macros.  I left these names like this for historical reasons and
** because oauadset and oauadseti are too long if they are to be treated as
** function names.
*/
#ifndef uadset
/* macro for doing array bind/define */
#define uadset(uad, b, bl, t)\
    (uad).uadbufp = (ptr_t)(b); (uad).uadbufl = (bl); (uad).uaddtype =(t)
#endif

#ifndef uadseti
/* macro for doing array bind/define with indicator variable */
#define uadseti(uad, b, bl, t, i)\
    (uad).uadbufp = (ptr_t)(b); (uad).uadbufl = (bl); (uad).uaddtype =(t);\
    (uad).uadindp = (b2 *)(i);
#endif

/* Access macros */

#define oacmghst(uenv)	((uenv)->oacmdhst)
#define oacmgcnt(uenv)  ((uenv)->oacmdoer->oercnt)
#define oacmgcur(pcur)	((pcur)->oacmcur)

sword oacmscs(/*_ oaxmctx *lcxcx, eword initial, eword final _*/);
sword oacmup(/*_ oaxmctx *lcxcx _*/);
sword oacmini(/*_ oaxmctx  *lcxcx, oacmd **puenv, struct hstdef *hst, 
		eword size _*/);
void  oacmdes(/*_ oacmd *uenv _*/);
oacmc *oacmlku(/*_ oacmd *uenv, ub4 curid _*/);
sword  oacmcls(/*_ oacmd *uenv _*/);
sword  oacmopn(/*_ oacmd *uenv, ub4 curid, ub1 weight, oacmc **pcur _*/);
void   oacmcst(/*_ oacmd *uenv, ub1 state _*/);
sword  oacmupi(/*_ oacmd *uenv, ub4 curid, ub1 weight, ub2 opflags,
		   const text *sqlbuf, ub4 count, ub4 roff,
		   ub4 dcnt, uaddef *dfn, ub4 bcnt, ua2def *bind _*/);
sword  oacmall(/*_ oacmd *uenv, ub4 curid, ub1 weight, ub2 opflags,
                   const text *sqlbuf, ub4 count, ub4 roff,
                   ub4 dcnt, uaddef *dfn, ub4 bcnt, ua2def *bind,
                   ub1 *iovec _*/);
dvoid *oacmalc(/*_ size_t size _*/);
sword oacmfeb (/*_ oacmd *uenv, text *str, size_t len _*/);
void  oacmfre(/*_ dvoid *mptr _*/);
ub4   oacmgdc(/*_ oacmd *uenv _*/);
sword oacmgcu (/*_ oacmd *uenv, sword *cnumber _*/);
void  oacmfcu (/*_ oacmd *uenv, sword *cnumber _*/);

#endif /* OACM */
