/*
 * $Header: gsdsd.h,v 1.15 97/03/28 19:12:04 jluke: Exp $ 
 */

/* Copyright (c) 1991 by Oracle Corporation */
/*
   NAME
     gsdsd.h - <one-line expansion of the name>
   DESCRIPTION
     <short description of component this file declares/defines>
   PUBLIC FUNCTION(S)
     <list of external functions declared/defined - with one-line descriptions>
   PRIVATE FUNCTION(S)
     <list of static functions defined in .c file - with one-line descriptions>
   RETURNS
     <function return values, for .c file with single function>
   NOTES
     <other useful comments, qualifications, etc.>
   MODIFIED   (MM/DD/YY)
    jluke      03/27/97 -  Eliminate build warnings! 
    hmadan     03/21/97 -  Add attribuutes for CAs 
    skjain     03/21/97 -  change gsdsAttrOrganizationTable 
    skjain     03/21/97 -  change gsdsAttrLocationsTable. 
    jluke      03/21/97 -  Add attribute table for aliases (unified class). 
    skjain     03/19/97 -  include certificate attributes in person object cl 
    skjain     03/17/97 -  change attribute names. 
    rdoreswa   12/13/96 -  Fix Table Mapping 
    rdoreswa   11/21/96 -  No reason specified 
    rdoreswa   11/20/96 -  No reason specified 
    rdoreswa   11/14/96 -  Creation 
*/

#ifndef GSDSD_H
#define GSDSD_H


static struct gsdsPersonAttrMap{
  text * AttrName;
  ub4    DSAttrID;
  ub4    GdsID;
}; 
static text *gsdsAttrPersonTable[] =
{
    { (text *)"oioName" },
    { (text *)"cn"}, /* commonname */
    { (text *)"telephoneNumber"},
    { (text *)"homeTelephoneNumber"},
    { (text *)"organizationalUnitName"},
    { (text *)"title"},
    { (text *)"serialNumber"},
    { (text *)"buildingName"},
    { (text *)"PostOfficeBox"},
    { (text *)"oioLanguage"},
    { (text *)"manager"},
    { (text *)"streetAddress"},
    { (text *)"l"}, /* localityName */
    { (text *)"stateOrProvinceName"},
    { (text *)"PostalCode"},
    { (text *)"friendlyCountryName"},
    { (text *)"oioBirthday"},
    { (text *)"mail"},
    { (text *)"LabeledURL"},
    { (text *)"oioWorkFlowLanguage"},
    { (text *)"oioWorkFlowTerritory"},
    { (text *)"sn"}, /* surname */
    { (text *)"oioDomainId"},
    { (text *)"givenname"}, /* oioFirstName */
    { (text *)"oioForeignMgr"},
    { (text *)"oioForeignOrg"},
    { (text *)"oioForeignRole"},
    { (text *)"facsimileTelephoneNumber"},
    { (text *)"oioMiddlename"},
    { (text *)"oioNickName"},
    { (text *)"oioObjectid"},
    { (text *)"oioOsName"},
    { (text *)"userPassword"},
    { (text *)"photo"},
    { (text *)"oioPrimaryAccount"},
	{ (text *)"userCertificate" },
	{ (text *)"userHashCertificate" }
};

static text *gsdsAttrDomainTable[] =
{
    { (text *)"cn" },
    { (text *)"Description"},
    { (text *)"oioqualifiedname"}
};
 
static text *gsdsAttrLocationTable[] =
{
    { (text *)"cn"},
    { (text *)"Description"},
    { (text *)"oioAdministrator"},
    { (text *)"oioParent"},
    { (text *)"oioqualifiedname"}
};

static text *gsdsAttrOrganizationTable[] =
{
    { (text *)"cn"},
    { (text *)"oioManager"},
    { (text *)"oioAdministrator"},
    { (text *)"oioCostCenter"},
    { (text *)"postOfficeBox"},
    { (text *)"streetAddress"},
    { (text *)"l"},
    { (text *)"stateOrProvince"},
    { (text *)"postalCode"},
    { (text *)"friendlyCountryName"},
    { (text *)"telephoneNumber"},
    { (text *)"facsimiliTelephoneNumber"},
    { (text *)"oioParent"},
    { (text *)"description"},
    { (text *)"oioQualifiedName"}
};

static text *gsdsAttrEquipmentTable[] = 
{
    { (text *)"CommonName"},
    { (text *)"Description"},
    { (text *)"oioAdministrator"},
    { (text *)"oioLocation"},
    { (text *)"oioQualifiedName"},
    { (text *)"ModelNumber"}
};

static text *gsdsAttrRoomTable[] =
{
    { (text *)"CommonName"},
    { (text *)"description"},
    { (text *)"oioAdministrator"},
    { (text *)"oiofacilityName"},
    { (text *)"oioCapacity"},
    { (text *)"oioQualifiedName"}
};

static text *gsdsAttrCATable[] =
{
    { (text *)"CommonName"},
    { (text *)"certificateRevocationList"},
    { (text *)"authorityRevocationList"},
    { (text *)"caCertificate"},
    { (text *)"oiohashCert"},
    { (text *)"crossCertificatePair"},
    { (text *)"oioQualifiedName"}
};

static text *gsdsAttrRoleTable[] =
{
    { (text *)"CommonName"},
    { (text *)"description"},
    { (text *)"oioQualifiedName"}
};

static text *gsdsAttrGatewayTable[] =
{
    { (text *)"CommonName"},
    { (text *)"description"},
    { (text *)"oioDomain"},
    { (text *)"oioNodeName"},
    { (text *)"oioQualifiedName"}
};

/*static text *gsdsAttrPrvtAliasesTable[] =
  {
      { (text *)"CommonName"},
      { (text *)"mail"},
      { (text *)"description"},
      { (text *)"oioType"},
      { (text *)"oioQualifiedName"}
  };
static text *gsdsAttrPublicAliasesTable[] =
  {
      { (text *)"CommonName"},
      { (text *)"mail"},
      { (text *)"description"},
      { (text *)"oioType"},
      { (text *)"oioQualifiedName"}
  };
*/

static text *gsdsAttrAliasTable[] =
{
    { (text *)"CommonName"},
    { (text *)"mail"},
    { (text *)"description"},
    { (text *)"oioType"},
    { (text *)"oioQualifiedName"}
};

static text *gsdsAttrDlsTable[] =
{
    { (text *)"CommonName"},
    { (text *)"description"},
    { (text *)"oioType"},
    { (text *)"oioQualifiedName"},
    { (text *)"oioMembers"}
};

static text *gsdsAttrPrvtDlsTable[] =
{
    { (text *)"CommonName"},
    { (text *)"description"},
    { (text *)"oioType"},
    { (text *)"oioQualifiedName"}
};

static text *gsdsAttrPublicDlsTable[] =
{
    { (text *)"CommonName"},
    { (text *)"description"},
    { (text *)"oioType"},
    { (text *)"oioQualifiedName"}
};


#endif /* GSDSD_H */
