#!/usr/bin/per

package module::ExportPath;

#Stick to perl version v5.x.x
use v5.8.8;
use Cwd  qw(abs_path);
use Cwd ;
use File::Basename qw(dirname);
use Exporter qw(import);

our @EXPORT_OK = qw(exportSudoPath);

my $scriptDir=dirname(abs_path($0));

sub exportSudoPath{
  my $home = cwd();
  my $propertyFileName=$scriptDir."/opatchauto.properties";
  my %properties;
  if(-e $propertyFileName){
    open(F,$propertyFileName);
   while (<F>){
     ($name,$val)=m/(\w+)\s*=(.+)/;
     $properties{$name}=$val;
     last;
   }
   close(F);
   my $path="";
   if(defined $ENV{'PATH'}){
    $path=$properties{'PATH'}.":".$ENV{'PATH'};
   }else{
    $path=$properties{'PATH'};
   }
   $ENV{'PATH'} =$path;
  }
  my $etcProfileFilePath="/etc/profile";
  my $etcEnvFilePath="/etc/environment";
  if(isSudoCommandFound()==0){
     if(-e $etcProfileFilePath){
        system("source $etcProfileFilePath");
       if(isSudoCommandFound()==0){
         if(-e $etcEnvFilePath){
          system("source $etcEnvFilePath");
          if(isSudoCommandFound()==0){
           exit(100);
          }
        }
      }
    }
  }
  return  $ENV{'PATH'};
}

sub isSudoCommandFound{
  my $sudoPath=`which sudo`;
  chomp $sudoPath;
  $sudoPath=abs_path($sudoPath);
  if(-e $sudoPath){
    return 1;
  }
  return 0;
}