Rem $Header: rdbms/admin/dbmstf.sql /main/6 2016/03/31 13:53:08 achaudhr Exp $
Rem
Rem dbmstf.sql
Rem
Rem    NAME
Rem      dbmstf.sql - Table Function Utility Package
Rem
Rem    DESCRIPTION
Rem      This is a PL/SQL package for polymorphic table functions to consume
Rem      and produce data, and get information about its execution environment.
Rem
Rem    NOTES
Rem      The package is expected to be called from inside the implementation 
Rem      of a PTF.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    achaudhr    03/24/16 - 2918931: disable trace_file parameter
Rem    sagrawal    01/19/16 - bug 22559697:remove unsupported API's
Rem    sagrawal    06/29/15 - fix typecodes
Rem    achaudhr    05/21/15 - add metadata support
Rem    sagrawal    03/23/15 - Add collections to represent columns
Rem    sagrawal    01/27/15 - add put_col and get_col ICDs
Rem    sagrawal    01/27/15 - add put_col and get_col ICDs
Rem    sagrawal    01/08/15 - change the name
Rem    sagrawal    01/23/14 - Polymorphic Table Functions: helper package
Rem    sagrawal    01/23/14 - Created
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/dbmstf.sql 
Rem    SQL_SHIPPED_FILE: rdbms/admin/dbmstf.sql 
Rem    SQL_PHASE: DBMSTF
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/catpdbms.sql
Rem    END SQL_FILE_METADATA

@@?/rdbms/admin/sqlsessstart.sql  
  
CREATE OR REPLACE PACKAGE DBMS_TF AS
  
  /* Column Metatdata */
  TYPE COLUMN_METADATA_T IS RECORD 
  (
    col_type               PLS_INTEGER,
    col_max_len            PLS_INTEGER,
    col_name               VARCHAR2(32767),
    col_name_len           PLS_INTEGER,
    /* following two attributes are used for numerical data */
    col_precision          PLS_INTEGER,
    col_scale              PLS_INTEGER,
    /* following three attributes are used for character data */
    col_charsetid          PLS_INTEGER,
    col_charsetform        PLS_INTEGER,
    col_collation          PLS_INTEGER,
    /* following attributes may be used in future */
    col_schema_name        DBMS_ID,
    col_schema_name_len    PLS_INTEGER,
    col_type_name          DBMS_ID,
    col_type_name_len      PLS_INTEGER
  );   

  /* Column Descriptor */
  TYPE COLUMN_T          IS RECORD 
  (
    description            COLUMN_METADATA_T, /* Column metadata */
    pass_through           BOOLEAN,      /* Pass-through column? */
    for_read               BOOLEAN  /* Column data will be read? */
  );

  /* Table Descriptor */
  TYPE TABLE_T IS TABLE OF COLUMN_T;
  
  /* Collection containing columns metadata */
  TYPE COLUMNS_WITH_TYPE_T IS TABLE OF COLUMN_METADATA_T;
  
  /* Collection containing column names */
  TYPE COLUMNS_T IS TABLE OF DBMS_QUOTED_ID;
  
  /* Collection for new columns */
  TYPE COLUMNS_NEW_T IS TABLE OF COLUMN_METADATA_T;
  
  /* Type Codes for supported types */
  TYPE_VARCHAR2            CONSTANT PLS_INTEGER :=   1;
  TYPE_NUMBER              CONSTANT PLS_INTEGER :=   2;
  TYPE_DATE                CONSTANT PLS_INTEGER :=  12;
  TYPE_BINARY_FLOAT        CONSTANT PLS_INTEGER :=  100;
  TYPE_BINARY_DOUBLE       CONSTANT PLS_INTEGER :=  101;
  TYPE_RAW                 CONSTANT PLS_INTEGER :=  23;
  TYPE_CHAR                CONSTANT PLS_INTEGER :=  96;
  TYPE_CLOB                CONSTANT PLS_INTEGER := 112;
  TYPE_BLOB                CONSTANT PLS_INTEGER := 113;
  TYPE_TIMESTAMP           CONSTANT PLS_INTEGER := 180;
  TYPE_TIMESTAMP_TZ        CONSTANT PLS_INTEGER := 181;
  TYPE_INTERVAL_YM         CONSTANT PLS_INTEGER := 182;
  TYPE_INTERVAL_DS         CONSTANT PLS_INTEGER := 183;
  TYPE_TIMESTAMP_LTZ       CONSTANT PLS_INTEGER := 231;

  /* Collections for each supported types */
  TYPE TAB_VARCHAR2_T      IS TABLE OF VARCHAR2(32767)             INDEX BY PLS_INTEGER;
  TYPE TAB_NUMBER_T        IS TABLE OF NUMBER                      INDEX BY PLS_INTEGER;
  TYPE TAB_DATE_T          IS TABLE OF DATE                        INDEX BY PLS_INTEGER;
  TYPE TAB_BINARY_FLOAT_T  IS TABLE OF BINARY_FLOAT                INDEX BY PLS_INTEGER;
  TYPE TAB_BINARY_DOUBLE_T IS TABLE OF BINARY_DOUBLE               INDEX BY PLS_INTEGER;
  TYPE TAB_RAW_T           IS TABLE OF RAW(32767)                  INDEX BY PLS_INTEGER;
  TYPE TAB_CHAR_T          IS TABLE OF CHAR(32767)                 INDEX BY PLS_INTEGER;
  TYPE TAB_CLOB_T          IS TABLE OF CLOB                        INDEX BY PLS_INTEGER;
  TYPE TAB_BLOB_T          IS TABLE OF BLOB                        INDEX BY PLS_INTEGER;
  TYPE TAB_TIMESTAMP_T     IS TABLE OF TIMESTAMP_UNCONSTRAINED     INDEX BY PLS_INTEGER;
  TYPE TAB_TIMESTAMP_TZ_T  IS TABLE OF TIMESTAMP_TZ_UNCONSTRAINED  INDEX BY PLS_INTEGER;
  TYPE TAB_INTERVAL_YM_T   IS TABLE OF YMINTERVAL_UNCONSTRAINED    INDEX BY PLS_INTEGER;
  TYPE TAB_INTERVAL_DS_T   IS TABLE OF DSINTERVAL_UNCONSTRAINED    INDEX BY PLS_INTEGER;
  TYPE TAB_TIMESTAMP_LTZ_T IS TABLE OF TIMESTAMP_LTZ_UNCONSTRAINED INDEX BY PLS_INTEGER;
  
  /* Data for a single column (tagged-union/variant-record) */
  TYPE COLUMN_DATA_T IS RECORD
  (
    /* ::TAG:: */
    metadata               COLUMN_METADATA_T, 
    
    /* ::VARIANT FIELDS:: Exactly one is active */
    tab_varchar2           TAB_VARCHAR2_T,
    tab_number             TAB_NUMBER_T,
    tab_date               TAB_DATE_T,
    tab_binary_float       TAB_BINARY_FLOAT_T,
    tab_binary_double      TAB_BINARY_DOUBLE_T,
    tab_raw                TAB_RAW_T,
    tab_char               TAB_CHAR_T,
    tab_clob               TAB_CLOB_T,
    tab_blob               TAB_BLOB_T,
    tab_timestamp          TAB_TIMESTAMP_T,
    tab_timestamp_tz       TAB_TIMESTAMP_TZ_T,
    tab_interval_ym        TAB_INTERVAL_YM_T,
    tab_interval_ds        TAB_INTERVAL_DS_T,
    tab_timestamp_ltz      TAB_TIMESTAMP_LTZ_T
  );

  /* Data for a rowset */
  TYPE ROW_SET_T IS TABLE OF COLUMN_DATA_T INDEX BY PLS_INTEGER;

  /**
   * NAME:
   *   Get_Col
   *   Put_Col
   * PARAMETERS:
   *   ColumnId   - The id for the column (1 .. N)
   *   Collection - The data for the column
   * DESCRIPTION:
   *   These procedure are used to "get" the read column values or 
   *   "put" the new column values.
   */
  PROCEDURE Get_Col(ColumnId NUMBER,     Collection IN OUT NOCOPY "<V2_TABLE_1>");
            pragma interface(c, Get_Col); 
  PROCEDURE Get_Col(ColumnName varchar2, Collection IN OUT  NOCOPY "<V2_TABLE_1>");
            pragma interface(c, Get_Col); 
  PROCEDURE Put_Col(ColumnId NUMBER,     Collection IN             "<V2_TABLE_1>");
            pragma interface(c, Put_Col); 
  PROCEDURE Put_Col(ColumnName varchar2, Collection IN             "<V2_TABLE_1>");
            pragma interface(c, Put_Col); 
  
  /**
   * NAME:
   *   Get_Row_Set
   *   Put_Row_Set
   * PARAMETERS:
   *   cols      - The column data and metadata
   *   row_count - The number of rows in the columns
   * DESCRIPTION:
   *   This function return miscellaneous information about the
   *   runtime environment of the current PTF.
   */
  PROCEDURE Get_Row_Set(rowset    OUT NOCOPY ROW_SET_T, row_count OUT PLS_INTEGER);
  PROCEDURE Get_Row_Set(rowset    OUT NOCOPY ROW_SET_T);
  PROCEDURE Put_Row_Set(rowset IN            ROW_SET_T);

  /**
   * NAME:
   *   Supported_Type
   * PARAMETERS:
   *   type_id - The type 
   * DESCRIPTION:
   *   See below.
   * RETURNS:
   *   TRUE iff the type_id is supported for obtaining or producing 
   *   columns inside a PTF.
   */
  FUNCTION Supported_Type(type_id PLS_INTEGER) 
           RETURN BOOLEAN;

  /**
   * NAME:
   *   Get_Execution_Id
   * DESCRIPTION:
   *   See below.
   * RETURN:
   *   A unique execution id that can be used by the PTF to index 
   *   any cursor-execution specific runtime state.
   */  
  FUNCTION Get_Execution_Id 
           RETURN VARCHAR2;
  
  TYPE PARALLEL_ENV_T         IS RECORD
  (
    instance_id      PLS_INTEGER,                      /* QC instance ID */
    session_id       PLS_INTEGER,                       /* QC session ID */
    slave_svr_grp    PLS_INTEGER,                  /* Slave server group */
    slave_set_no     PLS_INTEGER,                /* Slave server set num */
    no_slobal_slaves PLS_INTEGER,   /* Num of sibling slaves
                                                        (including self) */
    global_slave_no  PLS_INTEGER,        /* Global slave number (base 0) */
    no_local_slaves  PLS_INTEGER,/* Num of sibling slaves running on 
                                                                instance */
    local_slave_no   PLS_INTEGER          /* Local slave number (base 0) */
  );

  TYPE TABLE_METADATA_T IS TABLE OF COLUMN_METADATA_T INDEX BY PLS_INTEGER;

  TYPE PROJECTED_COLS_T IS TABLE OF BOOLEAN           INDEX BY PLS_INTEGER;

  TYPE ENV_T            IS RECORD
  (
    get_columns  TABLE_METADATA_T,         /* Metadata for the Get_Col() */
    put_columns  TABLE_METADATA_T,         /* Metadata for the Put_Col() */
    proj_put_col PROJECTED_COLS_T,   /* TRUE => put-column is not needed */
    parallel_env PARALLEL_ENV_T,       /* Parallel Execution information */
    query_optim  BOOLEAN    /* Is this execution for query optimization? */
  );

  /**
   * NAME:
   *   Get_Env
   * DESCRIPTION:
   *   See below.
   * RETURNS:
   *   This function return miscellaneous information about the PTF's
   *   runtime environment.
   */
  FUNCTION Get_Env 
           RETURN ENV_T;

  /**
   * NAME:
   *   Trace
   * DESCRIPTION:
   *   Sundry procedures that used DBMS_OUTPUT or DBMS_SYSTEM.ksdwrt to
   *   print out data structures in this package. These procedures are 
   *   helpful during development and problem diagnosis.
   */
  PROCEDURE Trace(msg                   varchar2, 
                  with_id               boolean   default FALSE, 
                  separator             varchar2  default NULL,
                  prefix                varchar2  default NULL);
  PROCEDURE Trace(rowset             IN row_set_t); 
  PROCEDURE Trace(env                IN env_t);
  PROCEDURE Trace(columns_new        IN columns_new_t);
  PROCEDURE Trace(cols               IN columns_t);
  PROCEDURE Trace(columns_with_type  IN columns_with_type_t);
  PROCEDURE Trace(tab                IN table_t); 

END DBMS_TF;
/

GRANT EXECUTE ON DBMS_TF to PUBLIC;

create or replace public synonym dbms_tf for sys.dbms_tf
/


@?/rdbms/admin/sqlsessend.sql
