Rem
Rem $Header: rdbms/admin/dbmssqlpatch.sql /st_rdbms_12.2.0.1.0/1 2016/08/16 16:22:42 surman Exp $
Rem
Rem dbmssqlpatch.sql
Rem
Rem Copyright (c) 2013, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbmssqlpatch.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      08/01/16 - 23170620: Rework set_patch_metadata and state
Rem                           table
Rem    surman      06/22/16 - 22694961: Application patches
Rem    surman      04/11/16 - 23025340: Switching trains project
Rem    surman      01/07/16 - 22359063: Add get_opatch_lsinventory
Rem    surman      01/30/15 - 20348653: Add opatch_registry_state
Rem    surman      09/16/14 - 19547370: Add show errors
Rem    surman      08/18/14 - Always reload dbms_sqlpatch
Rem    surman      06/24/14 - 19051526: Add verify_queryable_inventory
Rem    surman      04/10/14 - More parameters
Rem    surman      10/31/13 - Creation for 17277459
Rem    surman      07/29/13 - Created
Rem
Rem  BEGIN SQL_FILE_METADATA 
Rem  SQL_SOURCE_FILE: rdbms/admin/dbmssqlpatch.sql 
Rem  SQL_SHIPPED_FILE: rdbms/admin/dbmssqlpatch.sql
Rem  SQL_PHASE: DBMSSQLPATCH
Rem  SQL_STARTUP_MODE: NORMAL 
Rem  SQL_IGNORABLE_ERRORS: NONE 
Rem  SQL_CALLING_FILE: rdbms/admin/catpdbms.sql
Rem  END SQL_FILE_METADATA

@@?/rdbms/admin/sqlsessstart.sql

CREATE OR REPLACE PACKAGE dbms_sqlpatch AS

  -- Performs any initialization necessary for the given patch, including
  -- the initial insert to the SQL registry.  Parameters:
  -- patch_id/patch_uid: patch ID/universal patch id
  -- flags: patch flags
  -- description: patch description as recorded in binary registry
  -- action: APPLY or ROLLBACK
  -- logfile: Full path to logfile
  -- bndl_series: For a bundle patch, the bundle series.
  -- bnld_xml: For a bundle patch, the full path to the bundledata.xml
  PROCEDURE patch_initialize(p_patch_id IN NUMBER,
                             p_patch_uid IN NUMBER,
                             p_flags IN VARCHAR2,
                             p_description IN VARCHAR2,
                             p_action IN VARCHAR2,
                             p_logfile IN VARCHAR2,
                             p_bundle_series IN VARCHAR2 DEFAULT NULL);

  -- Performs any finalization necessary for the current patch.  This
  -- includes clearing the package state and updating the SQL registry.
  PROCEDURE patch_finalize;

  -- For the current patch and mode under consideration, determines if the
  -- given file should be run or not.  Returns the name of the file to be
  -- run, which will either be the supplied input file (prefixed with
  -- top_directory supplied during initialisze) or
  -- dbms_registry.nothing_script if the file does not need to be run.
  FUNCTION install_file(sql_file IN VARCHAR2)
    RETURN VARCHAR2;

  -- Returns a hash string representing the current state of the SQL
  -- registry (i.e. a list of the BLRs installed successfully or not, and
  -- the current bundle ID for any bundles).  This is used to compare the
  -- SQL registry upon PDB plug in
  FUNCTION sql_registry_state RETURN XMLType;

  -- Wrapper around queryable inventory's get_pending_activity function.
  -- Returns an XML string representing the state of SQL patches installed
  -- in the opatch inventory.
  FUNCTION opatch_registry_state RETURN XMLType;

  -- Wrapper around queryable inventory's get_opatch_lsinventory function.
  -- Returns an XML string consisting of the entire inventory.  This function
  -- caches the result for performance.
  FUNCTION get_opatch_lsinventory RETURN XMLType;

  -- Performs session initialization.  Must be called before patch_initialize.
  PROCEDURE session_initialize(p_oh IN VARCHAR2,
                               p_force IN BOOLEAN := FALSE,
                               p_debug IN BOOLEAN := FALSE);

  -- Tests the queryable inventory functionality.
  -- If QI is working properly, then the string 'OK' is returned, otherwise
  -- any errors are returned.
  FUNCTION verify_queryable_inventory RETURN VARCHAR2;

  -- 23025340: Because patch_initialize is part of the generated apply and
  -- rollback scripts, we can't easily change its signature.  Hence this 
  -- procedure is called directly by datapatch.
  PROCEDURE set_patch_metadata(p_patch_id IN NUMBER,
                               p_patch_uid IN NUMBER,
                               p_superseding IN BOOLEAN,
                               p_application_patch IN BOOLEAN,
                               p_patch_descriptor IN XMLType := NULL,
                               p_patch_directory IN BLOB := NULL);

  -- Removes all saved state from the dbms_sqlptach_state table.
  PROCEDURE clear_state;

END dbms_sqlpatch;
/

show errors

CREATE OR REPLACE PUBLIC SYNONYM dbms_sqlpatch FOR sys.dbms_sqlpatch;

GRANT EXECUTE ON dbms_sqlpatch TO execute_catalog_role;

@?/rdbms/admin/sqlsessend.sql
