Rem
Rem $Header: rdbms/admin/dbmssodautil.sql /st_rdbms_12.2.0.1.0/1 2016/08/10 15:17:37 prthiaga Exp $
Rem
Rem dbmssodautil.sql
Rem
Rem Copyright (c) 2014, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbmssodautil.sql - utility functions to be used by 
Rem                         JSON Collections API
Rem
Rem    DESCRIPTION
Rem      These functions are only allowed to be invoked by
Rem      xdb.dbms_collections for accessing SYS objects.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/dbmssodautil.sql 
Rem    SQL_SHIPPED_FILE: rdbms/admin/dbmssodautil.sql
Rem    SQL_PHASE: DBMSSODAUTIL 
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/catsodacoll.sql
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    prthiaga    08/03/15 - Bug 24350036: Allow xdb.dbms_soda_dml
Rem    prthiaga    03/10/15 - Bug 22905133: Allow xdb.dbms_soda_dom
Rem    prthiaga    02/10/16 - Bug 22675745: Add raise_system_error
Rem    prthiaga    06/02/15 - Bug 21188761: Add getCharSet
Rem    prthiaga    05/20/15 - Bug 21116398: Remove SET stmts
Rem    prthiaga    03/17/15 - Bug 20703629: Add getSCN
Rem    prthiaga    10/02/14 - Add checkColumns
Rem    prthiaga    07/29/14 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

create or replace package SYS.dbms_soda_util authid definer accessible by
(package xdb.dbms_soda_admin, package xdb.dbms_soda_dom,
 package xdb.dbms_soda_dml)
is
  type VCTAB is table of varchar2(32767) index by binary_integer;
  procedure getLongStringEnabled(P_LONG_STRINGS out varchar2);
  procedure getNLSCharSet(P_CS out varchar2);
  procedure getCharSet(P_CS out varchar2);
  procedure checkCompat;
  procedure checkSequenceExists (P_SCHEMA IN VARCHAR2, P_SEQNAME IN VARCHAR2,
                                 P_FOUND OUT boolean);
  procedure checkTableExists (P_SCHEMA IN VARCHAR2, P_TABNAME IN VARCHAR2,
                              P_FOUND OUT boolean);
  procedure checkViewExists (P_SCHEMA IN VARCHAR2, P_VIEWNAME IN VARCHAR2,
                             P_FOUND OUT boolean);
  procedure checkColumns (P_SCHEMA in varchar2, P_OBJNAME in varchar,
                          P_NCOLS in number,
                          P_COLNAMES in VCTAB, P_COLTYPES in VCTAB,
                          P_FOUND out boolean);
  procedure getSCN(P_SCN out NUMBER);
  procedure raise_system_error(error_number IN INTEGER, arg1 IN VARCHAR2);
  procedure raise_system_error(error_number IN INTEGER);


end dbms_soda_util;
/
show errors;
/

@?/rdbms/admin/sqlsessend.sql
