Rem
Rem $Header: rdbms/admin/dbmsgwmfx.sql /main/4 2016/05/16 09:07:52 dcolello Exp $
Rem
Rem dbmsgwmfx.sql
Rem
Rem Copyright (c) 2011, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbmsgwmfx.sql - DBMS package for GWM fixed operationsRem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/dbmsgwmfx.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/dbmsgwmfx.sql
Rem SQL_PHASE: DBMSGWMCL
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/dbmsgwm.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dcolello    04/27/16 - bug 22530860: validate character set of shard
Rem    dcolello    03/25/16 - lrg 19364619: fix typo
Rem    dcolello    03/21/16 - add validateShard()
Rem    dcolello    03/08/16 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

--*****************************************************************************
-- Package Declaration
--*****************************************************************************

create or replace package dbms_gsm_fix AS

-- DE-HEAD  <- tell SED where to cut when generating fixed package

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     validateDatabase
  --
  -- Description:  
  --    Validate database existence and return local DB info
  -- 
  -- Parameters:   
  --   dbpool - dbpool that database existis in
  --   db_unique_name - unique name of database
  --   instances - number of instances database currently has configured
  --   charset - catalog character set for validation
  --   ncharset - catalog national character set for validation
  --
  -- Notes:
  --   Called from GDSCTL during 'add shard'.
  --    
  -----------------------------------------------------------------------------

  PROCEDURE validateDatabase( dbpool         IN  varchar2,
                              db_unique_name OUT varchar2,
                              instances      OUT number,
                              cloud_name     IN varchar2 default NULL);

  PROCEDURE validateDatabase( dbpool              IN  varchar2,
                              db_unique_name      OUT varchar2,
                              instances           OUT number,
                              cloud_name          IN varchar2 default NULL,
                              hostname            OUT varchar2,
                              agent_port          OUT number,
                              db_sid              OUT varchar2,
                              oracle_home         OUT varchar2,
                              html_port           IN  number DEFAULT NULL,
                              registration_pass   IN varchar2 DEFAULT NULL,
                              cat_host            IN varchar2 DEFAULT NULL,
                              dbid                OUT number,
                              conversion_status   OUT varchar2,
                              gg_service          IN varchar2 DEFAULT NULL,
                              charset             IN varchar2 DEFAULT NULL,
                              ncharset            IN varchar2 DEFAULT NULL);

  -----------------------------------------------------------------------------
  --
  -- PROCEDURE     validateShard
  --
  -- Description:  
  --    Validate parameters on database to-be-added to configuration by user
  -- 
  -- Parameters:   
  --    reptype - either 'dg' or 'ogg' (case-insensitive)
  --
  --
  -- Notes:
  --   Called by users manually to validate a database prior to being added
  --   via 'add shard'.  Will display output with warnings and errors that
  --   can be corrected by user prior to 'add shard'.
  --    
  -----------------------------------------------------------------------------

  PROCEDURE validateShard(reptype IN varchar2 DEFAULT 'DG');

end;

-- CUT_HERE    <- tell sed where to chop off the rest

/

GRANT EXECUTE ON dbms_gsm_fix TO dba
/

GRANT EXECUTE ON dbms_gsm_fix TO sysdg
/


show errors;


@?/rdbms/admin/sqlsessend.sql
