Rem
Rem dbms_registry_basic.sql.pp
Rem
Rem Copyright (c) 2014, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbms_registry_basic.sql.pp and dbms_registry_basic.sql
Rem
Rem    DESCRIPTION
Rem      This file contains common constants and low level definitions for use
Rem      by the Preupgrade, Upgrade, and Downgrade.
Rem
Rem      Because some of the Upgrade team's PLSQL code must execute in the very limited
Rem      UPGRADE/MIGRATE mode ("alter database open upgrade" which lacks package
Rem      standard and dbms_output among other things) the common constants
Rem      and low level definitions shared by Upgrade PLSQL code are divided into
Rem      two packages, dbms_registry_basic and dbms_registry_extended.  The former contains
Rem      definitions which are acceptable in upgrade mode, and the latter contains
Rem      any common definition which cannot be placed in dbms_registry_basic.
Rem
Rem      This file, contains those former, "basic" definitions.
Rem
Rem    NOTES
Rem      Since some of the low level definitions are constants which are defined
Rem      by groups outside of Upgrade, the .sql.pp source file will be preprocessed
Rem      by the build to generate a corresponding DERIVED_OBJECT .sql file by replacing
Rem      tags in the .sql.pp file with their actual values derived by the build.
Rem
Rem      The tags are **UPPER CASE** equivalents of the following strings:
Rem
Rem        ##bannerversion## - the server's version number,(high_version) i.e. 12.2.0.0.0
Rem        ##ltz_content_ver## - the timezone*.dat version number, i.e. 23
Rem        ##apex_version## - apex's version is not the same as the server's, i.e. 4.2.5.00.08
Rem
Rem        In order to keep all of the Upgrade common definitions synchronized
Rem        across the various languages used by our team, it is imperative that
Rem        the following files stay religiously in lock step with one another:
Rem        
Rem            dbms_registry_extended.pm.pp
Rem            tkumregistry.tsc.pp
Rem            (dbms_registry_basic.sql.pp and dbms_registry_extended.sql.pp together*)
Rem        
Rem        That means that any definition placed in one of the files should
Rem        appear in all of the files.  In as much as possible within the
Rem        conventions of each language, the object definitions should use the
Rem        exact same name, including case, as used in other files.  The
Rem        definitions should be made in the same order to facilitate debugging
Rem        and allow for quick visual comparison of the files.
Rem        
Rem        * Note: due to the limitations of running sql under
Rem        "alter database open upgrade", the definitions made in SQL have to be
Rem        split into two files: dbms_registry_basic.sql.pp and dbms_registry_extended.sql.pp.
Rem        The former contains definitions which work when the database is open
Rem        in upgrade mode, and the latter file holds all of the other
Rem        definitions which can only be accessed when in NORMAL mode.  When it
Rem        comes to ordering definitions across all four of the files above, imagine
Rem        that dbms_registry_basic.sql.pp and dbms_registry_extended.sql.pp are logically
Rem        concatenated in that order.  A definition should appear only once in
Rem        one of those two files.  That means, if you are adding a definition
Rem        that belongs at the end of dbms_registry_basic.sql.pp, there will be no
Rem        definition in dbms_registry_extended.sql.pp, and the placement of the defintion
Rem        in dbms_registry_extended.pm.pp and tkumregistry.tsc.pp will appear somewhere in
Rem        the middle of those files.
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: rdbms/admin/dbms_registry_basic.sql.pp
Rem    SQL_SHIPPED_FILE: rdbms/admin/dbms_registry_basic.sql
Rem    SQL_PHASE: DBMS_REGISTRY_BASIC
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    SQL_CALLING_FILE: rdbms/admin/catupstr.sql
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    frealvar    07/30/16 - Bug 24332006 added missing metadata
Rem    ewittenb    10/29/14 - Creation
Rem


--
--    Server Version.  This is the HIGH numbered version in an upgrade/downgrade scenario
--                     and contains exactly 4 dots, i.e. 12.1.0.2.0
--                     If you need the version with fewer dots, look in package dbms_registry_extended.
--
define C_ORACLE_HIGH_VERSION_4_DOTS=12.2.0.1.0

--
--    The version of APEX that ships with the 12.2.0.0.0 version of Oracle.
--
define C_APEX_VERSION_4_DOTS=5.0.4.00.12

--
--    Latest oracore/zoneinfo/timezone_*.dat file shipped.
--
define C_LTZ_CONTENT_VER=26

--
--    The Oracle server versions that can be directly upgraded to C_ORACLE_HIGH_VERSION_4_DOTS
--    Note the value string intentionally includes NO SPACES, making version checks easier.
--
define C_UPGRADABLE_VERSIONS=11.2.0.3,11.2.0.4,12.1.0.1,12.1.0.2

--
--    Version specific default settings for PROCESSES initialization parameter
--
define C_DEFAULT_PROCESSES=300

--
--    Minimum setting for COMPATIBLE initialization parameter
--
define C_MINIMUM_COMPATIBLE=11.2.0

--
--    min value for upgrades to 12102 (needed for APEX)
--
define C_MIN_OPEN_CURSORS=150

--
--    Turn off SQLPLUS printint "Old Value: New Value:"
--
set verify off

