Rem
Rem $Header: rdbms/admin/cmpupend.sql /main/11 2016/06/14 23:41:26 cmlim Exp $
Rem
Rem cmpupend.sql
Rem
Rem Copyright (c) 2006, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      cmpupend.sql - CoMPonent UPgrade END script
Rem
Rem    DESCRIPTION
Rem      Final component upgrade actions
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    cmlim       06/06/16 - bug 23215791: add more DBUA_TIMESTAMPs during db
Rem                           upgrades
Rem    raeburns    01/10/16 - lrg 18666083: Add dbmsclr.plb for Windows NET
Rem                           extensions
Rem    raeburns    01/30/15 - move TSDP upgrade to xrdupgrd.sql
Rem    cmlim       05/15/13 - bug 16816410: add table name to errorlogging
Rem                           syntax
Rem    dgraj       11/12/11 - Project 32079: Upgrade action for TSDP
Rem    mdietric    03/23/11 - remove gathering stats - bug 11901407
Rem    cdilling    04/18/07 - add timestamp for gather_stats
Rem    rburns      12/07/06 - move gather_stats
Rem    cdilling    12/14/06 - add RDBMS identifier
Rem    rburns      07/19/06 - move final actions to catupend.sql 
Rem    rburns      05/22/06 - parallel upgrade 
Rem    rburns      05/22/06 - Created
Rem

set serveroutput off
set errorlogging on table sys.registry$error identifier 'ACTIONS';

SELECT dbms_registry_sys.time_stamp('ACTIONS_BGN') AS timestamp FROM DUAL;

Rem ===============================================================
Rem BEGIN ODE NET_EXTENSIONS upgrade
Rem ===============================================================

-- If dbms_clr objects are in the database, load the latest versions.
-- dbmsclr.plb is installed in rdbms/admin only on Windows and only 
-- when the NET_EXTENSIONS option is specified.  An SP2-0310 error
-- will be raised if the dbms_clr objects are in the database but the
-- dbmsclr.plb file is not in rdbms/admin.

COLUMN :clr_name NEW_VALUE clr_file NOPRINT;
VARIABLE clr_name VARCHAR2(256)

DECLARE
  found number:=0;
BEGIN
  SELECT 1 INTO found FROM dba_objects
  WHERE owner = 'SYS' AND object_type='LIBRARY'
    AND object_name = 'ORACLECLR_LIB';
  :clr_name := '?/rdbms/admin/dbmsclr.plb';
EXCEPTION
  WHEN NO_DATA_FOUND THEN
   :clr_name := sys.dbms_registry.nothing_script();
END;
/

-- Load the dbmsclr.plb script or the nothing script
SELECT :clr_name FROM DUAL;
@&clr_file

Rem ===============================================================
Rem End of ODE NET EXTENSIONS upgrade
Rem ===============================================================

-- DBUA_TIMESTAMP: database components upgrade finishes
SELECT dbms_registry_sys.time_stamp('CMPUPGRD') AS timestamp FROM DUAL;

-- DBUA_TIMESTAMP: FINAL upgrade scripts/ACTIONs begins
SELECT dbms_registry_sys.time_stamp_display('FINALACTION')
  AS timestamp FROM DUAL;

