Rem
Rem $Header: rdbms/admin/catsqlreg.sql /st_rdbms_12.2.0.1.0/1 2016/08/16 16:22:41 surman Exp $
Rem
Rem catsqlreg.sql
Rem
Rem Copyright (c) 2014, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      catsqlreg.sql - CAT SQLpatch REGistry
Rem
Rem    DESCRIPTION
Rem      Creates the registry$sqlpatch table and dba_registry_sqlpatch view
Rem      used by datapatch.
Rem
Rem    NOTES
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/catsqlreg.sql 
Rem    SQL_SHIPPED_FILE: rdbms/admin/catsqlreg.sql
Rem    SQL_PHASE: CATSQLREG
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/catxrd.sql
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      07/20/16 - 23170620: Add patch_directory
Rem    surman      06/14/16 - 22694961: Add datapatch_role
Rem    surman      04/01/16 - 23025340: Add install_id
Rem    surman      01/07/16 - 22359063: Add patch_descriptor
Rem    surman      10/01/15 - 20772435: Store as clob
Rem    surman      08/20/15 - 20772435: bundle_data back to XMLType
Rem    surman      10/08/14 - 19315691: bundle_data to CLOB
Rem    pyam        06/13/14 - fix table column ordering
Rem    surman      04/21/14 - Seperate script for SQL registry
Rem    surman      04/21/14 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

Rem SQL Registry table
Rem This is used to record the SQL patches that are applied and rolled back
Rem for this database instance.  It is updated by the patch apply and rollback
Rem scripts.
Rem 17277459: Add columns to track installation of bundle patches
Rem The flags column contains the following characters:
Rem  U: Patch requires upgrade mode
Rem  N: Patch requires normal mode
Rem  B: Patch is a bundle patch
Rem  J: Patch is a OJVM patch
Rem At least U or N must be present in flags.
Rem If the patch is not a bundle patch, then bundle_series will be NONE.
CREATE TABLE registry$sqlpatch (
  patch_id         NUMBER,         -- Patch ID
  action           VARCHAR2(15),   -- APPLY or ROLLBACK
  action_time      TIMESTAMP,      -- Time of action
  description      VARCHAR2(100),  -- Patch description
  logfile          VARCHAR2(500),  -- Location of logfile
  status           VARCHAR2(15),   -- BEGIN, END, SUCCESS, WITH ERRORS
  version          VARCHAR2(20),   -- First 4 digits of version
  patch_uid        NUMBER,         -- Patch UID
  flags            VARCHAR2(10),   -- Flags for this patch
  bundle_series    VARCHAR2(30),   -- PSU, EXA, WINBUNDLE, etc.
  bundle_id        NUMBER,         -- Bundle ID being installed
  bundle_data      XMLType,        -- Bundledata associated with this install
  patch_descriptor XMLType,        -- XML descriptor for this patch
  install_id       NUMBER,         -- Unique ID per datapatch invocation
  patch_directory  BLOB,           -- Zipped contents of patch directory
  CONSTRAINT registry$sqlpatch_pk
    PRIMARY KEY (patch_id, patch_uid, version, action, action_time)
  )
  XMLType COLUMN bundle_data STORE AS CLOB
  XMLType COLUMN patch_descriptor STORE AS CLOB
;


Rem -------------------------------------------------------------------------
Rem SQL Registry view
Rem -------------------------------------------------------------------------

CREATE OR REPLACE VIEW dba_registry_sqlpatch AS
  SELECT patch_id, patch_uid, version, flags, action, status, install_id,
         action_time, description, bundle_series, bundle_id,
         bundle_data, patch_descriptor, patch_directory, logfile
    FROM registry$sqlpatch;

CREATE OR REPLACE PUBLIC SYNONYM dba_registry_sqlpatch
                   FOR dba_registry_sqlpatch;

GRANT SELECT ON dba_registry_sqlpatch TO SELECT_CATALOG_ROLE;

execute CDBView.create_cdbview(false,'SYS','dba_registry_sqlpatch','CDB_registry_sqlpatch');
grant select on SYS.CDB_registry_sqlpatch to select_catalog_role
/
create or replace public synonym CDB_registry_sqlpatch for SYS.CDB_registry_sqlpatch
/

Rem -------------------------------------------------------------------------
Rem datapatch role
Rem -------------------------------------------------------------------------

DECLARE
  cnt NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO cnt
    FROM dba_roles
    WHERE role = 'DATAPATCH_ROLE';

  IF cnt = 0 THEN
    EXECUTE IMMEDIATE 'CREATE ROLE datapatch_role';
  END IF;
END;
/

@?/rdbms/admin/sqlsessend.sql
