Rem
Rem $Header: rdbms/admin/catnowrr.sql /main/6 2016/04/28 10:56:37 yberezin Exp $
Rem
Rem catnowrr.sql
Rem
Rem Copyright (c) 2006, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      catnowrr.sql - Catalog script to delete the 
Rem                     Workload Capture and Replay schema
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      Must be run when connected as SYSDBA
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catnowrr.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catnowrr.sql
Rem SQL_PHASE: CATNOWRR
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: NONE
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    yberezin    03/15/16 - add start/end
Rem    surman      01/23/15 - 20386160: Add SQL metadata tags
Rem    yujwang     02/07/14 - check before stopping capture/replay
Rem    kmorfoni    06/15/11 - drop tables required for workload intelligence
Rem    veeve       07/13/06 - stop capture/replay first
Rem    kdias       05/25/06 - rename record to capture 
Rem    veeve       04/11/06 - added catnowrrp.sql
Rem    veeve       01/25/06 - Created
Rem

@?/rdbms/admin/sqlsessstart.sql

Rem =========================================================
Rem Stop any Capture that is in progress
Rem =========================================================
declare
   cap_in_progress  NUMBER := 0;
begin
    SELECT count(*)
    INTO   cap_in_progress
    FROM   wrr$_captures
    WHERE  status = 'IN PROGRESS';

    if (cap_in_progress > 0) then
      dbms_workload_capture.finish_capture;
    end if;
end;
/

Rem =========================================================
Rem Stop any REPLAY that is in progress
Rem =========================================================
declare
   rep_in_progress  NUMBER := 0;
begin
    SELECT count(*)
    INTO   rep_in_progress
    FROM   wrr$_replays
    WHERE  status in ('IN PROGRESS', 'INITIALIZED', 'PREPARE');

    if (rep_in_progress > 0) then
      dbms_workload_replay.cancel_replay;
    end if;
end;
/

Rem
Rem Drop the common (shared by Capture and Replay) schema 
Rem and the Capture infrastructure tables 
@@catnowrrc.sql

Rem
Rem Drop the Replay infrastructure tables 
@@catnowrrp.sql

Rem =========================================================
Rem Dropping the common infra-structure tables
Rem =========================================================
Rem

drop table WRR$_FILTERS
/

Rem ==========================================================
Rem Dropping the the tables required for workload intelligence
Rem ==========================================================
Rem
@@catnowrrwitb.sql

@?/rdbms/admin/sqlsessend.sql
