Rem Copyright (c) 1987, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem NAME
Rem    CATMETINSERT.SQL - Inserts data into the Oracle dictionary for
Rem                       Metadata API.
Rem  FUNCTION
Rem     Inserts data into the Oracle dictionary
Rem     for use by the DataPump Metadata API.
Rem  NOTES
Rem     Must be run when connected to SYS or INTERNAL.
Rem     IMPORTANT! Keep the files catnomtt.sql and catnomta.sql in synch with
Rem     this file. These are invoked by catnodp.sql during downgrade.
Rem
Rem     All types must have EXECUTE granted to PUBLIC.
Rem     All top-level views used by the mdAPI to actually fetch full object
Rem     metadata (eg, KU$_TABLE_VIEW) must have SELECT granted to PUBLIC, but
Rem     must have CURRENT_USERID checking security clause.
Rem     All views subordinate to the top level views (Eg, KU$_SCHEMAOBJ_VIEW)
Rem     must have SELECT granted to SELECT_CATALOG_ROLE.
Rem
Rem     A note about export exclusion filters -
Rem     When adding a new object type and you wish to exclude objects of that
Rem     type assoc. with our list of Oracle-internal users/schemas, do NOT add
Rem     a whole new set of rows to ku_noexp_tab (in catdpb.sql) specific to that
Rem     new object type duplicating all 25+ excluded schemas; just make the 
Rem     filter reference the rows where obj_type = 'SCHEMA'. See type USER
Rem     as an example. Also note how ROLE_GRANTs make use of SCHEMA rows and
Rem     ROLE_GRANT rows for exclusion of grants to users and roles respectively.
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catmetinsert.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catmetinsert.sql
Rem SQL_PHASE: CATMETINSERT
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpdeps.sql
Rem END SQL_FILE_METADATA
Rem
Rem  MODIFIED     (MM/DD/YY)
Rem     jstenois   07/18/16 - XbranchMerge jstenois_bug-21912322 from main
Rem     bwright    06/23/16 - Bug 21912322: Add shard specific loading
Rem     jjanosik   06/22/16 - bug 23561567 - add remap_schema to on_user_grant
Rem     dvekaria   05/11/16 - Bug 22896578 Inc IDENTITY_COLUMN Filter.
Rem     sdavidso   04/27/16 - bug23179975 application table data exported
Rem                           twice.
Rem     sdavidso   04/14/16 - bug23098311 export app objects from app root
Rem     jjanosik   03/11/16 - bug 23014537 - add new transform param to force
Rem                           system generated partitions
Rem     tbhukya    03/02/16 - Bug 22859840: Initialize IND_SPARE4 correctly
Rem     youyang    02/15/16 - bug22672722:dv support for index functions
Rem     jjanosik   02/02/16 - bug 20317926 - version trigger
Rem     rapayne    01/22/16 - bug 22611512: TRANSPORTABLE parameter now a number.
Rem     dgagne     12/23/15 - add parse item for obj.flags
Rem     beiyu      01/13/15 - Bug 21365797: schema remap for HCS objs
Rem     sdavidso   11/24/15 - bug22264616 more move chunk subpart
Rem     jjanosik   11/18/15 - bug 21764718 - Add transform param and parse item
Rem     smesropi   11/09/15 - Bug 21171628: Rename HCS tables
Rem     sdavidso   11/04/15 - bug21869037 chunk move w/subpartitions
Rem     jibyun     11/01/15 - support DIAGNOSTIC auth for Database Vault
Rem     tbhukya    09/30/15 - Bug 21886016: Add param ENABLE_COLLATION
Rem     tbhukya    09/29/15 - Bug 21880241: Use PROPERTY2 in TOKEN_TAB filter
Rem     sdavidso   08/03/15 - bug-20756759: lobs, indexes, droppped tables
Rem     tbhukya    07/27/15 - Bug 21249249: Add TOKEN_TAB filter
Rem     yanchuan   07/27/15 - Bug 21299533: support for Database Vault
Rem                           Authorization
Rem     rapayne    07/24/15 - Bug 19241274: support partitions_by_quantity for 
Rem                           app fusion.
Rem     rapayne    07/19/15 - Bug 21459344: add new TABLE transform parameter,
Rem                           MATERIALIZED_ZONEMAP.
Rem     sdavidso   07/01/15 - bug20864693: read only partition support
Rem     mstasiew   06/18/15 - Bug 20744700: add TOTAL_ORDER HCS obj metafilter$
Rem                           fix HCS EXCLUDE_NOEXP metafilter$
Rem     rapayne    06/10/15 - bug 21205467: add DATA_LAYER_NOT_NETWORK transform param
Rem                           to SXML transform.
Rem     sanbhara   06/01/15 - Bug 21158282 - adding DVPS_COMMAND_RULE_ALTS_T.
Rem     sdavidso   05/15/15 - export app shared object data (for app root/pdb)
Rem     sdavidso   05/11/15 - bug21070097: multiple ordering filters do not
Rem                           work
Rem     sdavidso   05/01/15 - fix total order for constraint
Rem     rapayne    04/12/15 - Application Root support.
Rem     tbhukya    04/23/15 - Proj 47173: Add transform param COLLATION_CLAUSE
Rem     sdavidso   03/06/15 - Parallel metadata export
Rem     sdavidso   03/05/15 - proj 56220 - partition transportable
Rem     sogugupt   02/19/15 - Mark table as read only 
Rem     kaizhuan   02/05/15 - Bug 20481939: set DVPS_DV_POLICY dummy type 
Rem                           version to 0801000000 and register 
Rem                           kudvpolobjcalts in metastylesheet.
Rem     dgagne     01/13/15 - add table to index_by_name
Rem     beiyu      01/09/15 - Proj 47091: support for new HCS objects
Rem     tbhukya    12/18/14 - Proj 36477: Add XMLXVM_TRANSFORM_ENGINE param
Rem     rapayne    10/20/14 - bug 20164836: support for RAS schema level priv
Rem                           grants.
Rem     dgagne     12/04/14 - add parse item description
Rem     mjangir    12/02/14 - bug 18672264: modify order by clause for cyclic
Rem                           xml schema
Rem     tmontgom   11/20/14 - proj 32269: add REMAP_DIRECTORY transform param
Rem     kaizhuan   11/12/14 - Project 46812: support for Database Vault policy
Rem     bwright    11/05/14 - Support 'audit policy by granted roles'
Rem     dvekaria   11/03/14 - Bug 12920516: Turn on schema obj property for
Rem                           QUEUE TABLES.
Rem     mjangir    10/16/14 - bug 19827014: Add PARTITIONING transform param
Rem                           for CONSTRAINT
Rem     dgagne     09/23/14 - add parse item for index statistics
Rem     rapayne    09/21/13 - bug 19631502: add transform parameter to remove AQ clause.
Rem     tbhukya    09/09/14 - Lrg 13217417 : Remove KU$_12_1_INDEX_VIEW
Rem     rapayne    09/21/13 - bug 19631502: add transform parameter to remove AQ clause.
Rem     bwright    08/20/14 - Bug 16813931: Add length semantics parse item
Rem     jibyun     08/06/14 - Project 46812: support for Database Vault policy
Rem     rapayne    07/25/14 - lrg 12602979: enable 12g specific SYSGRANT view
Rem                           for 12.0 rather than 12.1
Rem     rapayne    07/15/14 - bug 19187205: add STATISITICS transform param to sxmlddl
Rem                           and sxml transforms - (this is ChangeManager specific and
Rem                           not used by Data Pump). Note: it is used to test CM
Rem                           specific code paths).
Rem     mwjohnso   07/15/14 - BUG 15979889: add USE_DATA_VALIDATE_HINT 
Rem     tbhukya    06/10/14 - Proj 32344 : Add rbo flag for PROCACT_INSTANCE, 
Rem                           XS_SECURITY_CLASS, XS_ACL objects.
Rem     mjangir    05/06/14 - bug 17605620: use cbo for ku$_procact_schema_view 
Rem     rapayne    04/26/14 - proj 46816: support for new sysrac priv.
Rem     lbarton    04/23/14 - bug 18374198: default on null
Rem     lbarton    03/13/14 - bug 18391893: REMAP_CONSTRAINT_NAME
Rem     lbarton    02/27/14 - bug 18322658: OMIT_COL_DATATYPE
Rem     sdavidso   02/17/14 - bug14821907: find tablespaces: table
Rem                           transportable
Rem     gclaborn   01/27/14 - 17247965: New table_data parse items for
Rem                           versioned import callouts
Rem     tbhukya    01/24/14 - Bug 13770504: Add UPGRADE_V10_XMLTYPE 
Rem                           transform param and remove param XMLCOL_V10P
Rem     lbarton    01/02/14 - bug 17943479: REMAP_SCHEMA for virtual cols
Rem     surman     12/29/13 - 13922626: Update SQL metadata
Rem     sdavidso   12/23/13 - bug17945280: export package bodys without headers
Rem     rapayne    12/23/13 - lrg 10074752: ku$_objgrant_view should be
Rem                           conditionalized on 12.0 not 12.1.
Rem     mjangir    12/21/13 - bug 17500493: AQ storage_clause with lob column
Rem     sdavidso   12/18/13 - lrg10206271: total order for procact_sys_pkg
Rem     tbhukya    12/11/13 - Bug 17803321: Add view KU$_12_1_INDEX_VIEW
Rem     bwright    11/25/13 - Bug 17801303: Diff default action for
Rem                           PRESERVE_TYPE_EVOLUTION for GET_DDL (no)
Rem                           than for DP import (yes)
Rem     gclaborn   10/09/13 - bug#17543726: Add noexp exc. filter for 
Rem                           passwd_verify_function
Rem     lbarton    10/02/13 - Project 48787: views to document mdapi transforms
Rem     lbarton    09/24/13 - bug 17236189: IND_SPARE4 parse item and transform
Rem                           param
Rem     sdavidso   09/23/13 - proj-47829 don't export READ priv to pre 12.1.0.2
Rem     sdavidso   09/06/13 - bug 17422784: fix exclude xdb repository
Rem     lbarton    08/15/13 - bug 16800820: valid-time temporal
Rem     gclaborn   08/08/13 - 16304706/17070445: Dont export Oracle-supplied
Rem                           or common users and roles
Rem     sdavidso   08/05/13 - bug14589782: allow exclude of XDB repository 
Rem                           tablespace from full transportable export
Rem     dvekaria   07/08/13 - Bug 14794472: Dont use Rule Base Optimizer for 
Rem                           KU$_TABLESPACE_VIEW.
Rem     lbarton    05/23/13 - bug 15872712: ILM policies
Rem     lbarton    05/16/13 - bug 16821535: INDEX_BY_NAME for REF_CONSTRAINT
Rem     dvekaria   05/15/13 - Bug 16811897 Prevent PASSWORD_HISTORY being
Rem                           imported for existing users.
Rem     sdavidso   05/08/13 - Add transforms for INMEMORY
Rem     rapayne    04/15/13 - bug 16310682: reduce memory for procact_schema
Rem     lbarton    03/14/13 - bug 14705313: IN_TSNUM transform
Rem     lbarton    03/12/13 - lrg 8879853: add REMAP_NAME parameter to
Rem                           MODIFYSTREAMSXML
Rem     rapayne    02/21/13 - add REMAP_SCHEMA parameter to MODIFYSTREAMSXML
Rem                           transform.
Rem     sdavidso   02/18/13 - Bug16051676: transportable partitioned index
Rem                           export
Rem     dgagne     01/31/13 - add null_constraints transform
Rem     dgagne     01/30/13 - fix bug for authpwdx
Rem     dvekaria   01/23/13 - Bug 14703309: Allow import of Priv Syn using DBLink.
Rem     rapayne    01/15/13 - bug 14802958: add PRESERVE_LOCAL transform
Rem                           parameter for INDEX SXMLDDL transforms.
Rem     dgagne     01/10/13 - return ancestor name for constraint as base
Rem                           object if available
Rem     sdavidso   01/04/13 - bug15930360 preserve table lock disable
Rem     sdavidso   12/24/12 - XbranchMerge sdavidso_bug14490576-2 from
Rem                           st_rdbms_12.1.0.1
Rem     lbarton    12/19/12 - bug 14202396: implement REMAP_COLUMN_NAME in
Rem                           MODIFY transform
Rem     lbarton    12/18/12 - bug 14239108: fix NAMED in _EXPORT_OBJECTS views
Rem     rapayne    11/06/12 - bug 15832675: create 11_2_view_view to exclude
Rem                           views with bequeath current_user.
Rem     sdavidso   10/31/12 - bug14490576 - 2ndary tables for
Rem                           full/transportable
Rem     sdavidso   10/26/12 - bug14783517 - SOURCE_VERSION trans param
Rem     dgagne     10/19/12 - bug 12866600
Rem     lbarton    10/09/12 - bug 10350062: ILM compression and storage tiering
Rem     rapayne    10/03/12 - lrg 7256879: force sql_execute for XS objects.
Rem     bwright    09/27/12 - Bug 14679947: Add import TYPE retry w/o evolution
Rem     mjangir    09/25/12 - bug 14658090: move catmetx.sql in catmet2sql
Rem     rapayne    09/12/12 - bug 13899189: do not fetch tables with virtual
Rem                           columns when version < 11g.
Rem     sdavidso   08/16/12 - bug 12977174 - allow option tags for
Rem                           include/exclude
Rem     rapayne    08/10/12 - lrg 7071802: new mviews to support secondary
Rem                           materialized views.
Rem     lbarton    07/26/12 - bug 13454387: long varchar
Rem     rapayne    07/21/12 - bug 13823879: the XS stylesheets have been 
Rem                           changed to limit the number privs that can be
Rem                           added to a security class at one time. If
Rem                           these are large than they will require calling
Rem                           dbms_sql.execute.
Rem     ssonawan   07/19/12 - bug 13843068: add ku$_11_2_psw_hist_view
Rem     dgagne     06/28/12 - remove base object name from audit object type
Rem     lbarton    06/13/12 - bug 13872190: CONVERT TIMESTAMP WITH TIME ZONE
Rem                           DATA
Rem     lbarton    05/22/12 - but 14092408: base object for procdepobj_grant_t
Rem                           should be anc_obj
Rem     jerrede    04/10/12 - Fix lrg 6849985 ORA-04063: package body
Rem                           SYS.DBMS_SCHEDULER has errors
Rem     gclaborn   04/05/12 - Add base object parsing for ALTER PACKAGE, et al
Rem     gclaborn   04/02/12 - Change ON_USER_GRANT exclusion filter
Rem     surman     03/27/12 - 13615447: Add SQL patching tags
Rem     gclaborn   03/22/12 - explicitly exclude GRANT INHERIT PRIVILEGES ON
Rem                           USER PUBLIC
Rem     sdavidso   03/22/12 - lrg6829209 - change default for INDEX_BY_NAME
Rem     sdavidso   03/05/12 - bug 13714302: remove sort of indexes
Rem     gclaborn   02/28/12 - Change NOEXP filters to use schema rows
Rem     lbarton    02/09/12 - project 37414: ILM support
Rem     ebatbout   01/30/12 - Proj. 36950: Code based role grants
Rem     sdavidso   01/23/12 - bug 13568859: exclude Oracle objects from export
Rem     rapayne    12/05/12 - bug 13569741: make minimun version for triton
Rem                           objects 12.0 (not 12.1)
Rem     sdavidso   12/22/11 - bug 11840083: reduce memory for procact_system
Rem     sdavidso   10/11/11 - add audit policy objects
Rem     rapayne    12/07/11 - bug 13421297: force TABLE_STATISTICS to use cbo.
Rem     ebatbout   11/09/11 - Project 36951: On_User_Grant support
Rem     sdavidso   11/03/11 - lrg 6000876: no export 12.1 privs to pre-12
Rem     lbarton    11/02/11 - 36954_dpump_tabcluster_zonemap
Rem     rapayne    10/24/11 - enable modify for XS objects.
Rem     dgagne     10/24/11 - add privname for object_grant
Rem     lbarton    10/20/11 - REMAP_IND_TABLESPACE
Rem     ebatbout   10/14/11 - 12781157: Add parse items, UNPACKEDCOL_COUNT and
Rem                           and UNPACKEDCOL_LIST wrt unpacked opaque types
Rem     lbarton    10/13/11 - lrg 5937462: don't export common grants
Rem     rapayne    08/30/11 - Triton rename to Real Application Security (RAS).
Rem     lbarton    09/30/11 - bug 12998372: REMAP_LOB_TABLESPACE, etc.
Rem     rapayne    08/01/11 - Project 36780: Identity Column support.
Rem     jerrede    09/07/11 - Created for Parallel Upgrade Project #23496
Rem

@@?/rdbms/admin/sqlsessstart.sql

-- POPULATE THE DICTIONARY TABLES WITH THE ORACLE MODEL INFORMATION
-- The Metadata API is table-driven. The following inserts set up the ORACLE
-- object model of the dictionary. Other models (eg, CWM, ANSI, etc) can be
-- plugged in by emulating what we do here.
-- To support upgrade/downgrade all inserts must specify a column list.
-- First, clear out old stuff.
--
DELETE FROM sys.metaview$               WHERE model='ORACLE';
DELETE FROM sys.metafilter$             WHERE model='ORACLE';
DELETE FROM sys.metaxslparamdesc$       WHERE model='ORACLE';
DELETE FROM sys.metaxslparam$           WHERE model='ORACLE';
DELETE FROM sys.metaxsl$                WHERE model='ORACLE';
DELETE FROM sys.metastylesheet          WHERE model='ORACLE';
DELETE FROM sys.metascript$             WHERE model='ORACLE';
DELETE FROM sys.metascriptfilter$       WHERE model='ORACLE';
DELETE FROM sys.metanametrans$          WHERE model='ORACLE';
DELETE FROM sys.metapathmap$            WHERE model='ORACLE';

-- Populate metaview$: This table identifies which view (object or relational)
-- to generate a SELECT against for a given object type. Might be multiple rows
-- in this table per object type if the object type's space has been
-- partitioned into multiple views. We did this for tables for performance:
-- Simple, relational, non-partitioned tables are in a high performance object
-- view with a relatively simple UDT.

-- The metaview$.properties column has the following defined bit values:
-- 0x00000001 1         schema object
-- 0x00000002 2         heterogeneous object type
-- 0x00000004 4         internal object type
-- 0x00000008 8         soft connect (do ALTER SESSION SET CURRENT_SCHEMA
--                              before creating object)
-- 0x00000010 16        hard connect (connect to schema before creating object)
-- 0x00000020 32        callout type
-- 0x00000040 64        dbms_sql.execute needed after dbms_sql.parse
--                      This is required for pl/sql blocks which exceed 32k.
-- 0x00000080 128       Object can be loaded in parallel
-- 0x00000100 256       object number fetch, no xml returned
-- 0x00000200 512       object number, dependent obj# fetch, no xml returned
-- 0x00000400 1024      Don't use rule base optimizer (Unused)
-- 0x00000800 2048      spare - used to be:
--                   object number, object name fetch, no xml returned
--                   for objects requiring name for unique ID (e.g., RLS_POICY)
-- 0x00001000 4096      fetch UDT not XMLType in query (don't use SYS_XMLGEN)
-- 0x00002000 8192      views_as_tables/create(drop)_table callouts
-- 0x00004000 16384     Marker step (special handling for marker number)
-- 0x00008000 32768     spare - used to be:
--                   object number, table-type fetch
-- 0x00010000 65536     No XML - just return parse items
-- 0x00020000 131072    add 'UNIQUE' to generated query
-- 0x00040000 262144    callout to load temporary table for estimate phase
-- 0x00080000 524288    Use rule based optimizer
-- 0x00100000 1048576   Use Old LPX transformation engine	
-- 0x00200000 2097152   Use New XmlXvm transformation engine
-- 0x00400000 4194304   Don't default owner to base owner for schema objects
--
-- NOTE: The following table flags are internal to the mdAPI and do *not*
-- correspond to the 'property' bits in tab$.

rem  table flags:   1 = heap tables
rem                 2 = index-organized tables
rem                 4 = unused
rem                 8 = unused
rem                16 = non-partitioned tables
rem                32 = partitioned tables
rem                64 = unused
rem               128 = unused
rem               256 = relational tables
rem               512 = object tables
rem              1024 = unused
rem              2048 = unused
rem              4096 = tables with builtin, non-LOB datatypes
rem              8192 = tables with LOB columns
rem             16384 = tables with UDT columns
rem
rem  The next flags designate the particular view.  This allows a filter
rem  to explicitly specify a desired set of views.
rem
rem             65536 = HTABLE     (10000x)
rem            131072 = FHTABLE    (20000x)
rem            262144 = PHTABLE    (40000x)
rem            524288 = PFHTABLE   (80000x)
rem           1048576 = IOTABLE   (100000x)
rem           2097152 = PIOTABLE  (200000x)
rem           4194304 = CPFHTABLE (400000x)
rem           8388608 = SECMVIEW  (800000x)

rem Like tables, materialized views and materialized view logs
rem have multiple UDTs and views. Each mv and mvl UDT contains
rem one of the table UDTs. Note that not all table types are represented.

rem ku$_*table_view used for version 10.2.0 and later
rem ku$_10_1_*table_view used for prior versions

rem heap, non-partitioned, relational, no LOB or UDT columns
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',1+16+64+256+4096+65536,1+1024,'ORACLE',1002000000,'TABLE_T',
         'KU$_HTABLE_T','SYS','KU$_HTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',1+16+64+256+4096+65536,1+1024,'ORACLE',0801000000,'TABLE_T',
         'KU$_HTABLE_T','SYS','KU$_10_1_HTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_VIEW_LOG',1+16+256+4096+65536,0,'ORACLE',0801000000,
         'M_VIEW_LOG_T', 'KU$_M_VIEW_LOG_H_T','SYS','KU$_M_VIEW_LOG_H_VIEW');

rem heap, non-partitioned, relational or object, any datatype
rem FHTABLE_VIEW does NOT set the bit for builtin, non-LOB types so that it
rem will be mutually exclusive of view HTABLE_VIEW. In other words, we DON'T
rem want this view used for simple relational tables because it's slow.

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('TABLE',1+16+256+512+8192+16384+131072,1+1024,'ORACLE',1100000000,'TABLE_T',
         'KU$_FHTABLE_T','SYS','KU$_FHTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('TABLE',1+16+256+512+8192+16384+131072,1+1024,'ORACLE',1002000000,'TABLE_T',
         'KU$_FHTABLE_T','SYS','KU$_10_2_FHTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('TABLE',1+16+256+512+8192+16384+131072,1+1024,'ORACLE',0801000000,'TABLE_T',
         'KU$_FHTABLE_T','SYS','KU$_10_1_FHTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
     ('MATERIALIZED_VIEW',1+16+256+512+8192+16384+131072,16+1,'ORACLE',
       0801000000, 'M_VIEW_T','KU$_M_VIEW_FH_T','SYS','KU$_M_VIEW_FH_VIEW');

-- bug 6750821 and lrg 7071802: secondary Materialized Views must be 
-- fetched/created before the primary mviews that reference them.
-- This used to be accomplished with an 'order by parent_vname nulls last'.
-- Now there are additional mview views the follow the naming convention, ku$_zm_*
-- (e.g., ku$_zm_view_view, ku$_zm_view_fh_view, etc.) which fetch just the
-- secondary mviews. The ordering of the fetch is implicitly accomplished 
-- by the name of the view.

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
     ('MATERIALIZED_VIEW',1+16+256+512+8192+16384+8388608,16+1,'ORACLE',
       0801000000, 'M_VIEW_T','KU$_M_VIEW_FH_T','SYS','KU$_ZM_VIEW_FH_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('MATERIALIZED_VIEW_LOG',1+16+256+512+8192+16384+131072,0,'ORACLE',0801000000,
         'M_VIEW_LOG_T','KU$_M_VIEW_LOG_FH_T','SYS','KU$_M_VIEW_LOG_FH_VIEW');

rem heap, partitioned, relational, no LOB or UDT columns
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',1+32+256+4096+262144,1+1024,'ORACLE',1002000000,'TABLE_T',
         'KU$_PHTABLE_T','SYS','KU$_PHTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',1+32+256+4096+262144,1+1024,'ORACLE',0801000000,'TABLE_T',
         'KU$_PHTABLE_T','SYS','KU$_10_1_PHTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_VIEW_LOG',1+32+256+4096+262144,0,'ORACLE',0801000000,
         'M_VIEW_LOG_T', 'KU$_M_VIEW_LOG_PH_T','SYS','KU$_M_VIEW_LOG_PH_VIEW');

rem heap, partitioned, relational or object, any datatype
rem PFHTABLE_VIEW does NOT set the bit for builtin, non-LOB types so that it
rem will be mutually exclusive of view PHTABLE_VIEW. In other words, we DON'T
rem want this view used for simple, partitioned tables because it's slow.

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('TABLE',1+32+256+512+8192+16384+524288,1+1024,'ORACLE',1002000000,'TABLE_T',
         'KU$_PFHTABLE_T','SYS','KU$_PFHTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('TABLE',1+32+256+512+8192+16384+524288,1+1024,'ORACLE',0801000000,'TABLE_T',
         'KU$_PFHTABLE_T','SYS','KU$_10_1_PFHTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
     ('MATERIALIZED_VIEW',1+32+256+512+8192+16384+524288,16+1,
         'ORACLE',0801000000,
         'M_VIEW_T', 'KU$_M_VIEW_PFH_T','SYS','KU$_M_VIEW_PFH_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
     ('MATERIALIZED_VIEW',1+32+256+512+8192+16384+8388608,16+1,
         'ORACLE',0801000000,
         'M_VIEW_T', 'KU$_M_VIEW_PFH_T','SYS','KU$_ZM_VIEW_PFH_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_VIEW_LOG',1+32+256+512+8192+16384+524288,0,
         'ORACLE',0801000000,
         'M_VIEW_LOG_T', 'KU$_M_VIEW_LOG_PFH_T','SYS',
         'KU$_M_VIEW_LOG_PFH_VIEW');

-- all child reference partionioned tables - includes both primitive
-- and full tables, as this view orders by level across those types.

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('TABLE',1+32+256+512+8192+16384+4194304,1+1024,'ORACLE',1100000000,'TABLE_T',
         'KU$_CPFHTABLE_T','SYS','KU$_ACPTABLE_VIEW');

rem IOT, non-partitioned, relational, any datatype
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',2+16+256+512+4096+8192+16384+1048576,1+1024,'ORACLE',
         1002000000,'TABLE_T',
         'KU$_IOTABLE_T','SYS','KU$_IOTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',2+16+256+512+4096+8192+16384+1048576,1+1024,'ORACLE',
         0801000000,'TABLE_T',
         'KU$_IOTABLE_T','SYS','KU$_10_1_IOTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_VIEW',2+16+256+512+4096+8192+16384+1048576,16+1,
         'ORACLE', 0801000000,'M_VIEW_T','KU$_M_VIEW_IOT_T','SYS',
          'KU$_M_VIEW_IOT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_VIEW',2+16+256+512+4096+8192+16384+8388608,16+1,
         'ORACLE', 0801000000,'M_VIEW_T','KU$_ZM_VIEW_IOT_T','SYS',
          'KU$_M_VIEW_IOT_VIEW');

rem IOT, partitioned, relational, any datatype
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',2+32+256+512+4096+8192+16384+2097152,1+1024,'ORACLE',
         1002000000,'TABLE_T',
         'KU$_PIOTABLE_T','SYS','KU$_PIOTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('TABLE',2+32+256+512+4096+8192+16384+2097152,1+1024,'ORACLE',
         0801000000,'TABLE_T',
         'KU$_PIOTABLE_T','SYS','KU$_10_1_PIOTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_VIEW',2+32+256+512+4096+8192+16384+2097152,16+1,
         'ORACLE', 0801000000,'M_VIEW_T', 'KU$_M_VIEW_PIOT_T','SYS',
         'KU$_M_VIEW_PIOT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_VIEW',2+32+256+512+4096+8192+16384+8388608,16+1,
         'ORACLE', 0801000000,'M_VIEW_T', 'KU$_ZM_VIEW_PIOT_T','SYS',
         'KU$_M_VIEW_PIOT_VIEW');

-- materialized zonemap (modeled on materialized view)
--
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
     ('MATERIALIZED_ZONEMAP',1+16+256+512+8192+16384+131072,16+1,'ORACLE',
       1200000000, 'M_ZONEMAP_T','KU$_M_VIEW_FH_T','SYS',
        'KU$_M_ZONEMAP_FH_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
     ('MATERIALIZED_ZONEMAP',1+32+256+512+8192+16384+524288,16+1,
         'ORACLE',1200000000,
         'M_ZONEMAP_T', 'KU$_M_VIEW_PFH_T','SYS','KU$_M_ZONEMAP_PFH_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_ZONEMAP',2+16+256+512+4096+8192+16384+1048576,16+1,
         'ORACLE', 1200000000,'M_ZONEMAP_T','KU$_M_VIEW_IOT_T','SYS',
          'KU$_M_ZONEMAP_IOT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('MATERIALIZED_ZONEMAP',2+32+256+512+4096+8192+16384+2097152,16+1,
         'ORACLE', 1200000000,'M_ZONEMAP_T', 'KU$_M_VIEW_PIOT_T','SYS',
         'KU$_M_ZONEMAP_PIOT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_OBJNUM',0,1+1024,'ORACLE',1200000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_TABLE_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_OBJNUM',0,1+1024,'ORACLE',1100000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_11_2_TABLE_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_OBJNUM',0,1+1024,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_10_1_TABLE_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SECONDARY_TABLE_OBJNUM',0,1024,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_2ND_TABLE_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('NTABLE_OBJNUM',0,0,'ORACLE',1200000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_NTABLE_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('NTABLE_OBJNUM',0,0,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_11_2_NTABLE_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XDB_NTABLE_OBJNUM',0,256,'ORACLE',1200000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_XDB_NTABLE_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XDB_NTABLE_OBJNUM',0,256,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_11_2_XDB_NTBL_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OPTION_OBJNUM',0,256,'ORACLE',1200000000,
  'OPTION_OBJNUM_T','KU$_OPTION_OBJNUM_T','SYS',
  'KU$_OPTION_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('MARKER',0,16384,'ORACLE',1200000000,
  'MARKER_T','KU$_MARKER_T','SYS', 'KU$_MARKER_VIEW');

-- used set table attributes after data is loaded.
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('POST_DATA_TABLE',0,0,'ORACLE',1102000000,
  'POST_DATA_TABLE_T', 'KU$_POST_DATA_TABLE_T','SYS', 'KU$_POST_DATA_TABLE_VIEW');

-- mv_deptbl_objnum view is used to find materialized view temp log tables
--  which must be exported with mv logs in transportable mode.
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('MV_DEPTBL_OBJNUM',0,256,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_MV_DEPTBL_OBJNUM_T','SYS','KU$_MV_DEPTBL_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DEPTABLE_OBJNUM',0,0,'ORACLE',1200000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_DEPTABLE_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DEPTABLE_OBJNUM',0,0,'ORACLE',0801000000,
  'TABLEOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_11_2_DEPTBL_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABTYPE_OBJNUM',0,256,'ORACLE',0801000000,
  'TABTYPEOBJNUM_T',NULL,'SYS','KU$_TTS_TYPES_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CLUSTERING',0,0,'ORACLE',1200000000,
  'CLST_T','KU$_TABCLST_T','SYS','KU$_TABCLST_VIEW');

rem
rem  type flags:  1 = type specification
rem               2 = type body
rem

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE',1,1,'ORACLE',0801000000,
  'TYPE_T','KU$_TYPE_T','SYS','KU$_TYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE',2,1,'ORACLE',0801000000,
  'TYPE_BODY_T','KU$_TYPE_BODY_T','SYS','KU$_TYPE_BODY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE',3,1,'ORACLE',0801000000,
  'FULL_TYPE_T','KU$_FULL_TYPE_T','SYS','KU$_FULL_TYPE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE_SPEC',0,1,'ORACLE',0801000000,
  'TYPE_T','KU$_TYPE_T','SYS','KU$_TYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TYPE_BODY',0,1,'ORACLE',0801000000,
  'TYPE_BODY_T', 'KU$_EXP_TYPE_BODY_T','SYS','KU$_EXP_TYPE_BODY_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INC_TYPE',0,1,'ORACLE',0902000000,
  'INC_TYPE_T', 'KU$_SCHEMAOBJ_T','SYS','KU$_INC_TYPE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SORT_TYPES',0,1+512,'ORACLE',0902000000,
  'SORT_TYPES_T', NULL,'SYS','KU$_DEPTYPES_VIEW');


rem
rem  package flags:  1 = package specification
rem                  2 = package body
rem

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
               ('PACKAGE_OBJNUM',0,1+256,'ORACLE',0801000000,'PACKAGEOBJNUM_T',
                      'KU$_PROC_OBJNUM_T','SYS','KU$_PKG_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
               ('PACKAGE',1,1+8,'ORACLE',0801000000,'PACKAGE_T',
                      'KU$_PROC_T','SYS','KU$_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
               ('PACKAGE',2,1+8,'ORACLE',0801000000,'PACKAGE_BODY_T',
                      'KU$_PROC_T','SYS','KU$_PKGBDY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PACKAGE',3,1+8,'ORACLE',0801000000,
  'FULL_PACKAGE_T','KU$_FULL_PKG_T','SYS','KU$_FULL_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PACKAGE_SPEC',0,1+8,'ORACLE',0801000000,
  'PACKAGE_T','KU$_PROC_T','SYS','KU$_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PACKAGE_BODY',0,1+8+128,'ORACLE',0801000000,
  'PACKAGE_BODY_T','KU$_EXP_PKG_BODY_T','SYS','KU$_EXP_PKG_BODY_VIEW');


insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX',0,1024+64+16+1,'ORACLE',0801000000,'INDEX_T',
  'KU$_INDEX_T','SYS','KU$_10_2_INDEX_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX',0,1024+64+16+1,'ORACLE',1100000000,'INDEX_T',
  'KU$_INDEX_T','SYS','KU$_INDEX_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DOMIDX_OBJNUM',0,256,'ORACLE',0801000000,
  'DOMIDXOBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_DOMIDX_OBJNUM_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCEDURE',0,1+8,'ORACLE',0801000000,'PROCEDURE_T',
  'KU$_PROC_T','SYS','KU$_PROC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('FUNCTION',0,1+8,'ORACLE',0801000000,'FUNCTION_T',
  'KU$_PROC_T','SYS','KU$_FUNC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_PROCEDURE',0,1+8,'ORACLE',0902000000,'ALTER_PROCEDURE_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_PROC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_FUNCTION',0,1+8,'ORACLE',0902000000,'ALTER_FUNCTION_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_FUNC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_PACKAGE_SPEC',0,1+8,'ORACLE',0902000000,'ALTER_PACKAGE_SPEC_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_PKGSPC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ALTER_PACKAGE_BODY',0,1+8,'ORACLE',0902000000,'ALTER_PACKAGE_BODY_T',
  'KU$_ALTER_PROC_T','SYS','KU$_ALTER_PKGBDY_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OPERATOR',0,1,'ORACLE',0801000000,'OPERATOR_T',
  'KU$_OPERATOR_T','SYS','KU$_OPERATOR_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEXTYPE',0,1,'ORACLE',0801000000,'INDEXTYPE_T',
  'KU$_INDEXTYPE_T','SYS','KU$_INDEXTYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OBJECT_GRANT',0,16+1024+4096,'ORACLE',1200000000,
  'OBJGRANT_T','KU$_OBJGRANT_T','SYS','KU$_OBJGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OBJECT_GRANT',0,16+1024+4096,'ORACLE',0801000000,
  'OBJGRANT_T','KU$_OBJGRANT_T','SYS','KU$_10_1_OBJGRANT_VIEW');

rem ku$_sysgrant_view used for version 10.2.0 and later
rem ku$_10_1_sysgrant_view used for prior versions

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_GRANT',0,16,'ORACLE',1202000000,
  'SYSGRANT_T','KU$_SYSGRANT_T','SYS','KU$_SYSGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_GRANT',0,16,'ORACLE',1200000000,
  'SYSGRANT_T','KU$_SYSGRANT_T','SYS','KU$_12_1_SYSGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_GRANT',0,16,'ORACLE',1002000000,
  'SYSGRANT_T','KU$_SYSGRANT_T','SYS','KU$_11_2_SYSGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_GRANT',0,16,'ORACLE',0801000000,
  'SYSGRANT_T','KU$_SYSGRANT_T','SYS','KU$_10_1_SYSGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRIGGER',0,1+8+1024+4194304,'ORACLE',1202000000,'TRIGGER_T',
  'KU$_TRIGGER_T','SYS','KU$_TRIGGER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRIGGER',0,1+8+1024+4194304,'ORACLE',1200000000,'TRIGGER_T',
  'KU$_TRIGGER_T','SYS','KU$_12_1_TRIGGER_VIEW'); 
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRIGGER',0,1+8+1024+4194304,'ORACLE',1100000000,'TRIGGER_T',
  'KU$_TRIGGER_T','SYS','KU$_11_2_TRIGGER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRIGGER',0,1+8+1024+4194304,'ORACLE',0801000000,'TRIGGER_T',
  'KU$_TRIGGER_T','SYS','KU$_10_2_TRIGGER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('VIEW',0,1+8,'ORACLE',0801000000,'VIEW_T',
  'KU$_VIEW_T','SYS','KU$_11_2_VIEW_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('VIEW',0,1+8,'ORACLE',1200000000,'VIEW_T',
  'KU$_VIEW_T','SYS','KU$_VIEW_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('VIEW_OBJNUM',0,1+256,'ORACLE',0801000000,
  'VIEWOBJNUM_T','KU$_SCHEMAOBJ_T','SYS','KU$_VIEW_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SORT_VIEWS',0,512,'ORACLE',0902000000,
  'SORT_VIEWS_T', NULL,'SYS','KU$_DEPVIEWS_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('OUTLINE',0,0,'ORACLE',0801000000,'OUTLINE_T',
  'KU$_OUTLINE_T','SYS','KU$_OUTLINE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYNONYM',0,1,'ORACLE',0801000000,'SYNONYM_T',
  'KU$_SYNONYM_T','SYS','KU$_SYNONYM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DIRECTORY',0,0,'ORACLE',0801000000,
  'DIRECTORY_T', 'KU$_DIRECTORY_T','SYS', 'KU$_DIRECTORY_VIEW');

rem
rem 12c project 32006: RADM, add datapump support
rem
insert into metaview$ (type, flags, properties, model, version,
                       xmltag, udt, schema, viewname) values
 ('RADM_POLICY',0,64,'ORACLE',1200000000,
  'RADM_POLICY_T','KU$_RADM_POLICY_T','SYS','KU$_RADM_POLICY_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag, udt, schema, viewname) values
 ('RADM_FPTM',0,0,'ORACLE',1200000000,
  'RADM_FPTM_T','KU$_RADM_FPTM_T','SYS','KU$_RADM_FPTM_VIEW');

rem
rem bug 6938028: Database Vault Protected Schema.
rem Insert the rows into metaview$ for the dummy Data Pump types.
rem
rem Note that these type registrations are for the dummy types
rem (defined in the SYS schema), and not the real types (those are
rem defined in the DVSYS schema). The dummy type names contain the string
rem "DUMMY_" instead of "DV_", to distinguish them from the real types.
rem
rem The use of the "version" attribute allows us to ensure that the rows
rem in metaview$ for the new Database Vault object types always correspond
rem to valid existing UDTs and views, whether or not Database Vault is
rem installed.
rem
rem Here, the version is set to 0801000000 for the dummy types, which allows
rem them to be used as long as the real types do not exist.
rem
rem Once the real types are registered by $SRCHOME/rdbms/admin/catmacdd.sql
rem during the Database Vault installation (with a version of 1002000200),
rem they will be used instead of the dummy types, even though the dummy
rem type registration (with version 0801000000) remains present.
rem
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_REALM',0,0,'ORACLE',0801000000,
  'DVPS_REALM_T',
  'KU$_DUMMY_REALM_T','SYS','KU$_DUMMY_REALM_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_REALM_MEMBERSHIP',0,0,'ORACLE',0801000000,
  'DVPS_REALM_MEMBERSHIP_T',
  'KU$_DUMMY_REALM_MEMBER_T','SYS','KU$_DUMMY_REALM_MEMBER_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_REALM_AUTHORIZATION',0,0,'ORACLE',0801000000,
  'DVPS_REALM_AUTHORIZATION_T',
  'KU$_DUMMY_REALM_AUTH_T','SYS','KU$_DUMMY_REALM_AUTH_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_IMPORT_STAGING_REALM',0,0,'ORACLE',0801000000,
  'DVPS_IMPORT_STAGING_REALM_T',
  'KU$_DUMMY_ISR_T','SYS','KU$_DUMMY_ISR_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_STAGING_REALM_MEMBERSHIP',0,0,'ORACLE',0801000000,
  'DVPS_STAGING_REALM_MEMBERSHP_T',
  'KU$_DUMMY_ISRM_T','SYS','KU$_DUMMY_ISRM_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DROP_IMPORT_STAGING_REALM',0,0,'ORACLE',0801000000,
  'DVPS_DISR_T',
  'KU$_DUMMY_ISR_T','SYS','KU$_DUMMY_ISR_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_RULE',0,0,'ORACLE',0801000000,
  'DVPS_RULE_T',
  'KU$_DUMMY_RULE_T','SYS','KU$_DUMMY_RULE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_RULE_SET',0,0,'ORACLE',0801000000,
  'DVPS_RULE_SET_T',
  'KU$_DUMMY_RULE_SET_T','SYS','KU$_DUMMY_RULE_SET_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_RULE_SET_MEMBERSHIP',0,0,'ORACLE',0801000000,
  'DVPS_RULE_SET_MEMBERSHIP_T',
  'KU$_DUMMY_RULE_SET_MEMBER_T','SYS','KU$_DUMMY_RULE_SET_MEMBER_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_COMMAND_RULE',0,0,'ORACLE',0801000000,
  'DVPS_COMMAND_RULE_T',
  'KU$_DUMMY_COMMAND_RULE_T','SYS','KU$_DUMMY_COMMAND_RULE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_COMMAND_RULE_ALTS',0,0,'ORACLE',0801000000,
  'DVPS_COMMAND_RULE_ALTS_T',
  'KU$_DUMMY_COMM_RULE_ALTS_T','SYS','KU$_DUMMY_COMM_RULE_ALTS_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_ROLE',0,0,'ORACLE',0801000000,
  'DVPS_ROLE_T',
  'KU$_DUMMY_ROLE_T','SYS','KU$_DUMMY_ROLE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_FACTOR',0,0,'ORACLE',0801000000,
  'DVPS_FACTOR_T',
  'KU$_DUMMY_FACTOR_T','SYS','KU$_DUMMY_FACTOR_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_FACTOR_LINK',0,0,'ORACLE',0801000000,
  'DVPS_FACTOR_LINK_T',
  'KU$_DUMMY_FACTOR_LINK_T','SYS','KU$_DUMMY_FACTOR_LINK_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_FACTOR_TYPE',0,0,'ORACLE',0801000000,
  'DVPS_FACTOR_TYPE_T',
  'KU$_DUMMY_FACTOR_TYPE_T','SYS','KU$_DUMMY_FACTOR_TYPE_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_IDENTITY',0,0,'ORACLE',0801000000,
  'DVPS_IDENTITY_T',
  'KU$_DUMMY_IDENTITY_T','SYS','KU$_DUMMY_IDENTITY_VIEW');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_IDENTITY_MAP',0,0,'ORACLE',0801000000,
  'DVPS_IDENTITY_MAP_T',
  'KU$_DUMMY_IDENTITY_MAP_T','SYS','KU$_DUMMY_IDENTITY_MAP_VIEW');

REM Project 46812: DV policy support
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_POLICY',0,0,'ORACLE',0801000000,
  'DVPS_DV_POLICY_T',
  'KU$_DUMMY_POLICY_T','SYS','KU$_DUMMY_POLICY_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_POLICY_OBJ_R',0,0,'ORACLE',0801000000,
  'DVPS_DV_POLICY_OBJ_R_T',
  'KU$_DUMMY_POLICY_OBJ_R_T','SYS','KU$_DUMMY_POLICY_OBJ_R_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_POLICY_OBJ_C',0,0,'ORACLE',0801000000,
  'DVPS_DV_POLICY_OBJ_C_T',
  'KU$_DUMMY_POLICY_OBJ_C_T','SYS','KU$_DUMMY_POLICY_OBJ_C_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_POLICY_OBJ_C_ALTS',0,0,'ORACLE',0801000000,
  'DVPS_DV_POLICY_OBJ_C_ALTS_T',
  'KU$_DUMMY_POLICY_OBJ_C_ALTS_T','SYS','KU$_DUMMY_POLICY_OBJ_C_ALTS_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_POLICY_OWNER',0,0,'ORACLE',0801000000,
  'DVPS_DV_POLICY_OWNER_T',
  'KU$_DUMMY_POLICY_OWNER_T','SYS','KU$_DUMMY_POLICY_OWNER_V');

-- Bug 21299533: support for Database Vault Authorization
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_DP',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_DP_T',
  'KU$_DUMMY_DV_AUTH_DP_T','SYS','KU$_DUMMY_DV_AUTH_DP_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_TTS',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_TTS_T',
  'KU$_DUMMY_DV_AUTH_TTS_T','SYS','KU$_DUMMY_DV_AUTH_TTS_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_JOB',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_JOB_T',
  'KU$_DUMMY_DV_AUTH_JOB_T','SYS','KU$_DUMMY_DV_AUTH_JOB_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_PROXY',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_PROXY_T',
  'KU$_DUMMY_DV_AUTH_PROXY_T','SYS','KU$_DUMMY_DV_AUTH_PROXY_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_DDL',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_DDL_T',
  'KU$_DUMMY_DV_AUTH_DDL_T','SYS','KU$_DUMMY_DV_AUTH_DDL_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_PREP',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_PREP_T',
  'KU$_DUMMY_DV_AUTH_PREP_T','SYS','KU$_DUMMY_DV_AUTH_PREP_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_DIAG',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_DIAG_T',
  'KU$_DUMMY_DV_AUTH_DIAG_T','SYS','KU$_DUMMY_DV_AUTH_DIAG_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_INDEX_FUNC',0,0,'ORACLE',0801000000,
  'DVPS_DV_INDEX_FUNC_T',
  'KU$_DUMMY_DV_INDEX_FUNC_T','SYS','KU$_DUMMY_DV_INDEX_FUNC_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_AUTH_MAINT',0,0,'ORACLE',0801000000,
  'DVPS_DV_AUTH_MAINT_T',
  'KU$_DUMMY_DV_AUTH_MAINT_T','SYS','KU$_DUMMY_DV_AUTH_MAINT_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_ORADEBUG',0,0,'ORACLE',0801000000,
  'DVPS_DV_ORADEBUG_T',
  'KU$_DUMMY_DV_ORADEBUG_T','SYS','KU$_DUMMY_DV_ORADEBUG_V');
insert into metaview$ (type, flags, properties, model, version,
                       xmltag,
                       udt, schema, viewname) values
 ('DVPS_DV_ACCTS',0,0,'ORACLE',0801000000,
  'DVPS_DV_ACCTS_T',
  'KU$_DUMMY_DV_ACCTS_T','SYS','KU$_DUMMY_DV_ACCTS_V');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLESPACE',0,1024,'ORACLE',0801000000,
 'TABLESPACE_T', 'KU$_TABLESPACE_T','SYS', 'KU$_TABLESPACE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLLBACK_SEGMENT',0,0,'ORACLE',0801000000,
  'ROLLBACK_T', 'KU$_ROLLBACK_T', 'SYS', 'KU$_ROLLBACK_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLESPACE_ILM_POLICY',0,0,'ORACLE',1200000000,
 'TABLESPACE_ILM_POLICY_T', 'KU$_TBS_ILM_POLICY_T','SYS',
 'KU$_TBS_ILM_POLICY_VIEW');

--
-- ku$_dblink_view used for version 10.2.0 and later
-- ku$_10_1_dblink_view used for prior versions
--

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DB_LINK',0,1+16,'ORACLE',1002000000, 'DBLINK_T',
  'KU$_DBLINK_T','SYS', 'KU$_DBLINK_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DB_LINK',0,1+16,'ORACLE',0801000000, 'DBLINK_T',
  'KU$_DBLINK_T','SYS', 'KU$_10_1_DBLINK_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TRUSTED_DB_LINK',0,64,'ORACLE',0801000000,
  'TRLINK_T', 'KU$_TRLINK_T','SYS', 'KU$_TRLINK_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('FGA_POLICY',0,64,'ORACLE',0801000000,
  'FGA_POLICY_T', 'KU$_FGA_POLICY_T','SYS', 'KU$_FGA_POLICY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_POLICY_OBJNUM',0,0,'ORACLE',0801000000,
  'RLS_POLICY_OBJNUM_T', NULL,'SYS','KU$_RLS_POLICY_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_POLICY',0,64,'ORACLE',0801000000,
  'RLS_POLICY_T', 'KU$_RLS_POLICY_T','SYS', 'KU$_RLS_POLICY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_GROUP',0,64,'ORACLE',0801000000,
  'RLS_GROUP_T', 'KU$_RLS_GROUP_T','SYS', 'KU$_RLS_GROUP_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RLS_CONTEXT',0,64,'ORACLE',0801000000,
  'RLS_CONTEXT_T', 'KU$_RLS_CONTEXT_T','SYS', 'KU$_RLS_CONTEXT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CONSTRAINT',0,1+1024,'ORACLE',0801000000,
  'CONSTRAINT_T', 'KU$_CONSTRAINT_T','SYS', 'KU$_CONSTRAINT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('REF_CONSTRAINT',0,1,'ORACLE',0801000000,
  'REF_CONSTRAINT_T', 'KU$_REF_CONSTRAINT_T','SYS', 'KU$_REF_CONSTRAINT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('LIBRARY',0,1,'ORACLE',0801000000,'LIBRARY_T',
  'KU$_LIBRARY_T','SYS','KU$_LIBRARY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROFILE',0,0,'ORACLE',0801000000,'PROFILE_T',
  'KU$_PROFILE_T','SYS','KU$_PROFILE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLE',0,0,'ORACLE',0801000000,'ROLE_T',
  'KU$_ROLE_T','SYS','KU$_ROLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('USER',0,16,'ORACLE',0801000000,'USER_T',
  'KU$_USER_T','SYS','KU$_USER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DEFAULT_ROLE',0,16,'ORACLE',0801000000,
  'DEFROLE_T','KU$_DEFROLE_T','SYS','KU$_DEFROLE_VIEW');

--
-- ku$_proxy_view used for version 10.2.0 and later
-- ku$_10_1_proxy_view used for prior versions
--

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROXY',0,0,'ORACLE',1002000000,
  'PROXY_T','KU$_PROXY_T','SYS','KU$_PROXY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROXY',0,0,'ORACLE',0801000000,
  'PROXY_T','KU$_PROXY_T','SYS','KU$_10_1_PROXY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLE_GRANT',0,16,'ORACLE',1200000000,
  'ROGRANT_T','KU$_ROGRANT_T','SYS','KU$_ROGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLE_GRANT',0,16,'ORACLE',1100000000,
  'ROGRANT_T','KU$_ROGRANT_T','SYS','KU$_11_2_ROGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ROLE_GRANT',0,16,'ORACLE',0801000000,
  'ROGRANT_T','KU$_ROGRANT_T','SYS','KU$_10_2_ROGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLESPACE_QUOTA',0,16,'ORACLE',0801000000,
  'TSQUOTA_T','KU$_TSQUOTA_T','SYS','KU$_TSQUOTA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RESOURCE_COST',0,64+16,'ORACLE',0801000000,
  'RESOCOST_T','KU$_RESOCOST_T','SYS','KU$_RESOCOST_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SEQUENCE',0,1+1024,'ORACLE',0801000000,'SEQUENCE_T',
  'KU$_SEQUENCE_T','SYS','KU$_SEQUENCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CONTEXT',0,0,'ORACLE',0801000000,'CONTEXT_T',
  'KU$_CONTEXT_T','SYS','KU$_CONTEXT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DIMENSION',0,1,'ORACLE',0801000000,
  'DIMENSION_T','KU$_DIMENSION_T','SYS','KU$_DIMENSION_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ASSOCIATION',0,0,'ORACLE',0801000000,'ASSOC_T',
  'KU$_ASSOC_T','SYS','KU$_ASSOC_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PASSWORD_VERIFY_FUNCTION',0, 16,'ORACLE', 0801000000,
  'PWDVFC_T','KU$_PROC_T','SYS','KU$_PWDVFC_VIEW');

--
-- ku$_comment_view used for version 10.2.0 and later
-- ku$_10_1_comment_view used for prior versions
--

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('COMMENT',0,0,'ORACLE',1002000000,
  'COMMENT_T','KU$_COMMENT_T','SYS','KU$_COMMENT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('COMMENT',0,0,'ORACLE',0801000000,
  'COMMENT_T','KU$_COMMENT_T','SYS','KU$_10_1_COMMENT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CLUSTER',0,1,'ORACLE',0801000000,
  'CLUSTER_T','KU$_CLUSTER_T','SYS','KU$_CLUSTER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT',0,0,'ORACLE',1200000000,
  'AUDIT_T','KU$_AUDIT_T','SYS','KU$_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT',0,0,'ORACLE',1002000000,
  'AUDIT_T','KU$_AUDIT_T','SYS','KU$_11_2_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT',0,0,'ORACLE',0801000000,
  'AUDIT_T','KU$_AUDIT_T','SYS','KU$_10_1_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT_OBJ',0,0,'ORACLE',0801000000,
  'AUDITOBJ_T','KU$_AUDIT_OBJ_T','SYS','KU$_AUDIT_OBJ_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AUDIT_DEFAULT',0,0,'ORACLE',0801000000,
  'AUDITDEF_T','KU$_AUDIT_DEFAULT_T','SYS','KU$_AUDIT_DEFAULT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('AUDIT_POLICY',0,0,'ORACLE',1200000000,'AUDIT_POLICY_T',
         'KU$_AUDIT_POLICY_T','SYS','KU$_AUDIT_POLICY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('AUDIT_POLICY_ENABLE',0,0,'ORACLE',1202000000,'AUDIT_POLICY_ENABLE_T',
         'KU$_AUDIT_POLICY_ENABLE_T','SYS','KU$_AUDIT_POLICY_ENABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('AUDIT_POLICY_ENABLE',0,0,'ORACLE',1200000000,'AUDIT_POLICY_ENABLE_T',
         'KU$_AUDIT_POLICY_ENABLE_T','SYS','KU$_12AUDIT_POLICY_ENABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
        ('AUDIT_CONTEXT',0,0,'ORACLE',1200000000,'AUDIT_CONTEXT_T',
         'KU$_AUDIT_CONTEXT_T','SYS','KU$_AUDIT_CONTEXT_VIEW');


insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AQ_QUEUE_TABLE',0,65,'ORACLE',0801000000,
  'QUETAB_T','KU$_QUEUE_TABLE_T','SYS','KU$_QUEUE_TABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AQ_QUEUE',0,65,'ORACLE',0801000000,
  'QUEUES_T','KU$_QUEUES_T','SYS','KU$_QUEUES_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('AQ_TRANSFORM',0,65,'ORACLE',0801000000,
  'QTRANS_T','KU$_QTRANS_T','SYS','KU$_QTRANS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JOB',0,65,'ORACLE',0801000000,
  'JOB_T','KU$_JOB_T','SYS','KU$_JOB_VIEW');

--
-- ku$_tab_stats_view for version 12 and greater
-- ku$_11_2_tab_stats_view for version 11.1.0.6 to 11.2.0.3
-- ku$_10_2_tab_stats_view for version 10.2.0 ONLY
--
-- ku$_ind_stats_view for version 12 and later
-- ku$_11_2_ind_stats_view for version 11.1.0.7 to 11.2.0.3
-- ku$_10_2_ind_stats_view for version 10.2 to 11.1.0.6
--

-- For user pref statistics, set the viewname to null; this object will be
-- excluded.  Normal version control mechanisms apply these for V12 and beyond.
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_STATISTICS',0,64+1024,'ORACLE',1200000000,
  'T_STAT_T', 'KU$_TAB_STATS_T','SYS', 'KU$_TAB_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('USER_PREF_STATISTICS',0,64,'ORACLE',1200000000,
  'T_USER_PREF_STAT_T', 'KU$_USER_PREF_STATS_T','SYS',NULL);

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_STATISTICS',0,64+1024,'ORACLE',1100000000,
  'T_STAT_T', 'KU$_TAB_STATS_T','SYS', 'KU$_11_2_TAB_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_STATISTICS',0,64+1024,'ORACLE',1002000000,
  'T_STAT_T', 'KU$_TAB_STATS_T','SYS', 'KU$_10_2_TAB_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_STATISTICS',0,64+1024,'ORACLE',0801000000,
  'T_STAT_T', 'KU$_TAB_STATS_T','SYS', 'KU$_10_1_TAB_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('USER_PREF_STATISTICS',0,64,'ORACLE',1100000000,
  'T_USER_PREF_STAT_T', 'KU$_USER_PREF_STATS_T','SYS',
  'KU$_USER_PREF_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_STATISTICS',0,64,'ORACLE',1200000000,
  'I_STAT_T', 'KU$_IND_STATS_T','SYS', 'KU$_IND_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_STATISTICS',0,64,'ORACLE',1101000700,
  'I_STAT_T', 'KU$_IND_STATS_T','SYS', 'KU$_11_2_IND_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_STATISTICS',0,64,'ORACLE',1002000000,
  'I_STAT_T', 'KU$_IND_STATS_T','SYS', 'KU$_10_2_IND_STATS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_STATISTICS',0,64,'ORACLE',0801000000,
  'I_STAT_T', 'KU$_IND_STATS_T','SYS', 'KU$_10_1_IND_STATS_VIEW');
--
-- Don't set the 'schema object' properties bit for TABLE_DATA;
-- it causes undesirable defaulting behavior.
--
-- ku$_table_data_view used for version 11.1.0 and later.
-- ku$_10_2_table_data_view used for version 10.2.0
-- ku$_10_1_table_data_view used for prior versions
--
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_DATA',0,1024,'ORACLE',1100000000,
  'TABLE_DATA_T','KU$_TABLE_DATA_T','SYS','KU$_TABLE_DATA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_DATA',0,0,'ORACLE',1002000000,
  'TABLE_DATA_T','KU$_TABLE_DATA_T','SYS','KU$_10_2_TABLE_DATA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('TABLE_DATA',0,0,'ORACLE',0801000000,
  'TABLE_DATA_T','KU$_TABLE_DATA_T','SYS','KU$_10_1_TABLE_DATA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_OBJNUM',0,1+256,'ORACLE',0801000000,
  'JAVAOBJNUM_T','KU$_SCHEMAOBJ_T','SYS','KU$_JAVA_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_SOURCE',0,1+8+64,'ORACLE',0801000000,
  'JAVASRC_T','KU$_JAVA_SOURCE_T','SYS','KU$_JAVA_SOURCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_RESOURCE',0,1+8+64,'ORACLE',0801000000,
  'JAVARESRC_T','KU$_JAVA_RESOURCE_T','SYS','KU$_JAVA_RESOURCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('JAVA_CLASS',0,1+8+64,'ORACLE',0801000000,
  'JAVACLASS_T','KU$_JAVA_CLASS_T','SYS','KU$_JAVA_CLASS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_PLAN',0,65,'ORACLE',0801000000,
  'RMGR_PLAN_T','KU$_RMGR_PLAN_T','SYS','KU$_RMGR_PLAN_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_PLAN_DIRECTIVE',0,64,'ORACLE',0801000000,
  'RMGR_PLAN_DIRECT_T','KU$_RMGR_PLAN_DIRECT_T','SYS',
  'KU$_RMGR_PLAN_DIRECT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_CONSUMER_GROUP',0,65,'ORACLE',0801000000,
  'RMGR_CONSUMER_T','KU$_RMGR_CONSUMER_T','SYS',
  'KU$_RMGR_CONSUMER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('RMGR_INITIAL_CONSUMER_GROUP',0,64,'ORACLE', 0801000000,
  'RMGR_INIT_CONSUMER_T','KU$_RMGR_INIT_CONSUMER_T',
  'SYS','KU$_RMGR_INIT_CONSUMER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PASSWORD_HISTORY',0,64,'ORACLE', 1200000000,
  'PSW_HIST_T','KU$_PSW_HIST_T','SYS','KU$_PSW_HIST_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PASSWORD_HISTORY',0,64,'ORACLE',0801000000,
  'PSW_HIST_T','KU$_PSW_HIST_T','SYS','KU$_11_2_PSW_HIST_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('REFRESH_GROUP',0,65+16,'ORACLE',0801000000,
  'REFGROUP_T','KU$_REFGROUP_T','SYS','KU$_REFGROUP_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('MONITORING',0,0,'ORACLE',0801000000,
                'MONITOR_T','KU$_MONITOR_T','SYS','KU$_MONITOR_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROC_SYSTEM_GRANT',0,80,'ORACLE',0801000000,
  'PROCGRANT_T','KU$_PROC_GRANT_T','SYS','KU$_PROC_GRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROC_AUDIT',0,80,'ORACLE',0801000000,
  'PROCAUDIT_T','KU$_PROC_AUDIT_T','SYS','KU$_PROC_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ',0,81,'ORACLE',0801000000,
  'PROCOBJ_T','KU$_PROCOBJ_T','SYS','KU$_PROCOBJ_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ_OBJNUM',0,1+16+256,'ORACLE',0801000000,
  'PROCOBJNUM_T','KU$_SCHEMAOBJ_T','SYS','KU$_PROCOBJ_OBJNUM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ_GRANT',0,80,'ORACLE',0801000000,'PROCOBJG_T',
  'KU$_PROCOBJ_GRANT_T','SYS','KU$_PROCOBJ_GRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCOBJ_AUDIT',0,80,'ORACLE',0801000000,'PROCOBJA_T',
  'KU$_PROCOBJ_AUDIT_T','SYS','KU$_PROCOBJ_AUDIT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCDEPOBJ',0,81+1024,'ORACLE',0801000000,
  'PROCDEPOBJ_T', 'KU$_PROCDEPOBJ_T','SYS', 'KU$_PROCDEPOBJ_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCDEPOBJ_GRANT',0,80,'ORACLE',0801000000,
  'PROCDEPOBJG_T', 'KU$_PROCDEPOBJG_T','SYS', 'KU$_PROCDEPOBJ_GRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCDEPOBJ_AUDIT',0,80,'ORACLE',0801000000,
  'PROCDEPOBJA_T', 'KU$_PROCDEPOBJA_T','SYS', 'KU$_PROCDEPOBJ_AUDIT_VIEW');
-- note: this is an internal step, nothing returned. So the XMLTAG doesn't
--  matter. except that it must be valid, and (HACK ALERT) can't be PROCACTSYS_T
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_SYS_PKG',0,1024,'ORACLE',0801000000,
  'TABLE_T','KU$_PROCACT_T','SYS','KU$_PROCACT_SYS_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_SYSTEM',0,16+64,'ORACLE',0801000000,
  'PROCACTSYS_T','KU$_PROCACT_T','SYS','KU$_PROCACT_SYS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_SCHEMA',0,1+16+64+1024,'ORACLE',0801000000,
  'PROCACTSCHEMA_T','KU$_PROCACT_SCHEMA_T','SYS','KU$_PROCACT_SCHEMA_VIEW');
-- note: this is an internal step, nothing returned. So the XMLTAG doesn't
--  matter. except that it must be valid, and (HACK ALERT) can't be PROCACTSYS_T
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_SCHEMA_PKG',0,1024,'ORACLE',0801000000,
  'TABLE_T','KU$_PROCACT_T','SYS','KU$_PROCACT_SCHEMA_PKG_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PROCACT_INSTANCE',0,16+64+524288,'ORACLE',0801000000,
  'PROCACTINS_T', 'KU$_PROCACT_INSTANCE_T','SYS', 'KU$_PROCACT_INSTANCE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PRE_TABLE_ACTION',0,8+64,'ORACLE',0801000000,'PRE_TABLE_T',
  'KU$_PREPOST_TABLE_T','SYS','KU$_PRE_TABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('POST_TABLE_ACTION',0,8+64,'ORACLE',0801000000,'POST_TABLE_T',
  'KU$_PREPOST_TABLE_T','SYS','KU$_POST_TABLE_VIEW');
-- new in 9.2
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XMLSCHEMA',0,64+16,'ORACLE',0900000000,
  'XMLSCHEMA_T', 'KU$_XMLSCHEMA_T','SYS','KU$_XMLSCHEMA_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('EXP_XMLSCHEMA',0,64+16,'ORACLE',0900000000,
  'XMLSCHEMA_T', 'KU$_XMLSCHEMA_T','SYS','KU$_EXP_XMLSCHEMA_VIEW');
--
-- ku$_strmtable_view used for version 11.1.0 and later.
-- ku$_10_2_strmtable_view used for prior versions.
--
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DPSTREAM_TABLE',0,1,'ORACLE',1100000000,
  'STRMTABLE_T','KU$_STRMTABLE_T','SYS','KU$_STRMTABLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DPSTREAM_TABLE',0,1,'ORACLE',0801000000,
  'STRMTABLE_T','KU$_10_2_STRMTABLE_T','SYS','KU$_10_2_STRMTABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYSTEM_CALLOUT',0,32,'ORACLE',0900000000,
  'SYSCALLOUT_T','KU$_CALLOUT_T','SYS','KU$_SYSCALLOUT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SCHEMA_CALLOUT',0,1+32,'ORACLE',0900000000,
  'SCHEMA_CALLOUT_T','KU$_CALLOUT_T','SYS','KU$_SCHEMA_CALLOUT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME_FULL',0,32,'ORACLE',120000000,
  'PLUGTS_TSNAME_FULL_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_FULL_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME_TABLE',0,32,'ORACLE',110000000,
  'PLUGTS_TSNAME_TABLE_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_TABLE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_EARLY_TABLESPACE',0,65536+32,'ORACLE',110000000,
  'PLUGTS_TSNAME_TABLE_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_EARLY_TBLSP_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME_INDEX',0,32,'ORACLE',110000000,
  'PLUGTS_TSNAME_INDEX_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_INDEX_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME_INDEXP',0,32,'ORACLE',110000000,
  'PLUGTS_TSNAME_INDEX_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_INDEXP_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INSTANCE_CALLOUT',0,32,'ORACLE',0900000000,
  'INSTANCE_CALLOUT_T','KU$_CALLOUT_T','SYS','KU$_INSTANCE_CALLOUT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_BEGIN', 0,96,'ORACLE',0900000000,
  'PLUGTS_BEGIN_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_BEGIN_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_TSNAME', 0,96,'ORACLE',0900000000,
  'PLUGTS_TSNAME_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_TSNAME_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_CHECKPL', 0,96,'ORACLE',0900000000,
  'PLUGTS_CHECKPL_T','KU$_CALLOUT_T','SYS','KU$_PLUGTS_CHECKPL_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_BLK', 0,64,'ORACLE',0900000000,
  'PLUGTS_BLK_T','KU$_PLUGTS_BLK_T','SYS','KU$_PLUGTS_BLK_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('END_PLUGTS_BLK', 0,64,'ORACLE',0900000000,
  'PLUGTS_BLK_T','KU$_PLUGTS_BLK_T','SYS','KU$_END_PLUGTS_BLK_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('IDENTITY_COLUMN', 0,1,'ORACLE',1200000000,
  'IDENTITY_COLUMN_T','KU$_IDENTITY_COLOBJ_T','SYS','KU$_IDENTITY_COLOBJ_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ON_USER_GRANT',0,16,'ORACLE',1200000000,
  'ON_USER_GRANT_T','KU$_ON_USER_GRANT_T','SYS','KU$_ON_USER_GRANT_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
('CODE_BASE_GRANT',0,16,'ORACLE',1200000000,
 'CODE_BASE_GRANT_T','KU$_CODE_BASE_GRANT_T','SYS','KU$_CODE_BASE_GRANT_VIEW');
 
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_USER', 0,64,'ORACLE',1200000000,
  'XS_USER_T','KU$_XSUSER_T','SYS','KU$_XSUSER_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_GRANT', 0,64,'ORACLE',1202000000,
  'XS_GRANT_T','KU$_XSGRANT_T','SYS','KU$_XSGRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_ROLE', 0,64,'ORACLE',1200000000,
  'XS_ROLE_T','KU$_XSROLE_T','SYS','KU$_XSROLE_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_ROLE_GRANT', 0,64,'ORACLE',1200000000,
  'XS_ROLE_GRANT_T','KU$_XSROLE_GRANT_T','SYS','KU$_XSROLE_GRANT_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_ROLESET', 0,64,'ORACLE',1200000000,
  'XS_ROLESET_T','KU$_XSROLESET_T','SYS','KU$_XSROLESET_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_SECURITY_CLASS', 0,1+64+524288,'ORACLE',1200000000,
  'XS_SECURITY_CLASS_T','KU$_XSSCLASS_T','SYS','KU$_XSSCLASS_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_DATA_SECURITY', 0,1+64,'ORACLE',1200000000,
  'XS_DATA_SECURITY_T','KU$_XSPOLICY_T','SYS','KU$_XSPOLICY_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_ACL', 0,1+64+524288,'ORACLE',1200000000,
  'XS_ACL_T','KU$_XSACL_T','SYS','KU$_XSACL_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_ACL_PARAM', 0,64,'ORACLE',1200000000,
  'XS_ACL_PARAM_T','KU$_XSACL_PARAM_T','SYS','KU$_XSPOLICY_PARAM_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('XS_NAMESPACE', 0,64,'ORACLE',1200000000,
  'XS_NAMESPACE_T','KU$_XSNSPACE_T','SYS','KU$_XSNSPACE_VIEW');

-- for the next 3 types, used in views_as_tables, version is set
-- to the same version as TABLE_EXPORT
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('CREATE_TABLE', 0,8192,'ORACLE',0900000000,
  'CREATE_TABLE_T','KU$_CALLOUT_T','SYS','KU$_DUMMY');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('DROP_TABLE', 0,8192,'ORACLE',0900000000,
  'DROP_TABLE_T','KU$_CALLOUT_T','SYS','KU$_DUMMY');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('VAT_OBJNUM', 0,8192,'ORACLE',0900000000,
  'VAT_OBJNUM_T','KU$_CALLOUT_T','SYS','KU$_DUMMY');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('LOAD_TEMPTABLE', 0,262144,'ORACLE',0900000000,
  'LOAD_TEMPTABLE_T','KU$_CALLOUT_T','SYS','KU$_DUMMY');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('PLUGTS_TABLESPACE', 0,131072,'ORACLE',1200000000,'PLUGTS_TABLESPACE_T',
  'KU$_PLUGTS_TABLESPACE_T','SYS','KU$_PLUGTS_TABLESPACE_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ATTRIBUTE_DIMENSION', 0, 1, 'ORACLE', 1202000000, 'ATTRIBUTE_DIM_T',
  'KU$_ATTRIBUTE_DIMENSION_T', 'SYS', 'KU$_ATTRIBUTE_DIMENSION_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('HIERARCHY', 0, 1, 'ORACLE', 1202000000, 'HIER_T',
  'KU$_HIERARCHY_T', 'SYS', 'KU$_HIERARCHY_VIEW');

insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('ANALYTIC_VIEW', 0, 1, 'ORACLE', 1202000000, 'ANALYTIC_VIEW_T',
  'KU$_ANALYTIC_VIEW_T', 'SYS', 'KU$_ANALYTIC_VIEW');

-- Populate metafilter$: This table defines all the valid SELECT filters for
-- dictionary object types that can be set through the SET_FILTER interface.
-- Common filters used by many object types are NAME / SCHEMA. grants support
-- GRANTOR / GRANTEE. Tables support TABLESPACE, HEAP or IOT, RELATIONAL or
-- OBJECT, etc. Each one of these turns into a WHERE clause predicate on the
-- SELECT stmts built against the views in metaview$. The attrname field
-- specifies the UDT attribute or rel. column used in the where clause.
--
-- The 'properties' flags have the following meanings:
--
-- 0x00000001 1         boolean filter
-- 0x00000002 2         expression filter
-- 0x00000004 4         custom filter
-- 0x00000008 8         has default
-- 0x00000010 16        numeric filter
-- 0x00000020 32        filter leaf types (e.g., BEGIN_WITH)
-- 0x00000040 64        filter branch (e.g., INCLUDE_PATH_EXPR)
-- 0x00000080 128       ORDERED filter
-- 0x00000100 256       TOTAL_ORDER filter
-- 0x00000200 512       NOT NULL filter
-- 0x00000400 1024      ORDER_OBJNUMS filter
-- 0x00000800 2048      special boolean filter
--    (Most boolean filters default to TRUE; they are not applied
--     unless the user sets them FALSE meaning "do not return this
--     kind of object." Special boolean filters work the other way:
--     the default to FALSE and are only applied when the user
--     sets them TRUE. Note: If this flag is set, the "boolean filter" flag
--     must also be set.)
-- 0x00001000 4096      bind variable filter (value bound at cursor OPEN)
-- 0x00002000 8192      ORDER_OBJNUMS_NOB (i.e., no ORDER BY) filter
-- 0x00004000 16384     OBJNUM plus name
-- 0x00008000 32768     TSNUM filter(view_attr:1=TTS, 2=EARLY)
-- 0x00010000 65536     NAME_SCHEMA filter
-- 0x00020000 131072    Pseudo-filter - do not include in where clause
-- 0x00040000 262144    filter for app shared objects
-- 0x00080000 524288    default for app filter

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_FUNCTION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_PACKAGE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_PACKAGE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ALTER_PROCEDURE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AQ_QUEUE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AQ_QUEUE_TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AQ_TRANSFORM', 'ORACLE', 4096, 0, 'TRANSFORM_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'CLUSTER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'CONSTRAINT', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'CONTEXT', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DB_LINK', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DIMENSION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DIRECTORY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem properties 4096 means a bind variable filter (value bound at cursor OPEN)
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_REALM', 'ORACLE', 4096, 0,
  'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_REALM_MEMBERSHIP', 'ORACLE', 4096, 0,
  'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_REALM_AUTHORIZATION', 'ORACLE', 4096, 0,
  'REALM_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_RULE', 'ORACLE', 4096, 0,
  'RULE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_RULE_SET', 'ORACLE', 4096, 0,
  'RULE_SET_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_RULE_SET_MEMBERSHIP', 'ORACLE', 4096, 0,
  'RULE_SET_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_COMMAND_RULE', 'ORACLE', 4096, 0,
  'RULE_SET_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_COMMAND_RULE_ALTS', 'ORACLE', 4096, 0,
  'RULE_SET_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_ROLE', 'ORACLE', 4096, 0,
  'ROLE', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_FACTOR', 'ORACLE', 4096, 0,
  'FACTOR_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_FACTOR_LINK', 'ORACLE', 4096, 0,
  'PARENT_FACTOR_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_FACTOR_TYPE', 'ORACLE', 4096, 0,
  'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_IDENTITY', 'ORACLE', 4096, 0,
  'FACTOR_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_IDENTITY_MAP', 'ORACLE', 4096, 0,
  'IDENTITY_FACTOR_NAME', NULL);

REM Project 46812: DV policy support
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_POLICY', 'ORACLE', 4096, 0,
  'POLICY_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_POLICY_OBJ_R', 'ORACLE', 4096, 0,
  'POLICY_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_POLICY_OBJ_C', 'ORACLE', 4096, 0,
  'POLICY_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_POLICY_OBJ_C_ALTS', 'ORACLE', 4096, 0,
  'POLICY_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_POLICY_OWNER', 'ORACLE', 4096, 0,
  'POLICY_NAME', NULL);

-- Bug 21299533: support for Database Vault Authorization
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_DP', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_TTS', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_JOB', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_PROXY', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_DDL', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_PREP', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_DIAG', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_INDEX_FUNC', 'ORACLE', 4096, 0,
  'OBJECT_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_AUTH_MAINT', 'ORACLE', 4096, 0,
  'GRANTEE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_ORADEBUG', 'ORACLE', 4096, 0,
  'STATE', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_DV_ACCTS', 'ORACLE', 4096, 0,
  'STATE', NULL);

rem
rem bug 6938028: Database Vault Protected Schema.
rem These correspond to the following lines in prvtmetd.sql in "de_users":
rem   inh_noexp_filter(h2);
rem   inh_total_order_filter(h2);
rem Properties "2" means "expression filter".
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''DVPS_STAGING_REALM_MEMBERSHIP'' ' ||
 'AND A.NAME=KU$.SCHEMA_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_NAME', 0);



insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.NAME',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem The "NAME" filter for the DVPS_STAGING_REALM_MEMBERSHIP type, which means
rem "filter based on the SCHEMA_NAME attribute of the ku$_dv_srm_t UDT", is
rem needed because of the "inh_name_filters" added to "de_users" in
rem prvtmetd.sql for exporting the DVPS_STAGING_REALM_MEMBERSHIP type along
rem with the USER type when the DE_USER heterogeneous type is exported.
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 0, 0, 'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'DPSTREAM_TABLE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'FUNCTION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ATTRIBUTE_DIMENSION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'HIERARCHY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ANALYTIC_VIEW', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INC_TYPE', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INDEX', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INDEXTYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_CLASS', 'ORACLE', 4096, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_RESOURCE', 'ORACLE', 4096, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_OBJNUM', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'JAVA_SOURCE', 'ORACLE', 4096, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'LIBRARY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'MATERIALIZED_VIEW', 'ORACLE', 4096, 0, 'MVIEW.VNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 4096, 0, 'MVIEWLOG.LOG', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'MATERIALIZED_ZONEMAP', 'ORACLE', 4096, 0, 'MVIEW.VNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'OPERATOR', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'OUTLINE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PACKAGE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PACKAGE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PACKAGE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PACKAGE_OBJNUM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCDEPOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 4096, 0,
  'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCEDURE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROCOBJ_OBJNUM', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PROFILE', 'ORACLE', 4096, 0, 'PROFILE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'REFRESH_GROUP', 'ORACLE', 4096, 0, 'REFNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'REF_CONSTRAINT', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'RMGR_CONSUMER_GROUP', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'RMGR_PLAN', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ROLE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'ROLLBACK_SEGMENT', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SEQUENCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SORT_TYPES', 'ORACLE', 0, 0, 'TYPENAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SORT_VIEWS', 'ORACLE', 0, 0, 'VIEWNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SYNONYM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLESPACE', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLE_DATA', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLE_OBJNUM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TRIGGER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_USER', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_ROLE', 'ORACLE', 4096, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_ROLE_GRANT', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_ROLESET', 'ORACLE', 4096, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_SECURITY_CLASS', 'ORACLE', 4096, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_DATA_SECURITY', 'ORACLE', 4096, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_ACL', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_ACL_PARAM', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XS_NAMESPACE', 'ORACLE', 4096, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TRUSTED_DB_LINK', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TYPE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TYPE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'USER', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'VIEW', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'VIEW_OBJNUM', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'XMLSCHEMA', 'ORACLE', 4096, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'EXP_XMLSCHEMA', 'ORACLE', 4096, 0, 'URL',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0, 'TRANSFORM_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'CLUSTER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'CONTEXT', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DB_LINK', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DIMENSION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DIRECTORY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem The "NAME_EXPR" filter for the DVPS_STAGING_REALM_MEMBERSHIP type, which
rem means "filter based on the SCHEMA_NAME attribute of the ku$_dv_srm_t UDT",
rem is needed because of the "inh_name_filters" added to "de_users" in
rem prvtmetd.sql for exporting the DVPS_STAGING_REALM_MEMBERSHIP type along
rem with the USER type when the DE_USER heterogeneous type is exported.
rem
rem The other "NAME_EXPR" filters are to allow only a specific named instance
rem of a type to be exported, e.g. to export only the Identities whose Factor
rem Name is 'Application_Domain', the parameter to expdp would be escaped
rem as follows:
rem   INCLUDE=DVPS_IDENTITY:\"= \(\'Application_Domain\'\)\" \
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
  'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_REALM', 'ORACLE', 2, 0,
  'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
  'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_REALM_AUTHORIZATION', 'ORACLE', 2, 0,
  'REALM_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_RULE', 'ORACLE', 2, 0,
  'RULE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_RULE_SET', 'ORACLE', 2, 0,
  'RULE_SET_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_RULE_SET_MEMBERSHIP', 'ORACLE', 2, 0,
  'RULE_SET_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_COMMAND_RULE', 'ORACLE', 2, 0,
  'RULE_SET_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_COMMAND_RULE_ALTS', 'ORACLE', 2, 0,
  'RULE_SET_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_ROLE', 'ORACLE', 2, 0,
  'ROLE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_FACTOR', 'ORACLE', 2, 0,
  'FACTOR_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_FACTOR_LINK', 'ORACLE', 2, 0,
  'PARENT_FACTOR_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_FACTOR_TYPE', 'ORACLE', 2, 0,
  'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_IDENTITY', 'ORACLE', 2, 0,
  'FACTOR_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_IDENTITY_MAP', 'ORACLE', 2, 0,
  'IDENTITY_FACTOR_NAME',NULL);

REM Project 46812: DV policy support
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_POLICY', 'ORACLE', 2, 0,
  'POLICY_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_POLICY_OBJ_R', 'ORACLE', 2, 0,
  'POLICY_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_POLICY_OBJ_C', 'ORACLE', 2, 0,
  'POLICY_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_POLICY_OBJ_C_ALTS', 'ORACLE', 2, 0,
  'POLICY_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_POLICY_OWNER', 'ORACLE', 2, 0,
  'POLICY_NAME',NULL);

-- Bug 21299533: support for Database Vault Authorization
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_DP', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_TTS', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_JOB', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_PROXY', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_DDL', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_PREP', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_DIAG', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_INDEX_FUNC', 'ORACLE', 2, 0,
  'OBJECT_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_AUTH_MAINT', 'ORACLE', 2, 0,
  'GRANTEE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_ORADEBUG', 'ORACLE', 2, 0,
  'STATE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DVPS_DV_ACCTS', 'ORACLE', 2, 0,
  'STATE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'FUNCTION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ATTRIBUTE_DIMENSION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'HIERARCHY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ANALYTIC_VIEW', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'INC_TYPE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'INDEX', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'LIBRARY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0, 'MVIEW.VNAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0, 'MVIEWLOG.LOG',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0, 'MVIEW.VNAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'OPERATOR', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'OUTLINE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PACKAGE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PACKAGE_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCEDURE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PROFILE', 'ORACLE', 2, 0, 'PROFILE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0, 'REFNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ROLE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'ROLLBACK_SEGMENT', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SEQUENCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0, 'TYPENAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0, 'VIEWNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLESPACE', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLESPACE_ILM_POLICY', 'ORACLE', 0, 0, 'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TRUSTED_DB_LINK', 'ORACLE', 2, 0, 'NAME',NULL);
-- Triton Security
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_USER', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_ROLE', 'ORACLE', 2, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_ROLE_GRANT', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_ROLESET', 'ORACLE', 2, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_SECURITY_CLASS', 'ORACLE', 2, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_DATA_SECURITY', 'ORACLE', 2, 0, 'XS_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_ACL', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_ACL_PARAM', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XS_NAMESPACE', 'ORACLE', 2, 0, 'XS_OBJ.NAME',NULL);
-- end of Triton Security objects
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'USER', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'VIEW', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0, 'URL',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0,
 'NOT (KU$.TRANSFORM_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'CLUSTER', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'CONTEXT', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DB_LINK', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DIMENSION', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DIRECTORY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
rem
rem bug 6938028: Database Vault Protected Schema.
rem The "EXCLUDE_NAME_EXPR" filter for the DVPS_STAGING_REALM_MEMBERSHIP type
rem is needed because of the "inh_name_filters" added to "de_users" in
rem prvtmetd.sql for exporting the DVPS_STAGING_REALM_MEMBERSHIP type along
rem with the USER type when the DE_USER heterogeneous type is exported.
rem
rem The other "EXCLUDE_NAME_EXPR" filters are to allow a specific named
rem instance of a type to be excluded from the export, e.g. to avoid exporting
rem Identities with the Factor Name 'Application_Domain', the parameter to
rem expdp would be escaped as follows:
rem   EXCLUDE=DVPS_IDENTITY:\"= \(\'Application_Domain\'\)\" \
rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_STAGING_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_REALM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_REALM_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_REALM_AUTHORIZATION', 'ORACLE', 2, 0,
 'NOT (KU$.REALM_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_RULE', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_RULE_SET', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_SET_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_RULE_SET_MEMBERSHIP', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_SET_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_COMMAND_RULE', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_SET_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_COMMAND_RULE_ALTS', 'ORACLE', 2, 0,
 'NOT (KU$.RULE_SET_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_ROLE', 'ORACLE', 2, 0,
 'NOT (KU$.ROLE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_FACTOR', 'ORACLE', 2, 0,
 'NOT (KU$.FACTOR_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_FACTOR_LINK', 'ORACLE', 2, 0,
 'NOT (KU$.PARENT_FACTOR_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_FACTOR_TYPE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_IDENTITY', 'ORACLE', 2, 0,
 'NOT (KU$.FACTOR_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_IDENTITY_MAP', 'ORACLE', 2, 0,
 'NOT (KU$.IDENTITY_FACTOR_NAME :1)',NULL);

REM Project 46812: DV policy support
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_POLICY', 'ORACLE', 2, 0,
 'NOT (KU$.POLICY_NAME_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_POLICY_OBJ_R', 'ORACLE', 2, 0,
 'NOT (KU$.POLICY_NAME_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_POLICY_OBJ_C', 'ORACLE', 2, 0,
 'NOT (KU$.POLICY_NAME_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_POLICY_OBJ_C_ALTS', 'ORACLE', 2, 0,
 'NOT (KU$.POLICY_NAME_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_POLICY_OWNER', 'ORACLE', 2, 0,
 'NOT (KU$.POLICY_NAME_NAME :1)',NULL);

-- Bug 21299533: support for Database Vault Authorization
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_DP', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_TTS', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_JOB', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_PROXY', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_DDL', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_PREP', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_DIAG', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_INDEX_FUNC', 'ORACLE', 2, 0,
 'NOT (KU$.OBJECT_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_AUTH_MAINT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_ORADEBUG', 'ORACLE', 2, 0,
 'NOT (KU$.STATE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DVPS_DV_ACCTS', 'ORACLE', 2, 0,
 'NOT (KU$.STATE :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'FUNCTION', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ATTRIBUTE_DIMENSION', 'ORACLE', 2, 0, 
  'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'HIERARCHY', 'ORACLE', 2, 0, 
  'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ANALYTIC_VIEW', 'ORACLE', 2, 0, 
  'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'INC_TYPE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'INDEX', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'LIBRARY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0,
 'NOT (KU$.MVIEW.VNAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
 'NOT (KU$.MVIEWLOG.LOG :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
 'NOT (KU$.MVIEW.VNAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'OPERATOR', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'OUTLINE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PACKAGE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PACKAGE_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCEDURE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCOBJ', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'PROFILE', 'ORACLE', 2, 0,
 'NOT (KU$.PROFILE_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0,
 'NOT (KU$.REFNAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ROLE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'ROLLBACK_SEGMENT', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SEQUENCE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0,
 'NOT (KU$.TYPENAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0,
 'NOT (KU$.VIEWNAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLESPACE', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLESPACE_ILM_POLICY', 'ORACLE', 0, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TRUSTED_DB_LINK', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TYPE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
-- Triton Security
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_USER', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_GRANT', 'ORACLE', 2, 0, 
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_ROLE', 'ORACLE', 2, 0,
 'NOT (KU$.XS_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_ROLE_GRANT', 'ORACLE', 2, 0, 
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_ROLESET', 'ORACLE', 2, 0,
 'NOT (KU$.XS_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_SECURITY_CLASS', 'ORACLE', 2, 0,
 'NOT (KU$.XS_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_DATA_SECURITY', 'ORACLE', 2, 0,
 'NOT (KU$.XS_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_ACL', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_ACL_PARAM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XS_NAMESPACE', 'ORACLE', 2, 0,
 'NOT (KU$.XS_OBJ.NAME :1)',NULL);
-- end of Triton Security objects
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'USER', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'VIEW', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT (KU$.URL :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT (KU$.URL :1)',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_FUNCTION', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_PACKAGE_BODY', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_PACKAGE_SPEC', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ALTER_PROCEDURE', 'ORACLE', 4096, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'AQ_QUEUE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'AQ_QUEUE_TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'AQ_TRANSFORM', 'ORACLE', 4096, 0, 'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'CLUSTER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'CONSTRAINT', 'ORACLE', 4096, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'DB_LINK', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'DIMENSION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'DPSTREAM_TABLE', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'FUNCTION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ATTRIBUTE_DIMENSION', 'ORACLE', 4096, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'HIERARCHY', 'ORACLE', 4096, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'ANALYTIC_VIEW', 'ORACLE', 4096, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'INC_TYPE', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'INDEX', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'INDEXTYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_CLASS', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_OBJNUM', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_RESOURCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JAVA_SOURCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'JOB', 'ORACLE', 4096, 0, 'POWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'LIBRARY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'MATERIALIZED_VIEW', 'ORACLE', 4096, 0, 'MVIEW.SOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 4096, 0, 'MVIEWLOG.MOWNER',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'MATERIALIZED_ZONEMAP', 'ORACLE', 4096, 0, 'MVIEW.SOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'OPERATOR', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PACKAGE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PACKAGE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PACKAGE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PACKAGE_OBJNUM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCACT_SCHEMA', 'ORACLE', 4096, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 4096, 0,
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCDEPOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCEDURE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCOBJ', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PROCOBJ_OBJNUM', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'REF_CONSTRAINT', 'ORACLE', 4096, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'REFRESH_GROUP', 'ORACLE', 4096, 0, 'REFOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'RMGR_CONSUMER_GROUP', 'ORACLE', 4096, 0,
        'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'RMGR_PLAN', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SCHEMA_CALLOUT', 'ORACLE', 0, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SEQUENCE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SORT_TYPES', 'ORACLE', 0, 0, 'TYPEOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SORT_VIEWS', 'ORACLE', 0, 0, 'VIEWOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SYNONYM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TABLE_DATA', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TABLE_OBJNUM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TRIGGER', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);

-- Add schema filters for Triton Security objects
-- Note: Security Class, ACL, Data Security Policy, and Privileges are
--       schema specific;
--       Users, Roles, Rolesets, Namespace Template and ACL Parameters
--       are not schema specific.
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'XS_SECURITY_CLASS', 'ORACLE', 4096, 0, 'XS_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'XS_DATA_SECURITY', 'ORACLE', 4096, 0, 'XS_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'XS_ACL', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TYPE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TYPE_BODY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'TYPE_SPEC', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'VIEW', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'VIEW_OBJNUM', 'ORACLE', 0, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'XMLSCHEMA', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'EXP_XMLSCHEMA', 'ORACLE', 4096, 0, 'OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'AQ_QUEUE_TABLE','ORACLE', 2, 0,'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0, 'SCHEMA_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'CLUSTER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'DB_LINK', 'ORACLE', 2, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'DIMENSION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'FUNCTION', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ATTRIBUTE_DIMENSION', 'ORACLE', 2, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'HIERARCHY', 'ORACLE', 2, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'ANALYTIC_VIEW', 'ORACLE', 2, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'INC_TYPE', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'INDEX', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'JOB', 'ORACLE', 2, 0, 'POWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'LIBRARY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0, 'MVIEW.SOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0, 'MVIEWLOG.MOWNER',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0, 'MVIEW.SOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'OPERATOR', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PACKAGE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PACKAGE_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 2, 0, 
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCACT_SCHEMA', 'ORACLE', 2, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCEDURE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCOBJ', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0, 'OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0, 'REFOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SCHEMA_CALLOUT', 'ORACLE', 2, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SEQUENCE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0, 'TYPEOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0, 'VIEWOWNER',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SYNONYM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TRIGGER', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);


-- Add schema_expr filters for Triton Security objects
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'XS_SECURITY_CLASS', 'ORACLE', 2, 0, 'XS_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'XS_DATA_SECURITY', 'ORACLE', 2, 0, 'XS_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'XS_ACL', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TYPE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'VIEW', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0, 'OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'AQ_TRANSFORM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'CLUSTER', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'DB_LINK', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'DIMENSION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'DPSTREAM_TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'FUNCTION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ATTRIBUTE_DIMENSION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'HIERARCHY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'ANALYTIC_VIEW', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'INC_TYPE', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'INDEX', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'INDEXTYPE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'JOB', 'ORACLE', 2, 0,
  'NOT (KU$.POWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'LIBRARY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0,
  'NOT (KU$.MVIEW.SOWNER :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  'NOT (KU$.MVIEWLOG.MOWNER :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
  'NOT (KU$.MVIEW.SOWNER :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'OPERATOR', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PACKAGE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PACKAGE_BODY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PACKAGE_SPEC', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PACKAGE_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCACT_SCHEMA', 'ORACLE', 2, 0,
  'NOT (KU$.USER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCEDURE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCOBJ', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'REFRESH_GROUP', 'ORACLE', 2, 0,
  'NOT (KU$.REFOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'RMGR_CONSUMER_GROUP', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'RMGR_PLAN', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SCHEMA_CALLOUT', 'ORACLE', 2, 0,
  'NOT (KU$.USER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SEQUENCE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SORT_TYPES', 'ORACLE', 2, 0,
  'NOT (KU$.TYPEOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SORT_VIEWS', 'ORACLE', 2, 0,
  'NOT (KU$.VIEWOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SYNONYM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'XS_SECURITY_CLASS', 'ORACLE', 2, 0,
  'NOT (KU$.XS_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'XS_DATA_SECURITY', 'ORACLE', 2, 0,
  'NOT (KU$.XS_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'XS_ACL', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TYPE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TYPE_BODY', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'TYPE_SPEC', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'VIEW', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'VIEW_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0,
  'NOT (KU$.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'PACKAGE', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'PACKAGE_SPEC', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'PACKAGE_OBJNUM', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'TYPE', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SPECIFICATION', 'TYPE_SPEC', 'ORACLE', 1, 1, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'PACKAGE', 'ORACLE', 1, 2, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'PACKAGE_BODY', 'ORACLE', 1, 2, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'TYPE', 'ORACLE', 1, 2, NULL,NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BODY', 'TYPE_BODY', 'ORACLE', 1, 2, NULL,NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'TABLE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'TABLE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'TABLE_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'PLUGTS_TSNAME', 'ORACLE', 0, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'PLUGTS_TSNAME', 'ORACLE', 2, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'CLUSTER', 'ORACLE', 0, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'CLUSTER', 'ORACLE', 2, 0, 'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  'NOT (EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  'NOT (EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_CLUSTER_TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_CLU_TS_VIEW CTS ' ||
  'WHERE CTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND CTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_CLUSTER_TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_CLU_TS_VIEW CTS ' ||
  'WHERE CTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND CTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'INDEX', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'INDEX', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'MATERIALIZED_VIEW', 'ORACLE', 0, 0,
  '(KU$.MVIEW_TAB.OBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MV_TS_VIEW KU2$ WHERE KU2$.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0,
  '(KU$.MVIEW_TAB.OBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MV_TS_VIEW KU2$ WHERE KU2$.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
  '(KU$.TABOBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MVL_TS_VIEW KU2$ ' ||
  ' WHERE KU2$.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  '(KU$.TABOBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MVL_TS_VIEW KU2$ ' ||
  'WHERE KU2$.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'MATERIALIZED_ZONEMAP', 'ORACLE', 0, 0,
  '(KU$.MVIEW_TAB.OBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MV_TS_VIEW KU2$ WHERE KU2$.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
  '(KU$.MVIEW_TAB.OBJ_NUM IN ' ||
  '(SELECT KU2$.OBJ_NUM FROM SYS.KU$_MV_TS_VIEW KU2$ WHERE KU2$.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'TABLE_DATA', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE', 'TABLE_DATA', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'PROCACT_INSTANCE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'PROCDEPOBJ', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLE_TABLESPACE_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'PRE_TABLE_ACTION', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'POST_TABLE_ACTION', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'OBJECT_GRANT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'MONITORING', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'MONITORING', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_TAB_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_TAB_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_BI_TABLESPACE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  '(NOT EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_BI_TABLESPACE_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  '(NOT EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_IND_OBJ.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'CONSTRAINT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'TABLE_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'USER_PREF_STATISTICS', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'CLUSTERING', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'CLUSTERING', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'COMMENT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'COMMENT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'AUDIT_OBJ', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RADM_POLICY', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RADM_POLICY', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'REF_CONSTRAINT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'TRIGGER', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE', 'TABLE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_TABLESPACE_EXPR', 'TABLE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLESPACE', 'TABLE', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_TABLESPACE_EXPR', 'TABLE', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.ANC_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_CONTEXT', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_CONTEXT', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_GROUP', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_POLICY', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'RLS_POLICY_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'FGA_POLICY', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
Rem
Rem  PRIMARY/SECONDARY filters (alphabetical by object type)
Rem  these must be defined for all schema objects and their dependent objects
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ALTER_PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'ALTER_PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'AUDIT_OBJ', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'AUDIT_OBJ', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'CLUSTER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'CLUSTER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'CLUSTERING', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'CLUSTERING', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'COMMENT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'COMMENT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'DIMENSION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'DIMENSION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'FGA_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'FGA_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'FUNCTION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ATTRIBUTE_DIMENSION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY','ATTRIBUTE_DIMENSION', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'HIERARCHY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY','HIERARCHY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'ANALYTIC_VIEW', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY','ANALYTIC_VIEW', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'INDEX', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'INDEX', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'INDEXTYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'INDEXTYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'INDEX_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_TAB_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'INDEX_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_TAB_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'JAVA_CLASS', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'JAVA_CLASS', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'JAVA_RESOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'JAVA_RESOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'JAVA_SOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'JAVA_SOURCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'LIBRARY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'LIBRARY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'OBJECT_GRANT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'OBJECT_GRANT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'OPERATOR', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'OPERATOR', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PACKAGE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PACKAGE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PACKAGE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PACKAGE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PACKAGE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PACKAGE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'PROCEDURE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'REF_CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'REF_CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_CONTEXT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_CONTEXT', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_GROUP', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_GROUP', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_POLICY', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'RLS_POLICY_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'RLS_POLICY_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'SEQUENCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'SEQUENCE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'SYNONYM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'SYNONYM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE_DATA', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE_DATA', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
-- for application table_data filters, relevant bits (see kqd.h) are:
-- KQDOBORCL       0x400000 4194304           /* is an Oracle-supplied object */
-- KQDOBF_MD_LINK  0x10000 65536 /* Metadata Link or a Metadata-Linked Object */
-- KQDOBF_OBJ_LINK 0x20000 131072    /* Object Link or a Object-Linked Object */
-- KQDOBFED      0x8000000 134217728       /* federation (application) object */
-- KQDOBF_ED_LINK 0x0100000000                          /* Extended Data Link */

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('APP_NOEXPORT', 'TABLE_OBJNUM', 'ORACLE', 524288+8+1, 0,
  '(1=1)',0);
-- for app pdb, table_data for application metadata linked tables
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('APPPDB_EXPORT', 'TABLE_OBJNUM', 'ORACLE', 262144+2048+1, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,134217728+65536)=134217728+65536)',0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'SECONDARY_TABLE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'SECONDARY_TABLE_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TABLE_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TABLE_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'USER_PREF_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'USER_PREF_STATISTICS', 'ORACLE', 9, 0,
  '(BITAND (KU$.BASE_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TRIGGER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TRIGGER', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TYPE', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TYPE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TYPE_BODY', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'TYPE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'TYPE_SPEC', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'VIEW', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'VIEW', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'VIEW_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'VIEW_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.FLAGS,16)=16)',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NESTED', 'TABLE',  'ORACLE', 9, 0,
  '(BITAND (KU$.PROPERTY,8192)=8192)',0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROC_SYSTEM_GRANT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROC_AUDIT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCOBJ',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCOBJ_GRANT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCOBJ_AUDIT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCDEPOBJ',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCDEPOBJ_GRANT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCDEPOBJ_AUDIT',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCACT_SYSTEM',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCACT_SCHEMA',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_SCHEMA', 'PROCACT_SYSTEM',  'ORACLE', 65536+8, 0,
  'KU$.SCHEMA=:SCHEMA1 AND KU$.PACKAGE=:PACKAGE2',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_SCHEMA', 'PROCACT_SCHEMA',  'ORACLE', 65536+8, 0,
  'KU$.SCHEMA=:SCHEMA1 AND KU$.PACKAGE=:PACKAGE2',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PROCACT_INSTANCE',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'PLUGTS_BLK',  'ORACLE', 9+512, 0,
  'PLSQL',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCLUDE_NULL', 'END_PLUGTS_BLK',  'ORACLE', 9+512, 0,
  'PLSQL',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCL_CONSTRAINTS', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'INCL_CONST', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCL_TRIGGERS', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'INCL_TRIG', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('INCL_GRANTS', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'INCL_GRANT', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_FULL_CHECK', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'TTS_FULL_CHK', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_CLOSURE_CHECK', 'PLUGTS_CHECKPL', 'ORACLE', 16, 0,
  'TTS_CLOSURE_CHK', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TYPE_NUM_EXPR', 'INDEX', 'ORACLE', 2, 0, 'TYPE_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TYPE_NUM_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0, 'TYPE_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TYPE_NUM_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  '(KU$.CON1.CONTYPE NOT IN (5) OR KU$.CON1.IND.TYPE_NUM :1)',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AQ_QUEUE', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AQ_QUEUE_TABLE', 'ORACLE', 0,0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'ASSOCIATION', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AUDIT', 'ORACLE', 0, 0, 'AUDIT_OPTION',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'AUDIT_OBJ', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'CLUSTERING', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'CODE_BASE_GRANT', 'ORACLE', 0, 0, 'CODE_TYPE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'COMMENT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'FGA_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'INDEX', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'INDEX_STATISTICS', 'ORACLE', 0, 0, 'BASE_TAB_OBJ.NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
  'MVIEWLOG.MASTER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'MATERIALIZED_ZONEMAP', 'ORACLE', 0, 0,
  'MVIEW.MASTER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'OBJECT_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'POST_TABLE_ACTION', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PRE_TABLE_ACTION', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCACT_INSTANCE', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCDEPOBJ', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCOBJ_AUDIT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PROCOBJ_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RADM_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'REF_CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_CONTEXT', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_GROUP', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('POLICY_NAME', 'RLS_POLICY', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RLS_POLICY_OBJNUM', 'ORACLE', 0,0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('POLICY_NAME', 'RLS_POLICY_OBJNUM', 'ORACLE', 4096, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 0, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE', 'ORACLE', 0, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE_DATA', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE_OBJNUM', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TABLE_STATISTICS', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'TABLESPACE_ILM_POLICY', 'ORACLE', 0, 0, 'NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'USER_PREF_STATISTICS', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'TRIGGER', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'ASSOCIATION', 'ORACLE', 2, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AUDIT', 'ORACLE', 2, 0, 'AUDIT_OPTION',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'CLUSTERING', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'CODE_BASE_GRANT', 'ORACLE', 2, 0, 'CODE_TYPE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'COMMENT', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'INDEX', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_TAB_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  'MVIEWLOG.MASTER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
  'MVIEW.MASTER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'OBJECT_GRANT','ORACLE',2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,'BASE_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RADM_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_CONTEXT', 'ORACLE',2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'ASSOCIATION', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.AUDIT_OPTION :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'CLUSTERING', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'CODE_BASE_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.CODE_TYPE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'COMMENT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'INDEX', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_TAB_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
 'NOT (KU$.MVIEWLOG.MASTER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
 'NOT (KU$.MVIEW.MASTER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'OBJECT_GRANT','ORACLE',2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RADM_POLICY', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_CONTEXT', 'ORACLE',2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);

Rem
Rem  Ancestor and domain index object filters
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0, 'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0, 'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'TABLE', 'ORACLE', 0, 0, 'ANC_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME', 'TABLE_DATA', 'ORACLE', 0, 0, 'ANC_OBJ.NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE',2, 0,'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE',2, 0,'ANC_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0, 'ANC_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'ANC_OBJ.NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.ANC_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.ANC_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'TABLE', 'ORACLE', 2, 0,
 'NOT (KU$.ANC_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0,
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0,
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'TABLE', 'ORACLE', 0, 0, 'ANC_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA', 'TABLE_DATA', 'ORACLE', 0, 0,
  'ANC_OBJ.OWNER_NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'ANC_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'ANC_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ANC_OBJECT_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'ANC_OBJ.OWNER_NAME', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_ANC_OBJECT_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.ANC_OBJ.OWNER_NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_NAME', 'TABLE_DATA', 'ORACLE', 0, 0, 'DOMIDX_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0, 'DOMIDX_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_DOMIDX_NAME_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.DOMIDX_OBJ.NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_SCHEMA', 'TABLE_DATA', 'ORACLE', 0, 0,
  'DOMIDX_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DOMIDX_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'DOMIDX_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_DOMIDX_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.DOMIDX_OBJ.OWNER_NAME :1)', NULL);


Rem
Rem  Base index filters
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_NAME', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  'BASE_IND_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_INDEX_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_IND_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_INDEX_NAME_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_IND_OBJ.NAME :1)', NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'AQ_QUEUE', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'AQ_QUEUE_TABLE', 'ORACLE', 0, 0,
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'ASSOCIATION', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'AUDIT_OBJ', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'CLUSTERING', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'CODE_BASE_GRANT', 'ORACLE', 0, 0,
  'GRANTEE', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'COMMENT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
   NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'DOMIDX_OBJNUM', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'FGA_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'INDEX', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  'BASE_TAB_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 0, 0,
  'MVIEWLOG.MOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'MATERIALIZED_ZONEMAP', 'ORACLE', 0, 0,
  'MVIEW.MOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'OBJECT_GRANT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
   NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'POST_TABLE_ACTION', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PRE_TABLE_ACTION', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCACT_INSTANCE', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCDEPOBJ', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCOBJ_AUDIT', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'PROCOBJ_GRANT', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RADM_POLICY', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'REF_CONSTRAINT', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_CONTEXT', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_GROUP', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_POLICY', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RLS_POLICY_OBJNUM', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE', 'ORACLE', 0, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.OWNER_NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE_DATA','ORACLE',0,0,'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE_OBJNUM', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TABLE_STATISTICS', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'USER_PREF_STATISTICS', 'ORACLE', 0, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'TRIGGER', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'ASSOCIATION', 'ORACLE', 2, 0,
 'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'CLUSTERING', 'ORACLE', 2, 0, 
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'CODE_BASE_GRANT', 'ORACLE', 2, 0,
  'GRANTEE', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'COMMENT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'INDEX', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_TAB_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  'MVIEWLOG.MOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
  'MVIEW.MOWNER', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
 'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RADM_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_CONTEXT', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE', 'ORACLE', 2, 0,
  'KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.OWNER_NAME :1',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE_DATA', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'AQ_QUEUE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'ASSOCIATION', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'AUDIT_OBJ', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'CLUSTERING', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'COMMENT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'CONSTRAINT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'FGA_POLICY', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'INDEX', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_TAB_OBJ.OWNER_NAME :1)', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
  'NOT (KU$.MVIEWLOG.MOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
  'NOT (KU$.MVIEW.MOWNER :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RADM_POLICY', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_CONTEXT', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_GROUP', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_POLICY', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'RMGR_PLAN_DIRECTIVE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ IS NOT NULL AND KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE_DATA', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'TRIGGER', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'AQ_QUEUE', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'AQ_QUEUE_TABLE', 'ORACLE', 0, 0,
  'SCHEMA_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'ASSOCIATION', 'ORACLE',0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'AUDIT_OBJ', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'CLUSTERING', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'CODE_BASE_GRANT', 'ORACLE', 0, 0, 'CODE_TYPE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'COMMENT', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'CONSTRAINT', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'FGA_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'INDEX', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'INDEX_STATISTICS', 'ORACLE', 0, 0,
  'BASE_TAB_OBJ.TYPE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'OBJECT_GRANT', 'ORACLE',0,0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'POST_TABLE_ACTION', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'PRE_TABLE_ACTION', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'PROCACT_INSTANCE', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'PROCDEPOBJ', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'PROCDEPOBJ_AUDIT', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'PROCDEPOBJ_GRANT', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'PROCOBJ_AUDIT', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'PROCOBJ_GRANT', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'REF_CONSTRAINT', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'RLS_CONTEXT', 'ORACLE',0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'RLS_GROUP', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'RLS_POLICY', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'RLS_POLICY_OBJNUM', 'ORACLE', 0, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'TRIGGER', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);

REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'AQ_QUEUE', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'AQ_QUEUE_TABLE', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'ASSOCIATION', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'AUDIT_OBJ', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'CLUSTERING', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'COMMENT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'FGA_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'INDEX', 'ORACLE', 2, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_TAB_OBJ.TYPE_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'RLS_CONTEXT', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'RLS_GROUP', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'RLS_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'TRIGGER', 'ORACLE', 2, 0,
  'BASE_OBJ.TYPE_NAME',NULL);


insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'INC_TYPE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'INDEX', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'JAVA_CLASS', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'JAVA_RESOURCE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'JAVA_SOURCE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'PROCOBJ', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'PLUGTS_EARLY_TABLESPACE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'PACKAGE_SPEC', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'PROCEDURE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EARLY_OPTION_PROCEDURE', 'PROCEDURE', 'ORACLE', 2048+1, 0,
  '(ku$.obj_num in (select obj_num from sys.ku$_option_objnum_view oov '||
            'where oov.tgt_type=7 and BITAND(oov.IMPC_FLAGS,2)!=0))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NORMAL_OPTION_PROCEDURE', 'PROCEDURE', 'ORACLE', 2048+1, 0,
  '(ku$.obj_num in (select obj_num from sys.ku$_option_objnum_view oov '||
            'where oov.tgt_type=7 and BITAND(oov.IMPC_FLAGS,2)=0))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EARLY_OPTION_TYPE', 'SORT_TYPES', 'ORACLE', 2048+1, 0,
  '(ku$.typeobjno in (select obj_num from sys.ku$_option_objnum_view oov '||
            'where oov.tgt_type=13 and BITAND(oov.IMPC_FLAGS,2)!=0))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NORMAL_OPTION_TYPE', 'SORT_TYPES', 'ORACLE', 2048+1, 0,
  '(ku$.typeobjno in (select obj_num from sys.ku$_option_objnum_view oov '||
            'where oov.tgt_type=13 and BITAND(oov.IMPC_FLAGS,2)=0))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'TABLE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_TSNUM', 'PLUGTS_TSNAME_FULL', 'ORACLE', 32768, 1,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_TSNUM', 'PLUGTS_TABLESPACE', 'ORACLE', 32768, 1,
  'TS_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_TSNUM', 'PLUGTS_EARLY_TABLESPACE', 'ORACLE', 32768, 1,
  'TS_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_TSNUM', 'TABLE_DATA', 'ORACLE', 32768+1, -1,
  'TS_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_TSNUM', 'INDEX', 'ORACLE', 32768+1, 1,
  'decode(bitand(ku$.property,2),'|| 
          '2, dbms_metadata.get_indpart_ts(ku$.obj_num),'||
          'KU$.STORAGE.TS_NUM )',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EARLY_TSNUM', 'PLUGTS_TABLESPACE', 'ORACLE', 32768, 2,
  'TS_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FULL_TSNUM', 'PLUGTS_TABLESPACE', 'ORACLE', 32768, 1,
  'TS_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'DEPTABLE_OBJNUM', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOKEN_TAB', 'DEPTABLE_OBJNUM', 'ORACLE', 1, 0,
  'BITAND(TRUNC(KU$.PROPERTY2 / POWER(2, 32)),2) = 2',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'POST_DATA_TABLE', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'POST_DATA_TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'POST_DATA_TABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'POST_DATA_TABLE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'XDB_NTABLE_OBJNUM', 'ORACLE', 2, 0,
  'SCHEMA_OBJ.OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'VIEW', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0,
  'SCHEMAOID IN (SELECT Q.SCHEMAOID FROM SYS.KU$_TABLE_XMLSCHEMA_VIEW Q WHERE Q.TABOBJ_NUM :1)',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'SECONDARY_TABLE_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OBJ_NUM',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'AUDIT_OBJ', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'CLUSTERING', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'COMMENT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'FGA_POLICY', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr, 
                         attrname, default_val) values             
 ('BASE_OBJNUM', 'IDENTITY_COLUMN', 'ORACLE', 2, 0, 
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'INDEX', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_IND_OBJNUM', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
  'MVIEW.BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PLUGTS_EARLY_TABLESPACE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PLUGTS_TSNAME_TABLE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
-- The following are added to support SYNONYM_OBJNUM
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('SYNONYM_OBJNUM',0,256+1,'ORACLE',0801000000,'SYNONYM_T',
  'KU$_SYNONYM_T','SYS','KU$_SYNONYM_VIEW');
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'SYNONYM_OBJNUM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'SYNONYM_OBJNUM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'SYNONYM_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'SYNONYM_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'SYNONYM_OBJNUM', 'ORACLE', 0, 0, 'SYN_LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0, 'SYN_LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SYN_LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OWNER_NAME', 'SYNONYM_OBJNUM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OWNER_NAME_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'SYNONYM_OBJNUM', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_OWNER_NAME_EXPR', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'SYNONYM_OBJNUM', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME ' ||
 'AND KU$.SCHEMA_OBJ.OWNER_NUM =1 ) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'SYNONYM', 'ORACLE', 2, 0, 'OBJ_NUM',NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYNONYM_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
-- NAME_SCHEMA is a pseudo filter. It is an 'objnum filter' to trigger special
-- processing; the attrname contains part of the query returned by
-- get_xml_inputs.
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PARTITION', 'PLUGTS_TSNAME_INDEXP', 'ORACLE', 0, 0,
  'BASE_OBJ.SUBNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PARTITION_EXPR', 'PLUGTS_TSNAME_INDEXP', 'ORACLE', 2, 0,
  'BASE_OBJ.SUBNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PARTITION_EXPR', 'PLUGTS_TSNAME_INDEXP', 'ORACLE', 2, 0,
  'BASE_OBJ.SUBNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PARTITION', 'PLUGTS_TSNAME_TABLE', 'ORACLE', 0, 0,
  'BASE_OBJ.SUBNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PARTITION_EXPR', 'PLUGTS_TSNAME_TABLE', 'ORACLE', 2, 0,
  'BASE_OBJ.SUBNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PARTITION_EXPR', 'PLUGTS_TSNAME_TABLE', 'ORACLE', 2, 0,
  'BASE_OBJ.SUBNAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PLUGTS_TSNAME_INDEX', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PLUGTS_TSNAME_INDEXP', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'OBJECT_GRANT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PACKAGE_BODY', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PROCDEPOBJ', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'RADM_POLICY', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'RLS_CONTEXT', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'RLS_GROUP', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'RLS_POLICY', 'ORACLE', 16384+2, 0,
  '(OBJ_NUM,NAME)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'SORT_TYPES', 'ORACLE', 2, 0,
  'TYPEOBJNO',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'SORT_VIEWS', 'ORACLE', 2, 0,
  'VIEWOBJNO',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'TABLE_DATA', 'ORACLE', 2, 0,
  'BASE_OBJ.OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'TRIGGER', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'TYPE_BODY', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'TABTYPE_OBJNUM', 'ORACLE', 2, 0,
  'TABOBJNO',NULL);

-- UNION_OBJNUM used by transportable_export heterogeneous object

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('UNION_OBJNUM', 'SORT_TYPES', 'ORACLE', 2, 0,
  '1=1 START WITH KU$.TYPEOBJNO :1 CONNECT BY PRIOR KU$.TYPEOBJNO=KU$.DOBJNO',
  NULL);

--
-- wgo = objauth$.option$ (or sysauth$.option$):
--                           0x04 = tuple represents ONLY a Common Privilege 
--                                                   0x08 = Common Privilege 
-- We want to exclude Oracle common privileges, and application common
-- prvivileges from application PDBs, but not application common
-- prvivileges from an application root. (got that?)
-- bitand(user$.spare1,4096) is set for an application common user.
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('COMMON_OBJECT','OBJECT_GRANT', 'ORACLE', 9, 0,
  '(NOT(BITAND(KU$.WGO,12)=0 OR'||
  '     (BITAND(ku$.user_spare1,4096)!=0 AND '||
  '      SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'')))',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('COMMON_OBJECT','SYSTEM_GRANT', 'ORACLE', 9, 0,
  '(NOT(BITAND(KU$.WGO,12)=0 OR'||
  '     (BITAND(ku$.user_spare1,4096)!=0 AND '||
  '      SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'')))',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('COMMON_OBJECT','ROLE_GRANT', 'ORACLE', 9, 0,
  '(NOT(BITAND(KU$.ADMIN,12)=0 OR'||
  '     (BITAND(ku$.user_spare1,4096)!=0 AND '||
  '      SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'')))',1);

-- system-generated

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SYSTEM_GENERATED', 'INDEX', 'ORACLE', 9, 0,
                                        'BITAND(KU$.SCHEMA_OBJ.FLAGS,4)=4',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SYSTEM_GENERATED', 'MATERIALIZED_VIEW', 'ORACLE', 9, 0,
                         'BITAND(KU$.MVIEW.MFLAGS,power(2,32)+power(2,33))>0',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SYSTEM_GENERATED', 'MATERIALIZED_ZONEMAP', 'ORACLE', 9, 0,
                         'BITAND(KU$.MVIEW.MFLAGS,power(2,32)+power(2,33))>0',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SYSTEM_GENERATED', 'ROLLBACK_SEGMENT', 'ORACLE', 9, 0,
                                      'BITAND(KU$.TABLESPACE.FLAGS,16)=16',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SYSTEM_GENERATED', 'TRIGGER', 'ORACLE', 9, 0,
                                        'BITAND(KU$.SCHEMA_OBJ.FLAGS,4)=4',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('XDB_GENERATED', 'TRIGGER', 'ORACLE', 1+8, 0,
  '(ku$.xdb_generated is NOT NULL)', 1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('XDB_GENERATED', 'RLS_POLICY_OBJNUM', 'ORACLE', 1+8, 0,
  '( KU$.PFSCHMA = ''XDB'' AND KU$.PPNAME=''DBMS_XDBZ0'' )', 1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HIDDEN_ID', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(KU$.CON1.CONTYPE=3 AND KU$.CON1.INTCOLS=1 ' ||
  'AND KU$.CON1.OID_OR_SETID!=0)',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HIDDEN_ID', 'INDEX', 'ORACLE', 9, 0,
  '(KU$.TYPE_NUM=1 AND KU$.INTCOLS=1 ' ||
  'AND KU$.OID_OR_SETID!=0)',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PKEY_FOR_IOT_PKOID', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(KU$.CON1.CONTYPE=2 AND BITAND(KU$.CON1.PROPERTY,64+4096)!=0)',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FOR_PKOID', 'INDEX', 'ORACLE', 9, 0, 'KU$.FOR_PKOID=1',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FOR_REFPAR', 'INDEX', 'ORACLE', 9, 0, 'KU$.FOR_REFPAR=1',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FOR_DIMTABLE_TARGET', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(KU$.TYPE_NUM=2 AND BITAND(KU$.CON1.PROPERTY2,268435456)!=0)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FOR_DIMTABLE_TARGET', 'INDEX', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_PROPERTY2,268435456)!=0',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('VT_TEMPORAL', 'CONSTRAINT', 'ORACLE', 9, 0,
  '(BITAND(NVL(KU$.FLAGS,0),2048)!=0)',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ZONEMAP_CONTAINER', 'TABLE_OBJNUM', 'ORACLE', 9, 0,
  'BITAND(KU$.PROPERTY2,2147483648)!=0',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ZONEMAP_CONTAINER_2', 'TABLE_OBJNUM', 'ORACLE', 1+8+2048, 0,
  '(BITAND(KU$.PROPERTY2,2147483648)=0 OR ' ||
  'DBMS_METADATA.IN_TSNUM_2(1,KU$.OBJ_NUM,KU$.TS_NUM,KU$.PROPERTY)!=0)',0);

-- RECYCLED filter for tables and their dependent objects
REM
REM    For maintainability the following are sorted by TYPE.
REM

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'AUDIT_OBJ', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'COMMENT', 'ORACLE', 9, 0, 'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'CONSTRAINT', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'INDEX', 'ORACLE', 9, 0, 'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'INDEX_STATISTICS', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_TAB_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'INSTANCE_CALLOUT', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'OBJECT_GRANT', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'POST_TABLE_ACTION', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'PRE_TABLE_ACTION', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'PROCACT_INSTANCE', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'PROCDEPOBJ', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'PROCDEPOBJ_AUDIT', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'PROCDEPOBJ_GRANT', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'REF_CONSTRAINT', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'TABLE', 'ORACLE', 9, 0, 'BITAND(KU$.SCHEMA_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'TABLE_DATA', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'TABLE_STATISTICS', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'USER_PREF_STATISTICS', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'TRIGGER', 'ORACLE', 9, 0,
  '(KU$.BASE_OBJ IS NOT NULL AND BITAND(KU$.BASE_OBJ.FLAGS,128)!=0)', 0);

-- ordering filters: these turn into ORDER BY clauses

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'TABLE_DATA', 'ORACLE', 1+8+128, 0,
  'KU$.BYTES_ALLOC DESC', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCOBJ', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM, KU$.TYPE_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCOBJ_GRANT', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM, KU$.TYPE_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCOBJ_AUDIT', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM, KU$.TYPE_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCDEPOBJ', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCDEPOBJ_GRANT', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCDEPOBJ_AUDIT', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCACT_SYSTEM', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCACT_SCHEMA', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PROCACT_INSTANCE', 'ORACLE', 1+8+128, 0,
  'KU$.LEVEL_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'OBJECT_GRANT', 'ORACLE', 1+8+128, 0,
  'KU$.SEQUENCE', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDER_BY_GRANTOR', 'OBJECT_GRANT', 'ORACLE', 1+8+128, 0,
  'KU$.GRANTOR', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'XMLSCHEMA', 'ORACLE', 1+8+128, 0,
  'KU$.SCHEMA_LEVEL', 0);
-- bug 18672264: As per luis.f.garcia, when registering cyclical schemas the
-- FORCE option lets them be registered but they cannot be used until all i
-- their dependencies are registered as well. Please make sure all schemas 
-- with cyclical dependencies are registered first. 
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'EXP_XMLSCHEMA', 'ORACLE', 1+8+128, 0,
  'KU$.SCHEMA_LEVEL', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'TABLESPACE_QUOTA', 'ORACLE', 1+8+128, 0,
  'KU$.USER_NAME, KU$.TS_NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'TRIGGER', 'ORACLE', 1+8+128, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME', 0);
--bug 6156708: add filter for index order by
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'INDEX', 'ORACLE', 1+8+128, 0,
  'KU$.SCHEMA_OBJ.OWNER_NUM, KU$.SCHEMA_OBJ.DATAOBJ_NUM', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ALTER_FUNCTION', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ALTER_PACKAGE_BODY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ALTER_PACKAGE_SPEC', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ALTER_PROCEDURE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ASSOCIATION', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME, KU$.OBJCOL', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'AUDIT', 'ORACLE', 1+8+256, 0,
  'KU$.USER_NAME, KU$.PROXY_NUM, KU$.AUDIT_OPTION', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'AUDIT_OBJ', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'CLUSTER', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'CLUSTERING', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'CODE_BASE_GRANT', 'ORACLE', 1+8+256, 0,
  'KU$.GRANTEE, KU$.ROLE', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'COMMENT', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME, KU$.COLNO', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'CONSTRAINT', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME,  NVL(KU$.CON1.IND.ANC_OBJ.NAME,KU$.BASE_OBJ.NAME), KU$.CON_NUM', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'CONTEXT', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'DB_LINK', 'ORACLE', 1+8+256, 0,
  'KU$.OWNER_NAME, KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'DEFAULT_ROLE', 'ORACLE', 1+8+256, 0,
  'KU$.USER_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'DIMENSION', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'DIRECTORY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'FGA_POLICY', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME, KU$.NAME, KU$.PFNAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'FUNCTION', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ATTRIBUTE_DIMENSION', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'HIERARCHY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ANALYTIC_VIEW', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'INDEX', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'INDEX_STATISTICS', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_IND_OBJ.OWNER_NAME, KU$.BASE_IND_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'INDEXTYPE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'JAVA_CLASS', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'JAVA_RESOURCE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'JAVA_SOURCE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'JOB', 'ORACLE', 1+8+256, 0,
  'KU$.POWNER, KU$.JOB_ID', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'LIBRARY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'MATERIALIZED_VIEW', 'ORACLE', 1+8+256, 0,
  'KU$.MVIEW.SOWNER, KU$.MVIEW.VNAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 1+8+256, 0,
  'KU$.MVIEWLOG.MOWNER, KU$.MVIEWLOG.MASTER', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'MATERIALIZED_ZONEMAP', 'ORACLE', 1+8+256, 0,
  'KU$.MVIEW.SOWNER, KU$.MVIEW.VNAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'MONITORING', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'OBJECT_GRANT', 'ORACLE', 1+8+256, 0,
  'KU$.GRANTOR, KU$.SEQUENCE', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ON_USER_GRANT', 'ORACLE', 1+8+256, 0,
  'KU$.SEQUENCE', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'OPERATOR', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PACKAGE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PACKAGE_BODY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'EXP_PACKAGE_BODY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PACKAGE_SPEC', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PACKAGE_OBJNUM', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PASSWORD_HISTORY', 'ORACLE', 1+8+256, 0,
  'KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PLUGTS_TSNAME_FULL', 'ORACLE', 1+8+256, 0,
  'KU$.TS_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PLUGTS_TSNAME_TABLE', 'ORACLE', 1+8+256, 0,
  'KU$.TS_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PLUGTS_TSNAME_INDEX', 'ORACLE', 1+8+256, 0,
  'KU$.TS_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PLUGTS_TSNAME_INDEXP', 'ORACLE', 1+8+256, 0,
  'KU$.TS_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'POST_TABLE_ACTION', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PRE_TABLE_ACTION', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCACT_INSTANCE', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCACT_SYS_PKG', 'ORACLE', 1+8+256, 0,
  'KU$.PLEVEL, KU$.PSCHEMA, KU$.PNAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'INSTANCE_CALLOUT', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'SCHEMA_CALLOUT', 'ORACLE', 1+8+256, 0,
  'KU$.USER_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCDEPOBJ', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME, ' ||
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCDEPOBJ_AUDIT', 'ORACLE', 1+8+256, 0,
  'KU$.ANC_OBJ.OWNER_NAME, KU$.ANC_OBJ.NAME, ' ||
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCDEPOBJ_GRANT', 'ORACLE', 1+8+256, 0,
  'KU$.ANC_OBJ.OWNER_NAME, KU$.ANC_OBJ.NAME, ' ||
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCEDURE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCOBJ', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCOBJ_AUDIT', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROCOBJ_GRANT', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROFILE', 'ORACLE', 1+8+256, 0,
  'KU$.PROFILE_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PROXY', 'ORACLE', 1+8+256, 0,
  'KU$.CLIENT_NAME, KU$.PROXY_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'RADM_POLICY', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME, KU$.PNAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'REF_CONSTRAINT', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME, KU$.CON_NUM', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'REFRESH_GROUP', 'ORACLE', 1+8+256, 0,
  'KU$.REFOWNER, KU$.REFNAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'RLS_CONTEXT', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'RLS_GROUP', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'RLS_POLICY', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ROLE', 'ORACLE', 1+8+256, 0,
  'KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ROLE_GRANT', 'ORACLE', 1+8+256, 0,
  'KU$.GRANTEE, KU$.ROLE', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'ROLLBACK_SEGMENT', 'ORACLE', 1+8+256, 0,
  'KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'SEQUENCE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'SYNONYM', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'SYSTEM_GRANT', 'ORACLE', 1+8+256, 0,
  'KU$.GRANTEE, KU$.PRIVNAME, KU$.SEQUENCE', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TABLE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TABLE_DATA', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME, KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TABLE_STATISTICS', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'USER_PREF_STATISTICS', 'ORACLE', 1+8+256, 0,
  'KU$.BASE_OBJ.OWNER_NAME, KU$.BASE_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TABLESPACE', 'ORACLE', 1+8+256, 0,
  'KU$.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TABLESPACE_ILM_POLICY', 'ORACLE', 1+8+256, 0,
  'KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TABLESPACE_QUOTA', 'ORACLE', 1+8+256, 0,
  'KU$.USER_NAME, KU$.TS_NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TRIGGER', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);
-- Add total_order filters for Triton Security objects
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'XS_SECURITY_CLASS', 'ORACLE', 1+256, 0, 'XS_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'XS_DATA_SECURITY', 'ORACLE', 1+256, 0, 'XS_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'XS_ACL', 'ORACLE', 1+256, 0, 'OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'XS_GRANT', 'ORACLE', 1+256, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TRUSTED_DB_LINK', 'ORACLE', 1+8+256, 0,
  'KU$.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TYPE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TYPE_SPEC', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'INC_TYPE', 'ORACLE', 1+8+256, 0,
  'KU$.OWNER_NAME, KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'SORT_TYPES', 'ORACLE', 1+8+256, 0,
  'KU$.TYPEOWNER, KU$.TYPENAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'SORT_VIEWS', 'ORACLE', 1+8+256, 0,
  'KU$.VIEWOWNER, KU$.VIEWNAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'TYPE_BODY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'EXP_TYPE_BODY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'USER', 'ORACLE', 1+8+256, 0,
  'KU$.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'VIEW', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME, KU$.SCHEMA_OBJ.NAME', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'XMLSCHEMA', 'ORACLE', 1+8+256, 0,
  'KU$.OWNER_NAME, KU$.URL', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'EXP_XMLSCHEMA', 'ORACLE', 1+8+256, 0,
  'KU$.OWNER_NAME, KU$.URL', 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDER_OBJNUMS', 'TYPE_SPEC', 'ORACLE', 2+1024, 0,
  'OBJ_NUM',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDER_OBJNUMS_NOB', 'VIEW', 'ORACLE', 2+8192, 0,
  'OBJ_NUM',NULL);


-- If BASE_OBJECT_NAME=DATABASE, we set NON_DB filter false to exclude
--  all triggers that are not database triggers.
-- Similarly, if BASE_OBJECT_NAME=SCHEMA, we set NON_SCHEMA filter false.
-- (A bit clumsy but it works.)

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NON_DB', 'TRIGGER', 'ORACLE', 9, 0, 'BITAND(KU$.PROPERTY,8)=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NON_SCHEMA', 'TRIGGER', 'ORACLE', 9, 0, 'BITAND(KU$.PROPERTY,16)=0',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'SYNONYM', 'ORACLE', 0, 0, 'SYN_LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0, 'SYN_LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0,
 'NOT (KU$.SYN_LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'JAVA_SOURCE', 'ORACLE', 0, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'JAVA_SOURCE', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'JAVA_RESOURCE', 'ORACLE', 0, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'JAVA_RESOURCE', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'JAVA_CLASS', 'ORACLE', 0, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'JAVA_CLASS', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'DB_LINK', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'DB_LINK', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'DB_LINK', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'XMLSCHEMA', 'ORACLE', 0, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT (KU$.URL :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'EXP_XMLSCHEMA', 'ORACLE', 0, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0, 'URL',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT (KU$.URL :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME', 'OBJECT_GRANT', 'ORACLE', 0, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LONGNAME_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0, 'LONG_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_LONGNAME_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.LONG_NAME :1)',NULL);


insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTOR', 'OBJECT_GRANT', 'ORACLE', 0, 0, 'GRANTOR',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTOR', 'ON_USER_GRANT', 'ORACLE', 0, 0, 'GRANTOR',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTOR', 'CODE_BASE_GRANT', 'ORACLE', 0, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'CODE_BASE_GRANT', 'ORACLE', 0, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'OBJECT_GRANT', 'ORACLE', 0, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'ON_USER_GRANT', 'ORACLE', 0, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'SYSTEM_GRANT', 'ORACLE', 0, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'DEFAULT_ROLE', 'ORACLE', 0, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'PROXY', 'ORACLE', 0, 0, 'CLIENT_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'XS_GRANT', 'ORACLE', 4096, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'ROLE_GRANT', 'ORACLE', 0, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'XS_ROLE_GRANT', 'ORACLE', 4096, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'TABLESPACE_QUOTA', 'ORACLE', 0, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTOR', 'TABLESPACE_QUOTA', 'ORACLE', 0, 0, 'GRANTOR',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'AUDIT', 'ORACLE', 0, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'PASSWORD_HISTORY', 'ORACLE', 0, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE', 'RMGR_INITIAL_CONSUMER_GROUP', 'ORACLE', 0, 0, 'GRANTEE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_TYPE', 'DEFAULT_ROLE', 'ORACLE', 0, 0, 'USER_TYPE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMAOID', 'XMLSCHEMA', 'ORACLE', 0, 0, 'SCHEMAOID',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NO_XML', 'XMLSCHEMA', 'ORACLE', 1+8, 0, NULL, 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMAOID', 'EXP_XMLSCHEMA', 'ORACLE', 0, 0, 'SCHEMAOID',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NO_XML', 'EXP_XMLSCHEMA', 'ORACLE', 1+8, 0, NULL, 0);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('XML_OUTOFLINE', 'TABLE_DATA', 'ORACLE', 1+8, 0,
  'XML_OUTOFLINE=''Y''', 1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'CODE_BASE_GRANT', 'ORACLE', 2, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'ON_USER_GRANT', 'ORACLE', 2, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'SYSTEM_GRANT', 'ORACLE', 2, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'DEFAULT_ROLE', 'ORACLE', 2, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'PROXY', 'ORACLE', 2, 0, 'CLIENT_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'XS_GRANT', 'ORACLE', 2, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'ROLE_GRANT', 'ORACLE', 2, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'XS_ROLE_GRANT', 'ORACLE', 2, 0, 'GRANTEE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'TABLESPACE_QUOTA', 'ORACLE', 2, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'AUDIT', 'ORACLE', 2, 0, 'USER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'PASSWORD_HISTORY', 'ORACLE', 2, 0, 'NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('GRANTEE_EXPR', 'RMGR_INITIAL_CONSUMER_GROUP', 'ORACLE', 2, 0,
  'GRANTEE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'OBJECT_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'ON_USER_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'CODE_BASE_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'SYSTEM_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'DEFAULT_ROLE', 'ORACLE', 2, 0,
 'NOT (KU$.USER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'PROXY', 'ORACLE', 2, 0,
 'NOT (KU$.CLIENT_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'XS_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'ROLE_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'XS_ROLE_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'TABLESPACE_QUOTA', 'ORACLE', 2, 0,
 'NOT (KU$.USER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.USER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'PASSWORD_HISTORY', 'ORACLE', 2, 0,
 'NOT (KU$.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_GRANTEE_EXPR', 'RMGR_INITIAL_CONSUMER_GROUP', 'ORACLE', 2, 0,
 'NOT (KU$.GRANTEE :1)',NULL);

Rem
Rem The OWNER_NAME filters for SYNONYM have the same definition as the
Rem SCHEMA filters.  They allow the heterogeneous type to define
Rem two filters for the same attribute, one to distinguish between
Rem public and private synonyms, the other to specify the synonym owner.
Rem (See routines do_de_synonym and inh_owner_name_filters in
Rem datapump/ddl/prvtmetd.sql)
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OWNER_NAME', 'SYNONYM', 'ORACLE', 0, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OWNER_NAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_OWNER_NAME_EXPR', 'SYNONYM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME', 'PROC_SYSTEM_GRANT', 'ORACLE', 0, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME', 'PROC_AUDIT', 'ORACLE', 0, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME', 'PROCACT_SYSTEM', 'ORACLE', 0, 0, 'PACKAGE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME', 'SYSTEM_CALLOUT', 'ORACLE', 0, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME', 'SCHEMA_CALLOUT', 'ORACLE', 0, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0, 'PACKAGE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME_EXPR', 'PROC_SYSTEM_GRANT', 'ORACLE', 2, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME_EXPR', 'PROC_AUDIT', 'ORACLE', 2, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME_EXPR', 'PROCACT_SYSTEM', 'ORACLE', 2, 0, 'PACKAGE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME_EXPR', 'SYSTEM_CALLOUT', 'ORACLE', 2, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME_EXPR', 'SCHEMA_CALLOUT', 'ORACLE', 2, 0, 'PACKAGE',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_NAME_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0, 'PACKAGE',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PACKAGE_NAME_EXPR', 'PROC_SYSTEM_GRANT', 'ORACLE', 2, 0,
  'NOT (KU$.PACKAGE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PACKAGE_NAME_EXPR', 'PROC_AUDIT', 'ORACLE', 2, 0,
  'NOT (KU$.PACKAGE :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PACKAGE_NAME_EXPR', 'PROCACT_SYSTEM', 'ORACLE', 2, 0,
  'NOT (KU$.PACKAGE :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA', 'PROC_SYSTEM_GRANT', 'ORACLE', 0, 0, 'SCHEMA',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA', 'PROC_AUDIT', 'ORACLE', 0, 0, 'SCHEMA',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA', 'PROCACT_SYSTEM', 'ORACLE', 0, 0, 'SCHEMA',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA', 'SYSTEM_CALLOUT', 'ORACLE', 0, 0, 'PKG_SCHEMA',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA', 'SCHEMA_CALLOUT', 'ORACLE', 0, 0, 'PKG_SCHEMA',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA', 'INSTANCE_CALLOUT', 'ORACLE', 0, 0, 'PKG_SCHEMA',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA_EXPR', 'PROC_SYSTEM_GRANT', 'ORACLE', 2, 0, 'SCHEMA',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA_EXPR', 'PROC_AUDIT', 'ORACLE', 2, 0, 'SCHEMA',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA_EXPR', 'PROCACT_SYSTEM', 'ORACLE', 2, 0, 'SCHEMA',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA_EXPR', 'SYSTEM_CALLOUT', 'ORACLE', 2, 0, 'PKG_SCHEMA',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA_EXPR', 'SCHEMA_CALLOUT', 'ORACLE', 2, 0, 'PKG_SCHEMA',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PACKAGE_SCHEMA_EXPR', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0, 'PKG_SCHEMA',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PACKAGE_SCHEMA_EXPR', 'PROC_SYSTEM_GRANT', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PACKAGE_SCHEMA_EXPR', 'PROC_AUDIT', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_PACKAGE_SCHEMA_EXPR', 'PROCACT_SYSTEM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA :1)',NULL);


REM
REM    For maintainability the following are sorted by TYPE.
REM
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ALTER_FUNCTION', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''FUNCTION'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ALTER_PACKAGE_BODY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PACKAGE_BODY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ALTER_PACKAGE_SPEC', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PACKAGE_SPEC'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ALTER_PROCEDURE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PROCEDURE'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ASSOCIATION', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'AUDIT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''AUDIT'' ' ||
 'AND A.NAME=KU$.USER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'AUDIT_POLICY', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''AUDIT_POLICY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'AUDIT_OBJ', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'CLUSTER', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''CLUSTER'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'CLUSTERING', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'CODE_BASE_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''CODE_BASE_GRANT'' ' ||
 'AND A.NAME=KU$.GRANTEE) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'COMMENT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'CONSTRAINT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''CONSTRAINT'' ' ||
 'AND A.NAME=KU$.NAME AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.OWNER_NAME)) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'CONTEXT', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.NAME=KU$.SCHEMA_OBJ.NAME ' ||
 'AND A.OBJ_TYPE=''CONTEXT'')' , NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'DB_LINK', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''DB_LINK'' ' ||
 'AND A.NAME=KU$.NAME AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'DEFAULT_ROLE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.USER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'DIMENSION', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''DIMENSION'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'DIRECTORY', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.NAME=KU$.SCHEMA_OBJ.NAME ' ||
 'AND A.OBJ_TYPE=''DIRECTORY'')' , NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'DOMIDX_OBJNUM', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'FGA_POLICY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'FUNCTION', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''FUNCTION'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ATTRIBUTE_DIMENSION', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''ATTRIBUTE_DIMENSION'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'HIERARCHY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''HIERARCHY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ANALYTIC_VIEW', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''ANALYTIC_VIEW'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'INC_TYPE', 'ORACLE', 2, 0,
 'BITAND(KU$.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TYPE_SPEC'' ' ||
 'AND A.NAME=KU$.NAME AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'INDEX', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''INDEX'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME)) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'INDEXTYPE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''INDEXTYPE'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'INDEX_STATISTICS', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_TAB_OBJ.NAME AND A.SCHEMA=KU$.BASE_TAB_OBJ.OWNER_NAME) '
 ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''INDEX'' ' ||
 'AND A.NAME=KU$.BASE_IND_OBJ.NAME AND A.SCHEMA=KU$.BASE_IND_OBJ.OWNER_NAME) '
 ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_TAB_OBJ.OWNER_NAME ' ||
 'OR A.NAME=KU$.BASE_IND_OBJ.OWNER_NAME)) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'INSTANCE_CALLOUT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'JAVA_CLASS', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''JAVA_CLASS'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'JAVA_OBJNUM', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE (A.OBJ_TYPE=''JAVA_RESOURCE'' ' ||
 'OR A.OBJ_TYPE=''JAVA_SOURCE'' OR A.OBJ_TYPE=''JAVA_CLASS'') ' ||
 'AND A.NAME=KU$.NAME AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'JAVA_RESOURCE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''JAVA_RESOURCE'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'JAVA_SOURCE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''JAVA_SOURCE'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'JOB', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.POWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'LIBRARY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''LIBRARY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'MATERIALIZED_VIEW', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''MATERIALIZED_VIEW'' ' ||
 'AND A.NAME=KU$.VNAME AND A.SCHEMA=KU$.SOWNER) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SOWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.MVIEWLOG.MASTER AND A.SCHEMA=KU$.MVIEWLOG.MOWNER) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.MVIEWLOG.MOWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'MATERIALIZED_ZONEMAP', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''MATERIALIZED_ZONEMAP'' ' ||
 'AND A.NAME=KU$.VNAME AND A.SCHEMA=KU$.SOWNER) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SOWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'OBJECT_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME IN (KU$.BASE_OBJ.OWNER_NAME,KU$.GRANTEE)) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ON_USER_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.GRANTEE) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''ON_USER_GRANT'' ' ||
 'AND A.NAME=KU$.USER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'OPERATOR', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''OPERATOR'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PACKAGE_BODY', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PACKAGE_BODY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'EXP_PACKAGE_BODY', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PACKAGE_BODY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PACKAGE_SPEC', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PACKAGE_SPEC'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PACKAGE_OBJNUM', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PACKAGE_SPEC'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PASSWORD_HISTORY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PASSWORD_VERIFY_FUNCTION', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS ' ||
 '(SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PASSWORD_VERIFY_FUNCTION'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'POST_TABLE_ACTION', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PRE_TABLE_ACTION', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCACT_INSTANCE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCDEPOBJ', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME)) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCDEPOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.ANC_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.ANC_OBJ.OWNER_NAME)) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCDEPOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.ANC_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.ANC_OBJ.OWNER_NAME)) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCACT_SCHEMA', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.USER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCEDURE', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PROCEDURE'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCOBJ', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PROCOBJ'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCOBJ_OBJNUM', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PROCOBJ'' ' ||
 'AND A.NAME=KU$.NAME AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCOBJ_AUDIT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PROCOBJ_AUDIT'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROCOBJ_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PROCOBJ_GRANT'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROFILE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.NAME=KU$.PROFILE_NAME ' ||
 'AND A.OBJ_TYPE=''PROFILE'')' , NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'PROXY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''PROXY'' ' ||
 'AND A.NAME=KU$.CLIENT_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'RADM_POLICY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'REF_CONSTRAINT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''CONSTRAINT'' ' ||
 'AND A.NAME=KU$.NAME AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.OWNER_NAME)) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'REFRESH_GROUP', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''REFRESH_GROUP'' ' ||
 'AND A.NAME=KU$.REFNAME AND A.SCHEMA=KU$.REFOWNER) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.REFOWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'RLS_CONTEXT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'RLS_GROUP', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'RLS_POLICY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'RLS_POLICY_OBJNUM', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ROLE', 'ORACLE', 2, 0,
  -- not comments for exculde_noexp for users
 'BITAND(KU$.SPARE1, 256)=0 AND ' || -- no export for any oracle supplied user 
 '(BITAND(KU$.SPARE1, 128)=0 OR ' || -- also common users 
 ' (BITAND(KU$.SPARE1, 4096) !=0 AND'||-- except app users when exorting approot
 '  SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES''))AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''ROLE'' ' ||
 'AND A.NAME=KU$.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ROLE_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE IN (''ROLE_GRANT'',' ||
 '''SCHEMA'') AND A.NAME=KU$.GRANTEE) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'ROLLBACK_SEGMENT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.NAME=KU$.NAME ' ||
 'AND A.OBJ_TYPE=''ROLLBACK_SEGMENT'')' , NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'SCHEMA_CALLOUT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.USER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'SEQUENCE', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SEQUENCE'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'SORT_TYPES', 'ORACLE', 2, 0,
 'BITAND(KU$.TYPEOBJFLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.TYPEOBJFLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TYPE_SPEC'' ' ||
 'AND A.NAME=KU$.TYPENAME AND A.SCHEMA=KU$.TYPEOWNER) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.TYPEOWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'SORT_VIEWS', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''VIEW'' ' ||
 'AND A.NAME=KU$.VIEWNAME AND A.SCHEMA=KU$.VIEWOWNER) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.VIEWOWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'SYNONYM', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME ' ||
 'AND KU$.SCHEMA_OBJ.OWNER_NUM =1 ) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'SYSTEM_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE IN (''SYSTEM_GRANT'',' ||
 '''SCHEMA'') AND A.NAME=KU$.GRANTEE) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABLE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABLESPACE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.NAME=KU$.NAME ' ||
 'AND A.OBJ_TYPE=''TABLESPACE'')' , NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABLESPACE_ILM_POLICY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.NAME=KU$.NAME ' ||
 'AND A.OBJ_TYPE=''TABLESPACE_ILM_POLICY'')' , NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABLESPACE_QUOTA', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.USER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABLE_DATA', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP_APP', 'TABLE_OBJNUM', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '|| -- exclude oracle objs
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABLE_STATISTICS', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME)',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TABTYPE_OBJNUM', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TYPE_SPEC'' ' ||
 'AND A.NAME=KU$.TYPENAME AND A.SCHEMA=KU$.TYPEOWNER) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.TYPEOWNER) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TRIGGER', 'ORACLE', 2, 0,
 'BITAND(KU$.SCHEMA_OBJ.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.SCHEMA_OBJ.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TRIGGER'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME)) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TRUSTED_DB_LINK', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.NAME=KU$.NAME ' ||
 'AND A.OBJ_TYPE=''TRUSTED_DB_LINK'')' , NULL);
-- Triton Security objects
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_USER', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_USER'' ' ||
 'AND A.NAME=KU$.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_GRANT'' ' ||
 'AND A.NAME=KU$.GRANTEE) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_ROLE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_ROLE'' ' ||
 'AND A.NAME=KU$.XS_OBJ.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_ROLE_GRANT', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_ROLE_GRANT'' ' ||
 'AND A.NAME=KU$.GRANTEE) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_ROLESET', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_ROLESET'' ' ||
 'AND A.NAME=KU$.XS_OBJ.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_SECURITY_CLASS', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_SECURITY_CLASS'' ' ||
 'AND A.NAME=KU$.XS_OBJ.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_DATA_SECURITY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_DATA_SECURITY'' ' ||
 'AND A.NAME=KU$.XS_OBJ.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_ACL', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_ACL'' ' ||
 'AND A.NAME=KU$.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_ACL_PARAM', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_ACL_PARAM'' ' ||
 'AND A.NAME=KU$.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XS_NAMESPACE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XS_NAMESPACE'' ' ||
 'AND A.NAME=KU$.XS_OBJ.NAME) ',  NULL);
-- end of Triton Security objects
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TYPE_BODY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TYPE_BODY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'EXP_TYPE_BODY', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TYPE_BODY'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'TYPE_SPEC', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TYPE_SPEC'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'USER', 'ORACLE', 2, 0,
-- exclude oracle supplied users and common users, except
--  application common users when exportnig from an approot.
-- flags in user$.spare1, not obj$.flags:
--  128 - common user
--  256 - oracle supplied
-- 4069 - application
 'BITAND(KU$.SPARE1, 256)=0 AND ' || -- no export for any oracle supplied user 
 '(BITAND(KU$.SPARE1, 128)=0 OR ' || -- also common users 
 ' (BITAND(KU$.SPARE1, 4096) !=0 AND'||-- except app users when exorting approot
 '  SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES''))AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'USER_PREF_STATISTICS', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.OWNER_NAME)',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'VIEW', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''VIEW'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'VIEW_OBJNUM', 'ORACLE', 2, 0,
 'BITAND(KU$.FLAGS,4194304)=0 AND '||   -- exclude oracle objs
 '(BITAND(KU$.FLAGS,134217728)=0 OR '|| --  and appl objs in apppdb
   'SYS_CONTEXT(''USERENV'', ''IS_APPLICATION_ROOT'')=''YES'') AND '||
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''VIEW'' ' ||
 'AND A.NAME=KU$.NAME AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XMLSCHEMA'' ' ||
 'AND A.NAME=KU$.URL AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME) ',  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'EXP_XMLSCHEMA', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''XMLSCHEMA'' ' ||
 'AND A.NAME=KU$.URL AND A.SCHEMA=KU$.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND A.NAME=KU$.OWNER_NAME) ',  NULL);


-- **** EXCLUDE_NOEXP2 = EXCLUDE_NOEXP for domain index secondary objects  ****

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP2', 'TABLE', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND (A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'OR (A.NAME=KU$.ANC_OBJ.NAME AND A.SCHEMA=KU$.ANC_OBJ.OWNER_NAME)) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME OR A.NAME=KU$.ANC_OBJ.OWNER_NAME ' ||
 'OR A.NAME=KU$.BASE_OBJ.OWNER_NAME)) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''INDEX'' ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ',
 NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP2', 'TABLE_DATA', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''TABLE'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'OR (A.NAME=KU$.ANC_OBJ.NAME AND A.SCHEMA=KU$.ANC_OBJ.OWNER_NAME)) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.ANC_OBJ.OWNER_NAME ' ||
 'OR A.NAME=KU$.DOMIDX_OBJ.OWNER_NAME)) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''INDEX'' ' ||
 'AND A.NAME=KU$.DOMIDX_OBJ.NAME AND A.SCHEMA=KU$.DOMIDX_OBJ.OWNER_NAME) ',
 NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CUSTOM_FILTER', '*', 'ORACLE', 4, 0, NULL,NULL);

/* additional filters for tables */
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HEAP', 'TABLE', 'ORACLE', 9, 1, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('IOT', 'TABLE', 'ORACLE', 9, 2, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NON_PARTITIONED', 'TABLE', 'ORACLE', 9, 16, 'BITAND(KU$.PROPERTY,32)=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PARTITIONED', 'TABLE', 'ORACLE', 9, 32, 'BITAND(KU$.PROPERTY,32)=32',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RELATIONAL', 'TABLE', 'ORACLE', 9, 256, 'BITAND(KU$.PROPERTY,1)=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJECT', 'TABLE', 'ORACLE', 9, 512, 'BITAND(KU$.PROPERTY,1)=1',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BUILTIN_COL', 'TABLE', 'ORACLE', 9, 4096, NULL, 1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LOB_COL', 'TABLE', 'ORACLE', 9, 8192,
        'BITAND(KU$.PROPERTY,2048+32768+262144)!=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('UDT_COL', 'TABLE', 'ORACLE',9, 16384, 'BITAND(KU$.PROPERTY,2+4+8+16)!=0',1);

Rem
Rem Boolean filters to pick out specific views.
Rem By default the filters are on, i.e., you get all views by default.
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HTABLE', 'TABLE', 'ORACLE', 9, 65536, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FHTABLE', 'TABLE', 'ORACLE', 9, 131072, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PHTABLE', 'TABLE', 'ORACLE', 9, 262144, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PFHTABLE', 'TABLE', 'ORACLE', 9, 524288, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('IOTABLE', 'TABLE', 'ORACLE', 9, 1048576, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PIOTABLE', 'TABLE', 'ORACLE', 9, 2097152, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CPFHTABLE', 'TABLE', 'ORACLE', 9, 4194304, NULL,1);

/* additional filters for materialized views */
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HEAP', 'MATERIALIZED_VIEW', 'ORACLE', 9, 1, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('IOT', 'MATERIALIZED_VIEW', 'ORACLE', 9, 2, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NON_PARTITIONED', 'MATERIALIZED_VIEW', 'ORACLE', 9, 16,
  'BITAND(KU$.MVIEW_TAB.PROPERTY,32)=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PARTITIONED', 'MATERIALIZED_VIEW', 'ORACLE', 9, 32,
  'BITAND(KU$.MVIEW_TAB.PROPERTY,32)=32',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RELATIONAL', 'MATERIALIZED_VIEW', 'ORACLE', 9, 256,
  'BITAND(KU$.MVIEW_TAB.PROPERTY,1)=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJECT', 'MATERIALIZED_VIEW', 'ORACLE', 9, 512,
  'BITAND(KU$.MVIEW_TAB.PROPERTY,1)=1',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BUILTIN_COL', 'MATERIALIZED_VIEW', 'ORACLE', 9, 4096, NULL, 1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LOB_COL', 'MATERIALIZED_VIEW', 'ORACLE', 9, 8192,
  'BITAND(KU$.MVIEW_TAB.PROPERTY,2048+32768+262144)!=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('UDT_COL', 'MATERIALIZED_VIEW', 'ORACLE',9, 16384,
  'BITAND(KU$.MVIEW_TAB.PROPERTY,2+4+8+16)!=0',1);
Rem
Rem Boolean filters to pick out specific views.
Rem By default the filters are on, i.e., you get all views by default.
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HTABLE', 'MATERIALIZED_VIEW', 'ORACLE', 9, 65536, NULL,0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FHTABLE', 'MATERIALIZED_VIEW', 'ORACLE', 9, 131072, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PHTABLE', 'MATERIALIZED_VIEW', 'ORACLE', 9, 262144, NULL,0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PFHTABLE', 'MATERIALIZED_VIEW', 'ORACLE', 9, 524288, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('IOTABLE', 'MATERIALIZED_VIEW', 'ORACLE', 9, 1048576, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PIOTABLE', 'MATERIALIZED_VIEW', 'ORACLE', 9, 2097152, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECMVIEW', 'MATERIALIZED_VIEW', 'ORACLE', 9, 8388608, NULL,1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HTABLE', 'MATERIALIZED_ZONEMAP', 'ORACLE', 9, 65536, NULL,0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FHTABLE', 'MATERIALIZED_ZONEMAP', 'ORACLE', 9, 131072, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PHTABLE', 'MATERIALIZED_ZONEMAP', 'ORACLE', 9, 262144, NULL,0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PFHTABLE', 'MATERIALIZED_ZONEMAP', 'ORACLE', 9, 524288, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('IOTABLE', 'MATERIALIZED_ZONEMAP', 'ORACLE', 9, 1048576, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PIOTABLE', 'MATERIALIZED_ZONEMAP', 'ORACLE', 9, 2097152, NULL,1);

/* additional filters for materialized view logs */
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HEAP', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 1, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('IOT', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 2, NULL,0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NON_PARTITIONED', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 16,
  'BITAND(KU$.MVIEWLOG_TAB.PROPERTY,32)=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PARTITIONED', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 32,
  'BITAND(KU$.MVIEWLOG_TAB.PROPERTY,32)=32',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RELATIONAL', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 256,
  'BITAND(KU$.MVIEWLOG_TAB.PROPERTY,1)=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJECT', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 512,
  'BITAND(KU$.MVIEWLOG_TAB.PROPERTY,1)=1',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BUILTIN_COL', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 4096, NULL, 1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('LOB_COL', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 8192,
  'BITAND(KU$.MVIEWLOG_TAB.PROPERTY,2048+32768+262144)!=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('UDT_COL', 'MATERIALIZED_VIEW_LOG', 'ORACLE',9, 16384,
  'BITAND(KU$.MVIEWLOG_TAB.PROPERTY,2+4+8+16)!=0',1);
Rem
Rem Boolean filters to pick out specific views.
Rem By default the filters are on, i.e., you get all views by default.
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HTABLE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 65536, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FHTABLE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 131072, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PHTABLE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 262144, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PFHTABLE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 524288, NULL,1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('IOTABLE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 1048576, NULL,0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PIOTABLE', 'MATERIALIZED_VIEW_LOG', 'ORACLE', 9, 2097152, NULL,0);

Rem
Rem  Procedural objects and actions CLASS and PREPOST filter
Rem
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CLASS', 'PROCOBJ', 'ORACLE', 16, 0, 'CLASS',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CLASS', 'PROCOBJ_GRANT', 'ORACLE', 16, 0, 'CLASS',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CLASS', 'PROCOBJ_AUDIT', 'ORACLE', 16, 0, 'CLASS',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CLASS', 'PROCDEPOBJ', 'ORACLE', 16, 0, 'CLASS',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CLASS', 'PROCDEPOBJ_GRANT', 'ORACLE', 16, 0, 'CLASS',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('CLASS', 'PROCDEPOBJ_AUDIT', 'ORACLE', 16, 0, 'CLASS',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCOBJ', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCOBJ_GRANT', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCOBJ_AUDIT', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCDEPOBJ', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCDEPOBJ_GRANT', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCDEPOBJ_AUDIT', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCACT_SYSTEM', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCACT_SCHEMA', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PROCACT_INSTANCE', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'SYSTEM_CALLOUT', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'SCHEMA_CALLOUT', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'INSTANCE_CALLOUT', 'ORACLE', 16, 0, 'PREPOST',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PREPOST', 'PLUGTS_BLK', 'ORACLE', 16, 0, 'PREPOST',NULL);

--filters for audit policy related objects
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AUDIT_POLICY', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AUDIT_POLICY', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AUDIT_POLICY', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'AUDIT_POLICY', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.NAME', 1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'AUDIT_POLICY_ENABLE', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'AUDIT_POLICY_ENABLE', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'AUDIT_POLICY_ENABLE', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'AUDIT_POLICY_ENABLE', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.NAME', 1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'AUDIT_CONTEXT', 'ORACLE', 1+8+256, 0,
  'KU$."USER"', 1);


-- Object grants have three special filters that when applied to 3 consecutive
-- queries will produce the grants in a creation order that works. The problem
-- with just fetching all grants ordered by seq # is that for large numbers of
-- grants, the sort is prohibitive; e.g, the Apps DB has 178K table grants.
-- So, for object types expected to have lots of grants, they're fetched with
-- 3 queries using the following filters: The first fetches all grants created
-- by an object's owner (the vast majority... no ordering req). The 2nd fetches
-- WGO grants *not* made by the owner (this is a very small number and the only
-- group that has to be ordered). The third is all the rest... non-WGO grants
-- not made by the owner. See the het. object definitions in datapump/ddl/utl
-- to see how these filters are used for sequences, tables, views and packages.

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OWNER', 'OBJECT_GRANT', 'ORACLE', 1+8+2048, 0,
  'KU$.GRANTOR=KU$.BASE_OBJ.OWNER_NAME', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NOTOWNER_WGO', 'OBJECT_GRANT', 'ORACLE', 1+8+2048, 0,
  'KU$.GRANTOR!=KU$.BASE_OBJ.OWNER_NAME AND KU$.WGO!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NOTOWNER_NOTWGO', 'OBJECT_GRANT', 'ORACLE', 1+8+2048, 0,
  'KU$.GRANTOR!=KU$.BASE_OBJ.OWNER_NAME AND KU$.WGO=0', 0);

-- option_objnum filters
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OT_EARLY', 'OPTION_OBJNUM', 'ORACLE', 2048+1, 0,
  'BITAND(KU$.IMPC_FLAGS,2)!=0', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OT_NORMAL', 'OPTION_OBJNUM', 'ORACLE', 2048+1, 0,
  'BITAND(KU$.IMPC_FLAGS,2)=0', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TAG_EXPR', 'OPTION_OBJNUM', 'ORACLE', 2, 0,
  'TAG', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OT_DEP', 'OPTION_OBJNUM', 'ORACLE', 2048+1, 0,
  'BITAND(KU$.IMPC_FLAGS,4)!=0', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OT_NODEP', 'OPTION_OBJNUM', 'ORACLE', 2048+1, 0,
  'BITAND(KU$.IMPC_FLAGS,4)=0', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OT_TBL_NOT_VIEW', 'OPTION_OBJNUM', 'ORACLE', 2048+1, 0,
  'bitand(KU$.IMPC_FLAGS,32768)!=0', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJECT_TYPE', 'OPTION_OBJNUM', 'ORACLE', 16, 0,
  'TGT_TYPE', 0);
-- tablespace filter to select tablespaces to export with transportable in
--   "full=y transportable=always"
--  SYSTEM and SYSAUX are never transported.
--  TEMPORARY tablesspaces (contents=1) are not transported
--  UNDO tablesspaces (bitnand(flags,16)!=0) are not transported
--  tablespaces not ONLINE or READ ONLY are not transported
--  tablespace containing XDB.XDB$RESPOITORY is tranported only
--   if read only.
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FULL_TABLESPACE', 'TABLESPACE', 'ORACLE', 1, 0,
  '(not(ku$.name not in (''SYSTEM'',''SYSAUX'') '||
  '     and ku$.contents=0 '||
  '     and bitand(KU$.flags,16)=0 '||
  '     and status in (1,4))) '||
  '     and not( ku$.status = 1 and ku$.ts_num = '||
  '      (select tt.ts_num '||
  '       from  sys.ku$_tts_tab_tablespace_view tt '||
  '       where tt.partobj.name = ''XDB$RESOURCE'' and  '||
  '             tt.partobj.owner_name = ''XDB'' ))', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('DATABASE_EXPORT', 'TABLESPACE', 'ORACLE', 1, 0,
  '(not(ku$.name not in (''SYSTEM'',''SYSAUX'') and '||
  'dbms_metadata.in_tsnum(1,ts_num)=0))', 0);

/* TBD: 'INCOMPLETE'??? */

-- Populate metaxsl$: This table provides the URI of the top level stylesheet
-- for a given XML document and transform. The XML document is identified by
-- xmltag and model (from metaview$) and the transform name (eg, DDL, CREATE,
-- PARSE, etc) is in 'transform'. 'script' contains the stylesheet name.
-- For ORACLE model stylesheets, this matches the 'name' column in the
-- table metastylesheet; dbms_metadata_int converts this name to a URI.
-- For other models, 'name' is a URI.

insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'DDL', 'ORACLE', 'kutable');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('IDENTITY_COLUMN_T', 'DDL', 'ORACLE', 'kutable');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'DDL', 'ORACLE', 'kuindex');

-- full.xsl can process type spec and type body as well as full type
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_T', 'DDL', 'ORACLE', 'kufull');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_BODY_T', 'DDL', 'ORACLE', 'kufull');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FULL_TYPE_T', 'DDL', 'ORACLE', 'kufull');

insert into metaxsl$ (xmltag, transform, model, script) values
 ('INC_TYPE_T', 'DDL', 'ORACLE', 'kufull');


insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCEDURE_T', 'DDL', 'ORACLE', 'kuproc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FUNCTION_T', 'DDL', 'ORACLE', 'kuproc');

-- full.xsl can process type spec and type body as well as full type
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PACKAGE_T', 'DDL', 'ORACLE', 'kufull');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PACKAGE_BODY_T', 'DDL', 'ORACLE', 'kufull');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FULL_PACKAGE_T', 'DDL', 'ORACLE', 'kufull');

insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_FUNCTION_T', 'DDL', 'ORACLE', 'kuproc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PACKAGE_SPEC_T', 'DDL', 'ORACLE', 'kuproc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PACKAGE_BODY_T', 'DDL', 'ORACLE', 'kuproc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PROCEDURE_T', 'DDL', 'ORACLE', 'kuproc');

insert into metaxsl$ (xmltag, transform, model, script) values
 ('POST_DATA_TABLE_T', 'DDL', 'ORACLE', 'kupostdt');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OPERATOR_T', 'DDL', 'ORACLE', 'kuoper');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEXTYPE_T', 'DDL', 'ORACLE', 'kuidxtyp');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OBJGRANT_T', 'DDL', 'ORACLE', 'kugrant');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ON_USER_GRANT_T', 'DDL', 'ORACLE', 'kurolegr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CODE_BASE_GRANT_T', 'DDL', 'ORACLE', 'kurolegr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYSGRANT_T', 'DDL', 'ORACLE', 'kugrant');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYNONYM_T', 'DDL', 'ORACLE', 'kusyn');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRIGGER_T', 'DDL', 'ORACLE', 'kutrig');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_USER_T', 'DDL', 'ORACLE', 'kutsuser');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_GRANT_T', 'DDL', 'ORACLE', 'kutsrole');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLE_T', 'DDL', 'ORACLE', 'kutsrole');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLE_GRANT_T', 'DDL', 'ORACLE', 'kutsrole');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLESET_T', 'DDL', 'ORACLE', 'kutsroleset');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_SECURITY_CLASS_T', 'DDL', 'ORACLE', 'kutssclass');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_DATA_SECURITY_T', 'DDL', 'ORACLE', 'kutsdsec');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ACL_T', 'DDL', 'ORACLE', 'kutsacl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ACL_PARAM_T', 'DDL', 'ORACLE', 'kutsacl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_NAMESPACE_T', 'DDL', 'ORACLE', 'kutsnspace');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'DDL', 'ORACLE', 'kuview');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'DDL', 'ORACLE', 'kumview');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'DDL', 'ORACLE', 'kumviewl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_ZONEMAP_T', 'DDL', 'ORACLE', 'kumview');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OUTLINE_T', 'DDL', 'ORACLE', 'kuoutln');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DIRECTORY_T', 'DDL', 'ORACLE', 'kudir');
rem
rem bug 6938028: Database Vault Protected Schema. This is the first
rem place where the XSLT stylesheet is registered. Here, the xmltag
rem of the stylesheet is registered for the Database Vault types.
rem
rem Stylesheet location                        xmltag
rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
rem $SRCHOME/rdbms/xml/xsl/kudvrlm.xsl         DVPS_REALM_T
rem $SRCHOME/rdbms/xml/xsl/kudvrlmm.xsl        DVPS_REALM_MEMBERSHIP_T
rem $SRCHOME/rdbms/xml/xsl/kudvrlma.xsl        DVPS_REALM_AUTHORIZATION_T
rem $SRCHOME/rdbms/xml/xsl/kudvsta.xsl         DVPS_IMPORT_STAGING_REALM_T
rem $SRCHOME/rdbms/xml/xsl/kudvstam.xsl        DVPS_STAGING_REALM_MEMBERSHP_T
rem $SRCHOME/rdbms/xml/xsl/kudvstad.xsl        DVPS_DISR_T
rem $SRCHOME/rdbms/xml/xsl/kudvrul.xsl         DVPS_RULE_T
rem $SRCHOME/rdbms/xml/xsl/kudvruls.xsl        DVPS_RULE_SET_T
rem $SRCHOME/rdbms/xml/xsl/kudvrsm.xsl         DVPS_RULE_SET_MEMBERSHIP_T
rem $SRCHOME/rdbms/xml/xsl/kudvcr.xsl          DVPS_COMMAND_RULE_T
rem $SRCHOME/rdbms/xml/xsl/kudvcralts.xsl      DVPS_COMMAND_RULE_ALTS_T
rem $SRCHOME/rdbms/xml/xsl/kudvrol.xsl         DVPS_ROLE_T
rem $SRCHOME/rdbms/xml/xsl/kudvf.xsl           DVPS_FACTOR_T
rem $SRCHOME/rdbms/xml/xsl/kudvfl.xsl          DVPS_FACTOR_LINK_T
rem $SRCHOME/rdbms/xml/xsl/kudvft.xsl          DVPS_FACTOR_TYPE_T
rem $SRCHOME/rdbms/xml/xsl/kudvid.xsl          DVPS_IDENTITY_T
rem $SRCHOME/rdbms/xml/xsl/kudvidm.xsl         DVPS_IDENTITY_MAP_T
rem $SRCHOME/rdbms/xml/xsl/kudvpol.xsl         DVPS_DV_POLICY_T
rem $SRCHOME/rdbms/xml/xsl/kudvpolobjr.xsl     DVPS_DV_POLICY_OBJ_R_T
rem $SRCHOME/rdbms/xml/xsl/kudvpolobjc.xsl     DVPS_DV_POLICY_OBJ_C_T
rem $SRCHOME/rdbms/xml/xsl/kudvpolobjcalts.xsl DVPS_DV_POLICY_OBJ_C_ALTS_T
rem $SRCHOME/rdbms/xml/xsl/kudvpolowner.xsl    DVPS_DV_POLICY_OWNER_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_DP_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_TTS_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_JOB_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_PROXY_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_DDL_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_PREP_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_MAINT_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_DIAG_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_INDEX_FUNC_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_ORADEBUG_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_ACCTS_T

insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_REALM_T', 'DDL', 'ORACLE', 'kudvrlm');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_REALM_MEMBERSHIP_T', 'DDL', 'ORACLE', 'kudvrlmm');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_REALM_AUTHORIZATION_T', 'DDL', 'ORACLE', 'kudvrlma');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_IMPORT_STAGING_REALM_T', 'DDL', 'ORACLE', 'kudvsta');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_STAGING_REALM_MEMBERSHP_T', 'DDL', 'ORACLE', 'kudvstam');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DISR_T', 'DDL', 'ORACLE', 'kudvstad');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_RULE_T', 'DDL', 'ORACLE', 'kudvrul');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_RULE_SET_T', 'DDL', 'ORACLE', 'kudvruls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_RULE_SET_MEMBERSHIP_T', 'DDL', 'ORACLE', 'kudvrsm');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_COMMAND_RULE_T', 'DDL', 'ORACLE', 'kudvcr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_COMMAND_RULE_ALTS_T', 'DDL', 'ORACLE', 'kudvcralts');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_ROLE_T', 'DDL', 'ORACLE', 'kudvrol');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_FACTOR_T', 'DDL', 'ORACLE', 'kudvf');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_FACTOR_LINK_T', 'DDL', 'ORACLE', 'kudvfl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_FACTOR_TYPE_T', 'DDL', 'ORACLE', 'kudvft');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_IDENTITY_T', 'DDL', 'ORACLE', 'kudvid');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_IDENTITY_MAP_T', 'DDL', 'ORACLE', 'kudvidm');

REM Project 46812: DV policy support
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_T', 'DDL', 'ORACLE', 'kudvpol');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OBJ_R_T', 'DDL', 'ORACLE', 'kudvpolobjr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OBJ_C_T', 'DDL', 'ORACLE', 'kudvpolobjc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OBJ_C_ALTS_T', 'DDL', 'ORACLE', 'kudvpolobjcalts');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OWNER_T', 'DDL', 'ORACLE', 'kudvpolowner');

-- Bug 21299533: support for Database Vault Authorization
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_DP_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_TTS_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_JOB_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_PROXY_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_DDL_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_PREP_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_DIAG_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_INDEX_FUNC_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_MAINT_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_ORADEBUG_T', 'DDL', 'ORACLE', 'kudvauth');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_ACCTS_T', 'DDL', 'ORACLE', 'kudvauth');

rem 12c project 32006: RADM
rem This is the first place where the XSLT stylesheet must be registered
rem for each type.
rem stylesheet location                 xmltag
rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
rem $SRCHOME/rdbms/xml/xsl/kuradmp.xsl  RADM_POLICY_T
rem $SRCHOME/rdbms/xml/xsl/kuradmf.xsl  RADM_FPTM_T
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RADM_POLICY_T', 'DDL', 'ORACLE', 'kuradmp');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RADM_FPTM_T', 'DDL', 'ORACLE', 'kuradmf');

insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLLBACK_T', 'DDL', 'ORACLE', 'kurollbk');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DBLINK_T', 'DDL', 'ORACLE', 'kudblink');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRLINK_T', 'DDL', 'ORACLE', 'kutrlink');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_T', 'DDL', 'ORACLE', 'kutblspc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_TABLESPACE_T', 'DDL', 'ORACLE', 'kutblspc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_ILM_POLICY_T', 'DDL', 'ORACLE', 'kuilm');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FGA_POLICY_T', 'DDL', 'ORACLE', 'kufga');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_POLICY_T', 'DDL', 'ORACLE', 'kurls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_GROUP_T', 'DDL', 'ORACLE', 'kurls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_CONTEXT_T', 'DDL', 'ORACLE', 'kurls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONSTRAINT_T', 'DDL', 'ORACLE', 'kualter');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('REF_CONSTRAINT_T', 'DDL', 'ORACLE', 'kualter');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('LIBRARY_T', 'DDL', 'ORACLE', 'kulib');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PWDVFC_T', 'DDL', 'ORACLE', 'kuproc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('USER_T', 'DDL', 'ORACLE', 'kuuser');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROFILE_T', 'DDL', 'ORACLE', 'kuprofil');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SEQUENCE_T', 'DDL', 'ORACLE', 'kuseq');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLE_T', 'DDL', 'ORACLE', 'kurole');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DEFROLE_T', 'DDL', 'ORACLE', 'kudefrol');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROXY_T', 'DDL', 'ORACLE', 'kuproxy');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROGRANT_T', 'DDL', 'ORACLE', 'kurolegr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TSQUOTA_T', 'DDL', 'ORACLE', 'kutsquo');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RESOCOST_T', 'DDL', 'ORACLE', 'kurescos');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONTEXT_T', 'DDL', 'ORACLE', 'kuctx');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DIMENSION_T', 'DDL', 'ORACLE', 'kudimen');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ASSOC_T', 'DDL', 'ORACLE', 'kuassoc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('COMMENT_T', 'DDL', 'ORACLE', 'kucoment');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLST_T', 'DDL', 'ORACLE', 'kuclzm');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLUSTER_T', 'DDL', 'ORACLE', 'kuclus');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_T', 'DDL', 'ORACLE', 'kuaudit');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDITOBJ_T', 'DDL', 'ORACLE', 'kuaudobj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDITDEF_T', 'DDL', 'ORACLE', 'kuauddef');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_POLICY_T', 'DDL', 'ORACLE', 'kuaudit');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_POLICY_ENABLE_T', 'DDL', 'ORACLE', 'kuaudit');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_CONTEXT_T', 'DDL', 'ORACLE', 'kuaudit');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_POLICY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVASRC_T', 'DDL', 'ORACLE', 'kujvsrc');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUETAB_T', 'DDL', 'ORACLE', 'kuquetab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUEUES_T', 'DDL', 'ORACLE', 'kuqueues');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QTRANS_T', 'DDL', 'ORACLE', 'kuqtrans');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JOB_T', 'DDL', 'ORACLE', 'kujob');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_PLAN_T', 'DDL', 'ORACLE', 'kuplan');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_PLAN_DIRECT_T', 'DDL', 'ORACLE', 'kupdiret');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_CONSUMER_T', 'DDL', 'ORACLE', 'kuconsum');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_INIT_CONSUMER_T', 'DDL', 'ORACLE', 'kuiconsu');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PSW_HIST_T', 'DDL', 'ORACLE', 'kupswhis');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('T_STAT_T', 'DDL', 'ORACLE', 'kustat');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('I_STAT_T', 'DDL', 'ORACLE', 'kustat');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('T_USER_PREF_STAT_T', 'DDL', 'ORACLE', 'kustat2');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVARESRC_T', 'DDL', 'ORACLE', 'kujava');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVACLASS_T', 'DDL', 'ORACLE', 'kujava');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XMLSCHEMA_T', 'DDL', 'ORACLE', 'kuxmlsch');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('REFGROUP_T', 'DDL', 'ORACLE', 'kurefgrp');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('MONITOR_T', 'DDL', 'ORACLE', 'kumonitr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_BLK_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCGRANT_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCAUDIT_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJ_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJG_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJA_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCDEPOBJ_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCDEPOBJG_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCDEPOBJA_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCACTSYS_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCACTSCHEMA_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCACTINS_T', 'DDL', 'ORACLE', 'kuprocoj');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('POST_TABLE_T', 'DDL', 'ORACLE', 'kupostab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PRE_TABLE_T', 'DDL', 'ORACLE', 'kupostab');

-- for HCS objects
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ATTRIBUTE_DIM_T', 'DDL', 'ORACLE', 'kuhier');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('HIER_T', 'DDL', 'ORACLE', 'kuhier');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ANALYTIC_VIEW_T', 'DDL', 'ORACLE', 'kuhier');

-- dummy entry for TABLE_DATA, etc.: This allows us to use the DDL transform
-- when fetching heterogeneous objects. (Test only.)
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_DATA_T', 'DDL', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYSCALLOUT_T', 'DDL', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SCHEMA_CALLOUT_T', 'DDL', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INSTANCE_CALLOUT_T', 'DDL', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('MARKER_T', 'DDL', 'ORACLE', 'kuprsso');

Rem
Rem  for parsing of xml doc
Rem  (Keep these in alphabetical order)
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_FUNCTION_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PACKAGE_BODY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PACKAGE_SPEC_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PROCEDURE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ASSOC_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDITDEF_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDITOBJ_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_POLICY_ENABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_CONTEXT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLST_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLUSTER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CODE_BASE_GRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('COMMENT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONSTRAINT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONTEXT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CREATE_TABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DBLINK_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DEFROLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DIMENSION_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DIRECTORY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DOMIDXOBJNUM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DROP_TABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
rem
rem bug 6938028: Database Vault Protected Schema.
rem
rem Note: Without the following rows in the metaxsl$ table, which register
rem the stylesheet $SRCHOME/rdbms/xml/xsl/kuprsso.xsl as the template
rem for generating parse items for XMLTypes for schema objects, the
rem error when using, for example,
rem   select dbms_metadata.get_ddl('DVPS_REALM_MEMBERSHIP','realm_name')
rem     from dual;
rem would be
rem   ORA-31604: invalid NAME parameter "PARSE" for object
rem              type DVPS_REALM_MEMBERSHIP in function ADD_TRANSFORM
rem This error occured when there was no 'PARSE' transformation
rem registered for the DVPS_REALM_MEMBERSHIP type, for example.
rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_REALM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_REALM_MEMBERSHIP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_REALM_AUTHORIZATION_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_IMPORT_STAGING_REALM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_STAGING_REALM_MEMBERSHP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DISR_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_RULE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_RULE_SET_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_RULE_SET_MEMBERSHIP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_COMMAND_RULE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_COMMAND_RULE_ALTS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_ROLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_FACTOR_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_FACTOR_LINK_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_FACTOR_TYPE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_IDENTITY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_IDENTITY_MAP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OBJ_R_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OBJ_C_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OBJ_C_ALTS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_POLICY_OWNER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_DP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_TTS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_JOB_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_PROXY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_DDL_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_PREP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_DIAG_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_INDEX_FUNC_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_AUTH_MAINT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_ORADEBUG_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DVPS_DV_ACCTS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FGA_POLICY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FULL_PACKAGE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FULL_TYPE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FUNCTION_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ATTRIBUTE_DIM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('HIER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ANALYTIC_VIEW_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INC_TYPE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('IDENTITY_COLUMN_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEXTYPE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INSTANCE_CALLOUT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('I_STAT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVACLASS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVAOBJNUM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVARESRC_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVASRC_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JOB_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('LIBRARY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('LOAD_TEMPTABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('MARKER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_TABLESPACE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_ZONEMAP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OBJGRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('POST_DATA_TABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ON_USER_GRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OPERATOR_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OUTLINE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PACKAGE_BODY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PACKAGE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_BEGIN_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_BLK_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_CHECKPL_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_TSNAME_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_TSNAME_FULL_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_TSNAME_TABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_TSNAME_INDEX_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PLUGTS_TSNAME_INDEXP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('POST_TABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PRE_TABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCACTINS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCACTSCHEMA_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCACTSYS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCAUDIT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCDEPOBJA_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCDEPOBJG_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCDEPOBJ_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCEDURE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCGRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJA_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJG_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJ_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJNUM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROFILE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROXY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PSW_HIST_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PWDVFC_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QTRANS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUETAB_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUEUES_T', 'PARSE', 'ORACLE', 'kuprsso');

rem 12c project 32006: RADM
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RADM_POLICY_T', 'PARSE', 'ORACLE', 'kuradmp');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RADM_FPTM_T', 'PARSE', 'ORACLE', 'kuradmf');

insert into metaxsl$ (xmltag, transform, model, script) values
 ('REFGROUP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('REF_CONSTRAINT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RESOCOST_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_CONTEXT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_GROUP_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_POLICY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_CONSUMER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_INIT_CONSUMER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_PLAN_DIRECT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RMGR_PLAN_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROGRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLLBACK_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SCHEMA_CALLOUT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SEQUENCE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SORT_TYPES_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SORT_VIEWS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYNONYM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYSCALLOUT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYSGRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_ILM_POLICY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_DATA_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLEOBJNUM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABTYPEOBJNUM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRIGGER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRLINK_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TSQUOTA_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_BODY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('T_STAT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('T_USER_PREF_STAT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('USER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VAT_OBJNUM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_USER_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_GRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLE_GRANT_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLESET_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_SECURITY_CLASS_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_DATA_SECURITY_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ACL_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ACL_PARAM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_NAMESPACE_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEWOBJNUM_T', 'PARSE', 'ORACLE', 'kuprsso');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XMLSCHEMA_T', 'PARSE', 'ORACLE', 'kuprsso');

Rem
Rem MODIFY transform
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_FUNCTION_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PACKAGE_SPEC_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PACKAGE_BODY_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_PROCEDURE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ASSOC_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDIT_T', 'MODIFY', 'ORACLE', 'kumodusr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('AUDITOBJ_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLST_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLUSTER_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CODE_BASE_GRANT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('COMMENT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONSTRAINT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DBLINK_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DEFROLE_T', 'MODIFY', 'ORACLE', 'kumodusr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DIMENSION_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DIRECTORY_T', 'MODIFY', 'ORACLE', 'kumoddf');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FGA_POLICY_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FUNCTION_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('I_STAT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('IDENTITY_COLUMN_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INC_TYPE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEXTYPE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVACLASS_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVARESRC_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JAVASRC_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('JOB_T', 'MODIFY', 'ORACLE', 'kumodusr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('LIBRARY_T', 'MODIFY', 'ORACLE', 'kumoddf');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_ZONEMAP_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OBJGRANT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('OPERATOR_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ON_USER_GRANT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PACKAGE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PACKAGE_SPEC_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PACKAGE_BODY_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PSW_HIST_T', 'MODIFY', 'ORACLE', 'kumodusr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PRE_TABLE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCDEPOBJG_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCEDURE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROCOBJG_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PROXY_T', 'MODIFY', 'ORACLE', 'kumodusr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('PWDVFC_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUEUES_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUETAB_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ATTRIBUTE_DIM_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('HIER_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ANALYTIC_VIEW_T', 'MODIFY', 'ORACLE', 'kumodtab');
Rem
Rem 12c project 32006 RADM
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RADM_POLICY_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('REF_CONSTRAINT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('REFGROUP_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_CONTEXT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_GROUP_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_POLICY_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROGRANT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLLBACK_T', 'MODIFY', 'ORACLE', 'kumodrbs');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SEQUENCE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('STRMTABLE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYNONYM_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYSGRANT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('T_STAT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('T_USER_PREF_STAT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_T', 'MODIFY', 'ORACLE', 'kumoddf');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TSQUOTA_T', 'MODIFY', 'ORACLE', 'kumodusr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRIGGER_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_SPEC_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_BODY_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('USER_T', 'MODIFY', 'ORACLE', 'kumodusr');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XMLSCHEMA_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_USER_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLE_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ROLE_GRANT_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_SECURITY_CLASS_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_DATA_SECURITY_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ACL_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_ACL_PARAM_T', 'MODIFY', 'ORACLE', 'kumodtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('XS_NAMESPACE_T', 'MODIFY', 'ORACLE', 'kumodtab');

Rem
Rem SXML transform
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'SXML', 'ORACLE', 'kustable');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'STREAMSXML','ORACLE','kuetable');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'MODIFYSTREAMSXML', 'ORACLE', 'kuemodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('STRMTABLE_T', 'SXML', 'ORACLE', 'kustable');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'SXML', 'ORACLE', 'kusindex');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLUSTER_T', 'SXML', 'ORACLE', 'kusclus');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONTEXT_T', 'SXML', 'ORACLE', 'kusctx');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DBLINK_T', 'SXML', 'ORACLE', 'kusdblk');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FGA_POLICY_T', 'SXML', 'ORACLE', 'kusfga');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'SXML', 'ORACLE', 'kusmv');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'SXML', 'ORACLE', 'kusmvl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUEUES_T', 'SXML', 'ORACLE', 'kusque');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUETAB_T', 'SXML', 'ORACLE', 'kusqtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_POLICY_T', 'SXML', 'ORACLE', 'kusrls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_CONTEXT_T', 'SXML', 'ORACLE', 'kusrls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_GROUP_T', 'SXML', 'ORACLE', 'kusrls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLE_T', 'SXML', 'ORACLE', 'kusrole');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SEQUENCE_T', 'SXML', 'ORACLE', 'kusseq');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYNONYM_T', 'SXML', 'ORACLE', 'kussyn');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_T', 'SXML', 'ORACLE', 'kustbls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRIGGER_T', 'SXML', 'ORACLE', 'kustrig');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_T', 'SXML', 'ORACLE', 'kustype');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_SPEC_T', 'SXML', 'ORACLE', 'kustype');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_BODY_T', 'SXML', 'ORACLE', 'kustype');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('USER_T', 'SXML', 'ORACLE', 'kususer');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'SXML', 'ORACLE', 'kusview');


Rem
Rem SXML transform
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'SXMLDDL', 'ORACLE', 'kustabld');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'SXMLDDL', 'ORACLE', 'kusindxd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLUSTER_T', 'SXMLDDL', 'ORACLE', 'kusclusd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONTEXT_T', 'SXMLDDL', 'ORACLE', 'kusctxd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DBLINK_T', 'SXMLDDL', 'ORACLE', 'kusdblkd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FGA_POLICY_T', 'SXMLDDL', 'ORACLE', 'kusfgad');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'SXMLDDL', 'ORACLE', 'kusmvd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'SXMLDDL', 'ORACLE', 'kusmvld');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUEUES_T', 'SXMLDDL', 'ORACLE', 'kusqued');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUETAB_T', 'SXMLDDL', 'ORACLE', 'kusqtabd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_POLICY_T', 'SXMLDDL', 'ORACLE', 'kusrlsd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_CONTEXT_T', 'SXMLDDL', 'ORACLE', 'kusrlsd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_GROUP_T', 'SXMLDDL', 'ORACLE', 'kusrlsd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLE_T', 'SXMLDDL', 'ORACLE', 'kusroled');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SEQUENCE_T', 'SXMLDDL', 'ORACLE', 'kusseqd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYNONYM_T', 'SXMLDDL', 'ORACLE', 'kussynd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_T', 'SXMLDDL', 'ORACLE', 'kustblsd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRIGGER_T', 'SXMLDDL', 'ORACLE', 'kustrigd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_T', 'SXMLDDL', 'ORACLE', 'kustyped');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_BODY_T', 'SXMLDDL', 'ORACLE', 'kustyped');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('USER_T', 'SXMLDDL', 'ORACLE', 'kususerd');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'SXMLDDL', 'ORACLE', 'kusviewd');

Rem
Rem ALTERXML transform
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLUSTER_T', 'ALTERXML', 'ORACLE', 'kuaclus');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'ALTERXML', 'ORACLE', 'kuaindex');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'ALTERXML', 'ORACLE', 'kuamv');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'ALTERXML', 'ORACLE', 'kuamvl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLE_T', 'ALTERXML', 'ORACLE', 'kuarole');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SEQUENCE_T', 'ALTERXML', 'ORACLE', 'kuaseq');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYNONYM_T', 'ALTERXML', 'ORACLE', 'kuasyn');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'ALTERXML', 'ORACLE', 'kuatable');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_T', 'ALTERXML', 'ORACLE', 'kuatbls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_T', 'ALTERXML', 'ORACLE', 'kuatype');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRIGGER_T', 'ALTERXML', 'ORACLE', 'kuatrig');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('USER_T', 'ALTERXML', 'ORACLE', 'kuauser');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'ALTERXML', 'ORACLE', 'kuaview');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUEUES_T', 'ALTERXML', 'ORACLE', 'kuaque');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUETAB_T', 'ALTERXML', 'ORACLE', 'kuaqtab');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_GROUP_T', 'ALTERXML', 'ORACLE', 'kuarls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_POLICY_T', 'ALTERXML', 'ORACLE', 'kuarls');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_CONTEXT_T', 'ALTERXML', 'ORACLE', 'kuarls');

Rem
Rem ALTERDDL transform
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ALTER_XML', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUETAB_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('QUEUES_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CLUSTER_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('CONTEXT_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('DBLINK_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('FGA_POLICY_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_CONTEXT_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_GROUP_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('RLS_POLICY_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('ROLE_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SEQUENCE_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('SYNONYM_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLESPACE_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TYPE_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TRIGGER_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('USER_T', 'ALTERDDL', 'ORACLE', 'kuaddl');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'ALTERDDL', 'ORACLE', 'kuaddl');

Rem
Rem MODIFYSXML transform (also used for editioning_view transform)
Rem
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'MODIFYSXML', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('INDEX_T', 'EDITIONING_VIEW', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'MODIFYSXML', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_T', 'EDITIONING_VIEW', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'MODIFYSXML', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('M_VIEW_LOG_T', 'EDITIONING_VIEW', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'MODIFYSXML', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('TABLE_T', 'EDITIONING_VIEW', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'MODIFYSXML', 'ORACLE', 'kusmodtb');
insert into metaxsl$ (xmltag, transform, model, script) values
 ('VIEW_T', 'EDITIONING_VIEW', 'ORACLE', 'kusmodtb');

-- Populate metaxslparam$: This table defines all the valid transformation
-- parameters for each dictionary object type and transform the user can set
-- through the SET_TRANSFORM_PARAM method. Eg, a table's creation DDL can be
-- generated with or without storage clause, OID, constraints, constraints as
-- ALTER TABLE cmns or column constraints, etc. The stylesheets themselves
-- define these parameters and the XSL engine sets them.

-- This table also defines valid parse items for the various object types.
-- For those that correspond to an attribute in the type's UDT, the column
-- 'parse_attr' contains a path to that attribute. These paths are used to
-- directly fetch the requested parse items from the type's object view...
-- much faster than the original method of using XSL to retrieve them from
-- the already-rendered XML. This speeds up export and network imports.
-- However, the original XSL-based method of extracting parse items is still
-- used when the XML is already in hand as in file-based imports.

-- Bit usage for the metaxslparam$.properties column:
-- 0x00000001 1         additive param (can be specified more than once)
-- 0x00000002 2         remap param
-- 0x00000008 4         <unused>
-- 0x00000008 8         <unused>
-- 0x00000010 16        <unused>
-- 0x00000020 32        special processing for tablespace parse item for tables
--
-- Values for the metaxslparam$.datatype column:
-- NULL   = unspecified type, no checking done
-- 0x0001 = boolean
-- 0x0002 = text
-- 0x0003 = number
--

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','PRETTY','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','SQLTERMINATOR','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','EMIT_SCHEMA','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','EXPORT','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','OLDEXPORT','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','TRANSPORTABLE','0',0,NULL,3,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','VERSION','9999999999',0,NULL,3,0,NULL);

-- SOURCE_VERSION is always expected to be set by worker when EXPORT=1
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','SOURCE_VERSION','1000000000',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','XMLXVM_TRANSFORM_ENGINE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','COLLATION_CLAUSE','"NON_DEFAULT"',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','ENABLE_COLLATION','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','SHARING_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','CON_TYPE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','SEGMENT_CREATION','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','DISABLE_ARCHIVE_LOGGING','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','RESTORE_ARCHIVE_LOGGING','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','TABLE_COMPRESSION','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','TABLE_COMPRESSION_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','INMEMORY','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','INMEMORY_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','PCTSPACE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','NULL_CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','REF_CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','CONSTRAINTS_AS_ALTER','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','OID','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','FORCE_UNIQUE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','LOB_SEGNAME','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','SIZE_BYTE_KEYWORD','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','OPERATION_TYPE','"CREATE"',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PARTITION','OPERATION_TYPE','"CREATE"',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','EXT_TABLE_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','EXT_TABLE_SCHEMA','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','EXT_TABLE_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','TARGET_TABLE_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','TARGET_TABLE_SCHEMA','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
('ORACLE','DDL','TABLE','XMLTYPE_STREAM_FORMAT','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','SCN','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','PARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','SUBPARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','DATAOBJ_NUM','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','NETWORK_LINK','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','NETWORK_SCHEMA','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','NETWORK_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','QUERY','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','QUERY_WHERE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','QUERY_ORDER_BY','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','SAMPLE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','DROP','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','TRANSPORTABLE_CLASSIC','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','ENCRYPTION_PASSWORD','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','REMAP_COLUMN_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','DML_ERROR_LOGGING_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','USE_DML_APPEND_HINT','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','PARALLEL_HINT','""',0,NULL,3,1,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','USE_DATA_VALIDATE_HINT','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','CONVERT_TSTZ_COLS','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','FORCE_VIRTUAL_COLUMNS','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','LOB_STORAGE','"NO_CHANGE"',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','WITH_FUNCTION','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','WITH_FUNCTION_QUERY','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','AQ_QUEUE_TABLE','LOB_STORAGE','"NO_CHANGE"',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','WILL_MAKE_TBS_RW','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','OMIT_COL_DATATYPE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','OMIT_AQ_CLAUSE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','MATERIALIZED_ZONEMAP','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','INCLUDE_PARTITIONS','',0,NULL,2,NULL,NULL);
-- for logical standby
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','INSERT','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','DBLINK','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','PARTITIONING','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE','INDEX_BY_NAME',NULL,0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW','START_WITH','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW','STORAGE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW_LOG','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW_LOG','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW_LOG','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_ZONEMAP','START_WITH','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_ZONEMAP','STORAGE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_ZONEMAP','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW','INMEMORY','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MATERIALIZED_VIEW','INMEMORY_CLAUSE','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','PARALLEL','-1',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','DISABLE_ARCHIVE_LOGGING','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','RESTORE_ARCHIVE_LOGGING','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','RESET_PARALLEL','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','PCTSPACE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','PARTITIONING','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','PARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','SUBPARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','BASE_PARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','BASE_SUBPARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','INDEX_COMPRESSION_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX','INCLUDE_PARTITIONS','',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','PCTSPACE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','PARTITIONING','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','ONLINE_REDEF',NULL,0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','INDEX_BY_NAME',NULL,0,NULL,1,NULL,NULL);
--
-- INDEX_BY_NAME is a no-op for REF_CONSTRAINT, but we register it
-- here so that dbms_redefinition can use INDEX_BY_NAME for both
-- CONSTRAINT and REF_CONSTRAINT
--
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','REF_CONSTRAINT','INDEX_BY_NAME',NULL,0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CLUSTER','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CLUSTER','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CLUSTER','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CLUSTER','PCTSPACE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ROLLBACK_SEGMENT','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ROLLBACK_SEGMENT','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ROLLBACK_SEGMENT','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ROLLBACK_SEGMENT','PCTSPACE','""',0,NULL,3,0,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TYPE','SPECIFICATION','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TYPE','BODY','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TYPE','OID','0',0,NULL,1,NULL,NULL);

-- Keep in-sync with kucommon.xsl's default.  The expected values
-- for this parameter are 0 (FALSE) or 1 (TRUE).  We set the 
-- default to something different, 3, so we know if the parameter
-- was passed in or not.  See usage in kusource.xsl.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TYPE','PRESERVE_TYPE_EVOLUTION','3',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INC_TYPE','OID','0',0,NULL,1,NULL,NULL);
rem insert into metaxslparam$ (model, transform, type, param,
rem                            default_val, properties, parse_attr,
rem                            datatype, lower_bound, upper_bound) values
rem    in the following line (should it ever be restored) the datatype,
rem      lower_bound, and upper_bound should be checked.
rem ('ORACLE','DDL','TYPE','TIMESTAMP','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PACKAGE','SPECIFICATION','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PACKAGE','BODY','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACE','REUSE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACE','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACE','PCTSPACE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACE','INMEMORY','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACEE','INMEMORY_CLAUSE','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','VIEW','FORCE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','VIEW','CONSTRAINTS','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','OUTLINE','INSERT','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ROLE','REVOKE_FROM','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TRIGGER','REGEN_DEFN','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TRIGGER','REMAP_TRG_SCHEMA','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TYPE','REGEN_DEFN','0',0,NULL,1,NULL,NULL);


insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','XMLSCHEMA','GEN_TYPES','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','XMLSCHEMA','GEN_BEAN','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','XMLSCHEMA','GEN_TABLES','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','XMLSCHEMA','FORCE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','EXP_XMLSCHEMA','GEN_TYPES','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','EXP_XMLSCHEMA','GEN_BEAN','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','EXP_XMLSCHEMA','GEN_TABLES','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','EXP_XMLSCHEMA','FORCE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','JOB','DBA','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','REFRESH_GROUP','DBA','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCACT_SYSTEM','CONNECT_PROCEDURE','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCOBJ_GRANT','CONNECT_PROCEDURE','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCDEPOBJ_GRANT','CONNECT_PROCEDURE','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCACT_SYSTEM','CURRENT_SCHEMA','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCOBJ_GRANT','CURRENT_SCHEMA','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCDEPOBJ_GRANT','CURRENT_SCHEMA','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCACT_SYSTEM','SQLFILE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCOBJ_GRANT','SQLFILE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCDEPOBJ_GRANT','SQLFILE','0',0,NULL,1,NULL,NULL);

Rem Dummy entries for object types without transform params.
Rem All object types need at least one DDL transform param.

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ALTER_FUNCTION','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ALTER_PACKAGE_BODY','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ALTER_PACKAGE_SPEC','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ALTER_PROCEDURE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','OPERATOR','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEXTYPE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TRIGGER','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCEDURE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','FUNCTION','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','SYSTEM_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','OBJECT_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ON_USER_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CODE_BASE_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DIRECTORY','DUMMY','0',0,NULL,1,NULL,NULL);
rem
rem 12c project 32006: RADM. Add a dummy transformation parameter, as no
rem transform parameters are supported for the RADM object types.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
  ('ORACLE','DDL','RADM_POLICY','DUMMY',
   '0',0,NULL,
   1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
  ('ORACLE','DDL','RADM_FPTM','DUMMY',
   '0',0,NULL,
    1,NULL,NULL);
rem
rem bug 6938028: Database Vault Protected Schema. Add a "parse item"
rem corresponding to the entire object type, so that the entire type
rem can be "filtered" out, e.g. if you only want to import objects of
rem type "tablespace" then you would add "INCLUDE=TABLESPACE" parameter
rem when running impdp. For each of the Database Vault types, DVPS_REALM
rem DVPS_REALM_MEMBERSHIP and DVPS_IMPORT_STAGING_REALM, we need to define
rem such a "parse item", otherwise impdp will not attempt to import
rem them from the dump file.
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_REALM','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_REALM''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_REALM_MEMBERSHIP','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_REALM_MEMBERSHIP''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_REALM_AUTHORIZATION','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_REALM_AUTHORIZATION''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_IMPORT_STAGING_REALM','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_IMPORT_STAGING_REALM''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_STAGING_REALM_MEMBERSHIP','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_STAGING_REALM_MEMBERSHIP''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DROP_IMPORT_STAGING_REALM','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DROP_IMPORT_STAGING_REALM''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_RULE','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_RULE''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_RULE_SET','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_RULE_SET''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_RULE_SET_MEMBERSHIP','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_RULE_SET_MEMBERSHIP''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_COMMAND_RULE','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_COMMAND_RULE''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_COMMAND_RULE_ALTS','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_COMMAND_RULE_ALTS''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_ROLE','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_ROLE''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_FACTOR','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_FACTOR''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_FACTOR_LINK','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_FACTOR_LINK''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_FACTOR_TYPE','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_FACTOR_TYPE''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_IDENTITY','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_IDENTITY''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_IDENTITY_MAP','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_IDENTITY_MAP''',
   NULL,NULL,NULL);
REM Project 46812: DV policy support
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_POLICY','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_POLICY''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_POLICY_OBJ_R','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_POLICY_OBJ_R''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_POLICY_OBJ_C','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_POLICY_OBJ_C''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_POLICY_OBJ_C_ALTS','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_POLICY_OBJ_C_ALTS''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_POLICY_OWNER','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_POLICY_OWNER''',
   NULL,NULL,NULL);
-- Bug 21299533: support for Database Vault Authorization
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_DP','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_DP''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_TTS','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_TTS''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_JOB','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_JOB''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_PROXY','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_PROXY''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_DDL','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_DDL''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_PREP','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_PREP''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_DIAG','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_DIAG''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_INDEX_FUNC','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_INDEX_FUNC''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_AUTH_MAINT','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_AUTH_MAINT''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_ORADEBUG','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_ORADEBUG''',
   NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                            default_val, properties, parse_attr,
                            datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','DVPS_DV_ACCTS','PRS_OBJECT_TYPE',
   '0', 0, '''DVPS_DV_ACCTS''',
   NULL,NULL,NULL);
rem
rem bug 6938028: Database Vault Protected Schema. Add a dummy transform
rem parameter, as no transform parameters are supported for the
rem DVPS_REALM, DVPS_REALM_MEMBERSHIP, DVPS_IMPORT_STAGING_REALM
rem and DVPS_STAGING_REALM_MEMBERSHIP object types.
rem
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_REALM','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_REALM_MEMBERSHIP','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_REALM_AUTHORIZATION','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_IMPORT_STAGING_REALM','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_STAGING_REALM_MEMBERSHIP','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DROP_IMPORT_STAGING_REALM','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_RULE','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_RULE_SET','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_RULE_SET_MEMBERSHIP','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_COMMAND_RULE','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_COMMAND_RULE_ALTS','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_ROLE','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_FACTOR','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_FACTOR_LINK','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_FACTOR_TYPE','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_IDENTITY','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_IDENTITY_MAP','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_POLICY','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_POLICY_OBJ_R','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_POLICY_OBJ_C','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_POLICY_OBJ_C_ALTS','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_POLICY_OWNER','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_DP','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_TTS','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_JOB','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_PROXY','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_DDL','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_PREP','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_DIAG','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_INDEX_FUNC','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_AUTH_MAINT','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_ORADEBUG','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DVPS_DV_ACCTS','DUMMY',
  '0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACE_ILM_POLICY','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DB_LINK','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TRUSTED_DB_LINK','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','FGA_POLICY','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RLS_POLICY','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RLS_GROUP','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RLS_CONTEXT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONSTRAINT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','REF_CONSTRAINT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','LIBRARY','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','USER','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROFILE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DEFAULT_ROLE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROXY','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RESOURCE_COST','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ROLE_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','SEQUENCE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLESPACE_QUOTA','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CONTEXT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DIMENSION','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','ASSOCIATION','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','COMMENT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PASSWORD_VERIFY_FUNCTION','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','CLUSTER','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','AUDIT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','AUDIT_OBJ','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','AUDIT_DEFAULT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','DOMIDX_OBJNUM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','JAVA_OBJNUM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','JAVA_SOURCE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','AQ_QUEUE_TABLE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','AQ_QUEUE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','AQ_TRANSFORM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','JOB','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RMGR_PLAN','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RMGR_PLAN_DIRECTIVE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RMGR_CONSUMER_GROUP','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','RMGR_INITIAL_CONSUMER_GROUP','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PASSWORD_HISTORY','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE_STATISTICS','STAT_SCHEMA',NULL,0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE_STATISTICS','STAT_TABLE',NULL,0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE_STATISTICS','LOCK_STATS','0', 0, NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE_STATISTICS','DUMMY','0', 0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','USER_PREF_STATISTICS','STAT_SCHEMA',NULL,0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','USER_PREF_STATISTICS','STAT_TABLE',NULL,0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','USER_PREF_STATISTICS','DUMMY','0', 0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX_STATISTICS','STAT_SCHEMA',NULL,0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX_STATISTICS','STAT_TABLE',NULL,0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','INDEX_STATISTICS','DUMMY','0', 0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','JAVA_RESOURCE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','JAVA_CLASS','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','REFRESH_GROUP','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','MONITORING','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PLUGTS_BLK','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','END_PLUGTS_BLK','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROC_SYSTEM_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROC_AUDIT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCOBJ','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCOBJ_OBJNUM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCOBJ_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCOBJ_AUDIT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCDEPOBJ','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCDEPOBJ_GRANT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCDEPOBJ_AUDIT','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCACT_SYSTEM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCACT_SCHEMA','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PROCACT_INSTANCE','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','PRE_TABLE_ACTION','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','POST_TABLE_ACTION','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','VIEW_OBJNUM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABLE_OBJNUM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','SECONDARY_TABLE_OBJNUM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','TABTYPE_OBJNUM','DUMMY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','*','LRG','0',0,NULL,1,NULL,NULL);

-- transform parameters for STREAMSXML
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','*','PRETTY','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','*','SQLTERMINATOR','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','*','EMIT_SCHEMA','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','*','EXPORT','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','*','OLDEXPORT','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','*','TRANSPORTABLE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','*','VERSION','9999999999',0,NULL,3,0,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','SEGMENT_CREATION','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','TABLE_COMPRESSION','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','PCTSPACE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','REF_CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','CONSTRAINTS_AS_ALTER','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','OID','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','SIZE_BYTE_KEYWORD','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','OPERATION_TYPE','"CREATE"',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','EXT_TABLE_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','EXT_TABLE_SCHEMA','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','EXT_TABLE_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','TARGET_TABLE_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','TARGET_TABLE_SCHEMA','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
('ORACLE','STREAMSXML','TABLE','XMLTYPE_STREAM_FORMAT','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','SCN','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','PARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','SUBPARTITION_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','DATAOBJ_NUM','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','NETWORK_LINK','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','NETWORK_SCHEMA','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','NETWORK_NAME','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','QUERY','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','QUERY_WHERE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','QUERY_ORDER_BY','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','SAMPLE','""',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','DROP','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','TRANSPORTABLE_CLASSIC','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','ENCRYPTION_PASSWORD','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','REMAP_COLUMN_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','DML_ERROR_LOGGING_CLAUSE','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','USE_DML_APPEND_HINT','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','PARALLEL_HINT','""',0,NULL,3,1,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','USE_DATA_VALIDATE_HINT','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','CONVERT_TSTZ_COLS','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','INSERT','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','DBLINK','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','PARTITIONING','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','INSERTNULLS','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','WITH_FUNCTION','""',0,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','STREAMSXML','TABLE','WITH_FUNCTION_QUERY','""',0,NULL,2,NULL,NULL);

-- parse items for ALTERXML
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_XPATH','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_ALTERABLE','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_CLAUSE_TYPE','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_COLUMN_ATTRIBUTE','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_CONSTRAINT_TYPE','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_CONSTRAINT_STATE','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_PARTITION_TYPE','0',0,NULL,NULL,NULL,NULL);

-- parse items for XML and DDL
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_ROW','0',0,NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_DDL','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_DELIM','"\{]`"',0,NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','*','PRS_VERB','0',0,NULL,NULL,NULL,NULL);

-- Items for ALTER_FUNCTION
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_OBJECT_TYPE','0',0,
    '''ALTER_FUNCTION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_FUNCTION','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.SCHEMA_OBJ.TYPE_NAME',NULL,NULL,NULL);


-- Items for ALTER_PACKAGE_BODY
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_OBJECT_TYPE','0',0,
    '''ALTER_PACKAGE_BODY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_BODY','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.SCHEMA_OBJ.TYPE_NAME',NULL,NULL,NULL);


-- Items for ALTER_PACKAGE_SPEC
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_OBJECT_TYPE','0',0,
    '''ALTER_PACKAGE_SPEC''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PACKAGE_SPEC','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.SCHEMA_OBJ.TYPE_NAME',NULL,NULL,NULL);


-- Items for ALTER_PROCEDURE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_OBJECT_TYPE','0',0,
    '''ALTER_PROCEDURE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ALTER_PROCEDURE','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.SCHEMA_OBJ.TYPE_NAME',NULL,NULL,NULL);



-- Items for AUDIT_DEFAULT
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_DEFAULT','PRS_OBJECT_TYPE','0',0,
    '''AUDIT_DEFAULT''',NULL,NULL,NULL);

-- Items for CLUSTER
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTER','PRS_OBJECT_TYPE','0',0,
    '''CLUSTER''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTER','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTER','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTER','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTER','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTER','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for POST_DATA_TABLE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_DATA_TABLE','PRS_OBJECT_TYPE','0',0,
    '''POST_DATA_TABLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_DATA_TABLE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_DATA_TABLE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_DATA_TABLE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_DATA_TABLE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_DATA_TABLE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for PROCEDURE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCEDURE','PRS_OBJECT_TYPE','0',0,
    '''PROCEDURE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCEDURE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCEDURE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCEDURE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCEDURE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCEDURE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for FUNCTION
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FUNCTION','PRS_OBJECT_TYPE','0',0,
    '''FUNCTION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FUNCTION','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FUNCTION','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FUNCTION','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FUNCTION','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FUNCTION','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for SEQUENCE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SEQUENCE','PRS_OBJECT_TYPE','0',0,
    '''SEQUENCE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SEQUENCE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SEQUENCE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SEQUENCE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SEQUENCE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SEQUENCE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for DEPTABLE_OBJNUM, MV_DEPTBL_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MV_DEPTBL_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DEPTABLE_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DEPTABLE_OBJNUM','PRS_OBJNUM_NAME','0',0,
    'KU$.TABLE_TYPE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','NTABLE_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','NTABLE_OBJNUM','PRS_OBJNUM_NAME','0',0,
    'KU$.TABLE_TYPE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XDB_NTABLE_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPTION_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPTION_OBJNUM','PRS_OBJNUM_NAME','0',0,
    'KU$.TABLE_TYPE',NULL,NULL,NULL);

-- Items for DOMIDX_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DOMIDX_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);

-- Items for VIEW_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','VIEW_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);

-- Items for VIEW
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','VIEW','PRS_OBJECT_TYPE','0',0,
    '''VIEW''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','VIEW','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','VIEW','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','VIEW','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','VIEW','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','VIEW','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for SORT_VIEWS
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SORT_VIEWS','PRS_OBJNUM','0',0,
    'KU$.VIEWOBJNO',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SORT_VIEWS','PRS_DEPOBJNUM','0',0,
    'KU$.DOBJNO',NULL,NULL,NULL);
-- Items for PROCACT_SYS_PKG
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SYS_PKG','PRS_SCHEMA','0',0,
    'KU$.PSCHEMA',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SYS_PKG','PRS_NAME','0',0,
    'KU$.PNAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SYS_PKG','PRS_LEVEL','0',0,
    'KU$.PLEVEL',NULL,NULL,NULL);

-- Items for PROCACT_SCHEMA_PKG
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SCHEMA_PKG','PRS_SCHEMA','0',0,
    'KU$.PSCHEMA',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SCHEMA_PKG','PRS_NAME','0',0,
    'KU$.PNAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SCHEMA_PKG','PRS_LEVEL','0',0,
    'KU$.PLEVEL',NULL,NULL,NULL);

-- Items for DIMENSION
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIMENSION','PRS_OBJECT_TYPE','0',0,
    '''DIMENSION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIMENSION','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIMENSION','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIMENSION','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIMENSION','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIMENSION','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for INDEXTYPE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEXTYPE','PRS_OBJECT_TYPE','0',0,
    '''INDEXTYPE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEXTYPE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEXTYPE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEXTYPE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEXTYPE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEXTYPE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for JAVA_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);

-- Items for JAVA_SOURCE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_SOURCE','PRS_OBJECT_TYPE','0',0,
    '''JAVA_SOURCE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_SOURCE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_SOURCE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_SOURCE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_SOURCE','PRS_LONGNAME','0',0,
    'KU$.LONG_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_SOURCE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for JAVA_CLASS
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_CLASS','PRS_OBJECT_TYPE','0',0,
    '''JAVA_CLASS''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_CLASS','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_CLASS','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_CLASS','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_CLASS','PRS_LONGNAME','0',0,
    'KU$.LONG_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_CLASS','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for JAVA_RESOURCE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_RESOURCE','PRS_OBJECT_TYPE','0',0,
    '''JAVA_RESOURCE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_RESOURCE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_RESOURCE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_RESOURCE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_RESOURCE','PRS_LONGNAME','0',0,
    'KU$.LONG_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JAVA_RESOURCE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for OPERATOR
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPERATOR','PRS_OBJECT_TYPE','0',0,
    '''OPERATOR''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPERATOR','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPERATOR','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPERATOR','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPERATOR','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OPERATOR','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for LIBRARY
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','LIBRARY','PRS_OBJECT_TYPE','0',0,
    '''LIBRARY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','LIBRARY','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','LIBRARY','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','LIBRARY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','LIBRARY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','LIBRARY','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for MATERIALIZED_VIEW
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW','PRS_OBJECT_TYPE','0',0,
    '''MATERIALIZED_VIEW''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW','PRS_OBJNUM','0',0,
    'KU$.MVIEW_TAB.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW','PRS_SCHEMA','0',0,
    'KU$.SOWNER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW','PRS_NAME','0',0,
    'KU$.VNAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW','PRS_LONGNAME','0',0,
    'KU$.VNAME',NULL,NULL,NULL);

-- Items for MATERIALIZED_VIEW_LOG
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW_LOG','PRS_OBJECT_TYPE','0',0,
    '''MATERIALIZED_VIEW_LOG''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW_LOG','PRS_SCHEMA','0',0,
    'KU$.MVIEWLOG.MOWNER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW_LOG','PRS_NAME','0',0,
    'KU$.MVIEWLOG.LOG',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW_LOG','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.MVIEWLOG.MOWNER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW_LOG','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.MVIEWLOG.MASTER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_VIEW_LOG','PRS_BASE_OBJECT_TYPE','0',0,
    '''TABLE''',NULL,NULL,NULL);

-- Items for MATERIALIZED_ZONEMAP
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_ZONEMAP','PRS_OBJECT_TYPE','0',0,
    '''MATERIALIZED_ZONEMAP''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_ZONEMAP','PRS_OBJNUM','0',0,
    'KU$.MVIEW_TAB.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_ZONEMAP','PRS_SCHEMA','0',0,
    'KU$.SOWNER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_ZONEMAP','PRS_NAME','0',0,
    'KU$.VNAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MATERIALIZED_ZONEMAP','PRS_LONGNAME','0',0,
    'KU$.VNAME',NULL,NULL,NULL);

-- Items for PACKAGE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE','PRS_OBJECT_TYPE','0',0,
    '''PACKAGE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for PACKAGE_SPEC
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_SPEC','PRS_OBJECT_TYPE','0',0,
    '''PACKAGE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_SPEC','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_SPEC','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_SPEC','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_SPEC','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_SPEC','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);


-- Items for PACKAGE_BODY (and EXP_PACKAGE_BODY)
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_BODY','PRS_OBJECT_TYPE','0',0,
    '''PACKAGE_BODY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_BODY','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_BODY','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_BODY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_BODY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_BODY','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_PACKAGE_BODY','PRS_OBJECT_TYPE','0',0,
    '''PACKAGE_BODY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_PACKAGE_BODY','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_PACKAGE_BODY','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_PACKAGE_BODY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_PACKAGE_BODY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_PACKAGE_BODY','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for TYPE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_OBJECT_TYPE','0',0,
    '''TYPE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for SORT_TYPES
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SORT_TYPES','PRS_OBJNUM','0',0,
    'KU$.TYPEOBJNO',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SORT_TYPES','PRS_DEPOBJNUM','0',0,
    'KU$.DOBJNO',NULL,NULL,NULL);

-- Items for INC_TYPE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INC_TYPE','PRS_OBJECT_TYPE','0',0,
    '''INC_TYPE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INC_TYPE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INC_TYPE','PRS_SCHEMA','0',0,
    'KU$.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INC_TYPE','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INC_TYPE','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);

-- Items for TYPE_SPEC
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_SPEC','PRS_OBJECT_TYPE','0',0,
    '''TYPE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_SPEC','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_SPEC','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_SPEC','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_SPEC','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_SPEC','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for TYPE_BODY (and EXP_TYPE_BODY)
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_BODY','PRS_OBJECT_TYPE','0',0,
    '''TYPE_BODY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_BODY','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_BODY','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_BODY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_BODY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_BODY','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_TYPE_BODY','PRS_OBJECT_TYPE','0',0,
    '''TYPE_BODY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_TYPE_BODY','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_TYPE_BODY','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_TYPE_BODY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_TYPE_BODY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_TYPE_BODY','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for SYNONYM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYNONYM','PRS_OBJECT_TYPE','0',0,
    '''SYNONYM''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYNONYM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYNONYM','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYNONYM','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYNONYM','PRS_LONGNAME','0',0,
    'KU$.SYN_LONG_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYNONYM','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Items for SYSTEM_GRANT
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYSTEM_GRANT','PRS_GRANTOR','0',0,
    '''SYSTEM''',NULL,NULL,NULL);
-- Items for IDENTITY_COLUMN
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','IDENTITY_COLUMN','PRS_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','IDENTITY_COLUMN','PRS_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','IDENTITY_COLUMN','PRS_OBJECT_TYPE','0',0,
    '''IDENTITY_COLUMN''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','IDENTITY_COLUMN','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','IDENTITY_COLUMN','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','IDENTITY_COLUMN','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
-- Items for TABLE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_OBJECT_TYPE','0',0,
    '''TABLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_PROPERTY','0',0,
    'KU$.PROPERTY',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_HAKAN','0',0,
    'KU$.SPARE1',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_HAS_XMLSCHEMA_COLS','0',0,
    'KU$.XMLSCHEMACOLS',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_LONG_POSITION','0',0, NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_BIND_PATTERN','0',0, NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_ALT_CONNECT_TYPE','0',0, NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_TYPE_ALTER_TYPE_CNT','0',0, NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE','PRS_LENGTH_SEMANTICS','0',0, NULL,NULL,NULL,NULL);

-- NOTE: Tablespace has some special handling for tables: If it's a non-part
-- table, the attribute to fetch is TS_NAME. If partitioned and *not* IOT,
--  it's part_obj.partobj.defts_name. If partitioned IOT,
--  it's part_obj.tabpartobj.defts_name.
-- The problem is that these don't exist in all
-- table types, so you can't do a decode at runtime on table's properties to
-- pick which one... compile-time throws an error. So, parse_attr has all 3
--  values concat. together and property=32 (std. partitioning value) is an
-- indicator to the query build code to pick which one based on the view's
-- flags which indicate among other things if the view supports partitioned obj
-- and IOTs. Ugly, but you do what you have to do.

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_TABLESPACE','0',32,
    'KU$.TS_NAMEKU$.PART_OBJ.PARTOBJ.DEFTS_NAMEKU$.PART_OBJ.TABPARTOBJ.DEFTS_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_NESTED_COLUMNS','0',0,
    'decode(bitand(KU$.PROPERTY,4),0,''N'',''Y'')',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_REFPAR_LEVEL','0',0,
    'KU$.REFPAR_LEVEL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_ROW_LEVEL_SECURITY','0',0,
    'decode(bitand(KU$.FLAGS,2048),0,''N'',''Y'')',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_SECONDARY','0',0,
    'decode(bitand(KU$.SCHEMA_OBJ.FLAGS,16),0,''N'',''Y'')',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_PARENT_OBJECT_SCHEMA','0',0,
    'KU$.PARENT_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_PARENT_OBJECT_NAME','0',0,
    'KU$.PARENT_OBJ.NAME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_ANC_OBJECT_SCHEMA','0',0,
    'KU$.ANC_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_ANC_OBJECT_NAME','0',0,
    'KU$.ANC_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_ANC_OBJECT_TYPE','0',0,
    'KU$.ANC_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_TRIGFLAG','0',0, 'KU$.TRIGFLAG',NULL,NULL,NULL);
--
-- When exporting tables from post-V12 to pre-V12 set this parse item to see
-- if table metadata must be modified.
--
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_SEQ_IN_DEFAULT','0',0,
 '(SELECT T.OBJ_NUM FROM SYS.KU$_SEQ_IN_DEFAULT_VIEW T ' ||
  'WHERE T.OBJ_NUM=KU$.OBJ_NUM)',
  NULL,NULL,NULL);
--
-- This parse item is only implemented in XSL, not available with fetch
--
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_HAS_VIRTUAL_COLUMNS','0',0,
    'NULL',NULL,NULL,NULL);

-- Items for MARKER
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MARKER','PRS_MARKER','0',0, 'KU$.MARKER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','MARKER','PRS_OBJECT_TYPE','0',0,
    '''MARKER''',NULL,NULL,NULL);

-- Items for TABLE_DATA
------------------------------------------------
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_XMLTYPE_FMTS','0',0,
    'KU$.XMLTYPE_FMTS',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_REFPAR_LEVEL','0',0,
    'KU$.REFPAR_LEVEL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_OBJECT_TYPE','0',0,
    '''TABLE_DATA''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_TABLE_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_BASE_OBJECT_TYPE','0',0,
    '''TABLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_TABLESPACE','0',0,
    'KU$.TS_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_BYTES_ALLOCATED','0',0,
    'to_char(KU$.BYTES_ALLOC)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_ET_PARALLEL','0',0,
    'to_char(KU$.ET_PARALLEL)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_UNLOAD_METHOD','0',0,
    'to_char(KU$.UNLOAD_METHOD)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_TRIGFLAG','0',0, 'KU$.TRIGFLAG',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_CREATION_TIME','0',0,
    'KU$.SCHEMA_OBJ.CTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_HAS_TSTZ_COLS','0',0,
    'KU$.TSTZ_COLS',NULL,NULL,NULL);
-- the NO_TABLE_LOCK parse item is only supported as a convert time parse item - so 
--  the parse_attr is set to 'NULL'.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_NO_TABLE_LOCK','0',0,
    'NULL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
  ('ORACLE','PARSE','TABLE','PRS_READ_ONLY_TABLE','0',0,'NULL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_HIERARCY_ENABLE','0',0,
  'KU$.XMLHIERARCHY',NULL,NULL,NULL);
-- OPTION_TAG parse item - to allow datapump to treat all objects
-- for a particular option tag as a unit for error handling. This information
-- is only returned as a parse item, which should only be specified for options
-- object paths (avoiding both overhead and viewaccess issues).
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_OPTION_TAG','0',0,
  '(select unique tag from sys.ku$_option_objnum_view opt where '||
   '(opt.schema_obj.owner_name=KU$.SCHEMA_OBJ.OWNER_NAME and '||
    'opt.schema_obj.name = KU$.SCHEMA_OBJ.NAME and '||
    'opt.tgt_type=2) or'||
   '(opt.schema_obj.owner_name=KU$.SCHEMA_OBJ.OWNER_NAME and '||
    'opt.schema_obj.name||''_TBL'' = KU$.SCHEMA_OBJ.NAME and '||
    'opt.tgt_type=4) )'
  ,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_OPTION_TAG','0',0,
  '(select unique tag from sys.ku$_option_objnum_view opt where '||
   '(opt.schema_obj.owner_name=KU$.SCHEMA_OBJ.OWNER_NAME and '||
    'opt.schema_obj.name = KU$.SCHEMA_OBJ.NAME and '||
    'opt.tgt_type=2) or'||
   '(opt.schema_obj.owner_name=KU$.SCHEMA_OBJ.OWNER_NAME and '||
    'opt.schema_obj.name||''_TBL'' = KU$.SCHEMA_OBJ.NAME and '||
    'opt.tgt_type=4) )'
  ,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TYPE_SPEC','PRS_OPTION_TAG','0',0,
  'case when KU$.SCHEMA_OBJ.OWNER_NAME=''XDB'' then ''XDB_REPOSITORY'' else NULL end'
  ,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCEDURE','PRS_OPTION_TAG','0',0,
  '(select unique tag from sys.ku$_option_objnum_view opt where '||
   'opt.schema_obj.owner_name=KU$.SCHEMA_OBJ.OWNER_NAME and '||
   'opt.schema_obj.name = KU$.SCHEMA_OBJ.NAME and '||
   'opt.tgt_type=KU$.SCHEMA_OBJ.TYPE_NUM)'
  ,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PACKAGE_SPEC','PRS_OPTION_TAG','0',0,
  '(select unique tag from sys.ku$_option_objnum_view opt where '||
   'opt.schema_obj.owner_name=KU$.SCHEMA_OBJ.OWNER_NAME and '||
   'opt.schema_obj.name = KU$.SCHEMA_OBJ.NAME and '||
   'opt.tgt_type=KU$.SCHEMA_OBJ.TYPE_NUM)'
  ,NULL,NULL,NULL);

-- If type is a table (2), then
--   'nested_partition table' or 'nested table' or 'table' based on property...
-- ACTUALLY - IT LOOKS LIKE A NESTED PARTITIONED TABLE WILL HAVE A TYPE OF 19
-- WHICH IS PARTITION, SO THE DECODE REALLY SHOULD BE ON TYPE =19.  IF
-- PROPERTY IS 8224, THEN NESTED PARTITION, OTHERWISE PARTITION.
-- otherwise, 'partition' (type# 19 = table partition; 20 = index partition
-- (for IOTs)) or 'subpartition'
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_TYPE','0',0,
  'decode(KU$.SCHEMA_OBJ.TYPE_NUM,' ||
  '2, decode(bitand(KU$.PROPERTY,8224),8224,''NESTED PARTITION'',' ||
                                      '8192,''NESTED TABLE'',' ||
                                      '''TABLE''),' ||
  '19, decode(bitand(KU$.PROPERTY,8224),8224,''NESTED PARTITION'',' ||
                                      '''PARTITION''),' ||
  '20,''PARTITION'',''SUBPARTITION'')',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_PROPERTY','0',0, 'KU$.PROPERTY',NULL,NULL,
   NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_PARTITION_NAME','0',0,
    'KU$.PART_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_DATAOBJ_NUM','0',0,
    'KU$.DATAOBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_SYSTEM_GENERATED','0',0,
    'decode(bitand(KU$.SCHEMA_OBJ.FLAGS,4),4,''Y'',''N'')',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_READ_ONLY','0',0,
    'KU$.READ_ONLY',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_HAS_XMLSCHEMA_COLS','0',0,
    'KU$.XMLSCHEMACOLS',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_HAS_LONG_COL','0',0,
    'KU$.LONGCOL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_HAS_NFT_VARRAY','0',0,
    'KU$.NFT_VARRAY',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_HAS_NONSCOPED_REF','0',0,
    'KU$.NONSCOPED_REF',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_HAS_TSTZ_COLS','0',0,
    'KU$.TSTZ_COLS',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_HAS_FGAC','0',0, 'KU$.FGAC',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_OBJ_FLAGS','0',0, 'KU$.SCHEMA_OBJ.FLAGS',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_PARTTYPE','0',0, 'KU$.PARTTYPE',NULL,NULL,NULL);
--
-- The next three are used in VAT processing and are not retrieved via fetch.
-- (hence, parse_attr=NULL); they're retrieved from the MDAPI's internal VAT 
-- list.
--
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_TEMPLATE_TABLE','0',0,
    'NULL',NULL,NULL,NULL);
--
-- These two are used only for RDBMS-internal option processing for
-- versioned callout support. They describe the real view to query as a proxy
-- for [alt_schema].alt_name
--
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_PROXY_VIEW',NULL,0,
    'NULL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_DATA','PRS_PROXY_SCHEMA',NULL,0,
    'NULL',NULL,NULL,NULL);

-- Items for TABLE_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_OBJNUM','PRS_OBJNUM_NAME','0',0,
    'KU$.TABLE_TYPE',NULL,NULL,NULL);

-- Items for SECONDARY_TABLE_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SECONDARY_TABLE_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SECONDARY_TABLE_OBJNUM','PRS_OBJNUM_NAME','0',0,
    'KU$.TABLE_TYPE',NULL,NULL,NULL);

-- Items for TABTYPE_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABTYPE_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.TYPEOBJNO',NULL,NULL,NULL);

-- CODE_BASE_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CODE_BASE_GRANT','PRS_OBJECT_TYPE','0',0,
    '''CODE_BASE_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CODE_BASE_GRANT','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CODE_BASE_GRANT','PRS_NAME','0',0,
    'KU$.ROLE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CODE_BASE_GRANT','PRS_GRANTOR','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);

-- DIRECTORY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIRECTORY','PRS_OBJECT_TYPE','0',0,
    '''DIRECTORY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIRECTORY','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIRECTORY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIRECTORY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DIRECTORY','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- ROLE_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLE_GRANT','PRS_OBJECT_TYPE','0',0,
    '''ROLE_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLE_GRANT','PRS_GRANTOR','0',0,
    '''SYSTEM''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLE_GRANT','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLE_GRANT','PRS_NAME','0',0,
    'KU$.ROLE',NULL,NULL,NULL);

-- SYSTEM_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYSTEM_GRANT','PRS_OBJECT_TYPE','0',0,
    '''SYSTEM_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYSTEM_GRANT','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','SYSTEM_GRANT','PRS_NAME','0',0,
    'KU$.PRIVNAME',NULL,NULL,NULL);

-- OBJECT_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OBJECT_GRANT','PRS_OBJECT_TYPE','0',0,
    '''OBJECT_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OBJECT_GRANT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OBJECT_GRANT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OBJECT_GRANT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OBJECT_GRANT','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OBJECT_GRANT','PRS_GRANTOR','0',0,
    'KU$.GRANTOR',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','OBJECT_GRANT','PRS_NAME','0',0,
    'KU$.PRIVNAME',NULL,NULL,NULL);

-- ON_USER_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ON_USER_GRANT','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ON_USER_GRANT','PRS_GRANTOR','0',0,
    'KU$.GRANTOR',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ON_USER_GRANT','PRS_OBJECT_TYPE','0',0,
    '''ON_USER_GRANT''',NULL,NULL,NULL);

-- CONTEXT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONTEXT','PRS_OBJECT_TYPE','0',0,
    '''CONTEXT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONTEXT','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONTEXT','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONTEXT','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONTEXT','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- PROFILE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROFILE','PRS_OBJECT_TYPE','0',0,
    '''PROFILE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROFILE','PRS_NAME','0',0,
    'KU$.PROFILE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROFILE','PRS_LONGNAME','0',0,
    'KU$.PROFILE_NAME',NULL,NULL,NULL);

-- XMLSCHEMA parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_OBJECT_TYPE','0',0,
    '''XMLSCHEMA''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_SCHEMA','0',0,
    'KU$.OWNER_NAME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_LOCAL','0',0,
  'KU$.LOCAL');

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_SCHEMA_LEVEL','0',0,
  'KU$.SCHEMA_LEVEL');

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_SCHEMAOID','0',0,
  'KU$.SCHEMAOID');

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_OBJECT_TYPE','0',0,
    '''XMLSCHEMA''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_SCHEMA','0',0,
    'KU$.OWNER_NAME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_LOCAL','0',0,
  'KU$.LOCAL');

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_SCHEMA_LEVEL','0',0,
  'KU$.SCHEMA_LEVEL');

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_SCHEMAOID','0',0,
  'KU$.SCHEMAOID');

-- Note: when Data Pump supports XML schemas, PRS_NAME should return
--  KU$.INT_OBJNAME (see comment in definition of ku$_xmlschema_t above)

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_NAME','0',0,
    'KU$.URL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_LONGNAME','0',0,
    'KU$.URL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XMLSCHEMA','PRS_BIND_PATTERN','0',0, NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_NAME','0',0,
    'KU$.URL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_LONGNAME','0',0,
    'KU$.URL',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','EXP_XMLSCHEMA','PRS_BIND_PATTERN','0',0, NULL,NULL,NULL,NULL);

-- REFRESH_GROUP parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REFRESH_GROUP','PRS_OBJECT_TYPE','0',0,
    '''REFRESH_GROUP''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REFRESH_GROUP','PRS_SCHEMA','0',0,
    'KU$.REFOWNER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REFRESH_GROUP','PRS_NAME','0',0,
    'KU$.REFNAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REFRESH_GROUP','PRS_LONGNAME','0',0,
    'KU$.REFNAME',NULL,NULL,NULL);

-- ASSOCIATION parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ASSOCIATION','PRS_OBJECT_TYPE','0',0,
    '''ASSOCIATION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ASSOCIATION','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ASSOCIATION','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ASSOCIATION','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ASSOCIATION','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- PASSWORD_VERIFY_FUNCTION parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_VERIFY_FUNCTION','PRS_OBJECT_TYPE','0',0,
    '''PASSWORD_VERIFY_FUNCTION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_VERIFY_FUNCTION','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_VERIFY_FUNCTION','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_VERIFY_FUNCTION','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_VERIFY_FUNCTION','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_VERIFY_FUNCTION','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- PASSWORD_VERIFY_FUNCTION parse items (internal)
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_VERIFY_FUNCTION','PRS_GRANTOR','0',0,
    '''SYS''',NULL,NULL,NULL);

-- INDEX parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_OBJECT_TYPE','0',0,
    '''INDEX''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.ANC_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.ANC_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.ANC_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_PROPERTY','0',0,
    'KU$.PROPERTY',NULL,NULL,NULL);

-- NOTE: Tablespace for indexes doesn't get the special 'if partitioned'
-- treatment as it does for tables because defts may be NULL even if the
-- index is partitioned. We always use TS_NAME

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_TABLESPACE','0',0,
    'KU$.TS_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_TYPE_NUM','0',0,
    'to_char(KU$.TYPE_NUM)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_SYSTEM_GENERATED','0',0,
    'decode(bitand(KU$.SCHEMA_OBJ.FLAGS,4),4,''Y'',''N'')',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_IND_FLAGS','0',0,
    'to_char(KU$.FLAGS)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_ALT_CONNECT_TYPE','0',0, NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_UNSUPPORTED_OBJECT','0',0,
   'decode(cardinality(KU$.COL_LIST),0,''1'',''0'')',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX','PRS_IND_SPARE4','0',0,
    'KU$.SPARE4',NULL,NULL,NULL);

-- TRIGGER parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_OBJECT_TYPE','0',0,
    '''TRIGGER''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_BASE_OBJECT_SCHEMA','0',0,
    'NVL(KU$.BASE_OBJ.OWNER_NAME,KU$.BASE_OBJ_SCHEMA)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRIGGER','PRS_ENABLE','0',0,
    'decode(KU$.ENABLED,1,''ENABLE'',''DISABLE'')',NULL,NULL,NULL);

-- PASSWORD_HISTORY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_HISTORY','PRS_OBJECT_TYPE','0',0,
    '''PASSWORD_HISTORY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_HISTORY','PRS_GRANTEE','0',0,
    'KU$.NAME',NULL,NULL,NULL);
-- Bug 16811897 Treat PASSWORD_HISTORY object independent of USER_T and
-- don't attempt to import user history if create user fails.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_HISTORY','PRS_BASE_OBJECT_TYPE','0',0,
    '''USER''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_HISTORY','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PASSWORD_HISTORY','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);

-- RLS_POLICY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_POLICY','PRS_OBJECT_TYPE','0',0,
    '''RLS_POLICY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_POLICY','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_POLICY','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_POLICY','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_POLICY_OBJNUM','PRS_OBJNUM_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_POLICY_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);

-- RLS_GROUP parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_GROUP','PRS_OBJECT_TYPE','0',0,
    '''RLS_GROUP''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_GROUP','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_GROUP','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_GROUP','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- RLS_CONTEXT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_CONTEXT','PRS_OBJECT_TYPE','0',0,
    '''RLS_CONTEXT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_CONTEXT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_CONTEXT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RLS_CONTEXT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- CLUSTERING parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTERING','PRS_OBJECT_TYPE','0',0,
    '''CLUSTERING''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTERING','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTERING','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CLUSTERING','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- COMMENT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','COMMENT','PRS_OBJECT_TYPE','0',0,
    '''COMMENT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','COMMENT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','COMMENT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','COMMENT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
--
-- HACK: return colname as NAME parse item for comment (for DP worker)
--  rather than inventing a new parse item name
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','COMMENT','PRS_NAME','0',0,
    'KU$.COLNAME',NULL,NULL,NULL);

-- CONSTRAINT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_OBJECT_TYPE','0',0,
    '''CONSTRAINT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_SCHEMA','0',0,
    'KU$.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_BASE_OBJECT_NAME','0',0,
    'NVL(KU$.CON1.IND.ANC_OBJ.NAME, KU$.BASE_OBJ.NAME)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','CONSTRAINT','PRS_SYSTEM_GENERATED','0',0,
    'decode(bitand(KU$.FLAGS,8),8,''Y'',''N'')',NULL,NULL,NULL);

-- RADM_FPTM parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RADM_FPTM','PRS_OBJECT_TYPE','0',0,
    '''RADM_FPTM''',NULL,NULL,NULL);

-- RADM_POLICY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RADM_POLICY','PRS_OBJECT_TYPE','0',0,
    '''RADM_POLICY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RADM_POLICY','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RADM_POLICY','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RADM_POLICY','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- REF_CONSTRAINT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_OBJECT_TYPE','0',0,
    '''REF_CONSTRAINT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_SCHEMA','0',0,
    'KU$.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','REF_CONSTRAINT','PRS_SYSTEM_GENERATED','0',0,
    'decode(bitand(KU$.FLAGS,8),8,''Y'',''N'')',NULL,NULL,NULL);

-- TABLESPACE_QUOTA parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE_QUOTA','PRS_OBJECT_TYPE','0',0,
    '''TABLESPACE_QUOTA''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE_QUOTA','PRS_GRANTEE','0',0,
    'KU$.USER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE_QUOTA','PRS_GRANTOR','0',0,
    'KU$.GRANTOR',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE_QUOTA','PRS_NAME','0',0, 'KU$.TS_NAME',NULL,NULL,NULL);

-- TABLESPACE_ILM_POLICY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE_ILM_POLICY','PRS_OBJECT_TYPE','0',0,
    '''TABLESPACE_ILM_POLICY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE_ILM_POLICY','PRS_NAME','0',0,
 'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE_ILM_POLICY',
  'PRS_ALT_CONNECT_TYPE','0',0, NULL,NULL,NULL,NULL);

-- DEFAULT_ROLE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DEFAULT_ROLE','PRS_OBJECT_TYPE','0',0,
    '''DEFAULT_ROLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DEFAULT_ROLE','PRS_GRANTEE','0',0,
    'KU$.USER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DEFAULT_ROLE','PRS_GRANTOR','0',0,
    '''SYSTEM''',NULL,NULL,NULL);

-- TRUSTED_DB_LINK parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRUSTED_DB_LINK','PRS_OBJECT_TYPE','0',0,
    '''TRUSTED_DB_LINK''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRUSTED_DB_LINK','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TRUSTED_DB_LINK','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);

-- DB_LINK parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DB_LINK','PRS_OBJECT_TYPE','0',0,
    '''DB_LINK''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DB_LINK','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DB_LINK','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DB_LINK','PRS_BIND_PATTERN','0',0, NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DB_LINK','PRS_DBLPWX','0',0, NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DB_LINK','PRS_DBLAPWX','0',0, NULL,NULL,NULL,NULL);

-- Return NULL if SCHEMA is 'PUBLIC'
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','DB_LINK','PRS_SCHEMA','0',0, 'KU$.OWNER_NAME',NULL,NULL,NULL);

-- ROLLBACK_SEGMENT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLLBACK_SEGMENT','PRS_OBJECT_TYPE','0',0,
    '''ROLLBACK_SEGMENT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLLBACK_SEGMENT','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLLBACK_SEGMENT','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);

-- PROCACT_SCHEMA parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SCHEMA','PRS_OBJECT_TYPE','0',0,
    '''PROCACT_SCHEMA''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SCHEMA','PRS_SCHEMA','0',0,
    'KU$.USER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SCHEMA','PRS_PKG_SCHEMA','0',0,
    'KU$.SCHEMA',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SCHEMA','PRS_PKG_NAME','0',0,
    'KU$.PACKAGE',NULL,NULL,NULL);

-- PRE_TABLE_ACTION parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PRE_TABLE_ACTION','PRS_OBJECT_TYPE','0',0,
    '''PRE_TABLE_ACTION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PRE_TABLE_ACTION','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PRE_TABLE_ACTION','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PRE_TABLE_ACTION','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- POST_TABLE_ACTION parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_TABLE_ACTION','PRS_OBJECT_TYPE','0',0,
    '''POST_TABLE_ACTION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_TABLE_ACTION','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_TABLE_ACTION','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','POST_TABLE_ACTION','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- PROCACT_INSTANCE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_INSTANCE','PRS_OBJECT_TYPE','0',0,
    '''PROCACT_INSTANCE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_INSTANCE','PRS_PKG_SCHEMA','0',0,
    'KU$.PKG_SCHEMA',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_INSTANCE','PRS_PKG_NAME','0',0,
    'KU$.PACKAGE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_INSTANCE','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_INSTANCE','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_INSTANCE','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- PROCACT_SYSTEM parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SYSTEM','PRS_OBJECT_TYPE','0',0,
    '''PROCACT_SYSTEM''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SYSTEM','PRS_PKG_SCHEMA','0',0,
    'KU$.SCHEMA',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SYSTEM','PRS_PKG_NAME','0',0,
    'KU$.PACKAGE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCACT_SYSTEM','PRS_GRANTOR','0',0, '''SYSTEM''',NULL,NULL,NULL);

-- PROC_AUDIT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROC_AUDIT','PRS_OBJECT_TYPE','0',0,
    '''PROC_AUDIT''',NULL,NULL,NULL);

-- PROCDEPOBJ_AUDIT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_AUDIT','PRS_OBJECT_TYPE','0',0,
    '''PROCDEPOBJ_AUDIT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_AUDIT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_AUDIT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_AUDIT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- PROCOBJ_AUDIT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_AUDIT','PRS_OBJECT_TYPE','0',0,
    '''PROCOBJ_AUDIT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_AUDIT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_AUDIT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_AUDIT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- PROCDEPOBJ parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_OBJECT_TYPE','0',0,
    '''PROCDEPOBJ''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- PROCDEPOBJ_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_GRANT','PRS_OBJECT_TYPE','0',0,
    '''PROCDEPOBJ_GRANT''',NULL,NULL,NULL);
--
-- bug 14092408: the "base object" parse items for procdepobj_grant
--  should be the ancestor object
--
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_GRANT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.ANC_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_GRANT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.ANC_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_GRANT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.ANC_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCDEPOBJ_GRANT','PRS_GRANTOR','0',0,NULL,NULL,NULL,NULL);

-- PROCOBJ_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_GRANT','PRS_OBJECT_TYPE','0',0,
    '''PROCOBJ_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_GRANT','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_GRANT','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_GRANT','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_GRANT','PRS_GRANTOR','0',0,NULL,NULL,NULL,NULL);

-- Items for PROCOBJ_OBJNUM
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);

-- PROCOBJ parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ','PRS_OBJECT_TYPE','0',0,
    '''PROCOBJ''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROCOBJ','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- PROC_SYSTEM_GRANT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROC_SYSTEM_GRANT','PRS_OBJECT_TYPE','0',0,
    '''PROC_SYSTEM_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROC_SYSTEM_GRANT','PRS_GRANTOR','0',0,
    '''SYSTEM''',NULL,NULL,NULL);

-- RESOURCE_COST parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RESOURCE_COST','PRS_OBJECT_TYPE','0',0,
    '''RESOURCE_COST''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RESOURCE_COST','PRS_GRANTOR','0',0,
    '''SYSTEM''',NULL,NULL,NULL);

-- INDEX_STATISTICS parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_OBJECT_TYPE','0',0,
    '''INDEX_STATISTICS''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_IND_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_IND_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_IND_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_ANC_OBJECT_SCHEMA','0',0,
    'KU$.BASE_TAB_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_ANC_OBJECT_NAME','0',0,
    'KU$.BASE_TAB_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_ANC_OBJECT_TYPE','0',0,
    'KU$.BASE_TAB_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_TYPE_NUM','0',0,
    'to_char(KU$.TYPE_NUM)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_BASE_IND_FLAGS','0',0,
    'to_char(KU$.BASE_IND_OBJ.FLAGS)',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_STATISTICS','PRS_BASE_IND_PROPERTY','0',0,
    'to_char(KU$.PROPERTY)',NULL,NULL,NULL);

-- TABLE_STATISTICS parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_STATISTICS','PRS_OBJECT_TYPE','0',0,
    '''TABLE_STATISTICS''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_STATISTICS','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_STATISTICS','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_STATISTICS','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE_STATISTICS','PRS_NESTED_TAB_NAME','0',0,
    'KU$.NESTED_TAB_NAME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_DROPCOLCOUNT','0',0, NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_DROPCOLNAME','0',0, NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_SQLVALID','0',0, NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_UNPACKEDCOL_COUNT','0',0, NULL,NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLE','PRS_UNPACKEDCOL_LIST','0',0, NULL,NULL,NULL,NULL);

-- TABLESPACE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE','PRS_OBJECT_TYPE','0',0,
    '''TABLESPACE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','TABLESPACE','PRS_OBJNUM','0',0,
    'KU$.TS_NUM',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TSNAME_TABLE','PRS_OBJNUM','0',0,
    'KU$.TS_NUM',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TSNAME_INDEX','PRS_OBJNUM','0',0,
    'KU$.TS_NUM',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TSNAME_INDEXP','PRS_OBJNUM','0',0,
    'KU$.TS_NUM',NULL,NULL,NULL);

-- ROLE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLE','PRS_OBJECT_TYPE','0',0,
    '''ROLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLE','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ROLE','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);

-- USER parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER','PRS_OBJECT_TYPE','0',0,
    '''USER''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER','PRS_LONGNAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER','PRS_GRANTOR','0',0,
    '''SYSTEM''',NULL,NULL,NULL);

-- Triton Security parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_USER','PRS_OBJECT_TYPE','0',0,
    '''XS_USER''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_USER','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_USER','PRS_SCHEMA','0',0,
    'KU$.OWNER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_GRANT','PRS_OBJECT_TYPE','0',0,
    '''XS_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_GRANT','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_GRANT','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLE','PRS_OBJECT_TYPE','0',0,
    '''XS_ROLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLE','PRS_NAME','0',0,
    'KU$.XS_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLE_GRANT','PRS_OBJECT_TYPE','0',0,
    '''XS_ROLE_GRANT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLE_GRANT','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLE_GRANT','PRS_GRANTOR','0',0,
    'KU$.GRANTER',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLE_GRANT','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLESET','PRS_OBJECT_TYPE','0',0,
    '''XS_ROLESET''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ROLESET','PRS_NAME','0',0,
    'KU$.XS_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_SECURITY_CLASS','PRS_OBJECT_TYPE','0',0,
    '''XS_SECURITY_CLASS''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_SECURITY_CLASS','PRS_NAME','0',0,
    'KU$.XS_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_SECURITY_CLASS','PRS_SCHEMA','0',0,
    'KU$.XS_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_DATA_SECURITY','PRS_OBJECT_TYPE','0',0,
    '''XS_DATA_SECURITY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_DATA_SECURITY','PRS_NAME','0',0,
    'KU$.XS_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_DATA_SECURITY','PRS_SCHEMA','0',0,
    'KU$.XS_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ACL','PRS_OBJECT_TYPE','0',0,
    '''XS_ACL''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ACL','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ACL','PRS_SCHEMA','0',0,
    'KU$.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ACL_PARAM','PRS_OBJECT_TYPE','0',0,
    '''XS_ACL_PARAM''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_ACL_PARAM','PRS_NAME','0',0,
    'KU$.NAME',NULL,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_NAMESPACE','PRS_OBJECT_TYPE','0',0,
    '''XS_NAMESPACE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','XS_NAMESPACE','PRS_NAME','0',0,
    'KU$.XS_OBJ.NAME',NULL,NULL,NULL);
-- end of Triton Security parse items

-- USER PREF STATISTICS parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER_PREF_STATISTICS','PRS_OBJECT_TYPE','0',0,
    '''USER_PREF_STATISTICS''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER_PREF_STATISTICS','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER_PREF_STATISTICS','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER_PREF_STATISTICS','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);

-- AQ_QUEUE_TABLE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_OBJECT_TYPE','0',0,
    '''AQ_QUEUE_TABLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- Inconsistency in old parse items... kuquetab.xsl uses schema_obj for *base*
-- object parse items. We'll remain bug-for-bug compatible.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE_TABLE','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.SCHEMA_OBJ.TYPE',NULL,NULL,NULL);

-- AQ_TRANSFORM parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_TRANSFORM','PRS_OBJECT_TYPE','0',0,
    '''AQ_TRANSFORM''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_TRANSFORM','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_TRANSFORM','PRS_NAME','0',0,
    'KU$.TRANSFORM_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_TRANSFORM','PRS_LONGNAME','0',0,
    'KU$.TRANSFORM_NAME',NULL,NULL,NULL);

-- JOB parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JOB','PRS_OBJECT_TYPE','0',0,
    '''JOB''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','JOB','PRS_SCHEMA','0',0,
    'KU$.POWNER',NULL,NULL,NULL);

-- FGA_POLICY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FGA_POLICY','PRS_OBJECT_TYPE','0',0,
    '''FGA_POLICY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FGA_POLICY','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','FGA_POLICY','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);

-- RMGR_INITIAL_CONSUMER_GROUP parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_INITIAL_CONSUMER_GROUP','PRS_OBJECT_TYPE','0',0,
    '''RMGR_INITIAL_CONSUMER_GROUP''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_INITIAL_CONSUMER_GROUP','PRS_GRANTEE','0',0,
    'KU$.GRANTEE',NULL,NULL,NULL);

-- PROXY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROXY','PRS_OBJECT_TYPE','0',0,
    '''PROXY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROXY','PRS_GRANTEE','0',0,
    'KU$.CLIENT_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PROXY','PRS_NAME', '0', 0, 'KU$.PROXY_NAME',NULL,NULL,NULL);

-- RMGR_PLAN parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN','PRS_OBJECT_TYPE','0',0,
    '''RMGR_PLAN''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- RMGR_PLAN_DIRECTIVE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN_DIRECTIVE','PRS_OBJECT_TYPE','0',0,
    '''RMGR_PLAN_DIRECTIVE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN_DIRECTIVE','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_PLAN_DIRECTIVE','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);

-- RMGR_CONSUMER_GROUP parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_CONSUMER_GROUP','PRS_OBJECT_TYPE','0',0,
    '''RMGR_CONSUMER_GROUP''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_CONSUMER_GROUP','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_CONSUMER_GROUP','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_CONSUMER_GROUP','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','RMGR_CONSUMER_GROUP','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);

-- PLUGTS_BLK parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_BLK','PRS_OBJECT_TYPE','0',0,
    '''PLUGTS_BLK''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','END_PLUGTS_BLK','PRS_OBJECT_TYPE','0',0,
    '''PLUGTS_BLK''',NULL,NULL,NULL);

-- Items for PLUGTS_TABLESPACE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TABLESPACE','PRS_TABLESPACE','0',0, 'KU$.TS_NAME',
    NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TABLESPACE','PRS_OBJECT_TYPE','0',0,
    '''PLUGTS_TABLESPACE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TABLESPACE','PRS_BITMAPPED','0',0,'KU$.BITMAPPED',
    NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TABLESPACE','PRS_FLAGS','0',0,'KU$.FLAGS',
    NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_TABLESPACE','PRS_TS_NUM','0',0,'KU$.TS_NUM',
    NULL,NULL,NULL);
-- Items for PLUGTS_TSNAME_TABLE
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','PLUGTS_EARLY_TABLESPACE','PRS_OBJNUM','0',0,
    'KU$.TS_NUM',NULL,NULL,NULL);

-- AQ_QUEUE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE','PRS_OBJECT_TYPE','0',0,
    '''AQ_QUEUE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE','PRS_LAST_DDL_TIME','0',0,
    'KU$.SCHEMA_OBJ.MTIME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AQ_QUEUE','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);

-- AUDIT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT','PRS_OBJECT_TYPE','0',0,
    '''AUDIT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT','PRS_GRANTEE','0',0,
    'KU$.USER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT','PRS_NAME','0',0,
    'KU$.USER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT','PRS_LONGNAME','0',0,
    'KU$.USER_NAME',NULL,NULL,NULL);

-- AUDIT_OBJ parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_OBJ','PRS_OBJECT_TYPE','0',0,
    '''AUDIT_OBJ''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_OBJ','PRS_BASE_OBJECT_SCHEMA','0',0,
    'KU$.BASE_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_OBJ','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.BASE_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_OBJ','PRS_BASE_OBJECT_TYPE','0',0,
    'KU$.BASE_OBJ.TYPE_NAME',NULL,NULL,NULL);


-- MODIFY transforms
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','*','OBJECT_ROW','0',1,NULL,3,0,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLESPACE','REMAP_DATAFILE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','LIBRARY','REMAP_DATAFILE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DIRECTORY','REMAP_DATAFILE','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLESPACE','REMAP_DIRECTORY','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','LIBRARY','REMAP_DIRECTORY','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DIRECTORY','REMAP_DIRECTORY','0',3,NULL,2,NULL,NULL);


insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CLUSTER','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CONSTRAINT','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEX','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_VIEW','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_VIEW_LOG','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_ZONEMAP','REMAP_TABLESPACE','0',3,
  NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ROLLBACK_SEGMENT','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_TABLE_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_LOB_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_PART_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_SPART_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_IND_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','VERSION','9999999999',0,NULL,3,0,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLESPACE','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLESPACE_QUOTA','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','USER','REMAP_TABLESPACE','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_FUNCTION','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_PACKAGE_BODY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_PACKAGE_SPEC','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_PROCEDURE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ASSOCIATION','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','AUDIT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','AUDIT_OBJ','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CLUSTER','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CLUSTERING','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CODE_BASE_GRANT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','COMMENT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CONSTRAINT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DB_LINK','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DEFAULT_ROLE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DIMENSION','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','FGA_POLICY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','FUNCTION','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INC_TYPE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','IDENTITY_COLUMN','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEX_STATISTICS','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEX','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEXTYPE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','JAVA_CLASS','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','JAVA_RESOURCE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','JAVA_SOURCE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','JOB','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','LIBRARY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_VIEW','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_VIEW_LOG','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_ZONEMAP','REMAP_SCHEMA','0',3,NULL,2,
  NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','OBJECT_GRANT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','OPERATOR','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PACKAGE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PACKAGE_SPEC','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PACKAGE_BODY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','EXP_PACKAGE_BODY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PASSWORD_HISTORY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PASSWORD_VERIFY_FUNCTION','REMAP_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROCDEPOBJ_GRANT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROCEDURE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROCOBJ_GRANT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROXY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','REF_CONSTRAINT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','REFRESH_GROUP','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','RLS_CONTEXT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','RLS_GROUP','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','RLS_POLICY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ROLE_GRANT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','SEQUENCE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DPSTREAM_TABLE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ON_USER_GRANT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DPSTREAM_TABLE','UPGRADE_V10_XMLTYPE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','SYNONYM','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','SYSTEM_GRANT','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE_STATISTICS','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','USER_PREF_STATISTICS','REMAP_SCHEMA','0',3,NULL,2,NULL,
   NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLESPACE_QUOTA','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TRIGGER','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TYPE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TYPE_SPEC','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TYPE_BODY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','EXP_TYPE_BODY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','USER','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','VIEW','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XMLSCHEMA','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','EXP_XMLSCHEMA','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_SECURITY_CLASS','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_ACL','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_DATA_SECURITY','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_FUNCTION','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_PACKAGE_BODY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_PACKAGE_SPEC','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ALTER_PROCEDURE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ASSOCIATION','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','AUDIT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','AUDIT_OBJ','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CLUSTER','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CLUSTERING','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','COMMENT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CONSTRAINT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DB_LINK','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DEFAULT_ROLE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DIMENSION','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','FGA_POLICY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','FUNCTION','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','IDENTITY_COLUMN','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INC_TYPE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEX_STATISTICS','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEX','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEXTYPE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','JAVA_CLASS','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','JAVA_RESOURCE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','JAVA_SOURCE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','LIBRARY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_VIEW','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_VIEW_LOG','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','MATERIALIZED_ZONEMAP','REMAP_NAME','0',3,
  NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','OBJECT_GRANT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','OPERATOR','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PACKAGE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PACKAGE_SPEC','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PACKAGE_BODY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','EXP_PACKAGE_BODY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PASSWORD_HISTORY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PASSWORD_VERIFY_FUNCTION','REMAP_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROCDEPOBJ_GRANT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROCEDURE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROCOBJ_GRANT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','PROXY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','REF_CONSTRAINT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','REFRESH_GROUP','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','RLS_CONTEXT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','RLS_GROUP','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','RLS_POLICY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ROLE_GRANT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ROLLBACK_SEGMENT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','SEQUENCE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','DPSTREAM_TABLE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','SYNONYM','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','SYSTEM_GRANT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_CONSTRAINT_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE_STATISTICS','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','USER_PREF_STATISTICS','REMAP_NAME','0',3,NULL,2,NULL,
  NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLESPACE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLESPACE_QUOTA','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TRIGGER','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TYPE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TYPE_SPEC','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TYPE_BODY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','EXP_TYPE_BODY','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','USER','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','VIEW','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XMLSCHEMA','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','EXP_XMLSCHEMA','REMAP_NAME','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_USER','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_ROLE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_ROLE_GRANT','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_ACL_PARAM','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_NAMESPACE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_SECURITY_CLASS','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_ACL','REMAP_NAME','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','XS_DATA_SECURITY','REMAP_NAME','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','CONSTRAINT','REMAP_TYPE_NAME','0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','INDEX','IND_SPARE4','""',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','*','PARSE_EXPRESSIONS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','*','PARSE_ALTER','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','*','XMLXVM_TRANSFORM_ENGINE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','*','COLLATION_CLAUSE','"NON_DEFAULT"',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','*','ENABLE_COLLATION','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','PARTITIONS_BY_QUANTITY','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','PHYSICAL_PROPERTIES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','PARTITIONING','1',0,NULL,1,NULL,NULL);
-- ChangeManager specific INDEX transform parameters - only in place for
-- testing.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','CM_MODE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','INDEX','STATISTICS','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','PHYSICAL_PROPERTIES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','HIDDEN_COLUMNS','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','DATA_LAYER_NOT_NETWORK','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','STREAMD_VERSION','2',0,NULL,3,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','REF_CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','USING_INDEX','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','OID','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','PARTITIONING','1',0,NULL,1,NULL,NULL);
-- ChangeManager specific TABLE transform parameters - only in place for
-- testing.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','CM_MODE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','TABLE','STATISTICS','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','CLUSTER','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','CLUSTER','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','CLUSTER','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','CLUSTER','CM_MODE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW','PHYSICAL_PROPERTIES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW','CM_MODE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW_LOG','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW_LOG','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW_LOG','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','MATERIALIZED_VIEW_LOG','CM_MODE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','*','LRG','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXML','*','VERSION','9999999999',0,NULL,3,0,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','*','PRETTY','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','*','SQLTERMINATOR','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','*','VERSION','9999999999',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','ALTERXML','*','VERSION','9999999999',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','ALTERDDL','*','SQLTERMINATOR','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','*','XMLXVM_TRANSFORM_ENGINE','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','*','COLLATION_CLAUSE','"NON_DEFAULT"',0,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','*','ENABLE_COLLATION','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','INDEX','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','INDEX','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','INDEX','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','INDEX','PARTITIONING','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','INDEX','PRESERVE_LOCAL','0',0,NULL,1,NULL,NULL);
-- ChangeManager specific INDEX transform parameters - only in place for
-- testing.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','INDEX','STATISTICS','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','REF_CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','USING_INDEX','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','OID','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','PARTITIONING','1',0,NULL,1,NULL,NULL);
-- ChangeManager specific TABLE transform parameters - only in place for
-- testing.
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLE','STATISTICS','0',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','TABLESPACE','REUSE','0',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','CLUSTER','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','CLUSTER','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','CLUSTER','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','MATERIALIZED_VIEW','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','MATERIALIZED_VIEW','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','MATERIALIZED_VIEW','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','MATERIALIZED_VIEW_LOG','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','MATERIALIZED_VIEW_LOG','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','SXMLDDL','MATERIALIZED_VIEW_LOG','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','*','TO_LOGICAL','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','TABLE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','TABLE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','TABLE','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','TABLE','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','TABLE','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','INDEX','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','INDEX','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','INDEX','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','INDEX','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','INDEX','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','VIEW','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','VIEW','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','VIEW','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','VIEW','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','VIEW','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW','REMAP_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW','REMAP_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW_LOG','REMAP_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW_LOG','REMAP_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_VIEW_LOG','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_ZONEMAP','REMAP_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_ZONEMAP','REMAP_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_ZONEMAP','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_ZONEMAP','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','EDITIONING_VIEW','MATERIALIZED_ZONEMAP','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','REMAP_COLUMN_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','REF_CONSTRAINTS','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','TABLE','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','REMAP_COLUMN_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','INDEX','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','VIEW','REMAP_SCHEMA','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','VIEW','REMAP_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','VIEW','REMAP_COLUMN_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','VIEW','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','VIEW','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','REMAP_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','REMAP_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','REMAP_COLUMN_NAME_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','REMAP_COLUMN_NAME_TABLE',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW','TABLESPACE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW_LOG','REMAP_SCHEMA',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW_LOG','REMAP_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW_LOG','REMAP_COLUMN_NAME',
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW_LOG','SEGMENT_ATTRIBUTES','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW_LOG','STORAGE','1',0,NULL,1,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSXML','MATERIALIZED_VIEW_LOG','TABLESPACE','1',0,NULL,1,NULL,NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSTREAMSXML','TABLE','REMAP_COLUMN_NAME','0',3,
    NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSTREAMSXML','TABLE','REMAP_SCHEMA','0',3,
    NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFYSTREAMSXML','TABLE','REMAP_NAME','0',3,
    NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','OVERRIDE_CHARSET','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','OVERRIDE_NCHARSET','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','OVERRIDE_CHARLENGTH','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','OVERRIDE_CHARSETNAME','""',0,NULL,2,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','OVERRIDE_NCHARSETNAME','""',0,NULL,2,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','DPAPIVERSION','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','FORCE_LOB_BE','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','FORCE_NO_ENCRYPT','0',0,NULL,3,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','VIEW_AS_TABLE','0',0,NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','REMAP_COLUMN_NAME','0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','TABLE','IN_TSNUM','""',0,NULL,2,0,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ATTRIBUTE_DIMENSION','REMAP_SCHEMA', 
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','HIERARCHY','REMAP_SCHEMA', 
  '0',3,NULL,2,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','MODIFY','ANALYTIC_VIEW','REMAP_SCHEMA', 
  '0',3,NULL,2,NULL,NULL);
-- AUDIT_POLICY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY','PRS_OBJECT_TYPE','0',0,
    '''AUDIT_POLICY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY','PRS_GRANTEE','0',0,
    NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);

-- AUDIT_POLICY_ENABLE parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY_ENABLE','PRS_OBJECT_TYPE','0',0,
    '''AUDIT_POLICY_ENABLE''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY_ENABLE','PRS_BASE_OBJECT_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY_ENABLE','PRS_GRANTEE','0',0,
    NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY_ENABLE','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_POLICY_ENABLE','PRS_LONGNAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);

-- AUDIT_CONTEXT parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_CONTEXT','PRS_OBJECT_TYPE','0',0,
    '''AUDIT_CONTEXT''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_CONTEXT','PRS_BASE_OBJECT_NAME','0',0,
    NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_CONTEXT','PRS_GRANTEE','0',0,
    NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_CONTEXT','PRS_NAME','0',0,
    NULL,NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','AUDIT_CONTEXT','PRS_LONGNAME','0',0,
    NULL,NULL,NULL,NULL);
--------------------------------------------------------------
-- index objnum
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
 ('INDEX_OBJNUM',0,256,'ORACLE',0801000000,
  'INDEX_OBJNUM_T','KU$_TABLE_OBJNUM_T','SYS','KU$_INDEX_OBJNUM_VIEW');

-- ATTRIBUTE_DIMENSION parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ATTRIBUTE_DIMENSION','PRS_OBJECT_TYPE','0',0,
  '''ATTRIBUTE_DIMENSION''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ATTRIBUTE_DIMENSION','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ATTRIBUTE_DIMENSION','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);

-- HIERARCHY parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','HIERARCHY','PRS_OBJECT_TYPE','0',0,
  '''HIERARCHY''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','HIERARCHY','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','HIERARCHY','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);

-- ANALYTIC_VIEW parse items
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ANALYTIC_VIEW','PRS_OBJECT_TYPE','0',0,
  '''ANALYTIC_VIEW''',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ANALYTIC_VIEW','PRS_SCHEMA','0',0,
    'KU$.SCHEMA_OBJ.OWNER_NAME',NULL,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','ANALYTIC_VIEW','PRS_NAME','0',0,
    'KU$.SCHEMA_OBJ.NAME',NULL,NULL,NULL);

-- bug 21764718 - transform param and parse item
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','DDL','USER','TEN_G_LOGON_ALLOWED',12,0,NULL,3,NULL,NULL);
insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','USER','PRS_USER_DISABLED','0',0,
    NULL,NULL,NULL,NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INDEX_OBJNUM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NAME_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.SCHEMA_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'INDEX_OBJNUM', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0, 'SCHEMA_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_SCHEMA_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.SCHEMA_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'INDEX_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_TABLESPACE', 'INDEX_OBJNUM', 'ORACLE', 0, 0,
  'NOT (EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUSIVE_TABLESPACE_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  'NOT (EXISTS (SELECT 1 FROM SYS.KU$_IND_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.OBJ_NUM AND NOT (TTS.TS_NAME :1)))',
  NULL);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_CLUSTER_TABLESPACE', 'INDEX_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_CLU_TS_VIEW CTS ' ||
  'WHERE CTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND CTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_CLUSTER_TABLESPACE_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_CLU_TS_VIEW CTS ' ||
  'WHERE CTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND CTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE', 'INDEX_OBJNUM', 'ORACLE', 0, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_TABLE_TABLESPACE_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  '(EXISTS (SELECT 1 FROM SYS.KU$_TAB_TS_VIEW TTS ' ||
  'WHERE TTS.OBJ_NUM = KU$.BASE_OBJ.OBJ_NUM AND TTS.TS_NAME :1))',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('PRIMARY', 'INDEX_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)!=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SECONDARY', 'INDEX_OBJNUM', 'ORACLE', 9, 0,
  '(BITAND (KU$.SCHEMA_OBJ.FLAGS,16)=16)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TYPE_NUM_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0, 'TYPE_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'INDEX_OBJNUM', 'ORACLE', 0, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0, 'BASE_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_NAME_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
 'NOT (KU$.BASE_OBJ.NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA', 'INDEX_OBJNUM', 'ORACLE', 0, 0, 'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_SCHEMA_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ.OWNER_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_BASE_OBJECT_SCHEMA_EXP', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  'NOT (KU$.BASE_OBJ.OWNER_NAME :1)',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE', 'INDEX_OBJNUM', 'ORACLE', 0, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_TYPE_EXPR', 'INDEX_OBJNUM', 'ORACLE', 2, 0, 'BASE_OBJ.TYPE_NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('OBJNUM', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  'OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TTS_TSNUM', 'INDEX_OBJNUM', 'ORACLE', 32768+1, 1,
  'decode(bitand(ku$.property,2),'|| 
          '2, dbms_metadata.get_indpart_ts(ku$.obj_num),'||
          'KU$.STORAGE.TS_NUM )',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJNUM', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
  'BASE_OBJ_NUM',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SYSTEM_GENERATED', 'INDEX_OBJNUM', 'ORACLE', 9, 0,
                                        'BITAND(KU$.SCHEMA_OBJ.FLAGS,4)=4',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('HIDDEN_ID', 'INDEX_OBJNUM', 'ORACLE', 9, 0,
  '(KU$.TYPE_NUM=1 AND KU$.INTCOLS=1 ' ||
  'AND KU$.OID_OR_SETID!=0)',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FOR_PKOID', 'INDEX_OBJNUM', 'ORACLE', 9, 0, 'KU$.FOR_PKOID=1',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FOR_REFPAR', 'INDEX_OBJNUM', 'ORACLE', 9, 0, 'KU$.FOR_REFPAR=1',1);

insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('FOR_DIMTABLE_TARGET', 'INDEX_OBJNUM', 'ORACLE', 9, 0,
  'BITAND(KU$.BASE_PROPERTY2,268435456)!=0',1);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'INDEX_OBJNUM', 'ORACLE', 9, 0, 'BITAND(KU$.BASE_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'INDEX_OBJNUM', 'ORACLE', 1+8+128, 0,
  'KU$.SCHEMA_OBJ.OWNER_NUM, KU$.SCHEMA_OBJ.DATAOBJ_NUM', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('EXCLUDE_NOEXP', 'INDEX_OBJNUM', 'ORACLE', 2, 0,
 'NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=KU$.BASE_OBJ.TYPE_NAME ' ||
 'AND A.NAME=KU$.BASE_OBJ.NAME AND A.SCHEMA=KU$.BASE_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''INDEX_OBJNUM'' ' ||
 'AND A.NAME=KU$.SCHEMA_OBJ.NAME AND A.SCHEMA=KU$.SCHEMA_OBJ.OWNER_NAME) ' ||
 'AND NOT EXISTS (SELECT 1 FROM :1 A WHERE A.OBJ_TYPE=''SCHEMA'' ' ||
 'AND (A.NAME=KU$.BASE_OBJ.OWNER_NAME OR A.NAME=KU$.SCHEMA_OBJ.OWNER_NAME)) ',
 NULL);

insert into metaxslparam$ (model, transform, type, param,
                           default_val, properties, parse_attr,
                           datatype, lower_bound, upper_bound) values
 ('ORACLE','PARSE','INDEX_OBJNUM','PRS_OBJNUM','0',0,
    'KU$.OBJ_NUM',NULL,NULL,NULL);

--------------------------------------------------------------
-- Populate metaxslparamdesc$: This table stores the descriptions
-- of transform parameters and parse items.
-- flags:
--   0x001 = internal transform parameter, not documented for users
--   0x002 = parse item for ALTER_XML  
--   0x004 = parse item returned by FETCH_XML_CLOB  
--   0x008 = parse item returned by CONVERT and FETCH_DDL  
--

insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','BASE_PARTITION_NAME',1,
  'Base partition for index partition selected for the transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','BASE_SUBPARTITION_NAME',1,
  'Base subpartition for index subpartition selected for the transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','BODY',0,
  'Include type or package body in DDL');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','CM_MODE',1,
  'Generate syntax for Oracle Change Manager');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','CONNECT_PROCEDURE',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','CONSTRAINTS',0,
  'Include nonreferential table constraints in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','CONSTRAINTS_AS_ALTER',0,
  'Include table constraints as separate ALTER TABLE statements');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','CONVERT_TSTZ_COLS',1,
  'Use ORA_DST_CONVERT(SYS_ET_BLOB_TO_IMAGE()) when importing ' ||
  'VARRAY BLOB columns with external tables');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','CURRENT_SCHEMA',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DATA_LAYER_NOT_NETWORK',1,
  'SXML transform from data layer -- datapump non-network mode');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DATAOBJ_NUM',1,
  'dataobj# of (sub)partition to fetch over db link -- datapump network mode');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DBA',1,
  'If TRUE, use privileged interface');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DBLINK',1,
  '** UNSUPPORTED ** -- originally for logical standby');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DISABLE_ARCHIVE_LOGGING',1,
  'Generate ALTER TABLE NOLOGGING');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DML_ERROR_LOGGING_CLAUSE',1,
  'DML error logging clause for external table import');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DPAPIVERSION',1,
  'Direct path API version in stream metadata');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DROP',1,
  'Drop external table at end of operation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','DUMMY',1,
  'Dummy parameter for transforms with no real parameters');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','EMIT_SCHEMA',1,
  'Include schema when referencing schema objects');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','ENCRYPTION_PASSWORD',1,
  'Password to use for external table (un)load of encrypted column');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','EXPORT',1,
  'Emit datapump-specific syntax');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','EXT_TABLE_CLAUSE',1,
  'Text to emit following ORGANIZATION EXTERNAL');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','EXT_TABLE_NAME',1,
  'Name of external table (defaults to ET$ + obj#)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','EXT_TABLE_SCHEMA',1,
  'Schema of external table');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','FORCE',0,
  'Use the FORCE keyword in the CREATE VIEW statement ' ||
  'or in call to dbms_xmlschema.registerSchema');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','FORCE_LOB_BE',1,
  'Make lob in stream metadata appear big-endian');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','FORCE_NO_ENCRYPT',1,
  'Clear encryption bits in column property in stream metadata');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','FORCE_UNIQUE',1,
  'Generate unique names for nested tables when remapping table name');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','FORCE_VIRTUAL_COLUMNS',1,
  'Force generation of virtual column definitions in datapump operation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','GEN_BEAN',1,
  'Value of genbean parameter in call to dbms_xmlschema.registerSchema');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','GEN_TABLES',1,
  'Value of gentables parameter in call to dbms_xmlschema.registerSchema');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','GEN_TYPES',1,
  'Value of gentypes parameter in call to dbms_xmlschema.registerSchema');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','HIDDEN_COLUMNS',1,
  'Create unique name for nested table setid column ' || 
  '(instead of system generated name) -- used by datapump data layer');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','IND_SPARE4',1,
  'Specify a new value for the PARAMETERS clause in an INDEX_T XML ' ||
  'document (the parameters are stored in ind$.spare4)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','INDEX_BY_NAME',1,
  'When adding primary/unique constraint specify index name in USING INDEX');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','INDEX_COMPRESSION_CLAUSE',0,
  'Text of user-specified index compression clause');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','INMEMORY',1,
  'Generate INMEMORY clause for in-memory columnar support');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','INMEMORY_CLAUSE',1,
  'Text of INMEMORY clause for in-memory columnar support');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','INSERT',1,
  '** UNSUPPORTED ** -- originally for logical standby');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','INSERTNULLS',1,
  'Build an insert statement whose VALUES clause contains all NULL values' ||
  ' - used by kupd$data.fetch_insert_stmt');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','IN_TSNUM',1,
  'Value of TRANSPORTABLE for views as tables');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','LOB_SEGNAME',1,
  'Emit lob segment name as part of lob description');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','LOB_STORAGE',0,
  'Storage keyword for LOB columns: SECUREFILE, BASICFILE, ' ||
  'DEFAULT (suppress keyword and take default), ' ||
  'NO_CHANGE (use value in XML document)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','LOCK_STATS',1,
  'Call DBMS_STATS.LOCK_TABLE_STATS if table stats were previously locked');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','LRG',1,
  'Generate syntax needed for regression tests');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','MATERIALIZED_ZONEMAP',0,
  'Include MATERIALIZED ZONEMAP clause in DDL transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','INCLUDE_PARTITIONS',0,
  'Include generated interval and list partitions in DDL transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','NETWORK_LINK',1,
  'DB link when loading table from network');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','NETWORK_NAME',1,
  'Remote table name when loading table from network');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','NETWORK_SCHEMA',1,
  'Schema of remote table when loading table from network');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','NULL_CONSTRAINTS',1,
  'Emit NULL constraint');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OBJECT_ROW',1,
  'Copy only this specify row to the output doc');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OID',0,
  'Include OID clause in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OLDEXPORT',1,
  'Generate SQL for original export');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OMIT_COL_DATATYPE',1,
  'Omit the column datatype when generating a CREATE TABLE ddl');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','ONLINE_REDEF',1,
  'For PK/UK constraint omit the CREATE UNIQUE INDEX syntax (this param ' ||
  ' used by online redefinition)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OPERATION_TYPE',1,
  'Type of DDL operation: ' ||
  'CREATE (create an internal database table), ' ||
  'EXPORT (unload data for export using external tables), ' ||
  'IMPORT (load data for import using external tables), ' ||
  'IMPORT_CONVENTIONAL (load data for import with conventional path load), ' ||
  'NETWORK (load data from remote database for import)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OVERRIDE_CHARLENGTH',1,
  'Maximum width (in bytes) of character in OVERRIDE_CHARSET');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OVERRIDE_CHARSET',1,
  'Character set ID for all character/clob columns');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OVERRIDE_CHARSETNAME',1,
  'Character set name for all character/clob columns');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OVERRIDE_NCHARSET',1,
  'Character set ID for all national character/clob columns');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OVERRIDE_NCHARSETNAME',1,
  'Character set name for all national character/clob columns');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PARALLEL',1,
  'User-specified PARALLEL value');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PARALLEL_HINT',1,
  'Value of PARALLEL hint in INSERT statement');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PARSE_ALTER',1,
  'Internal: used by diff/alter to detect columns that are not alterable ' ||
  'because referenced within a virtual column or functional index expression');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PARSE_EXPRESSIONS',0,
  'Get parsed SXML for view query, functional index expression ' ||
  'or check constraint condition');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PARTITIONING',0,
  'Include partitioning clauses in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PARTITIONS_BY_QUANTITY',0,
  'Generate hash partitioning by quantity syntax');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PARTITION_NAME',0,
  'Name of partition selected for the transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PCTSPACE',0,
  'Percentage by which space allocation is to be modified');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PHYSICAL_PROPERTIES',0,
  'Include physical properties in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRESERVE_LOCAL',0,
  'Preserve the LOCAL keyword for locally partitioned indexes when ' ||
  'PARTITIONING is set false');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRESERVE_TYPE_EVOLUTION',1,
  'Break up the ALTER TYPE subclauses of the CREATE TYPE source lines ' ||
  'into separately executable commands');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRETTY',0,
  'Format the output with indentation and line feeds');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ALTERABLE',2,
  'Reason why difference cannot be altered');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ALT_CONNECT_TYPE',1+8,
  'Connect required for operation: HARD, SOFT or NONE (datapump only)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ANC_OBJECT_NAME',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ANC_OBJECT_SCHEMA',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ANC_OBJECT_TYPE',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BASE_IND_FLAGS',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BASE_IND_PROPERTY',1+4,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BASE_OBJECT_NAME',4+8,
  'Name of the base object');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BASE_OBJECT_SCHEMA',4+8,
  'Schema of the base object');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BASE_OBJECT_TYPE',4+8,
  'Object type of the base object');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BIND_PATTERN',1+8,
  '(internal) Bind variables must be passed in. This is a private ' ||
  'handshake between the worker and the mdapi');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BITMAPPED',1+4,
  'Unit size of bitmapped tablespace in blocks');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_BYTES_ALLOCATED',1+4,
  'Total number of bytes allocated for table or (sub)partition');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_CLAUSE_TYPE',2,
  'Type of modification clause, e.g., ADD_PARTITION');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_COLUMN_ATTRIBUTE',2,
  'Column attribute being modified, e.g., CACHE');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_CONSTRAINT_STATE',2,
  'Constraint state');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_CONSTRAINT_TYPE',2,
  'Constraint type: PRIMARY, FOREIGN, UNIQUE, CHECK, SCOPE');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_CREATION_TIME',1+4,
  'obj$.ctime');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DATAOBJ_NUM',1+4,
  'dataobj# of table or (sub)partition');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DBLAPWX',1+8,
  'Value of AUTHPWDX for data base link');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DBLPWX',1+8,
  'Value of PASSWORDX for data base link');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DDL',1,
  '(internal) DDL generated for object');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DELIM',1,
  '(internal) character string used to delimit parse item names and values');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DEPOBJNUM',1+4,
  '(internal) obj# of object this object is dependent on');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DROPCOLCOUNT',1+8,
  'Count of columns in dumpfile table not present in preexisting table');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_DROPCOLNAME',1+8,
  'Names of columns in dumpfile table not present in preexisting table');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ENABLE',4+8,
  'ENABLE if the trigger is enabled; DISABLE otherwise');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ET_PARALLEL',1+4,
  '1 = can do ET parallel unload; 0 = cannot');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_FLAGS',1+4,
  'ts$.flags');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_GRANTEE',4+8,
  'The grantee, if any');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_GRANTOR',4+8,
  'The grantor, if any');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAKAN',1+4,
  'tab$.spare1 - used to store hakan_kqldtvc');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAS_FGAC',1+4,
  'non-0 = FGAC enabled');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAS_LONG_COL',1+4,
  'Y = table has long or long raw column');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAS_NFT_VARRAY',1+4,
  'Y = table has varray with embedded non final type');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAS_NONSCOPED_REF',1+4,
  'Y = table has non-scoped ref column');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAS_TSTZ_COLS',1+4+8,
  'Y = table has data of type DTYSTZ "TIMESTAMP WITH TIME ZONE"');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAS_VIRTUAL_COLUMNS',1+8,
  'String of Y = table has virtual columns');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HAS_XMLSCHEMA_COLS',1+4,
  'Y = table has xmlschema-based columns');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_READ_ONLY',1+4,
  'Y = table data is read only');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_HIERARCY_ENABLE',1+4,
  'Y = table is xml hierarchy enabled');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_IND_FLAGS',1+4,
  'ind$.flags');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_IND_SPARE4',1,
  'ind$.spare4 - this is where the PARAMETERS clause for an XML index ' ||
  'is stored');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_LAST_DDL_TIME',1+4,
  'obj$.mtime');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_LEVEL',1+4,
  'exppkgact$.level#');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_LOCAL',1+4,
  'flags: 0x01 = local, 0x02 = stored as binary (from dba_xml_schemas)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_LONGNAME',4,
  'Object longname if it exists, otherwise object name');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_LONG_POSITION',1+8,
  'Position of long column');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_MARKER',1+4,
  'Marker type');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_NAME',2+4+8,
  'Object name');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_NESTED_COLUMNS',1+4,
  'Y = has tested-TABLE columns, N = does not');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_NESTED_TAB_NAME',1+4,
  'Nested table name');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_NO_TABLE_LOCK',1+8,
  'Y = table lock is disabled');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_READ_ONLY_TABLE',1+8,
  'Y = table is read only');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_OBJECT_TYPE',4+8,
  'Object type');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_OBJNUM',1+4,
  'obj# of object');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_OBJNUM_NAME',1+4,
  'T = base table, N = nested table, ' ||
  'X = nested table belonging to XMLtype');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_OPTION_TAG',1+4,
  'Unique tag for the option (from ku$_option_objnum_view)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PARENT_OBJECT_NAME',1+4,
  'Name of parent object (if refpar child)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PARENT_OBJECT_SCHEMA',1+4,
  'Schema of parent object (if refpar child)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PARTITION_NAME',1+4,
  'Partition name');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PARTITION_TYPE',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PARTTYPE',1+4,
  'partobj$.parttype: 1 = range, 2 = hash, 3 = system 4 = List, 5 = Ref');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PKG_NAME',1+4,
  'exppkgact$.package');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PKG_SCHEMA',1+4,
  'exppkgact$.schema');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PROPERTY',1+4,
  'tab$.property or ind$.property');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_OBJ_FLAGS',1+4,
  'obj$.flags');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PROXY_SCHEMA',1+4,
  'for downgrade export of import procedural object, schema of view to query');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_PROXY_VIEW',1+4,
  'for downgrade export of import procedural object, name of view to query');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_REFPAR_LEVEL',1+4,
  'Reference partition level');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ROW',1+8,
  '1-based row number of object in XML document');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_ROW_LEVEL_SECURITY',1+4,
  'Y = table has row-level security policy; N = does not');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_SCHEMA',4+8,
  'Object schema, if any');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_SCHEMAOID',1+4,
  'Schema OID of XML schema');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_SCHEMA_LEVEL',1+4,
  'Depth of dependence on other xml schemas');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_SECONDARY',1+4,
  'Y = secondary object');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_SEQ_IN_DEFAULT',1+4,
  'non-null = table has column with default expression containing a sequence');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_SQLVALID',1+8,
  '1 = valid SQL statement can be generated; ' ||
  '100 = stream version not valid; ' ||
  '101 = no columns match between source and target tables');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_SYSTEM_GENERATED',4+8,
  'Y = system-generated object; N = not system-generated');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TABLESPACE',4+8,
  'Object tablespace (default tablespace for partitioned objects)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TABLE_NAME',1+4,
  'Table name');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TEMPLATE_TABLE',1+8,
  'Name of the template table for a view-as-table');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TRIGFLAG',1+4,
  'tab$.trigflag');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TS_NUM',1+4,
  'ts# for pluggable tablespace');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TYPE',1+4,
  'Type of table_data object: TABLE, PARTITION, SUBPARTITION, ' ||
  'NESTED TABLE, NESTED PARTITION');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TYPE_ALTER_TYPE_CNT',1+8,
  'Number of ALTER TYPE subclauses in the CREATE TYPE');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_LENGTH_SEMANTICS',1+8,
  'String length semantics of the object');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_TYPE_NUM',1+4,
  'ind$.type#: 1 = normal, 2 = bitmap, 3 = cluster, 4 = iot-top, ' ||
  '5 = iot - nested, 6 = secondary, 7 = ansi, 8 = lob, 9 = domain');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_UNLOAD_METHOD',1+4,
  'unload method: 1 = prefer_direct, 4 = require_external');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_UNPACKEDCOL_COUNT',1+8,
  'Number of columns belonging to an unpacked AnyData type column');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_UNPACKEDCOL_LIST',1+8,
  'Source and targer names of columns belonging to ' || 
  'an unpacked AnyData type column');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_UNSUPPORTED_OBJECT',1+4,
  '1 = index has no columns; not supported');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_VERB',8,
  'SQL verb');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_XMLTYPE_FMTS',1+4,
  'formats of XMLType columns: 0x01=CLOB; 0x02=BLOB');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_XPATH',2,
  'XPath of element in SXML diff document');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','QUERY',1,
  'Query to use in external table or network query');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','QUERY_ORDER_BY',1,
  'ORDER BY-clause in Query to use in external table or network query');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','QUERY_WHERE',1,
  'WHERE-clause in Query to use in external table or network query');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REF_CONSTRAINTS',0,
  'Include referential (foreign key) constraints in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REGEN_DEFN',0,
  'TRUE = regenerate type definition from dictionary metadata');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_COLUMN_NAME',1,
  'Used for REMAP_DATA: insert REMAP_COLUMN_NAME element');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_COLUMN_NAME_SCHEMA',1,
  'Schema of table whose column is to be remapped (editioning views)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_COLUMN_NAME_TABLE',1,
  'Name of table whose column is to be remapped (editioning views)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_CONSTRAINT_NAME',1,
  'Remap constraint name (in table) from old to new');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_DATAFILE',0,
  'Remap datafile names from old to new');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_DIRECTORY',0,
  'Remap datafile paths from old to new');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_IND_TABLESPACE',1,
  'Remap IND/TS_NAME');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_LOB_TABLESPACE',1,
  'Remap PLOBMD_DEFTS_NAME');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_NAME',0,
  'Remap object names from old to new');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_PART_TABLESPACE',1,
  'Remap PARTOBJ/DEFTS_NAME');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_SCHEMA',0,
  'Remap schema names, grantee names, and user names from old to new');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_SPART_TABLESPACE',1,
  'Remap COMPART_LIST_ITEM/DEFTS_NAME');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_TABLESPACE',0,
  'Remap tablespace names from old to new');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_TABLE_TABLESPACE',1,
  'Remap TABLE/TS_NAME');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_TRG_SCHEMA',1,
  'TRUE = REMAP_SCHEMA specified; use new schema in trigger definition');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REMAP_TYPE_NAME',1,
  'Remap TYPE_NAME from old to new');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','RESET_PARALLEL',1,
  'Generate ALTER INDEX to reset PARALLEL to value in XML document');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','RESTORE_ARCHIVE_LOGGING',1,
  'Generate ALTER TABLE to restore logging to original state');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REUSE',0,
  'Include REUSE parameter for tablespace datafiles');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','REVOKE_FROM',0,
  'User from whom role must be revoked');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SAMPLE',1,
  'SAMPLE value to use when fetching data for external table ' ||
  'or remote operation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SCN',1,
  'SCN to use in AS OF SCN clause in external table or remote operation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SEGMENT_ATTRIBUTES',0,
  'Include segment attribute clauses (physical attributes, ' || 
  'storage attributes, tablespace, logging) in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SHARING_CLAUSE',0,
  'Sharing clause for common objects, keywords '||
  'NONE, METADATA, DATA, EXTENDED_DATA, NO_SHARING');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','CON_TYPE',1,
  'Container type being imported');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SEGMENT_CREATION',1,
  'Generate SEGMENT CREATION syntax');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SIZE_BYTE_KEYWORD',0,
  'Include the BYTE keyword as part of the size specification ' ||
  'for CHAR and VARCHAR2 columns that use byte semantics');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SOURCE_VERSION',1,
  'Source database version');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SPECIFICATION',0,
  'Include type or package specification in DDL');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SQLFILE',1,
  '** UNSUPPORTED **');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SQLTERMINATOR',0,
  'Append a SQL terminator to each SQL statement');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','START_WITH',1,
  'Value of START WITH');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','STAT_SCHEMA',1,
  'Schema for table for table stats');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','STAT_TABLE',1,
  'Name of table for table stats');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','STORAGE',0,
  'Include storage clauses in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','STREAMD_VERSION',1,
  'Stream metadata version (used by data layer)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','SUBPARTITION_NAME',0,
  'Name of subpartition selected for the transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TABLESPACE',0,
  'Include tablespace clauses in transformation');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TABLE_COMPRESSION',1,
  'Include table compression clause');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TABLE_COMPRESSION_CLAUSE',0,
  'Value of table compression clause or NONE');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TARGET_TABLE_NAME',1,
  'Name of target table for external table import');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TARGET_TABLE_SCHEMA',1,
  'Schema of target table for external table import');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TO_LOGICAL',1,
  '1 = convert column references from physical to logical; ' ||
  '0 = convert from logical to physical');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TRANSPORTABLE',1,
  'Generate syntax for transportable import');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TRANSPORTABLE_CLASSIC',1,
  'Generate transportable syntax for original exp/imp');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','UNIQUE_NAME',1,
  'Unique identifier for datapump job - to generate unique object names');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','UPGRADE_V10_XMLTYPE',1,
  'Dumpfile with V10.x xmlstype column fix: generate appropriate syntax');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','USE_DML_APPEND_HINT',1,
  ' Use APPEND hint in external table INSERT statements for import');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','USE_DATA_VALIDATE_HINT',1,
  ' Use DATA_VALIDATE hint in external table SELECT statements for import');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','USING_INDEX',0,
  'Include USING INDEX clause');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','VERSION',0,
  'Version for which the output is generated');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','VIEW_AS_TABLE',1,
  'Insert VIEW_AS_TABLE element in document');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','WILL_MAKE_TBS_RW',1,
  'Use undocumented TSTZ syntax in CREATE TABLE statement ' ||
  '(worker will fix up later)');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','WITH_FUNCTION',1,
  'With function used on create table for sharded table loading');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','WITH_FUNCTION_QUERY',1,
  'Query referencing the "with function" for sharded table loading');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','XMLTYPE_STREAM_FORMAT',1,
  'Format of XMLType columns in stream, either CLOB or BLOB');
-- dbms_redefinition interim tables can not be queue tables.
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','OMIT_AQ_CLAUSE',1,
  'Remove QUEUE_TABLE designation on table redefinitions ');
-- ChangeManager specific transform parameters - only in place for
-- testing.
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','STATISTICS',1,
  'ChangeManager specific transform parameters - not used by Data Pump');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','XMLXVM_TRANSFORM_ENGINE',1,
  'Use XmlXvm transformation engine when set to TRUE');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','COLLATION_CLAUSE',0,
  'Keyword values ALWAYS, NEVER, NON_DEFAULT control when collation clause ' ||
  'is included in DDL');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','ENABLE_COLLATION',1,
  'Enable databound collation when max_string_size is set to extended');
-- bug 21764718 - transform param and parse item
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','TEN_G_LOGON_ALLOWED',1,
  'Allow 10g style verifiers');
insert into metaxslparamdesc$ (model, param, flags, description) values
 ('ORACLE','PRS_USER_DISABLED',1+8, 
  'Returns ''USER_DISABLED=1'' if the generated DDL was modified to ' ||
  'create the user as LOCKED with the PASSWORD EXPIRED');

-- Populate metastylesheet: This table actually stores the XSL stylesheets,
-- one row per. The CLOB column is loaded later during install / upgrade from
-- files via routine dbms_metadata_util.load_stylesheets, but it must be loaded
-- here with some dummy text so that the LOB locator won't be NULL.

-- For maintainability's sake, try to keep these in alphabetical order:
-- DDL stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('kualter','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuassoc','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuauddef','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuaudit','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuaudobj','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kubody','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuclus','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuclzm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kucolumn','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kucoment','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kucommon','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuconstr','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuconsum','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuctx','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudblink','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudefrol','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudimen','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudir','ORACLE','not initialized');
rem
rem bug 6938028: Database Vault Protected Schema. This is the second
rem place where the XSLT stylesheet must be registered for each type.
rem
rem Stylesheet location                        Type name
rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
rem $SRCHOME/rdbms/xml/xsl/kudvrlm.xsl         DVPS_REALM
rem $SRCHOME/rdbms/xml/xsl/kudvrlmm.xsl        DVPS_REALM_MEMBERSHIP
rem $SRCHOME/rdbms/xml/xsl/kudvrlma.xsl        DVPS_REALM_AUTHORIZATION
rem $SRCHOME/rdbms/xml/xsl/kudvsta.xsl         DVPS_IMPORT_STAGING_REALM
rem $SRCHOME/rdbms/xml/xsl/kudvstam.xsl        DVPS_STAGING_REALM_MEMBERSHIP
rem $SRCHOME/rdbms/xml/xsl/kudvstad.xsl        DVPS_DROP_IMPORT_STAGING_REALM
rem $SRCHOME/rdbms/xml/xsl/kudvrul.xsl         DVPS_RULE
rem $SRCHOME/rdbms/xml/xsl/kudvruls.xsl        DVPS_RULE_SET
rem $SRCHOME/rdbms/xml/xsl/kudvrsm.xsl         DVPS_RULE_SET_MEMBERSHIP
rem $SRCHOME/rdbms/xml/xsl/kudvcr.xsl          DVPS_COMMAND_RULE
rem $SRCHOME/rdbms/xml/xsl/kudvcralts.xsl      DVPS_COMMAND_RULE_ALTS
rem $SRCHOME/rdbms/xml/xsl/kudvrol.xsl         DVPS_ROLE
rem $SRCHOME/rdbms/xml/xsl/kudvf.xsl           DVPS_FACTOR
rem $SRCHOME/rdbms/xml/xsl/kudvfl.xsl          DVPS_FACTOR_LINK
rem $SRCHOME/rdbms/xml/xsl/kudvft.xsl          DVPS_FACTOR_TYPE
rem $SRCHOME/rdbms/xml/xsl/kudvid.xsl          DVPS_IDENTITY
rem $SRCHOME/rdbms/xml/xsl/kudvidm.xsl         DVPS_IDENTITY_MAP
rem $SRCHOME/rdbms/xml/xsl/kudvpol.xsl         DVPS_DV_POLICY
rem $SRCHOME/rdbms/xml/xsl/kudvpolobjr.xsl     DVPS_DV_POLICY_OBJ_R
rem $SRCHOME/rdbms/xml/xsl/kudvpolobjc.xsl     DVPS_DV_POLICY_OBJ_C
rem $SRCHOME/rdbms/xml/xsl/kudvpolobjcalts.xsl DVPS_DV_POLICY_OBJ_C_ALTS
rem $SRCHOME/rdbms/xml/xsl/kudvpolowner.xsl    DVPS_DV_POLICY_OWNER
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_DP_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_TTS_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_JOB_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_PROXY_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_DDL_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_PREP_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_MAINT_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_ORADEBUG_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_ACCTS_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_AUTH_DIAG_T
rem $SRCHOME/rdbms/xml/xsl/kudvauth.xsl        DVPS_DV_INDEX_FUNC_T
rem
insert into metastylesheet (name, model, stylesheet) values
        ('kudvrlm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvrlmm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvrlma','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvsta','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvstam','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvstad','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvrul','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvruls','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvrsm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvcr','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvcralts','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvrol','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvf','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvfl','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvft','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvid','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvidm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvpol','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvpolobjr','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvpolobjc','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvpolobjcalts','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvpolowner','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kudvauth','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuexttbl','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kufga','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kufull','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kugrant','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuiconsu','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuidxtyp','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuidxwrk','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuilm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuindex','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuiot','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kucot','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kujava','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kujob','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kujvsrc','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuhier','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kulib','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kulob','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumodcom','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumoddf','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumodrbs','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumodtab','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumodts','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumodusr','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumonitr','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumview','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kumviewl','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuntab','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuobjtbl','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuoper','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuoutln','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kupdiret','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuplan','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kupostab','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kupostdt','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuproc','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuprocoj','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuprofil','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuproxy','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuprscom','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuprsso','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuprtobj','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kupswhis','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuqtrans','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuquetab','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuqueues','ORACLE','not initialized');
rem 12c project 32006: RADM
rem This is the second place where the XSLT stylesheet must be registered
rem for each type.
rem stylesheet location                 xmltag
rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
rem $SRCHOME/rdbms/xml/xsl/kuradmp.xsl  RADM_POLICY_T
rem $SRCHOME/rdbms/xml/xsl/kuradmf.xsl  RADM_FPTM_T
insert into metastylesheet (name, model, stylesheet) values
        ('kuradmp','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuradmf','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kurefgrp','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kurescos','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kurls','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kurole','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kurolegr','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kurollbk','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuseq','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusource','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustat','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustat2','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustorag','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusyn','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutabcon','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutable','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutblspc','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutrig','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutrlink','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutsquo','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutypspc','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuuser','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuview','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuxmlsch','ORACLE','not initialized');
-- Triton Security stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('kutsuser','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutsrole','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutsroleset','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutssclass','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutsdsec','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutsacl','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kutsnspace','ORACLE','not initialized');

-- SXML and SXMLDDL stylesheets
-- For maintainability's sake, try to keep these in alphabetical order:

insert into metastylesheet (name, model, stylesheet) values
        ('kuemodtb','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuetable','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusclus', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusclusd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusclzm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuscnstd','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuscnstr','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuscomm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuscommd','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusctx', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusctxd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusdblk', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusdblkd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusfga', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusfgad', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusidxwd','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusidxwk','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusilm','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusilmd','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusindex','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusindxd','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusmv', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusmvd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusmvl', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusmvld', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuspar','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuspard','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusparsd','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusque', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusqued', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusqtab', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusqtabd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusrls', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusrlsd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusrole', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusroled', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusseq', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusseqd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusstorg','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kussyn', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kussynd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustabld','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustable','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustbphd','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustbphy','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustbls', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustblsd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustrig', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustrigd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustype', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustyped', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kususer', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kususerd', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusview', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusviewd', 'ORACLE', 'not initialized');

-- generate by the build:
insert into metastylesheet (name, model, stylesheet) values
        ('kuscommcx', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kusparsdx', 'ORACLE', 'not initialized');

-- EDITIONING_VIEW or MODIFYSXML stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('kusmodtb', 'ORACLE', 'not initialized');

-- common alterxml stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('kuacomm', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuscommc', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustablc', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kustrigc', 'ORACLE', 'not initialized');
-- object type specific alterxml stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('kuaclus', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuacnstr', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuaindex', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kualob', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuamv', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuamvl', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuarole', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuaque', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuaqtab', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuarls', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuaseq', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuasyn', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuatable', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuatbls', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuatcol', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuatpar', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuatprop', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuatrig', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuatype', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuauser', 'ORACLE', 'not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('kuaview', 'ORACLE', 'not initialized');

-- alterddl stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('kuaddl', 'ORACLE', 'not initialized');

-- replication stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('knfcf1','ORACLE','not initialized');
insert into metastylesheet (name, model, stylesheet) values
        ('knfcf2','ORACLE','not initialized');

-- online redefinition stylesheets
insert into metastylesheet (name, model, stylesheet) values
        ('knredef1','ORACLE','not initialized');

-- View for partition object (partition transportable for sharding)
--  this is used for 'move chunk' in sharing, types and views include 'P2T'
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('PARTITION',      1,0,'ORACLE',1202000000,
        'TABLE_T','KU$_PARTITION_T','SYS','KU$_PARTITION_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('PARTITION',      2,0,'ORACLE',1202000000,
        'TABLE_T','KU$_PARTITION_T','SYS','KU$_SUBPARTITION_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('INDEX_PARTITION',1,0,'ORACLE',1202000000,
        'INDEX_T','KU$_INDEX_PARTITION_T','SYS','KU$_INDEX_PARTITION_VIEW');
insert into metaview$ (type, flags, properties, model, version, xmltag,
                       udt, schema, viewname) values
       ('INDEX_PARTITION',2,0,'ORACLE',1202000000,
        'INDEX_T','KU$_INDEX_PARTITION_T','SYS','KU$_INDEX_SUBPARTITION_VIEW');

-- Partition object filters
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('RECYCLED', 'PARTITION', 'ORACLE', 9, 0, 'BITAND(KU$.SCHEMA_OBJ.FLAGS,128)!=0', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE', 'PARTITION', 'ORACLE', 0, 0,'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TABLESPACE_EXPR', 'PARTITION', 'ORACLE', 2, 0,'TS_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'PARTITION', 'ORACLE', 0, 0,
  'TABPART.SCHEMA_OBJ.NAME||''_''||KU$.TABPART.SCHEMA_OBJ.SUBNAME',
  NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME_EXPR', 'PARTITION', 'ORACLE',2, 0,'TABPART.SCHEMA_OBJ.SUBNAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('BASE_OBJECT_NAME', 'PARTITION', 'ORACLE', 0, 0,
  'TABPART.SCHEMA_OBJ.NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA', 'PARTITION', 'ORACLE',0,0,'TABPART.SCHEMA_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('SCHEMA_EXPR', 'PARTITION', 'ORACLE',2,0,'TABPART.SCHEMA_OBJ.OWNER_NAME', NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('ORDERED', 'PARTITION', 'ORACLE', 1+8+128, 0,
  'KU$.REFPAR_LEVEL', 0);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('TOTAL_ORDER', 'PARTITION', 'ORACLE', 1+8+256, 0,
  'KU$.SCHEMA_OBJ.OWNER_NAME,KU$.SCHEMA_OBJ.NAME,KU$.TABPART.SCHEMA_OBJ.SUBNAME', 0);

-- Index Partition object filters
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrname, default_val) values
 ('NAME', 'INDEX_PARTITION', 'ORACLE', 4096, 0, 'SCHEMA_OBJ.NAME',NULL);
insert into metafilter$ (filter, type, model, properties, view_attr,
                         attrna