Rem
Rem $Header: javavm/ojvmwcu/install/load_ojvmwcu.sql /main/4 2015/12/27 19:52:22 kdere Exp $
Rem
Rem load_ojvmwcu.sql
Rem
Rem Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      load_ojvmwcu.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: javavm/ojvmwcu/load_ojvmwcu.sql 
Rem    SQL_SHIPPED_FILE: 
Rem    SQL_PHASE: 
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: 
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kdere       11/19/15 - Remove Version number
Rem    kdere       11/02/15 - Removing annotation jar
Rem    kdere       08/13/15 - Created
Rem

create or replace package ojvmwcu_install authid current_user as
 procedure require_sys;
 procedure load_ojvmwcu;
end ojvmwcu_install;
/ 

create or replace package body ojvmwcu_install as

procedure require_sys as
begin
  if login_user != 'SYS' then
    declare
      foo exception;
      pragma exception_init(foo,-1031);
    begin
      raise foo;
    end;
  end if;
end;

procedure load_ojvmwcu as
  verifier_status number;
  trash varchar2(300) := dbms_java.endsession_and_related_state;
begin
  require_sys;
  verifier_status := dbms_java.option_controller(2,3);
  begin
    ojvmwcu_sys.load_jar( 'ojvmwcu-security.jar' );   
    ojvmwcu_sys.load_jar( 'jersey-guava-2.22.1.jar' );    
    ojvmwcu_sys.load_jar( 'javax.inject-2.4.0-b31.jar' );  
    ojvmwcu_sys.load_jar( 'hk2-utils-2.4.0-b31.jar' );    
    ojvmwcu_sys.load_jar( 'org.osgi.core-4.2.0.jar' );
    ojvmwcu_sys.load_jar( 'osgi-resource-locator-1.0.1.jar' );
    ojvmwcu_sys.load_jar( 'oracle-hk2.jar' );                 
    -- Try to remove this jar asm with trimmed source
    ojvmwcu_sys.load_jar( 'asm-debug-all-5.0.4.jar' );  
    ojvmwcu_sys.load_jar( 'oracle-jaxrs-ri.jar' );  
    ojvmwcu_sys.load_jar( 'javassist-3.18.1-GA.jar' );       
    ojvmwcu_sys.load_jar( 'aopalliance-repackaged-2.4.0-b31.jar' ); 
    if verifier_status = 1 then
       verifier_status := dbms_java.option_controller(2,2);
    end if;
  exception when others then
    if verifier_status = 1 then
       verifier_status := dbms_java.option_controller(2,2);
    end if;
    raise;
  end;
end;

end ojvmwcu_install;
/

call dbms_output.put_line('WCU: Loading Jersey jars'); 
call ojvmwcu_install.load_ojvmwcu();
call dbms_output.put_line('WCU: Done Loading Jersey jars'); 
