#!/bin/sh
umask 002
################################################################################
# Tool to list out the files that will be picked up by the component map files #
# Usage: filesList.sh -mapfile <component map filename> -slvfile <filename>    #
################################################################################

OUIHOME=`dirname $0`/..
OUICLASSPATH="$OUIHOME/jlib/filesList.jar:$OUIHOME/jlib/xmlparserv2.jar"
echo $OUICLASSPATH
ulimit -n 1024

if [ -z "$SRCHOME" ]; then
   SRCHOME=$OUIHOME/..
   echo $SRCHOME
fi

if [ -z "$JAVAHOME" ]; then
   JAVAHOME=$SRCHOME/jdk
fi

"$JAVAHOME/bin/java" -ss2M -oss20M -mx512M -Dosp.running.on=JAVA -Dosp.properties.file="$OUIHOME/bin/filesList.properties" -DSRCHOME="$SRCHOME" -classpath $OUICLASSPATH  FilesTool.BuildToolsFilesTool $@

EXITCODE=$?

exit $EXITCODE
