<?xml version="1.0"?>
<!--
 Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
	
	NAME
	rspfmt_ext2raw_transformer_v11_2_0.xsl - XSLT to transform external property based Database response file format to internal format
	
	DESCRIPTION
	<short description of component this file declares/defines>
	
	NOTES
	<other useful comments, qualifications, etc.>
	
	MODIFIED   (MM/DD/YY)
 	pkuruvad 08/22/12 - Removing old winsec properties
	pkuruvad 08/16/12 - changing win security parameter names
	pvallam  05/13/11 - adding proxy realm
	pvallam  04/26/11 - XbranchMerge pvallam_bug-11770204_11203 from
                     st_install_11.2.0
	pvallam  03/20/11 - removing mts bean property
	pvallam  03/20/11 - removing mts bean property
	gramamur 03/03/11 - Adding parameters related to Windows Secure Option
	gramamur 03/03/11 - Adding parameters related to Windows Secure Option
	rmallego 07/07/10 - modifying toValueList template to support curly braces
	rmallego 07/07/10 - modifying toValueList template to support curly braces
	dschrein 03/17/10 - add upgrade-related var
	dschrein 03/17/10 - add upgrade-related var
	pvallam  10/12/09 - updating for auto-updates options
	rochang  04/24/09 - Adding silent install for Scheduler Agent
	sangkuma 03/30/09 - Removing backward compatible code
	sangkuma 03/04/09 - Retaining the names of other OUI session variables
	sangkuma 02/22/09 - Changing oracle.install.*.ORACLE_* variables to
	ORACLE_*
	pvallam  09/17/08 - adding entry for mts port number
	jaikrish 07/28/08 - Changes for bug fix 7186623
	msubbann 05/12/08 - Take out ORACLE_HOME_NAME property
	sangkuma 03/12/08 - change the property name of
	oracle.install.OPERGroupNameUsed to
	UNIX_GROUP_NAME
	dschrein 03/03/08 - need customComponents
	dschrein 02/13/08 - creation
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
	<xsl:template match="properties">
		<beanstore>
			<ClientSetupBean>
				<ORACLE_HOSTNAME>
					<xsl:value-of select="ORACLE_HOSTNAME" />
				</ORACLE_HOSTNAME>
				<SELECTED_LANGUAGES>
					<xsl:call-template name="toValueList">
						<xsl:with-param name="stringList"
							select="SELECTED_LANGUAGES">
						</xsl:with-param>
					</xsl:call-template>
				</SELECTED_LANGUAGES>
				<CentralInventorySettings>
					<INVENTORY_LOCATION>
						<xsl:value-of select="INVENTORY_LOCATION" />
					</INVENTORY_LOCATION>
					<UNIX_GROUP_NAME>
						<xsl:value-of select="UNIX_GROUP_NAME" />
					</UNIX_GROUP_NAME>
				</CentralInventorySettings>
				<AutoUpdatesInstallSettings>
					<oracle_install_autoupdates_myOracleSupportCredentials>
						<oracle_install_autoupdates_myOracleSupportUserName>
							<xsl:value-of select="AUTOUPDATES_MYORACLESUPPORT_USERNAME"/>
						</oracle_install_autoupdates_myOracleSupportUserName>
						<oracle_install_autoupdates_myOracleSupportPassword>
							<xsl:value-of select="AUTOUPDATES_MYORACLESUPPORT_PASSWORD" />
						</oracle_install_autoupdates_myOracleSupportPassword>
					</oracle_install_autoupdates_myOracleSupportCredentials>
					<oracle_install_autoupdates_httpProxySettings>
						<oracle_install_autoupdates_httpProxyHost>
							<xsl:value-of select="PROXY_HOST" />
						</oracle_install_autoupdates_httpProxyHost>
						<oracle_install_autoupdates_httpProxyPort>
							<xsl:value-of select="PROXY_PORT" />
						</oracle_install_autoupdates_httpProxyPort>
						<oracle_install_autoupdates_httpProxyUser>
							<xsl:value-of select="PROXY_USER" />
						</oracle_install_autoupdates_httpProxyUser>
						<oracle_install_autoupdates_httpProxyPassword>
							<xsl:value-of select="PROXY_PWD" />
						</oracle_install_autoupdates_httpProxyPassword>
						<oracle_install_autoupdates_httpProxyRealm>
                                                        <xsl:value-of select="PROXY_REALM" />
                                                </oracle_install_autoupdates_httpProxyRealm>
					</oracle_install_autoupdates_httpProxySettings>
						<xsl:variable name="autoUpdatesOption"
						select="oracle.installer.autoupdates.option" />
					<oracle_install_autoupdates_option>
						<xsl:value-of select="$autoUpdatesOption" />
					</oracle_install_autoupdates_option>
					<xsl:variable name="autoUpdatesLoc"
						select="oracle.installer.autoupdates.downloadUpdatesLoc" />
					<oracle_install_autoupdates_downloadLoc>
						<xsl:value-of select="$autoUpdatesLoc" />
					</oracle_install_autoupdates_downloadLoc>
				</AutoUpdatesInstallSettings>
				<ClientInstallSettings>
					<ORACLE_HOME>
						<xsl:value-of select="ORACLE_HOME" />
					</ORACLE_HOME>
					<ORACLE_BASE>
						<xsl:value-of select="ORACLE_BASE" />
					</ORACLE_BASE>
					<INSTALL_TYPE>
						<xsl:value-of
							select="oracle.install.client.installType" />
					</INSTALL_TYPE>
					<oracle_install_client_CustomComponents>
						<xsl:call-template name="toValueList">
							<xsl:with-param name="stringList"
								select="oracle.install.client.customComponents">
							</xsl:with-param>
						</xsl:call-template>
					</oracle_install_client_CustomComponents>
					<oracle_install_client_SchedulerAgentHostName>
						<xsl:value-of
							select="oracle.install.client.schedulerAgentHostName" />
					</oracle_install_client_SchedulerAgentHostName>
					<oracle_install_client_SchedulerAgentPortNumber>
						<xsl:value-of
							select="oracle.install.client.schedulerAgentPortNumber" />
					</oracle_install_client_SchedulerAgentPortNumber>

					<RemoveHomes>false</RemoveHomes>
					<RESTART_REMOTE_SYSTEM>false</RESTART_REMOTE_SYSTEM>
					<RESTART_SYSTEM>false</RESTART_SYSTEM>
				</ClientInstallSettings>
				<WindowsSecureOptionSettings>
					<oracle_install_IsBuiltInAccount>
					        <xsl:value-of select="oracle.install.IsBuiltInAccount" />
					</oracle_install_IsBuiltInAccount>
					<oracle_install_OracleHomeUserName>
					        <xsl:value-of select="oracle.install.OracleHomeUserName" />
					</oracle_install_OracleHomeUserName>
					<oracle_install_OracleHomeUserPassword>
					        <xsl:value-of select="oracle.install.OracleHomeUserPassword" />
					</oracle_install_OracleHomeUserPassword>
				</WindowsSecureOptionSettings>
			</ClientSetupBean>
		</beanstore>
	</xsl:template>
	<xsl:template name="toValueList">
		<xsl:param name="stringList" />
		<xsl:if test="$stringList and string-length($stringList) > 0">
			<xsl:choose>
				<xsl:when test="contains($stringList, '{')">
					<xsl:call-template name="toValueList">
						<xsl:with-param name="stringList"
							select="substring-after($stringList,'{')" />
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="contains($stringList, ',')">
					<value>
						<xsl:value-of
							select="substring-before($stringList,',')" />
					</value>
					<xsl:call-template name="toValueList">
						<xsl:with-param name="stringList"
							select="substring-after($stringList,',')" />
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="contains($stringList, '}')">
					<value>
						<xsl:value-of select="substring-before($stringList,'}')" />
					</value>
				</xsl:when>
				<xsl:otherwise>
					<value>
						<xsl:value-of select="$stringList" />
					</value>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
