/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifd.OiifdInfoDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmInfo;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmSingleSelectPanelC
extends LWContainer
implements ItemListener,
ActionListener {
    private static final int INSETS = 2;
    private static final int NUM_VISIBLE = 10;
    private static final int MAX_RADIO_ITEMS = 10;
    private LWContainer m_selectPanel;
    private MultiLineLabel m_textLabel;
    private LWList m_list;
    private LWCheckbox[] m_radio;
    private LWCheckboxGroup m_radioButtonGroup;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private boolean m_isList;
    private OiifmInfo[] m_choices;
    private ItemListener m_itemListener;
    private ActionListener m_actnListener;
    private LWButton m_infoButton;
    private String m_sHelpID;
    private String m_sInfoTitleID;

    public OiifmSingleSelectPanelC(String message) {
        this.setLayout(new BorderLayout());
        this.m_textLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), message);
        this.m_textLabel.setPreferredAspectRatio(0.0f);
        this.m_textLabel.setFont(new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 1, 14));
        this.add((Component)this.m_textLabel, "North");
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(2, 2, 2, 0);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.anchor = 18;
        this.c.gridwidth = 0;
        this.m_selectPanel = new LWContainer();
        this.m_selectPanel.setLayout((LayoutManager)this.gridbag);
        this.add((Component)this.m_selectPanel, "Center");
        this.m_itemListener = null;
        this.m_actnListener = null;
        this.validate();
    }

    public OiifmSingleSelectPanelC(String message, OiifmInfo[] choices) {
        this(message);
        this.setChoices(choices);
    }

    public OiifmSingleSelectPanelC(String message, OiifmInfo[] choices, int defaultIndex) {
        this(message, choices);
        this.setSelection(defaultIndex);
    }

    public void setChoices(OiifmInfo[] choices) {
        this.removeChoices();
        this.m_choices = choices;
        if (this.m_choices != null) {
            if (this.m_choices.length >= 10) {
                this.addList();
            } else {
                this.addRadioButtons();
            }
        }
    }

    public void setInfoHelpID(String sHelpID) {
        this.m_sHelpID = sHelpID;
    }

    public void setInfoTitleID(String sTitleID) {
        this.m_sInfoTitleID = sTitleID;
    }

    public void forceListDisplay() {
        if (!this.m_isList) {
            OiifmInfo[] c = this.m_choices;
            this.removeChoices();
            this.m_choices = c;
            this.addList();
        }
    }

    private void addRadioButtons() {
        TextWrapper twrap = WordWrapper.getTextWrapper();
        Font smallfont = new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 0, 11);
        Font bigfont = new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 0, 14);
        int size = this.m_choices.length;
        this.m_isList = false;
        this.c.anchor = 18;
        this.c.fill = 1;
        this.c.insets.top = 0;
        this.c.insets.left = 0;
        this.c.insets.bottom = 2;
        this.m_radioButtonGroup = new LWCheckboxGroup();
        this.m_radio = new LWCheckbox[size];
        for (int i = 0; i < size; ++i) {
            String cname = this.m_choices[i].getDisplayName();
            String d = this.m_choices[i].desc == null ? "" : this.m_choices[i].desc.trim();
            this.m_radio[i] = new LWCheckbox(cname, this.m_radioButtonGroup, false);
            this.m_radio[i].setFont(bigfont);
            new LWLabel(d).setLabelFor((Component)this.m_radio[i]);
            this.c.insets.top = 2;
            this.c.insets.left = 0;
            this.c.insets.bottom = 0;
            this.c.weighty = 0.0;
            this.gridbag.setConstraints((Component)this.m_radio[i], this.c);
            this.m_radio[i].addItemListener((ItemListener)this);
            this.m_selectPanel.add((Component)this.m_radio[i]);
            if (d.length() > 0 || i == size - 1) {
                this.c.weightx = 1.0;
                this.c.insets.top = 0;
                this.c.insets.left = 16;
                this.c.insets.bottom = 8;
                this.c.gridwidth = 0;
                MultiLineLabel mulLabel = new MultiLineLabel(twrap, d);
                mulLabel.setPreferredAspectRatio(0.0f);
                mulLabel.setFont(smallfont);
                this.c.weighty = i == size - 1 ? 1.0 : 0.0;
                this.gridbag.setConstraints((Component)mulLabel, this.c);
                this.m_selectPanel.add((Component)mulLabel);
            }
            this.c.insets.top = 2;
            this.c.insets.left = 0;
            this.c.insets.bottom = 0;
        }
    }

    private void addList() {
        int size = this.m_choices.length;
        this.m_isList = true;
        this.c.weighty = 1.0;
        this.c.anchor = 18;
        this.c.fill = 1;
        this.m_list = new LWList(10, false);
        this.gridbag.setConstraints((Component)this.m_list, this.c);
        this.m_list.addItemListener((ItemListener)this);
        this.m_list.addActionListener((ActionListener)this);
        this.m_selectPanel.add((Component)this.m_list);
        for (int i = 0; i < size; ++i) {
            this.m_list.add(this.m_choices[i].getDisplayName());
        }
        this.m_infoButton = new LWButton(OiixResourceBundle.getString((String)"S_INFORMATION_SHORTFORM"));
        Font f = new Font(OiixResourceBundle.getString((String)"S_DEFAULT_FONT"), 1, 14);
        this.m_infoButton.setFont(f);
        this.m_infoButton.setToolTipValue(OiixResourceBundle.getString((String)"S_INFORMATION"));
        this.m_infoButton.addActionListener((ActionListener)this);
        LWContainer iPanel = new LWContainer();
        iPanel.setLayout((LayoutManager)new BorderLayout());
        iPanel.add((Component)this.m_infoButton, (Object)"South");
        this.add((Component)iPanel, "East");
    }

    private void removeChoices() {
        Component[] clist = this.m_selectPanel.getComponents();
        for (int i = 0; i < clist.length; ++i) {
            this.m_selectPanel.remove(clist[i]);
        }
        this.m_choices = null;
    }

    public OiifmInfo[] getChoices() {
        return this.m_choices;
    }

    public void setSelection(String selString) {
        int index = 0;
        if (this.m_isList) {
            String[] items = this.m_list.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].equals(selString)) continue;
                index = i;
                break;
            }
        } else if (this.m_radio != null) {
            for (int i = 0; i < this.m_radio.length; ++i) {
                if (!this.m_radio[i].getLabel().equals(selString)) continue;
                index = i;
                break;
            }
        }
        this.setSelection(index);
    }

    public void setSelection(int index) {
        if (this.m_isList) {
            this.m_list.select(index);
        } else if (this.m_radio != null && this.m_radio.length > index) {
            this.m_radioButtonGroup.setSelectedCheckbox(this.m_radio[index]);
        }
    }

    public String getSelection() {
        if (this.m_isList) {
            return this.m_list.getSelectedItem();
        }
        if (this.m_radio != null) {
            return this.m_radioButtonGroup.getSelectedCheckbox().getLabel();
        }
        return null;
    }

    public int getSelectionIndex() {
        LWCheckbox sel;
        if (this.m_isList) {
            return this.m_list.getSelectedIndex();
        }
        if (this.m_radio != null && (sel = this.m_radioButtonGroup.getSelectedCheckbox()) != null) {
            for (int i = 0; i < this.m_radio.length; ++i) {
                if (this.m_radio[i] != sel) continue;
                return i;
            }
        }
        return -1;
    }

    public String getPrompt() {
        return this.m_textLabel.getText();
    }

    public void setPrompt(String label) {
        this.m_textLabel.setText(label);
        this.invalidate();
        this.validate();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_itemListener = listener;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.m_actnListener = listener;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (this.m_itemListener != null) {
            this.m_itemListener.itemStateChanged(event);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.m_actnListener != null) {
            this.m_actnListener.actionPerformed(event);
        }
        Object source = event.getSource();
        OiifmCursorUtil.setCursor((int)3, (Component)((Object)this));
        if (source == this.m_infoButton) {
            OiifdInfoDlg infoDlg = new OiifdInfoDlg(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString((String)this.m_sInfoTitleID), this.m_choices[this.getSelectionIndex()], this.m_sHelpID);
            infoDlg.runAlert();
        }
        OiifmCursorUtil.setCursor((int)0, (Component)((Object)this));
        if (source == this.m_infoButton) {
            this.m_infoButton.requestFocus();
        }
    }
}

