/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oip.oipc.oipch.OipchRange;
import oracle.sysman.oip.oipc.oipch.OipchRangeSemantics;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class OipchBaseRangeList {
    protected List m_oRangeList = new ArrayList();

    public OipchBaseRangeList(NamedNodeMap oNodeAttribs) {
        this(oNodeAttribs, false);
    }

    public OipchBaseRangeList(NamedNodeMap oNodeAttribs, boolean ignoreValue) {
        int nNodeAttribs = oNodeAttribs.getLength();
        for (int i = 0; i < nNodeAttribs; ++i) {
            Node oAttrib = null;
            oAttrib = oNodeAttribs.item(i);
            if (oAttrib == null) continue;
            String sAttName = oAttrib.getNodeName();
            if (!ignoreValue && sAttName.equalsIgnoreCase("VALUE")) {
                sAttName = this.resolveValueAttribute();
            }
            if (!OipchRangeSemantics.isRangeAttribute(sAttName)) continue;
            String sAttValue = oAttrib.getNodeValue();
            String sInvAttName = this.resolveSemantic(sAttName);
            this.m_oRangeList.add(new OipchRange(sInvAttName, sAttValue));
        }
    }

    public Iterator getRangeList() {
        return this.m_oRangeList.iterator();
    }

    protected abstract String resolveSemantic(String var1);

    protected abstract String resolveValueAttribute();

    public String toString() {
        StringBuffer oStringOut = new StringBuffer("");
        Iterator oRangeList = this.getRangeList();
        OipchRange oRange = null;
        while (oRangeList.hasNext()) {
            oRange = (OipchRange)oRangeList.next();
            oStringOut.append(oRange.toString());
        }
        return oStringOut.toString();
    }
}

