/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdkv2impl;

import java.io.File;
import java.nio.file.Path;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdkv2.IPatch;
import oracle.opatch.opatchsdkv2.IReadSession;
import oracle.opatch.opatchsdkv2.ce.OperationConfiguration;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class ReadSession
implements IReadSession {
    protected final OperationConfiguration opCfg;
    private static String oracleHome = null;
    private String workSheetPath;
    private static final String WORK_FILE = "SDKWork.txt";
    private static OPatchContext context = null;

    public ReadSession(OperationConfiguration cfg) {
        this.opCfg = cfg;
        oracleHome = this.opCfg.getOracleHomePath().toString();
        try {
            this.init();
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        this.opCfg.print();
    }

    private void init() throws OPatchException {
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            System.setProperty("OPatch.ORACLE_HOME", oracleHome);
            String ouiLoc = System.getProperty("OPatch.OUI_LOCATION");
            if (ouiLoc == null || ouiLoc.equals("")) {
                System.setProperty("OPatch.OUI_LOCATION", oracleHome + File.separator + "oui");
            }
            OPatchEnv.setBranchKey("SDK");
            OPatchEnv.setupPatchStorage(oracleHome);
            OPatchEnv.setOPatchSDKMode(true);
            boolean isCustom = false;
            if (OPatchEnv.getCustomLogDir() != null && !OPatchEnv.getCustomLogDir().equals("")) {
                isCustom = true;
            }
            this.workSheetPath = this.getWorkSheet(oracleHome);
            if (OPatchEnv.getOhWritePermission()) {
                try {
                    SystemCall.createNewFile(this.workSheetPath);
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException("Not able to create temporary file \"" + this.workSheetPath);
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
            } else if (!isCustom) {
                throw new RuntimeException("This is a read-only Oracle Home. Please set custom scratch working directory and re-try");
            }
        } else {
            throw new UnsupportedOperationException("OPatchSDKV2 requires CAS support");
        }
        OPatchContext.destroyContextReference();
        context = OPatchContext.getInstance((String)oracleHome, (String)this.opCfg.getInvPtr().toString());
        OPatchSDK.initLogFile(oracleHome);
    }

    private String getWorkSheet(String oracleHomePath) {
        File workSheetFile;
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
        String customLogDir = OPatchEnv.getCustomLogDir();
        if (customLogDir != null && !customLogDir.equals("")) {
            buff.setLength(0);
            buff.append(customLogDir);
            buff.append(File.separator);
            buff.append("opatch");
        }
        if (!(workSheetFile = new File(buff.toString())).exists()) {
            workSheetFile.mkdirs();
        }
        buff.append(File.separator);
        buff.append(WORK_FILE);
        return buff.toString();
    }

    protected String getWorkSheetPath() {
        return this.workSheetPath;
    }

    public Path getOracleHomePath() {
        return this.opCfg.getOracleHomePath();
    }

    public IPatch getPatch(String id) {
        return null;
    }
}

