/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.PrereqSession;
import oracle.opatch.ROSessionException;
import oracle.opatch.RWSessionException;
import oracle.opatch.Rac;
import oracle.opatch.RacSrvm;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;

public class RacPrereqAPI {
    private RacPrereqAPI() {
    }

    public static PrereqResult checkForCRSHomeIfRAC(String oracleHomePath) {
        PrereqResult resObj;
        block11: {
            resObj = new PrereqResult();
            StringBuffer buff = new StringBuffer("RacPrereqAPI::checkForCRSHomeIfRAC()");
            OLogger.debug(buff);
            try {
                buff = new StringBuffer("Setting up an OUI Session.");
                OLogger.debug(buff);
                IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
                Rac.RacType racType = null;
                try {
                    racType = Rac.getInstance(readServices);
                }
                catch (RuntimeException e2) {
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(e2);
                    buff = new StringBuffer("Exception occured");
                    buff.append(e2.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                    return resObj;
                }
                buff = new StringBuffer(racType.getDetail());
                OLogger.debug(buff);
                String toString = Rac.toString(readServices);
                buff = new StringBuffer(toString);
                OLogger.printlnOnLog(buff.toString());
                if (racType != Rac.RacType.NO_RAC) {
                    if (readServices.isCRSHomePresent()) {
                        String crsHomeName = readServices.findCRSHomeName();
                        buff = new StringBuffer("CRS Home: ");
                        buff.append(crsHomeName);
                        OLogger.printlnOnLog(buff.toString());
                        buff = new StringBuffer("\nFound a CRS Home : ");
                        buff.append(crsHomeName);
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    } else {
                        buff = new StringBuffer("\nNo CRS Home is registered with the given Central Inventory");
                        buff.append("\n Use -local_node <nodename> while invoking OPatch to specify which node to be taken as Local node.");
                        OLogger.printlnOnLog(buff.toString());
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                        resObj.addDetail(buff.toString());
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    }
                    break block11;
                }
                if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
                    buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
                    buff.append("This could be because of one or more of the following:\n");
                    buff.append("   a) Problems with the clusterware detection.\n");
                    buff.append("   b) Problems getting the local node name.\n");
                    buff.append("   c) Problems getting the remote node names.\n");
                    buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
                    buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(buff.toString());
                    return resObj;
                }
                buff = new StringBuffer("Not a RAC setup.");
                OLogger.println(buff.toString());
                resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                return resObj;
            }
            catch (ROSessionException e3) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e3);
                buff = new StringBuffer("ROSessionException occured");
                buff.append(e3.getMessage());
                OLogger.printlnOnLog(buff.toString());
            }
            catch (RWSessionException e4) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e4);
                buff = new StringBuffer("RWSessionException occured");
                buff.append(e4.getMessage());
                OLogger.printlnOnLog(buff.toString());
            }
            catch (RuntimeException e5) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e5);
                buff = new StringBuffer("Exception occured");
                buff.append(e5.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(t);
                buff = new StringBuffer("Exception occured");
                buff.append(t.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
        }
        return resObj;
    }

    public static PrereqResult checkRACNodeList(String oracleHomePath) {
        StringBuffer buff;
        PrereqResult resObj;
        block29: {
            resObj = new PrereqResult();
            buff = new StringBuffer("RacPrereqAPI::checkRACNodeList()");
            OLogger.debug(buff);
            try {
                buff = new StringBuffer("Setting up an OUI Session.");
                OLogger.debug(buff);
                IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
                Rac.RacType racType = null;
                try {
                    racType = Rac.getInstance(readServices);
                }
                catch (RuntimeException e2) {
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(e2);
                    buff = new StringBuffer("Exception occured");
                    buff.append(e2.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                    return resObj;
                }
                buff = new StringBuffer(racType.getDetail());
                OLogger.debug(buff);
                String toString = Rac.toString(readServices);
                buff = new StringBuffer(toString);
                OLogger.printlnOnLog(buff.toString());
                if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
                    buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
                    buff.append("This could be because of one or more of the following:\n");
                    buff.append("   a) Problems with the clusterware detection.\n");
                    buff.append("   b) Problems getting the local node name.\n");
                    buff.append("   c) Problems getting the remote node names.\n");
                    buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
                    buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
                    resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                    resObj.addDetail(buff.toString());
                    return resObj;
                }
                if (racType == Rac.RacType.MULTIPLE_NODE) {
                    String localNode = racType.getLocalNode();
                    String[] nodes = racType.getRemoteNodes();
                    buff = new StringBuffer("\nLocal Node : " + localNode);
                    if (nodes != null) {
                        buff.append("\nRemote Nodes : ");
                        for (int i2 = 0; i2 < nodes.length; ++i2) {
                            buff.append(nodes[i2]);
                            buff.append("   ");
                        }
                    }
                    OLogger.verbose(OPatchSession.PREREQ, buff);
                    if (nodes != null && nodes.length > 0) {
                        ArrayList<String> aliveNodes = new ArrayList<String>();
                        int timeout = 100;
                        try {
                            new ClusterCmd().areNodesAlive(nodes, timeout, null);
                        }
                        catch (ClusterException e3) {
                            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                            resObj.addDetail((Object)e3);
                            buff = new StringBuffer("Exception occured");
                            buff.append(e3.getMessage());
                            OLogger.printlnOnLog(buff.toString());
                            return resObj;
                        }
                        catch (RemoteFileOperationException e4) {
                            resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                            for (int i3 = 0; i3 < nodes.length; ++i3) {
                                try {
                                    switch (e4.getStatus(nodes[i3])) {
                                        case 0: {
                                            aliveNodes.add(nodes[i3]);
                                            break;
                                        }
                                        case 1: {
                                            resObj.addDetail("Not Alive : " + nodes[i3]);
                                            break;
                                        }
                                        case 2: {
                                            resObj.addDetail("Not Alive : " + nodes[i3]);
                                        }
                                    }
                                    continue;
                                }
                                catch (NoSuchNodeException nsne) {
                                    resObj.addDetail("Node does not exist : " + nodes[i3]);
                                }
                            }
                        }
                        if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                            buff = new StringBuffer("Alive Remote Nodes are: ");
                            for (int nodeIter = 0; nodeIter < aliveNodes.size(); ++nodeIter) {
                                buff.append(aliveNodes.get(nodeIter));
                                if (nodeIter + 1 == aliveNodes.size()) continue;
                                buff.append(",");
                            }
                            OLogger.printlnOnLog(buff.toString());
                            resObj.addDetail(buff.toString());
                        } else {
                            buff = new StringBuffer("Alive Remote Nodes are: ");
                            for (int nodeIter = 0; nodeIter < nodes.length; ++nodeIter) {
                                buff.append(nodes[nodeIter]);
                                if (nodeIter + 1 == nodes.length) continue;
                                buff.append(",");
                            }
                            OLogger.printlnOnLog(buff.toString());
                            resObj.addDetail(buff.toString());
                        }
                        break block29;
                    }
                    buff = new StringBuffer("\nThere is no remote node.");
                    OLogger.verbose(OPatchSession.PREREQ, buff);
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    return resObj;
                }
                if (racType == Rac.RacType.NO_RAC) {
                    OLogger.println("Not a RAC setup.");
                    resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                    return resObj;
                }
            }
            catch (ROSessionException e5) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e5);
                buff = new StringBuffer("ROSessionException occured");
                buff.append(e5.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            catch (RWSessionException e6) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e6);
                buff = new StringBuffer("RWSessionException occured");
                buff.append(e6.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            catch (RuntimeException e7) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e7);
                buff = new StringBuffer("Exception occured");
                buff.append(e7.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(t);
                buff = new StringBuffer("Exception occured");
                buff.append(t.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\nAll nodes are alive and reachable");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrereqResult checkRemoteCommandInvocable(String oracleHomePath) {
        StringBuffer buff;
        PrereqResult resObj;
        block19: {
            resObj = new PrereqResult();
            buff = new StringBuffer("RacPrereqAPI::checkRemoteCommandInvocable()");
            OLogger.debug(buff);
            try {
                String remoteCmd;
                String[] nodes;
                block18: {
                    buff = new StringBuffer("\nSetting up an OUI Session.");
                    OLogger.verbose(OPatchSession.PREREQ, buff);
                    IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
                    Rac.RacType racType = null;
                    try {
                        racType = Rac.getInstance(readServices);
                    }
                    catch (RuntimeException e2) {
                        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                        resObj.addDetail(e2);
                        buff = new StringBuffer("Exception occured");
                        buff.append(e2.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                        return resObj;
                    }
                    buff = new StringBuffer(racType.getDetail());
                    OLogger.debug(buff);
                    String toString = Rac.toString(readServices);
                    buff = new StringBuffer(toString);
                    OLogger.printlnOnLog(buff.toString());
                    if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
                        buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
                        buff.append("This could be because of one or more of the following:\n");
                        buff.append("   a) Problems with the clusterware detection.\n");
                        buff.append("   b) Problems getting the local node name.\n");
                        buff.append("   c) Problems getting the remote node names.\n");
                        buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
                        buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
                        resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                        resObj.addDetail(buff.toString());
                        return resObj;
                    }
                    if (racType == Rac.RacType.MULTIPLE_NODE) {
                        String localNode = racType.getLocalNode();
                        nodes = racType.getRemoteNodes();
                        buff = new StringBuffer("\nLocal Node : " + localNode);
                        if (nodes != null) {
                            buff.append("\nRemote Nodes : ");
                            for (int i2 = 0; i2 < nodes.length; ++i2) {
                                buff.append(nodes[i2]);
                                buff.append("   ");
                            }
                        }
                        OLogger.verbose(OPatchSession.PREREQ, buff);
                        if (nodes != null && nodes.length > 0) {
                            remoteCmd = "date";
                            break block18;
                        } else {
                            buff = new StringBuffer("\nThere is no remote Node.");
                            OLogger.verbose(OPatchSession.PREREQ, buff);
                            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                            return resObj;
                        }
                    }
                    if (racType == Rac.RacType.NO_RAC) {
                        OLogger.println("Not a RAC setup.");
                        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
                        return resObj;
                    }
                    break block19;
                }
                for (int nodeIter = 0; nodeIter < nodes.length; ++nodeIter) {
                    try {
                        Rac.srvmRunRemoteCommand(nodes[nodeIter], remoteCmd);
                        continue;
                    }
                    catch (RuntimeException e3) {
                        resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                        resObj.addDetail(e3.getMessage());
                        buff = new StringBuffer("Exception occured");
                        buff.append(e3.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                    }
                }
            }
            catch (ROSessionException e4) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e4);
                buff = new StringBuffer("ROSessionException occured");
                buff.append(e4.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            catch (RWSessionException e5) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e5);
                buff = new StringBuffer("RWSessionException occured");
                buff.append(e5.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            catch (RuntimeException e6) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e6);
                buff = new StringBuffer("Exception occured");
                buff.append(e6.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            catch (Throwable t) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(t);
                buff = new StringBuffer("Exception occured");
                buff.append(t.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
        }
        if (resObj.getResult() != PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("\n\"date\" command was executed successfully on all the remote nodes.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return resObj;
    }

    public static PrereqResult checkRemoteCopyAndRemove(String oracleHomePath) {
        PrereqResult resObj = new PrereqResult();
        StringBuffer buff = new StringBuffer("RacPrereqAPI::checkRemoteCopyAndRemove()");
        OLogger.debug(buff);
        Rac.RacType racType = null;
        try {
            buff = new StringBuffer("\nSetting up an OUI Session.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            try {
                racType = Rac.getInstance(readServices);
            }
            catch (RuntimeException e2) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e2);
                buff = new StringBuffer("Exception occured");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            buff = new StringBuffer(racType.getDetail());
            OLogger.debug(buff);
            String toString = Rac.toString(readServices);
            buff = new StringBuffer(toString);
            OLogger.printlnOnLog(buff.toString());
        }
        catch (ROSessionException e3) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(e3);
            buff = new StringBuffer("ROSessionException occured");
            buff.append(e3.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return resObj;
        }
        catch (RWSessionException e4) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(e4);
            buff = new StringBuffer("RWSessionException occured");
            buff.append(e4.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return resObj;
        }
        catch (RuntimeException e5) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(e5);
            buff = new StringBuffer("Exception occured");
            buff.append(e5.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return resObj;
        }
        catch (Throwable t) {
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(t);
            buff = new StringBuffer("Exception occured");
            buff.append(t.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return resObj;
        }
        if (racType == Rac.RacType.NO_RAC && racType.getRacDiagCode() == Rac.RacDiagCode.NODE_LIST_DETECTED_PATCH_LOCAL) {
            buff = new StringBuffer("\nOPatch found issues in detecting the local node and remote_nodes. ");
            buff.append("This could be because of one or more of the following:\n");
            buff.append("   a) Problems with the clusterware detection.\n");
            buff.append("   b) Problems getting the local node name.\n");
            buff.append("   c) Problems getting the remote node names.\n");
            buff.append("   d) Values passed to -local_node or -remote_nodes options are not valid.\n");
            buff.append("Please check the setup and run 'opatch lsinventory' to get the node names.\n");
            resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            resObj.addDetail(buff.toString());
            return resObj;
        }
        if (racType == Rac.RacType.MULTIPLE_NODE) {
            String[] nodes = racType.getRemoteNodes();
            String ohPatchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
            File f2 = new File(ohPatchStorage);
            if (!f2.exists() && !f2.mkdirs()) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                buff = new StringBuffer("Unable to create");
                buff.append(ohPatchStorage);
                OLogger.printlnOnLog(buff.toString());
                resObj.addDetail(buff.toString());
                return resObj;
            }
            String listingFile = ohPatchStorage + File.separator + "prereq_files_propogation_list.txt";
            String finalCopyFile = ohPatchStorage + File.separator + "prereq_copy_instantiated.txt";
            String finalRemoveFile = ohPatchStorage + File.separator + "prereq_remove_instantiated.txt";
            try {
                if (!RacPrereqAPI.createAndPopulateListingFile(oracleHomePath, ohPatchStorage, listingFile)) {
                    buff = new StringBuffer("Files were not created to do remote copy/remove.");
                    OLogger.printlnOnLog(buff.toString());
                    resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                    resObj.addDetail(buff.toString());
                    return resObj;
                }
            }
            catch (IOException e6) {
                resObj.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
                resObj.addDetail(e6);
                buff = new StringBuffer("Creation of listing and actual files failed");
                buff.append("Exception occured: ");
                buff.append(e6.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            try {
                RacSrvm.propagateListedFilesToNodes(oracleHomePath, nodes, listingFile, finalCopyFile);
            }
            catch (RuntimeException e7) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(e7);
                buff = new StringBuffer("File propogation failed.");
                buff.append("Exception occured: ");
                buff.append(e7.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            buff = new StringBuffer("\nFile has been propogated successfully");
            OLogger.verbose(OPatchSession.PREREQ, buff);
            try {
                RacSrvm.removeListedFilesOnNodes(oracleHomePath, nodes, listingFile, finalRemoveFile);
            }
            catch (RuntimeException e8) {
                resObj.setResult(PrereqResult.ExecuteStatus.FAILED);
                resObj.addDetail(e8);
                buff = new StringBuffer("Remote file delete failed.");
                buff.append("Exception occured: ");
                buff.append(e8.getMessage());
                OLogger.printlnOnLog(buff.toString());
                return resObj;
            }
            buff = new StringBuffer("\nFile has been removed successfully on remote nodes.");
            OLogger.verbose(OPatchSession.PREREQ, buff);
        } else if (racType == Rac.RacType.NO_RAC) {
            OLogger.println("Not a RAC setup.");
            resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            return resObj;
        }
        resObj.setResult(PrereqResult.ExecuteStatus.PASSED);
        OLogger.debug(new StringBuffer("Prereq checkRemoteCopyAndRemove Passed."));
        return resObj;
    }

    private static boolean createAndPopulateListingFile(String oracleHomePath, String ohPatchStorage, String listingFile) throws IOException {
        String actualFileToPropogate = ohPatchStorage + File.separator + "prereq_testing.txt";
        File f2 = new File(actualFileToPropogate);
        if (f2.exists()) {
            f2.delete();
        }
        if (!f2.createNewFile()) {
            return false;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(f2));
        StringBuffer buff = new StringBuffer("This is a temporary file, created as \n");
        buff.append("a part of prereq checks, to check file propogation\n");
        buff.append("to remote nodes.\n");
        bw.write(buff.toString(), 0, buff.length());
        bw.close();
        File fl = new File(listingFile);
        if (fl.exists()) {
            fl.delete();
        }
        if (!fl.createNewFile()) {
            return false;
        }
        BufferedWriter bw2 = new BufferedWriter(new FileWriter(fl));
        String fileToPropogate = oracleHomePath + File.separator + OPatchEnv.getPatchStorageName() + File.separator + "prereq_testing.txt";
        bw2.write(fileToPropogate, 0, fileToPropogate.length());
        bw2.close();
        return true;
    }
}

