/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.util.Vector;

public class PrereqResult {
    ExecuteStatus resultValue;
    Vector resultDetail;

    protected PrereqResult() {
        this.resultValue = ExecuteStatus.NOT_EXECUTED;
        this.resultDetail = new Vector();
    }

    protected PrereqResult(ExecuteStatus result, Vector details) {
        this.resultValue = result;
        this.resultDetail = details;
    }

    protected void setResult(ExecuteStatus result) {
        this.resultValue = result;
    }

    public ExecuteStatus getResult() {
        return this.resultValue;
    }

    protected void setResultDetails(Vector details) {
        this.resultDetail = details;
    }

    public Vector getResultDetails() {
        return this.resultDetail;
    }

    protected void addDetail(Object detail) {
        this.resultDetail.add(detail);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.resultDetail.size() != 0) {
            buff.append("\nThe details are:\n");
        }
        for (int i2 = 0; i2 < this.resultDetail.size(); ++i2) {
            Object obj = this.resultDetail.elementAt(i2);
            if (obj instanceof String) {
                String str = (String)obj;
                buff.append(str);
                continue;
            }
            if (obj instanceof Exception) {
                Exception e2 = (Exception)obj;
                buff.append("Exception occured :");
                buff.append("\t" + e2.getMessage());
                continue;
            }
            buff.append(obj.toString());
        }
        return buff.toString();
    }

    public static PrereqResult getPrereqResult(ExecuteStatus status, String message) {
        PrereqResult result = new PrereqResult();
        result.setResult(status);
        result.addDetail(message);
        return result;
    }

    public static class ExecuteStatus {
        int state;
        public static ExecuteStatus PASSED = new ExecuteStatus(0);
        public static ExecuteStatus FAILED = new ExecuteStatus(1);
        public static ExecuteStatus NOT_EXECUTED = new ExecuteStatus(2);

        private ExecuteStatus() {
        }

        public ExecuteStatus(int state) {
            this.state = state;
        }
    }
}

