/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.BuildRelationPatchMap;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexKeyPair;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexKeyTriple;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.SelectBetterPatchOneOffEngine;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ICheckPatchPrereqEngine;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckPatchInterPrereqEngine
implements ICheckPatchPrereqEngine {
    @Override
    public PrereqResult checkDuplicatePatch(String oh, ArrayList exitPatches, OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("checkPatchInterPrereqEngine:checkDuplicatePatch");
        PrereqResult pr = new PrereqResult();
        HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res = new HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>>();
        if (!this.validate(oh, pIs, pr)) {
            return pr;
        }
        OneOffEntry[] pOHs = null;
        try {
            pOHs = PrereqAPI.getInstalledOneOff(oh);
        }
        catch (Throwable t) {
            return pr;
        }
        BuildRelationPatchMap build = new BuildRelationPatchMap();
        HashMap hm = build.buildDuplicatePohMap(pOHs);
        this.initResult(res);
        for (int i2 = 0; i2 < pIs.length; ++i2) {
            OneOffEntry pi = pIs[i2];
            String idPi = pi.getID();
            String langPi = this.norm(pi.getPatchLanguage());
            if (langPi == "") {
                langPi = "en";
            }
            String[] bugsPi = pIs[i2].getBugIDsFixed();
            String uidPi = this.norm(pi.getPSENumber());
            IndexKeyPair piKeyPair = new IndexKeyPair(langPi, bugsPi);
            OneOffEntry poh = (OneOffEntry)hm.get(piKeyPair);
            SelectBetterPatchOneOffEngine eng = new SelectBetterPatchOneOffEngine();
            eng.selectBetterPatchAgainstOh(poh, pi, res);
        }
        this.buildOutputExitPatches(exitPatches, res);
        StringBuffer retMsg = new StringBuffer();
        this.buildOutputMsg(retMsg, res, pIs);
        this.buildOutputPrereqResult(pr, retMsg.toString(), res);
        return pr;
    }

    @Override
    public PrereqResult checkIdenticalPatch(String oh, ArrayList exitPatches, OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("checkPatchInterPrereqEngine:checkIdenticalPatch");
        PrereqResult pr = new PrereqResult();
        HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res = new HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>>();
        OLogger.debug(buff);
        if (!this.validate(oh, pIs, pr)) {
            return pr;
        }
        OneOffEntry[] pOHs = null;
        try {
            pOHs = PrereqAPI.getInstalledOneOff(oh);
        }
        catch (Throwable t) {
            return pr;
        }
        BuildRelationPatchMap build = new BuildRelationPatchMap();
        HashMap hm = build.buildIdenticalPohMap(pOHs);
        this.initResult(res);
        SelectBetterPatchOneOffEngine eng = new SelectBetterPatchOneOffEngine();
        for (int i2 = 0; i2 < pIs.length; ++i2) {
            OneOffEntry pi = pIs[i2];
            String idPi = pi.getID();
            String langPi = this.norm(pi.getPatchLanguage());
            if (langPi == "") {
                langPi = "en";
            }
            String[] bugsPi = pIs[i2].getBugIDsFixed();
            String uidPi = this.norm(pi.getPSENumber());
            IndexKeyTriple piKeyPair = new IndexKeyTriple(idPi, langPi, bugsPi);
            OneOffEntry poh = (OneOffEntry)hm.get(piKeyPair);
            if (pi.getIsComposite()) {
                if (!pi.getPatchID().equals(pi.getConstituentActiveField())) continue;
                eng.selectBetterPatchAgainstOh(poh, pi, res);
                continue;
            }
            eng.selectBetterPatchAgainstOh(poh, pi, res);
        }
        this.buildOutputExitPatches(exitPatches, res);
        StringBuffer retMsg = new StringBuffer();
        this.buildOutputMsg(retMsg, res, pIs);
        this.buildOutputPrereqResult(pr, retMsg.toString(), res);
        return pr;
    }

    private void buildOutputPrereqResult(PrereqResult pr, String retMsg, HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res) {
        pr.addDetail(retMsg);
        if (res.get((Object)ICheckPatchPrereqEngine.Result.WORSE).size() > 0 || res.get((Object)ICheckPatchPrereqEngine.Result.SAME).size() > 0) {
            pr.setResult(PrereqResult.ExecuteStatus.FAILED);
        } else {
            pr.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
        if (res.get((Object)ICheckPatchPrereqEngine.Result.SAME).size() > 0 || res.get((Object)ICheckPatchPrereqEngine.Result.WORSE).size() > 0 && !calledFromOUI && !OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            throw new ExitOPatchException(retMsg);
        }
    }

    private String printWarningMessages(StringBuffer[] msgs, boolean shouldPrint) {
        String s = "";
        if (msgs != null && msgs.length >= 4) {
            if (msgs[1].length() != 0) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67652", new Object[]{msgs[1]});
                }
                s = s + OLogger.getString("OUI-67655", new Object[]{msgs[1]});
            }
            if (msgs[2].length() != 0) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67633", new Object[]{msgs[2]});
                }
                s = s + OLogger.getString("OUI-67633", new Object[]{msgs[2]});
            }
            if (msgs[3].length() != 0) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67650", new Object[]{msgs[3]});
                }
                s = s + OLogger.getString("OUI-67653", new Object[]{msgs[3]});
            }
            if (msgs[4].length() != 0) {
                if (!OPatchEnv.getSessionType().equalsIgnoreCase("prereq") && shouldPrint) {
                    OLogger.warn("OUI-67651", new Object[]{msgs[4]});
                }
                s = s + OLogger.getString("OUI-67654", new Object[]{msgs[4]});
            }
        }
        return s;
    }

    private void buildOutputExitPatches(ArrayList exitPatches, HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res) {
        ArrayList<OneOffEntry> same = res.get((Object)ICheckPatchPrereqEngine.Result.SAME);
        ArrayList<OneOffEntry> worse = res.get((Object)ICheckPatchPrereqEngine.Result.WORSE);
        for (OneOffEntry entry : same) {
            exitPatches.add(entry);
        }
        for (OneOffEntry entry : worse) {
            exitPatches.add(entry);
        }
    }

    private void buildOutputMsg(StringBuffer outputMsg, HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res, OneOffEntry[] pIs) {
        String id;
        StringBuffer buff = new StringBuffer("CheckPatchInterPrereqEngine::buildOutputMsg()");
        StringBuffer[] msgs = new StringBuffer[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            msgs[i2] = new StringBuffer();
        }
        ArrayList<OneOffEntry> list = res.get((Object)ICheckPatchPrereqEngine.Result.SAME);
        buff.append("Build same patches group: ");
        for (OneOffEntry entry : list) {
            id = entry.getID();
            buff.append("[").append(id).append("] ");
            msgs[1] = msgs[1] == null ? new StringBuffer(id) : msgs[1].append(" ").append(id);
        }
        OLogger.debug(buff);
        buff.setLength(0);
        list = res.get((Object)ICheckPatchPrereqEngine.Result.BETTER);
        buff.append("Build better patches group: ");
        for (OneOffEntry entry : list) {
            id = entry.getID();
            buff.append("[").append(id).append("] ");
            msgs[3] = msgs[3] == null ? new StringBuffer(id) : msgs[3].append(" ").append(id);
        }
        OLogger.debug(buff);
        buff.setLength(0);
        list = res.get((Object)ICheckPatchPrereqEngine.Result.WORSE);
        buff.append("Build worse patches group: ");
        for (OneOffEntry entry : list) {
            id = entry.getID();
            buff.append("[").append(id).append("] ");
            msgs[4] = msgs[4] == null ? new StringBuffer(id) : msgs[4].append(" ").append(id);
        }
        OLogger.debug(buff);
        String retMsg = "";
        if (OPatchEnv.getSessionType().equalsIgnoreCase("prereq")) {
            retMsg = this.printWarningMessages(msgs, true);
        } else {
            boolean shouldPrint = true;
            boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
            if (res.get((Object)ICheckPatchPrereqEngine.Result.SAME).size() != pIs.length && pIs.length != 1) {
                shouldPrint = false;
            }
            if (calledFromOUI) {
                shouldPrint = false;
            }
            String warnMsg = this.printWarningMessages(msgs, shouldPrint);
            if (calledFromOUI) {
                retMsg = warnMsg;
            }
        }
        outputMsg.append(retMsg);
    }

    private boolean validate(String oh, OneOffEntry[] pIs, PrereqResult pr) {
        StringBuffer buff = new StringBuffer("CheckPatchInterPrereqEngine:validate");
        if (pIs == null || pIs.length == 0) {
            pr.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            String msg = "Empty List of incoming patches.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return false;
        }
        if ("".equals(oh = this.norm(oh))) {
            pr.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            String msg = "Invalid Oracle Home Path.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return false;
        }
        OneOffEntry[] pOHs = null;
        try {
            pOHs = PrereqAPI.getInstalledOneOff(oh);
        }
        catch (Throwable t) {
            pr.setResult(PrereqResult.ExecuteStatus.NOT_EXECUTED);
            OLogger.printlnOnLog("Exception occured while getting patches installed in Oracle Home \n" + t.getMessage());
            pr.addDetail(new Exception(t));
            return false;
        }
        if (pOHs == null || pOHs.length == 0) {
            pr.setResult(PrereqResult.ExecuteStatus.PASSED);
            String msg = "No patch installed in Oracle Home. Skipping check.";
            pr.addDetail(msg);
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return false;
        }
        return true;
    }

    private void initResult(HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res) {
        res.put(ICheckPatchPrereqEngine.Result.SAME, new ArrayList());
        res.put(ICheckPatchPrereqEngine.Result.WORSE, new ArrayList());
        res.put(ICheckPatchPrereqEngine.Result.BETTER, new ArrayList());
        res.put(ICheckPatchPrereqEngine.Result.DIFF, new ArrayList());
    }

    private String norm(String s) {
        return s == null ? "" : s.trim();
    }
}

