/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchingModel;
import oracle.opatch.conflicttextualinterpreter.AutoWeightConflictResolutionPlanner;
import oracle.opatch.conflicttextualinterpreter.Configuration;
import oracle.opatch.conflicttextualinterpreter.ConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IConflictResolutionPlanner;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IntraConflictException;
import oracle.opatch.conflicttextualinterpreter.InvalidPSUTrainException;
import oracle.opatch.conflicttextualinterpreter.MergePatch;
import oracle.opatch.conflicttextualinterpreter.MoreThanTwoPSUTrainException;
import oracle.opatch.conflicttextualinterpreter.MultiCompositeException;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.NoNeedListParser;
import oracle.opatch.conflicttextualinterpreter.Patch;
import oracle.opatch.conflicttextualinterpreter.PrereqNotExistException;
import oracle.opatch.conflicttextualinterpreter.SubsetOverlaySupersetException;
import oracle.opatch.opatchactions.dbpkgAction;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchactions.oarAction;
import oracle.opatch.opatchactions.onewaycopyAction;
import oracle.opatch.opatchactions.sharedlibraryAction;
import oracle.opatch.opatchactions.sqlprocAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.ConflictOutput;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckConflictAdapter {
    private StringBuffer buffer = new StringBuffer(4096);
    private StatusCode code = StatusCode.PASSED;
    private Collection<IPatch> notNeeds = new ArrayList<IPatch>();
    private HashSet<OneOffEntry> skipConflicts = new HashSet();
    private HashSet<OneOffEntry> skipConflictsToComposite = new HashSet();
    private HashSet<OneOffEntry> notNeedDuplicates = new HashSet();
    private HashSet<OneOffEntry> subsetOfBigPoh = new HashSet();
    private HashSet<OneOffEntry> subsetOfBigPi = new HashSet();
    private HashSet<OneOffEntry> subsetPSUTrain = new HashSet();
    private boolean supersetFlag = false;

    public ArrayList<OneOffEntry> getSubsetOfBigPoh() {
        return new ArrayList<OneOffEntry>(this.subsetOfBigPoh);
    }

    public ArrayList<OneOffEntry> getSubsetOfBigPi() {
        return new ArrayList<OneOffEntry>(this.subsetOfBigPi);
    }

    public ArrayList<OneOffEntry> getSubsetPSUTrain() {
        return new ArrayList<OneOffEntry>(this.subsetPSUTrain);
    }

    public StatusCode getStatusCode() {
        return this.code;
    }

    public boolean hasSupersetFlag() {
        return this.supersetFlag;
    }

    public boolean isConflictStatusCode() {
        return this.code == StatusCode.CONFLICT;
    }

    public ArrayList<OneOffEntry> getDuplicates() {
        return new ArrayList<OneOffEntry>(this.notNeedDuplicates);
    }

    public ArrayList<OneOffEntry> getSkipConflicts() {
        return new ArrayList<OneOffEntry>(this.skipConflicts);
    }

    public ArrayList<OneOffEntry> getSkipConflictToComposite() {
        return new ArrayList<OneOffEntry>(this.skipConflictsToComposite);
    }

    public String getPrereqErrorMessage() {
        return this.buffer.toString();
    }

    public PrereqResult getPrereqResult() {
        PrereqResult result = new PrereqResult();
        result.addDetail(this.buffer.toString());
        return result;
    }

    public ConflictOutput checkConflictAmongPatches(String oracleHome, OneOffEntry[] piOneOffs) {
        OLogger.logTime(new StringBuffer("checkConflictAmongPatches start -> "));
        Collection<IPatch> pis = this.convertOneOffEntryToIPatch(piOneOffs, false, false, oracleHome);
        ConflictOutput output = new ConflictOutput();
        this.checkConflictCore(oracleHome, pis, new ArrayList<IPatch>(), output, false);
        OLogger.logTime(new StringBuffer("checkConflictAmongPatches end -> "));
        return output;
    }

    public ConflictMatrixOutput checkConflictAmongPatchesWithDetail(String oracleHome, OneOffEntry[] piOneOffs) {
        Collection<String> sameStuff;
        NPatchRelations relations;
        OLogger.logTime(new StringBuffer("checkConflictAmongPatchesWithDetail start -> "));
        StringBuffer buff = new StringBuffer(4096);
        buff.append("CheckConflictAdapter::checkConflictAmongPatchesWithDetail()");
        OLogger.debug(buff);
        int len = piOneOffs.length;
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(len, len);
        Collection<IPatch> pis = this.convertOneOffEntryToIPatch(piOneOffs, false, false, oracleHome);
        IConflictResolutionPlanner planner = this.checkConflictCore(oracleHome, pis, new ArrayList<IPatch>(), resObj, false);
        PrereqResult.ExecuteStatus es = resObj.getResult();
        IConflictMap omap = planner.getFinalConflictMap();
        this.createCompositeMatrixOutput(piOneOffs, piOneOffs, planner.getOrginalConflictMap(), resObj);
        HashMap<OneOffEntry, Integer> pos = new HashMap<OneOffEntry, Integer>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            pos.put(piOneOffs[i2], i2);
        }
        for (int i2 = 0; i2 < len; ++i2) {
            for (int j2 = 0; j2 < len; ++j2) {
                resObj.setRowPatchID(i2, j2, piOneOffs[i2].getID());
                resObj.setColumnPatchID(i2, j2, piOneOffs[j2].getID());
                resObj.setRowPatchType(i2, j2, piOneOffs[i2].getIsComposite() ? ConflictMatrixOutput.PatchType.SUBPATCH : ConflictMatrixOutput.PatchType.ONEOFF);
                resObj.setColumnPatchType(i2, j2, piOneOffs[j2].getIsComposite() ? ConflictMatrixOutput.PatchType.SUBPATCH : ConflictMatrixOutput.PatchType.ONEOFF);
            }
        }
        Collection<IPatch> tpis = omap.getPi();
        for (IPatch pi : tpis) {
            relations = omap.getRelations(pi);
            Collection<NPatchRelation> conflicts = relations.getSingleConflicts();
            for (NPatchRelation nPatchRelation : conflicts) {
                int m2 = (Integer)pos.get(nPatchRelation.from().getOneOffEntry());
                int n2 = (Integer)pos.get(nPatchRelation.to().getOneOffEntry());
                resObj.setColumnPatchID(m2, n2, nPatchRelation.to().getPatchId());
                resObj.setRowPatchID(m2, n2, nPatchRelation.from().getPatchId());
                if (nPatchRelation.getDef().getBugs().size() > 0) {
                    sameStuff = nPatchRelation.getDef().getBugs();
                    resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                    continue;
                }
                sameStuff = nPatchRelation.getDef().getFiles();
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
            }
        }
        omap = planner.getOrginalConflictMap();
        tpis = omap.getPi();
        for (IPatch pi : tpis) {
            int n2;
            int m2;
            relations = omap.getRelations(pi);
            Collection<NPatchRelation> duplicates = relations.getDuplicates();
            for (NPatchRelation nPatchRelation : duplicates) {
                m2 = (Integer)pos.get(nPatchRelation.from().getOneOffEntry());
                n2 = (Integer)pos.get(nPatchRelation.to().getOneOffEntry());
                resObj.setRowPatchID(m2, n2, nPatchRelation.from().getPatchId());
                resObj.setColumnPatchID(m2, n2, nPatchRelation.to().getPatchId());
                resObj.setConflictType((Integer)pos.get(nPatchRelation.from().getOneOffEntry()), (Integer)pos.get(nPatchRelation.to().getOneOffEntry()), ConflictMatrixOutput.ConflictType.IDENTICAL_PATCH);
            }
            Collection<NPatchRelation> supersets = relations.getSingleSupersets();
            for (NPatchRelation rel3 : supersets) {
                m2 = (Integer)pos.get(rel3.from().getOneOffEntry());
                n2 = (Integer)pos.get(rel3.to().getOneOffEntry());
                sameStuff = rel3.getDef().getBugs();
                resObj.setRowPatchID(m2, n2, rel3.from().getPatchId());
                resObj.setColumnPatchID(m2, n2, rel3.to().getPatchId());
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUPERSET);
            }
            Collection<NPatchRelation> collection = relations.getSingleSubsets();
            for (NPatchRelation rel4 : collection) {
                m2 = (Integer)pos.get(rel4.from().getOneOffEntry());
                n2 = (Integer)pos.get(rel4.to().getOneOffEntry());
                sameStuff = rel4.getDef().getBugs();
                resObj.setRowPatchID(m2, n2, rel4.from().getPatchId());
                resObj.setColumnPatchID(m2, n2, rel4.to().getPatchId());
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUBSET);
            }
        }
        if (this.code == StatusCode.APPLY_DEPENDENTS_FAIL || this.code == StatusCode.MULTI_COMPOSITES || this.code == StatusCode.PREREQ_OVERLAY_CYCLE || this.code == StatusCode.INVALID_PSU_RELATION || this.code == StatusCode.SUBSET_OVERLAY_SUPERSET) {
            resObj.addDetail(this.buffer.toString());
        }
        resObj.setResult(es);
        OLogger.logTime(new StringBuffer("checkConflictAmongPatchesWithDetail end -> "));
        return resObj;
    }

    public ConflictOutput checkConflictAgainstOH(String oracleHome, OneOffEntry[] piOneOffs, OneOffEntry[] pohOneOffs) {
        OLogger.logTime(new StringBuffer("checkConflictAgainstOH start -> "));
        Collection<IPatch> pis = this.convertOneOffEntryToIPatch(piOneOffs, false, false, oracleHome);
        Collection<IPatch> pohs = this.convertOneOffEntryToIPatch(pohOneOffs, true, false, oracleHome);
        ConflictOutput output = new ConflictOutput();
        this.checkConflictCore(oracleHome, pis, pohs, output, true);
        OLogger.logTime(new StringBuffer("checkConflictAgainstOH end -> "));
        return output;
    }

    public ConflictMatrixOutput checkConflictAgainstOHWithDetail(String oracleHome, OneOffEntry[] piOneOffs, OneOffEntry[] pohOneOffs) {
        OLogger.logTime(new StringBuffer("checkConflictAgainstOHWithDetail start -> "));
        StringBuffer buff = new StringBuffer(4096);
        buff.append("CheckConflictAdapter::checkConflictAgainstOHWithDetail()");
        OLogger.debug(buff);
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(piOneOffs.length, piOneOffs.length + pohOneOffs.length);
        Collection<IPatch> pis = this.convertOneOffEntryToIPatch(piOneOffs, false, false, oracleHome);
        Collection<IPatch> pohs = this.convertOneOffEntryToIPatch(pohOneOffs, true, false, oracleHome);
        IConflictResolutionPlanner planner = this.checkConflictCore(oracleHome, pis, pohs, resObj, true);
        PrereqResult.ExecuteStatus es = resObj.getResult();
        this.checkConflictAgainstOHWithDetailCore(piOneOffs, pohOneOffs, planner, resObj);
        resObj.setResult(es);
        OLogger.logTime(new StringBuffer("checkConflictAgainstOHWithDetail end -> "));
        return resObj;
    }

    public ConflictOutput checkConflictAgainstOHSkipMissingComps(String oracleHome, OneOffEntry[] piOneOffs, OneOffEntry[] pohOneOffs) {
        OLogger.logTime(new StringBuffer("checkConflictAgainstOHSkipMissingComps start -> "));
        Collection<IPatch> pis = this.convertOneOffEntryToIPatch(piOneOffs, false, true, oracleHome);
        Collection<IPatch> pohs = this.convertOneOffEntryToIPatch(pohOneOffs, true, true, oracleHome);
        ConflictOutput output = new ConflictOutput();
        this.checkConflictCore(oracleHome, pis, pohs, output, true);
        OLogger.logTime(new StringBuffer("checkConflictAgainstOHSkipMissingComps end -> "));
        return output;
    }

    public ConflictMatrixOutput checkConflictAgainstOHWithDetailSkipMissingComps(String oracleHome, OneOffEntry[] piOneOffs, OneOffEntry[] pohOneOffs) {
        OLogger.logTime(new StringBuffer("checkConflictAgainstOHWithDetailSkipMissingComps start -> "));
        StringBuffer buff = new StringBuffer(4096);
        buff.append("CheckConflictAdapter::checkConflictAgainstOHWithDetail()");
        OLogger.debug(buff);
        ConflictMatrixOutput resObj = new ConflictMatrixOutput(piOneOffs.length, piOneOffs.length + pohOneOffs.length);
        Collection<IPatch> pis = this.convertOneOffEntryToIPatch(piOneOffs, false, true, oracleHome);
        Collection<IPatch> pohs = this.convertOneOffEntryToIPatch(pohOneOffs, true, true, oracleHome);
        IConflictResolutionPlanner planner = this.checkConflictCore(oracleHome, pis, pohs, resObj, true);
        PrereqResult.ExecuteStatus es = resObj.getResult();
        this.checkConflictAgainstOHWithDetailCore(piOneOffs, pohOneOffs, planner, resObj);
        resObj.setResult(es);
        OLogger.logTime(new StringBuffer("checkConflictAgainstOHWIthDetailSkipMissingComps end -> "));
        return resObj;
    }

    /*
     * WARNING - void declaration
     */
    private void checkConflictAgainstOHWithDetailCore(OneOffEntry[] piOneOffs, OneOffEntry[] pohOneOffs, IConflictResolutionPlanner planner, ConflictMatrixOutput resObj) {
        void var20_65;
        OneOffEntry[] oldConflicts;
        int n2;
        int m2;
        OneOffEntry[] oneOffEntryArray;
        Collection<String> sameStuff;
        NPatchRelations relations;
        int i2;
        IConflictMap omap = planner.getFinalConflictMap();
        this.createCompositeMatrixOutput(piOneOffs, pohOneOffs, planner.getOrginalConflictMap(), resObj);
        int piLen = piOneOffs.length;
        int pohLen = pohOneOffs.length;
        HashMap<OneOffEntry, Integer> piPos = new HashMap<OneOffEntry, Integer>(piLen);
        HashMap<OneOffEntry, Integer> pohPos = new HashMap<OneOffEntry, Integer>(pohLen);
        for (int i22 = 0; i22 < piLen; ++i22) {
            piPos.put(piOneOffs[i22], i22);
        }
        for (i2 = 0; i2 < pohLen; ++i2) {
            pohPos.put(pohOneOffs[i2], i2 + piLen);
        }
        for (i2 = 0; i2 < piLen; ++i2) {
            for (int j2 = 0; j2 < piLen; ++j2) {
                resObj.setRowPatchID(i2, j2, piOneOffs[i2].getID());
                resObj.setColumnPatchID(i2, j2, piOneOffs[j2].getID());
                resObj.setRowPatchType(i2, j2, piOneOffs[i2].getIsComposite() ? ConflictMatrixOutput.PatchType.SUBPATCH : ConflictMatrixOutput.PatchType.ONEOFF);
                resObj.setColumnPatchType(i2, j2, piOneOffs[j2].getIsComposite() ? ConflictMatrixOutput.PatchType.SUBPATCH : ConflictMatrixOutput.PatchType.ONEOFF);
            }
            for (int j2 = piLen; j2 < piLen + pohLen; ++j2) {
                resObj.setRowPatchID(i2, j2, piOneOffs[i2].getID());
                resObj.setColumnPatchID(i2, j2, pohOneOffs[j2 - piLen].getID());
                resObj.setRowPatchType(i2, j2, piOneOffs[i2].getIsComposite() ? ConflictMatrixOutput.PatchType.SUBPATCH : ConflictMatrixOutput.PatchType.ONEOFF);
                resObj.setColumnPatchType(i2, j2, pohOneOffs[j2 - piLen].getIsComposite() ? ConflictMatrixOutput.PatchType.SUBPATCH : ConflictMatrixOutput.PatchType.ONEOFF);
            }
        }
        Collection<IPatch> tpis = omap.getPi();
        for (IPatch pi : tpis) {
            relations = omap.getRelations(pi);
            Collection<NPatchRelation> conflicts2 = relations.getSingleConflicts();
            for (NPatchRelation nPatchRelation : conflicts2) {
                int m22 = (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                int n22 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                if (nPatchRelation.getDef().getBugs().size() > 0) {
                    sameStuff = nPatchRelation.getDef().getBugs();
                    resObj.add(m22, n22, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                    continue;
                }
                sameStuff = nPatchRelation.getDef().getFiles();
                resObj.add(m22, n22, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
            }
        }
        omap = planner.getOrginalConflictMap();
        tpis = omap.getPi();
        for (IPatch pi : tpis) {
            relations = omap.getRelations(pi);
            Iterator<Object> duplicates = relations.getDuplicates();
            oneOffEntryArray = duplicates.iterator();
            while (oneOffEntryArray.hasNext()) {
                NPatchRelation nPatchRelation = oneOffEntryArray.next();
                this.notNeedDuplicates.add(nPatchRelation.from().getOneOffEntry());
                m2 = (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                resObj.setConflictType(m2, n2, ConflictMatrixOutput.ConflictType.IDENTICAL_PATCH);
            }
            Collection<NPatchRelation> supersets = relations.getSingleSupersets();
            for (NPatchRelation nPatchRelation : supersets) {
                m2 = (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                sameStuff = nPatchRelation.getDef().getBugs();
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUPERSET);
            }
            Collection<NPatchRelation> collection = relations.getSingleSubsets();
            for (NPatchRelation nPatchRelation : collection) {
                m2 = (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                sameStuff = nPatchRelation.getDef().getBugs();
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUBSET);
            }
            Collection<NPatchRelation> collection2 = relations.getWorses();
            for (NPatchRelation nPatchRelation : collection2) {
                this.notNeedDuplicates.add(nPatchRelation.from().getOneOffEntry());
                m2 = (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                resObj.setConflictType(m2, n2, ConflictMatrixOutput.ConflictType.WORSER_PATCH);
            }
            Collection<NPatchRelation> collection3 = relations.getBetters();
            for (NPatchRelation rel5 : collection3) {
                m2 = (Integer)piPos.get(rel5.from().getOneOffEntry());
                n2 = rel5.to().isInOh() ? (Integer)pohPos.get(rel5.to().getOneOffEntry()) : (Integer)piPos.get(rel5.to().getOneOffEntry());
                resObj.setConflictType(m2, n2, ConflictMatrixOutput.ConflictType.BETTER_PATCH);
            }
        }
        omap = planner.getOrginalConflictMap();
        NoNeedListParser noNeedParser = new NoNeedListParser(this.notNeeds, omap);
        HashSet<OneOffEntry> notNeedConflicts = new HashSet<OneOffEntry>();
        Collection<NoNeedListParser.NoNeedReason> noNeedReasons = noNeedParser.getNoNeedBysubSet();
        for (NoNeedListParser.NoNeedReason reason : noNeedReasons) {
            Collection<NPatchRelation> collection = reason.getRelations();
            for (NPatchRelation nPatchRelation : collection) {
                m2 = nPatchRelation.from().isInOh() ? (Integer)pohPos.get(nPatchRelation.from().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                sameStuff = nPatchRelation.getDef().getBugs();
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUBSET);
                if (nPatchRelation.to().isInOh()) continue;
                resObj.add(n2, m2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUPERSET);
            }
        }
        noNeedReasons = noNeedParser.getNoNeedByWorse();
        for (NoNeedListParser.NoNeedReason reason : noNeedReasons) {
            Collection<NPatchRelation> collection = reason.getRelations();
            for (NPatchRelation nPatchRelation : collection) {
                m2 = nPatchRelation.from().isInOh() ? (Integer)pohPos.get(nPatchRelation.from().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                resObj.setConflictType(m2, n2, ConflictMatrixOutput.ConflictType.WORSER_PATCH);
                if (nPatchRelation.to().isInOh()) continue;
                resObj.setConflictType(n2, m2, ConflictMatrixOutput.ConflictType.BETTER_PATCH);
            }
        }
        noNeedReasons = noNeedParser.getNoNeedByDuplicate();
        for (NoNeedListParser.NoNeedReason reason : noNeedReasons) {
            Collection<NPatchRelation> collection = reason.getRelations();
            for (NPatchRelation nPatchRelation : collection) {
                m2 = nPatchRelation.from().isInOh() ? (Integer)pohPos.get(nPatchRelation.from().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                resObj.setConflictType(m2, n2, ConflictMatrixOutput.ConflictType.IDENTICAL_PATCH);
            }
        }
        noNeedReasons = noNeedParser.getNoNeedBySkipConflict();
        for (NoNeedListParser.NoNeedReason reason : noNeedReasons) {
            Collection<NPatchRelation> collection = reason.getRelations();
            for (NPatchRelation nPatchRelation : collection) {
                m2 = nPatchRelation.from().isInOh() ? (Integer)pohPos.get(nPatchRelation.from().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                notNeedConflicts.add(nPatchRelation.from().getParent().getOneOffEntry());
                notNeedConflicts.add(nPatchRelation.to().getParent().getOneOffEntry());
                this.skipConflicts.add(nPatchRelation.from().getParent().getOneOffEntry());
                if (nPatchRelation.getDef().getBugs().size() > 0) {
                    sameStuff = nPatchRelation.getDef().getBugs();
                    resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                    continue;
                }
                sameStuff = nPatchRelation.getDef().getFiles();
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
            }
        }
        noNeedReasons = noNeedParser.getNoNeedBySkipConflictToCompositePatch();
        for (NoNeedListParser.NoNeedReason reason : noNeedReasons) {
            Collection<NPatchRelation> collection = reason.getRelations();
            for (NPatchRelation nPatchRelation : collection) {
                m2 = nPatchRelation.from().isInOh() ? (Integer)pohPos.get(nPatchRelation.from().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                notNeedConflicts.add(nPatchRelation.from().getParent().getOneOffEntry());
                notNeedConflicts.add(nPatchRelation.to().getParent().getOneOffEntry());
                this.skipConflictsToComposite.add(nPatchRelation.from().getOneOffEntry());
                if (nPatchRelation.getDef().getBugs().size() > 0) {
                    sameStuff = nPatchRelation.getDef().getBugs();
                    resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                    continue;
                }
                sameStuff = nPatchRelation.getDef().getFiles();
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
            }
        }
        noNeedReasons = noNeedParser.getNoNeedBySubSetOfBigPoh();
        for (NoNeedListParser.NoNeedReason reason : noNeedReasons) {
            Collection<NPatchRelation> collection = reason.getRelations();
            for (NPatchRelation nPatchRelation : collection) {
                this.subsetOfBigPoh.add(nPatchRelation.from().getOneOffEntry());
            }
        }
        noNeedReasons = noNeedParser.getNoNeedBySubsetPSU();
        for (NoNeedListParser.NoNeedReason reason : noNeedReasons) {
            Collection<NPatchRelation> collection = reason.getRelations();
            for (NPatchRelation nPatchRelation : collection) {
                this.subsetPSUTrain.add(nPatchRelation.from().getOneOffEntry());
            }
        }
        for (IPatch pi : this.notNeeds) {
            NPatchRelations nPatchRelations = omap.getRelations(pi);
            Collection<NPatchRelation> collection = nPatchRelations.getSingleConflicts();
            for (NPatchRelation nPatchRelation : collection) {
                if (!nPatchRelation.to().isInOh() || this.notNeedDuplicates.contains(nPatchRelation.from().getOneOffEntry())) continue;
                m2 = nPatchRelation.from().isInOh() ? (Integer)pohPos.get(nPatchRelation.from().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.from().getOneOffEntry());
                n2 = nPatchRelation.to().isInOh() ? (Integer)pohPos.get(nPatchRelation.to().getOneOffEntry()) : (Integer)piPos.get(nPatchRelation.to().getOneOffEntry());
                if (nPatchRelation.getDef().getBugs().size() > 0) {
                    sameStuff = nPatchRelation.getDef().getBugs();
                    resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                    continue;
                }
                sameStuff = nPatchRelation.getDef().getFiles();
                resObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
            }
        }
        oneOffEntryArray = oldConflicts = resObj.getListOfPatchesToBeMerged();
        int n3 = oneOffEntryArray.length;
        boolean bl = false;
        while (var20_65 < n3) {
            OneOffEntry oneOffEntry = oneOffEntryArray[var20_65];
            notNeedConflicts.add(oneOffEntry);
            ++var20_65;
        }
        resObj.setListOfPatchesToBeMerged(notNeedConflicts.toArray(new OneOffEntry[notNeedConflicts.size()]));
        if (this.code == StatusCode.APPLY_DEPENDENTS_FAIL || this.code == StatusCode.MULTI_COMPOSITES || this.code == StatusCode.PREREQ_OVERLAY_CYCLE || this.code == StatusCode.ROLLBACK_COMPOSITE_FAIL || this.code == StatusCode.ROLLBACK_DEPENDENTS_FAIL || this.code == StatusCode.INVALID_PSU_RELATION || this.code == StatusCode.NEED_MERGE_PATCH || this.code == StatusCode.SUBSET_OVERLAY_SUPERSET) {
            resObj.addDetail(this.buffer.toString());
        }
    }

    private IConflictResolutionPlanner checkConflictCore(String oracleHome, Collection<IPatch> pis, Collection<IPatch> pohs, ConflictOutput output, boolean againstOH) {
        OLogger.logTime(new StringBuffer(""));
        IConflictMapBuilder builder = ConflictMapBuilder.getInstance();
        Configuration cfg = new Configuration();
        IConflictMap map = null;
        map = againstOH ? builder.build(pis, pohs) : builder.build(pis);
        Collection<IPatch> tpis = map.getPi();
        for (IPatch pi : tpis) {
            NPatchRelations relations = map.getRelations(pi);
            Collection<NPatchRelation> supersets = relations.getSupersets();
            if (supersets.size() <= 0) continue;
            this.supersetFlag = true;
        }
        AutoWeightConflictResolutionPlanner planner = new AutoWeightConflictResolutionPlanner(map);
        INPatchPlan plan = null;
        PrereqSet canGoSet = new PrereqSet();
        PrereqSet conflictSet = new PrereqSet();
        PrereqSet notNeedSet = new PrereqSet();
        PrereqSet rollbackSet = new PrereqSet();
        try {
            plan = planner.plan(cfg);
        }
        catch (Throwable t) {
            this.buffer.setLength(0);
            if (t instanceof MultiCompositeException) {
                int i2;
                MultiCompositeException exception = (MultiCompositeException)t;
                List composites = exception.getCompositePatches();
                this.buffer.append("There are ");
                this.buffer.append(composites.size()).append(" composites[");
                for (i2 = 0; i2 < composites.size() - 1; ++i2) {
                    this.buffer.append(((IPatch)composites.get(i2)).getPatchId()).append(",");
                }
                this.buffer.append(((IPatch)composites.get(i2)).getPatchId()).append("] being applied.\n");
                this.buffer.append("OPatch do not allow more than one composite applied at a time.");
                this.code = StatusCode.MULTI_COMPOSITES;
            } else if (t instanceof PrereqNotExistException) {
                PrereqNotExistException exception = (PrereqNotExistException)t;
                IPatch pi = exception.getPatch();
                Set nonPrereqs = exception.getNonExistPrereqs();
                this.buffer.append("Interim patch ").append(pi.getPatchId());
                this.buffer.append("  requires prerequisite patch(es) ");
                this.buffer.append(nonPrereqs.toString());
                this.buffer.append(" which are not present in the Oracle Home.\n");
                this.buffer.append("Apply prerequisite patch(es) ").append(nonPrereqs.toString());
                this.buffer.append(" before applying interim patch ").append(pi.getPatchId());
                this.buffer.append(".");
                this.code = StatusCode.APPLY_DEPENDENTS_FAIL;
            } else if (t instanceof IntraConflictException) {
                Collection<NPatchRelation> relation;
                NPatchRelations relations;
                HashSet<IPatch> conflicts = new HashSet<IPatch>();
                HashSet<IPatch> notneed = new HashSet<IPatch>();
                map = planner.getFinalConflictMap();
                Collection<IPatch> ppis = map.getPi();
                HashSet<IPatch> cango = new HashSet<IPatch>(ppis);
                for (IPatch patch : ppis) {
                    relations = map.getRelations(patch);
                    relation = relations.getBetters();
                    for (NPatchRelation nPatchRelation : relation) {
                        notneed.add(nPatchRelation.to());
                    }
                    relation = relations.getSupersets();
                    for (NPatchRelation nPatchRelation : relation) {
                        notneed.add(nPatchRelation.to());
                    }
                }
                for (IPatch patch : ppis) {
                    relations = map.getRelations(patch);
                    relation = relations.getWholeConflicts();
                    for (NPatchRelation nPatchRelation : relation) {
                        if (notneed.contains(nPatchRelation.from()) || notneed.contains(nPatchRelation.to())) continue;
                        conflicts.add(nPatchRelation.from().getParent());
                        conflicts.add(nPatchRelation.to().getParent());
                    }
                }
                cango.removeAll(conflicts);
                cango.removeAll(notneed);
                for (IPatch patch : cango) {
                    canGoSet.add(patch.getOneOffEntry());
                }
                for (IPatch patch : conflicts) {
                    conflictSet.add(patch.getOneOffEntry());
                }
                for (IPatch patch : notneed) {
                    notNeedSet.add(patch.getOneOffEntry());
                }
                output.update(canGoSet, conflictSet, notNeedSet);
                this.code = StatusCode.CONFLICT;
            } else if (t instanceof MoreThanTwoPSUTrainException) {
                MoreThanTwoPSUTrainException exception = (MoreThanTwoPSUTrainException)t;
                List composites = exception.getCompositePatches();
                IPatch ocpb = (IPatch)composites.get(0);
                if (ocpb != null) {
                    this.buffer.append("It's not allowed to install more than two level psu train. Please rollback the OCPB [");
                    this.buffer.append(ocpb.getPatchId());
                    this.buffer.append("] in oracle home firstly .");
                }
                this.code = StatusCode.INVALID_PSU_RELATION;
            } else if (t instanceof InvalidPSUTrainException) {
                int i3;
                InvalidPSUTrainException exception = (InvalidPSUTrainException)t;
                List composites = exception.getCompositePatches();
                this.buffer.append("The relation between ");
                this.buffer.append(composites.size()).append(" composites[");
                for (i3 = 0; i3 < composites.size() - 1; ++i3) {
                    this.buffer.append(((IPatch)composites.get(i3)).getPatchId()).append(",");
                }
                this.buffer.append(((IPatch)composites.get(i3)).getPatchId()).append("] are invalid.\n");
                this.buffer.append("Please contact SE team to regenerate the patches.");
                this.code = StatusCode.INVALID_PSU_RELATION;
            } else if (t instanceof SubsetOverlaySupersetException) {
                SubsetOverlaySupersetException exception = (SubsetOverlaySupersetException)t;
                this.buffer.append(t.getMessage());
                this.code = StatusCode.SUBSET_OVERLAY_SUPERSET;
            } else {
                this.buffer.append("There is a prereq/overlay cycle exist in being applied patches.");
                this.code = StatusCode.PREREQ_OVERLAY_CYCLE;
            }
            output.setResult(PrereqResult.ExecuteStatus.FAILED);
            return planner;
        }
        Collection<IPatch> canGos = plan.getCanAppliedPatches();
        Collection<IPatch> conflicts = plan.getConflictedPatches();
        this.notNeeds = plan.getNotNeededPatches();
        Collection<IPatch> rollbacks = plan.getAutoRollbackPatches();
        Collection<IPatch> ignores = plan.getIgnoredPatches();
        StringBuffer canGoBuff = new StringBuffer();
        canGoBuff.append("Adapter can go list:");
        for (IPatch canGo : canGos) {
            if (canGo.isComposite()) {
                Collection<IPatch> subPatches = canGo.getSubPatches();
                for (IPatch iPatch : subPatches) {
                    if (!iPatch.isActive()) continue;
                    canGoBuff.append(" " + iPatch.getPatchId());
                    canGoSet.add(iPatch.getOneOffEntry());
                }
                canGoSet.add(canGo.getOneOffEntry());
                canGoBuff.append(" " + canGo.getPatchId());
                continue;
            }
            canGoSet.add(canGo.getOneOffEntry());
            canGoBuff.append(" " + canGo.getPatchId());
        }
        OLogger.log(canGoBuff.toString(), new Object[0]);
        canGoBuff.setLength(0);
        canGoBuff.append("Adapter not need list:");
        for (IPatch notNeed : this.notNeeds) {
            canGoBuff.append(" ").append(notNeed.getPatchId());
            notNeedSet.add(notNeed.getOneOffEntry());
        }
        OLogger.log(canGoBuff.toString(), new Object[0]);
        canGoBuff.setLength(0);
        canGoBuff.append("Adapter auto-rollback list:");
        for (IPatch rollback : rollbacks) {
            canGoBuff.append(" ").append(rollback.getPatchId());
            rollbackSet.add(rollback.getOneOffEntry());
            if (!rollback.isSubSetOfBigPi()) continue;
            this.subsetOfBigPi.add(rollback.getOneOffEntry());
        }
        OLogger.log(canGoBuff.toString(), new Object[0]);
        if (conflicts.size() > 0) {
            HashMap dependentMap = planner.getDependentMap();
            List<MergePatch> mergePatchList = planner.getMergePatchList();
            if (dependentMap.size() > 0) {
                this.buffer.setLength(0);
                HashSet comps = new HashSet();
                HashMap piPrereqs = new HashMap();
                for (Object k2 : dependentMap.keySet()) {
                    IPatch patch = (IPatch)k2;
                    Set dependentIDs = (Set)dependentMap.get(patch);
                    if (patch.isComposite() && dependentIDs.isEmpty()) {
                        if (!comps.contains(patch.getParent())) {
                            this.buffer.append("Patch ").append(patch.getParent().getPatchId());
                            this.buffer.append(" is a composite patch which could not be rollback.\n");
                            comps.add(patch.getParent());
                        }
                        this.code = StatusCode.ROLLBACK_COMPOSITE_FAIL;
                        continue;
                    }
                    if (patch.isInOh()) {
                        this.buffer.append("OPatch will not roll back patch(es) [");
                        this.buffer.append(patch.getPatchId());
                        this.buffer.append("] until you have rolled back dependent patch(es) ");
                        this.buffer.append(dependentIDs.toString());
                        this.buffer.append(".\n");
                        this.code = StatusCode.ROLLBACK_DEPENDENTS_FAIL;
                        continue;
                    }
                    Iterator<NPatchRelation> iterator = dependentIDs.iterator();
                    while (iterator.hasNext()) {
                        NPatchRelation dependent = iterator.next();
                        if (piPrereqs.containsKey(dependent)) {
                            ((HashSet)piPrereqs.get(dependent)).add(patch);
                            continue;
                        }
                        HashSet<IPatch> patches = new HashSet<IPatch>();
                        patches.add(patch);
                        piPrereqs.put(dependent, patches);
                    }
                    this.code = StatusCode.APPLY_DEPENDENTS_FAIL;
                }
                if (this.code == StatusCode.APPLY_DEPENDENTS_FAIL && piPrereqs.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (Object obj : piPrereqs.keySet()) {
                        stringBuffer.setLength(0);
                        stringBuffer.append("[");
                        for (IPatch patch : (HashSet)piPrereqs.get(obj)) {
                            stringBuffer.append(" ").append(patch.getPatchId());
                        }
                        stringBuffer.append(" ]");
                        String buffStr = stringBuffer.toString();
                        this.buffer.append("Interim patch ").append(obj);
                        this.buffer.append(" requires prerequisite patch(es) ");
                        this.buffer.append(buffStr);
                        this.buffer.append(" which are skipped from apply list.\n");
                        this.buffer.append("Apply prerequisite patch(es) ").append(buffStr);
                        this.buffer.append(" before applying interim patch ").append(obj);
                        this.buffer.append(".\n");
                    }
                }
            } else if (mergePatchList != null && !mergePatchList.isEmpty()) {
                this.buffer.setLength(0);
                for (MergePatch mergePatch : mergePatchList) {
                    if (!mergePatch.needMerge()) continue;
                    this.buffer.append("Please rebuild the superset patch [");
                    this.buffer.append(mergePatch.getSupersetPatch().getPatchId());
                    this.buffer.append("] to make sure it supersedes all the relevant patch(es) [");
                    for (IPatch iPatch : mergePatch.getToMergePatch()) {
                        this.buffer.append(iPatch.getPatchId());
                        this.buffer.append(",");
                    }
                    this.buffer.deleteCharAt(this.buffer.length() - 1);
                    this.buffer.append("].\nThe rebuild patch should contain bug fix ");
                    this.buffer.append(mergePatch.getBugs().toString());
                    this.buffer.append(".\n");
                    this.code = StatusCode.NEED_MERGE_PATCH;
                }
            } else {
                this.code = StatusCode.CONFLICT;
            }
            IConflictMap finalMap = planner.getFinalConflictMap();
            HashSet<OneOffEntry> hashConflicts = new HashSet<OneOffEntry>();
            for (IPatch iPatch : conflicts) {
                hashConflicts.add(iPatch.getParent().getOneOffEntry());
                NPatchRelations relations = finalMap.getRelations(iPatch);
                Collection<NPatchRelation> pohConflicts = relations.getWholeConflicts();
                for (NPatchRelation rel : pohConflicts) {
                    hashConflicts.add(rel.to().getParent().getOneOffEntry());
                }
            }
            for (OneOffEntry oneOffEntry : hashConflicts) {
                conflictSet.add(oneOffEntry);
            }
        }
        output.update(canGoSet, conflictSet, notNeedSet, rollbackSet);
        if (conflicts.size() > 0) {
            output.setResult(PrereqResult.ExecuteStatus.FAILED);
        } else {
            output.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
        return planner;
    }

    public Collection<IPatch> convertOneOffEntryToIPatch(OneOffEntry[] oneOffs, boolean isInOH, boolean skipMissingComp, String oracleHome) {
        ArrayList<IPatch> patches = new ArrayList<IPatch>(oneOffs.length);
        for (OneOffEntry oneOff : oneOffs) {
            String[] bugs;
            Patch patch = new Patch(oneOff, isInOH);
            PatchAction[] actions = null;
            for (String bug : bugs = oneOff.getBugIDsFixed()) {
                patch.addBug(bug);
            }
            actions = skipMissingComp ? PrereqAPI.getPatchActionsForPresentComponents(oracleHome, "TPP", oneOff) : oneOff.getPatchActions();
            int patchingModel = PatchingModel.returnModelCode(oracleHome);
            if (patchingModel == 2) {
                patches.add(patch);
                continue;
            }
            StringBuilder buff = new StringBuilder(1024);
            for (PatchAction action : actions) {
                String[] procList;
                String[] files;
                PatchAction copy;
                buff.setLength(0);
                if (action instanceof CopyAction) {
                    copy = (CopyAction)action;
                    for (String str : files = ((CopyAction)copy).filesTouched(oracleHome)) {
                        patch.addFile(str);
                    }
                    continue;
                }
                if (action instanceof JarAction) {
                    copy = (JarAction)action;
                    files = ((JarAction)copy).filesTouched(oracleHome);
                    for (int i2 = 0; i2 < files.length - 1; ++i2) {
                        buff.append(files[i2]);
                    }
                    buff.append(":");
                    String lastFile = files[files.length - 1];
                    if (lastFile.startsWith(File.separator)) {
                        lastFile = lastFile.substring(1, lastFile.length());
                    }
                    buff.append(lastFile);
                    patch.addFile(buff.toString());
                    continue;
                }
                if (action instanceof ArchiveAction) {
                    copy = (ArchiveAction)action;
                    files = ((ArchiveAction)copy).filesTouched(oracleHome);
                    for (int i3 = 0; i3 < files.length - 1; ++i3) {
                        buff.append(files[i3]);
                    }
                    buff.append(files[files.length - 1].replace(File.separator, ":"));
                    patch.addFile(buff.toString());
                    continue;
                }
                if (action instanceof dbpkgAction) {
                    dbpkgAction dbpkg = (dbpkgAction)action;
                    buff.append(dbpkg.getPackageName());
                    buff.append(":");
                    buff.append(dbpkg.getPkgType());
                    patch.addFile(buff.toString());
                    continue;
                }
                if (action instanceof hotpatchAction) {
                    String[] objectNames;
                    hotpatchAction hotpatch = (hotpatchAction)action;
                    for (String objectName : objectNames = hotpatch.filesTouched(oracleHome)) {
                        buff.setLength(0);
                        buff.append(oracleHome).append(File.separator);
                        buff.append(objectName.replaceAll("/", File.separator));
                        patch.addFile(buff.toString());
                    }
                    continue;
                }
                if (action instanceof oarAction) {
                    oarAction oar = (oarAction)action;
                    for (String file : files = oar.filesTouched(oracleHome)) {
                        patch.addFile(file);
                    }
                    continue;
                }
                if (action instanceof onewaycopyAction) {
                    onewaycopyAction onewaycopy = (onewaycopyAction)action;
                    for (String str : files = onewaycopy.filesTouched(oracleHome)) {
                        patch.addFile(str);
                    }
                    continue;
                }
                if (action instanceof sharedlibraryAction) {
                    sharedlibraryAction sharedlibrary = (sharedlibraryAction)action;
                    files = sharedlibrary.filesTouched(oracleHome);
                    for (int i4 = 0; i4 < files.length - 1; ++i4) {
                        buff.append(files[i4]);
                    }
                    buff.append(File.separator);
                    buff.append(files[files.length - 1]);
                    patch.addFile(buff.toString());
                    continue;
                }
                if (!(action instanceof sqlprocAction) || !OPatchEnv.isRunSql()) continue;
                sqlprocAction sqlproc = (sqlprocAction)action;
                for (String proc : procList = sqlproc.filesTouched(oracleHome)) {
                    patch.addFile(proc);
                }
            }
            patches.add(patch);
        }
        return patches;
    }

    private void createCompositeMatrixOutput(OneOffEntry[] piOneOffs, OneOffEntry[] pohOneOffs, IConflictMap finalmap, ConflictMatrixOutput resObj) {
        boolean compositeFlag = false;
        ArrayList<OneOffEntry> piOneOffsWithTopComposite = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> piAndPohOneOffsWithTopComposite = new ArrayList<OneOffEntry>();
        for (int i3 = 0; i3 < piOneOffs.length; ++i3) {
            OneOffEntry pi = piOneOffs[i3];
            if (pi.getIsComposite() && pi.getConstituentActiveField().equals(pi.getID())) {
                piOneOffsWithTopComposite.add(pi);
                piAndPohOneOffsWithTopComposite.add(pi);
            }
            piOneOffsWithTopComposite.add(pi);
            piAndPohOneOffsWithTopComposite.add(pi);
        }
        for (int i2 = 0; i2 < pohOneOffs.length; ++i2) {
            OneOffEntry poh = pohOneOffs[i2];
            if (poh.getIsComposite() && poh.getConstituentActiveField().equals(poh.getID())) {
                piAndPohOneOffsWithTopComposite.add(poh);
            }
            piAndPohOneOffsWithTopComposite.add(poh);
        }
        int piWithTopCompositeLen = piOneOffsWithTopComposite.size();
        int piAndPohWithTopCompositeLen = piAndPohOneOffsWithTopComposite.size();
        HashMap piWithTopCompositePos = new HashMap(piWithTopCompositeLen);
        HashMap pohWithTopCompositePos = new HashMap(piAndPohWithTopCompositeLen);
        for (int i2 = 0; i2 < piWithTopCompositeLen; ++i2) {
            piWithTopCompositePos.put(piOneOffsWithTopComposite.get(i2), i2);
        }
        for (int i3 = 0; i3 < piAndPohWithTopCompositeLen; ++i3) {
            pohWithTopCompositePos.put(piAndPohOneOffsWithTopComposite.get(i3), i3);
        }
        ConflictMatrixOutput wholeResObj = new ConflictMatrixOutput(piWithTopCompositeLen, piAndPohWithTopCompositeLen);
        for (int i4 = 0; i4 < piWithTopCompositeLen; ++i4) {
            for (int j2 = 0; j2 < piAndPohWithTopCompositeLen; ++j2) {
                wholeResObj.setRowPatchID(i4, j2, ((OneOffEntry)piOneOffsWithTopComposite.get(i4)).getID());
                wholeResObj.setColumnPatchID(i4, j2, ((OneOffEntry)piAndPohOneOffsWithTopComposite.get(j2)).getID());
                wholeResObj.setRowPatchType(i4, j2, ((OneOffEntry)piOneOffsWithTopComposite.get(i4)).getIsComposite() ? ConflictMatrixOutput.PatchType.COMPOSITE : ConflictMatrixOutput.PatchType.ONEOFF);
                wholeResObj.setColumnPatchType(i4, j2, ((OneOffEntry)piAndPohOneOffsWithTopComposite.get(j2)).getIsComposite() ? ConflictMatrixOutput.PatchType.COMPOSITE : ConflictMatrixOutput.PatchType.ONEOFF);
            }
        }
        Collection<IPatch> tpis = finalmap.getPi();
        for (IPatch pi : tpis) {
            int n2;
            int m2;
            Collection<String> sameStuff;
            NPatchRelations relations = finalmap.getRelations(pi);
            Collection<NPatchRelation> wholeconflicts = relations.getWholeCompositeConflicts();
            for (NPatchRelation nPatchRelation : wholeconflicts) {
                int m22 = (Integer)piWithTopCompositePos.get(nPatchRelation.from().getOneOffEntry());
                int n22 = (Integer)pohWithTopCompositePos.get(nPatchRelation.to().getOneOffEntry());
                if (nPatchRelation.getDef().getBugs().size() > 0) {
                    sameStuff = nPatchRelation.getDef().getBugs();
                    wholeResObj.add(m22, n22, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_CONFLICT);
                } else {
                    sameStuff = nPatchRelation.getDef().getFiles();
                    wholeResObj.add(m22, n22, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT);
                }
                compositeFlag = true;
            }
            Collection<NPatchRelation> wholeSupersets = relations.getWholeCompositeSupersets();
            for (NPatchRelation rel3 : wholeSupersets) {
                m2 = (Integer)piWithTopCompositePos.get(rel3.from().getOneOffEntry());
                n2 = (Integer)pohWithTopCompositePos.get(rel3.to().getOneOffEntry());
                sameStuff = rel3.getDef().getBugs();
                wholeResObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUPERSET);
                compositeFlag = true;
            }
            Collection<NPatchRelation> collection = relations.getWholeCompositeSubsets();
            for (NPatchRelation rel4 : collection) {
                m2 = (Integer)piWithTopCompositePos.get(rel4.from().getOneOffEntry());
                n2 = (Integer)pohWithTopCompositePos.get(rel4.to().getOneOffEntry());
                sameStuff = rel4.getDef().getBugs();
                wholeResObj.add(m2, n2, sameStuff.toArray(new String[sameStuff.size()]), ConflictMatrixOutput.ConflictType.BUG_SUBSET);
                compositeFlag = true;
            }
        }
        if (compositeFlag) {
            resObj.setCompositeMatrix(wholeResObj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusCode {
        PASSED,
        CONFLICT,
        APPLY_DEPENDENTS_FAIL,
        ROLLBACK_DEPENDENTS_FAIL,
        ROLLBACK_COMPOSITE_FAIL,
        MULTI_COMPOSITES,
        PREREQ_OVERLAY_CYCLE,
        INVALID_PSU_RELATION,
        NEED_MERGE_PATCH,
        SUBSET_OVERLAY_SUPERSET;

    }
}

