/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchlogger;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class CmdLinePrintStream
extends PrintStream {
    PrintStream console_out;
    PrintStream console_error;
    PrintWriter log_stream;

    public CmdLinePrintStream(PrintStream primary, PrintStream error, String fileLoc) throws IOException {
        super(primary);
        this.console_out = primary;
        this.console_error = error;
        this.log_stream = new PrintWriter(new FileOutputStream(fileLoc, true), true);
    }

    public void flush() {
        if (this.console_out != null) {
            this.console_out.flush();
        }
        if (this.log_stream != null) {
            this.log_stream.flush();
        }
    }

    public void close() {
        if (this.console_out != null) {
            this.console_out.close();
        }
        if (this.log_stream != null) {
            this.log_stream.close();
        }
    }

    public boolean checkError() {
        boolean ce1 = false;
        boolean ce2 = false;
        if (this.console_out != null) {
            ce1 = this.console_out.checkError();
        }
        if (this.log_stream != null) {
            ce2 = this.log_stream.checkError();
        }
        return ce1 || ce2;
    }

    public void write(int b2) {
        if (this.console_out != null) {
            this.console_out.write(b2);
        }
        if (this.log_stream != null) {
            this.log_stream.write(b2);
        }
    }

    public void write(byte[] buf, int off, int len) {
        if (this.console_out != null) {
            this.console_out.write(buf, off, len);
        }
        if (this.log_stream != null) {
            this.log_stream.write(new String(buf, off, len));
        }
    }

    public void writeSecondary(String str) {
        if (this.log_stream != null) {
            this.log_stream.write(str);
        }
    }

    public void printlnPrimary(String s) {
        if (this.console_out != null) {
            this.console_out.println(s);
        }
    }

    public void printPrimary(String s) {
        if (this.console_out != null) {
            this.console_out.print(s);
        }
        this.flush();
    }

    public void printlnPrimary(Object s) {
        if (this.console_out != null) {
            this.console_out.println(s);
        }
    }

    public void printlnError(String s) {
        if (this.console_error != null) {
            this.console_error.println(s);
        } else {
            this.printlnPrimary(s);
        }
    }

    public void printlnError(Object s) {
        if (this.console_error != null) {
            this.console_error.println(s);
        } else {
            this.printlnPrimary(s);
        }
    }

    public void println() {
        if (this.console_out != null) {
            this.console_out.println();
        }
        this.writeSecondary("\n");
        this.flush();
    }

    public void println(boolean x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(char x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(int x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(long x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(float x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(double x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(char[] x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(String x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void println(Object x) {
        if (this.console_out != null) {
            this.console_out.println(x);
        }
        this.writeSecondary(x + "\n");
        this.flush();
    }

    public void setConsoleOut(PrintStream ps) {
        this.console_out = ps;
    }

    public void setConsoleErr(PrintStream ps) {
        this.console_error = ps;
    }
}

