/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.opatch.opatchfafmw.FMWException;
import oracle.opatch.opatchfafmw.FMWLogger;
import oracle.opatch.opatchfafmw.rb.RB;

class Logger {
    private static FMWLogger logger;
    private static ResourceBundle rb;
    static boolean debug;
    private static StringWriter sw;
    private static PrintWriter pw;

    private Logger() {
    }

    static void setLogger(FMWLogger fmwLogger) {
        logger = fmwLogger != null ? fmwLogger : new FMWLogger();
        debug = logger.debug();
        Locale locale = logger.locale();
        rb = locale != null ? ResourceBundle.getBundle("oracle.opatch.opatchfafmw.rb.RB", locale) : ResourceBundle.getBundle("oracle.opatch.opatchfafmw.rb.RB");
    }

    protected static String getString(RB.Entry key, Object ... params) {
        if (key == null) {
            return "null";
        }
        String value = rb.getString(key.name());
        if (params == null || params.length == 0) {
            return value;
        }
        try {
            return MessageFormat.format(value, params);
        }
        catch (Exception e2) {
            Logger.loge(e2);
            return value;
        }
    }

    static void error(RB.Entry key, Object ... args) {
        String msg = Logger.getString(key, args);
        Logger.printOnConsole("[FMW-ERROR] " + msg);
        throw new FMWException(key.getCode(), msg);
    }

    static void warn(RB.Entry key, Object ... args) {
        String msg = "[FMW-WARNING] " + Logger.getString(key, args);
        logger.printWarnMessage(msg);
    }

    static void log(RB.Entry key, Object ... args) {
        Logger.printOnConsole("[FMW] " + Logger.getString(key, args));
    }

    static void logm(String s) {
        logger.printInMainLogFile("[FMW] " + s);
    }

    static void close() {
        logger.close();
    }

    static void log(String s) {
        Logger.printOnConsole("[FMW] " + s);
    }

    static void loge(Exception e2) {
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        e2.printStackTrace(pw);
        pw.flush();
        sw.flush();
        Logger.printInLogFile("[FMW-EXCEPTION] " + sw.toString());
    }

    static void loge(RB.Entry key, Object ... args) {
        Logger.printInLogFile("[FMW-ERROR] " + Logger.getString(key, args));
    }

    static void loge(String s) {
        Logger.printInLogFile("[FMW-ERROR] " + s);
    }

    static void logw(String s) {
        Logger.printInLogFile("[FMW-WARNING] " + s);
    }

    static void logi(String s) {
        Logger.printInLogFile("[FMW-INFO] " + s);
    }

    static void logAndPrint(String s) {
        Logger.printOnConsole("[FMW] " + s);
        Logger.printInLogFile("[FMW-INFO] " + s);
    }

    static void debug(String s) {
        if (debug) {
            Logger.printInLogFile("[FMW-DEBUG] " + s);
        }
    }

    private static void printOnConsole(String s) {
        logger.printOnConsole(s);
    }

    private static void printInLogFile(String s) {
        logger.printInLogFile(s);
    }

    static {
        sw = new StringWriter();
        pw = new PrintWriter(sw);
    }
}

