/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class CompositeLifeCycle
implements Operation {
    private final boolean start;
    private String operation;
    private String name = "";
    private String revision = "";

    CompositeLifeCycle(boolean start) {
        this.start = start;
        this.operation = start ? "Start Composite" : "Stop Composite";
    }

    public void run(FMWContext c2) {
        block26: {
            boolean compositeLifecycleNoNeed = false;
            try {
                OPatchStepAdapter executionStep = null;
                Domain d2 = c2.getDomain();
                if (!d2.connected()) {
                    try {
                        executionStep = new OPatchStepAdapter(OPatchFAStep.SETUP_JMX_CONNECTION);
                        executionStep.setStepDescription("Setup JMX Connectivity");
                        c2.getContextBuilder().addExecutionStep(executionStep);
                        d2.setupJMXConnection();
                    }
                    catch (Throwable t) {
                        executionStep.setSuccess(false);
                        executionStep.setExceptionObject(new RuntimeException(t));
                        String errorMsg = "";
                        errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
                        if (errorMsg != null) {
                            executionStep.setErrorMessage(errorMsg);
                        }
                        Logger.loge(new RuntimeException(t));
                        throw t;
                    }
                }
                SOAComposite sc = c2.getSOAComposite();
                SOACompositeManager scm = d2.getSOACompositeManager();
                this.name = sc.getName();
                this.revision = sc.getRevision();
                if (this.revision == null || this.revision.length() < 1) {
                    executionStep = new OPatchStepAdapter(OPatchFAStep.SOA_FIND_CORRECT_REVISION);
                    executionStep.setStepDescription("Trying to get the default revision since the input revision is empty.");
                    c2.getContextBuilder().addExecutionStep(executionStep);
                    try {
                        this.revision = scm.getDefaultRevision(this.name);
                    }
                    catch (Throwable t) {
                        executionStep.setSuccess(false);
                        executionStep.setExceptionObject(new RuntimeException(t));
                        String errorMsg = "";
                        errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
                        if (errorMsg != null) {
                            executionStep.setErrorMessage(errorMsg);
                        }
                        Logger.loge(new RuntimeException(t));
                        throw t;
                    }
                }
                String compositeDN = "default/" + this.name + "!" + this.revision;
                if (this.start) {
                    try {
                        executionStep = new OPatchStepAdapter(OPatchFAStep.START_SOA_COMPOSITE);
                        executionStep.setStepDescription("Start SOA Composite with name \"" + this.name + "\" and revision \"" + this.revision + "\"");
                        c2.getContextBuilder().addExecutionStep(executionStep);
                        if (scm.isStarted(compositeDN)) {
                            compositeLifecycleNoNeed = true;
                            throw new RuntimeException("SOA Composite with name \"" + this.name + " and revision \"" + this.revision + "\" is already started.");
                        }
                        scm.startComposite(this.name, this.revision);
                        break block26;
                    }
                    catch (Throwable t) {
                        executionStep.setSuccess(false);
                        executionStep.setExceptionObject(new RuntimeException(t));
                        String errorMsg = "";
                        errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
                        if (errorMsg != null) {
                            executionStep.setErrorMessage(errorMsg);
                        }
                        Logger.loge(new RuntimeException(t));
                        throw t;
                    }
                }
                try {
                    executionStep = new OPatchStepAdapter(OPatchFAStep.STOP_SOA_COMPOSITE);
                    executionStep.setStepDescription("Stop SOA Composite with name \"" + this.name + "\" and revision \"" + this.revision + "\"");
                    c2.getContextBuilder().addExecutionStep(executionStep);
                    if (!scm.isStarted(compositeDN)) {
                        compositeLifecycleNoNeed = true;
                        throw new RuntimeException("SOA Composite with name \"" + this.name + " and revision \"" + this.revision + "\" is already stopped.");
                    }
                    scm.stopComposite(this.name, this.revision);
                }
                catch (Throwable t) {
                    executionStep.setSuccess(false);
                    executionStep.setExceptionObject(new RuntimeException(t));
                    String errorMsg = "";
                    errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
                    if (errorMsg != null) {
                        executionStep.setErrorMessage(errorMsg);
                    }
                    Logger.loge(new RuntimeException(t));
                    throw t;
                }
            }
            catch (Exception e2) {
                if (!compositeLifecycleNoNeed) {
                    Logger.error(RB.Entry.ERROR_IN_COMPOSITE_LIFECYCLE, this.operation, this.name, this.revision);
                } else if (this.start) {
                    Logger.error(RB.Entry.ERROR_IN_COMPOSITE_LIFECYCLE_WITH_NO_NEED_ACTION, this.name, this.revision, "started");
                } else {
                    Logger.error(RB.Entry.ERROR_IN_COMPOSITE_LIFECYCLE_WITH_NO_NEED_ACTION, this.name, this.revision, "stopped");
                }
            }
            catch (Throwable t) {
                if (!compositeLifecycleNoNeed) {
                    Logger.error(RB.Entry.ERROR_IN_COMPOSITE_LIFECYCLE, this.operation, this.name, this.revision);
                }
                if (this.start) {
                    Logger.error(RB.Entry.ERROR_IN_COMPOSITE_LIFECYCLE_WITH_NO_NEED_ACTION, this.name, this.revision, "started");
                }
                Logger.error(RB.Entry.ERROR_IN_COMPOSITE_LIFECYCLE_WITH_NO_NEED_ACTION, this.name, this.revision, "stopped");
            }
        }
    }
}

