/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqSet;

public class PatchValidation {
    private NApplyData data;

    public PatchValidation(NApplyData data) {
        this.data = data;
    }

    public void validatePatch(NApplyData data) {
        OneOffEntry[] patchesToApply = data.getPatchesToApply();
        try {
            StringBuffer dBuff = new StringBuffer("N-Apply: check if patchesToApply is empty.");
            OLogger.debug(dBuff);
            NapplyProcessHelper.checkEmptyPatchList(patchesToApply);
        }
        catch (RuntimeException e2) {
            StringBuffer buff = new StringBuffer(OLogger.getString("OUI-67306", new Object[]{"NApply", "apply"}));
            OLogger.debug(buff);
            OPatchStateManagerFactory.getInstance().setErrorCode(216);
            throw new RuntimeException(buff.toString());
        }
        PrereqSet patchesToApplySet = new PrereqSet(patchesToApply);
        if (OPatchSessionHelper.hasHotPatch(patchesToApplySet) && OPatchSessionHelper.hasNonHotPatch(patchesToApplySet)) {
            RuntimeException re = new RuntimeException(OLogger.getString("OUI-67320", new Object[]{OPatchSessionHelper.getHotPatchIDs(patchesToApplySet), OPatchSessionHelper.getNonHotPatchIDs(patchesToApplySet), "napply"}));
            throw re;
        }
        if (OPatchSessionHelper.hasMiniPatchset(patchesToApplySet) && OPatchSessionHelper.hasNormalOneoffs(patchesToApplySet)) {
            RuntimeException re = new RuntimeException(OLogger.getString("OUI-67326", new Object[]{OPatchSessionHelper.getNonMiniPatchSetIDs(patchesToApplySet), OPatchSessionHelper.getMiniPatchSetIDs(patchesToApplySet), "napply"}));
            throw re;
        }
    }
}

