/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.IOException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class OUIInventorySession {
    private OiicStandardInventorySession iSession = null;

    protected OUIInventorySession(String opatchVersion) {
        this.iSession = new OiicStandardInventorySession("OPatch", opatchVersion);
    }

    protected void initSession(int nAccessLevel) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, IllegalArgumentException {
        StringBuffer msg = new StringBuffer("==> OUIInventorySession::initSession(): ");
        this.logDebuggedIds(msg);
        if (this.iSession != null) {
            this.iSession.initSession(nAccessLevel);
        }
    }

    protected void endSession() {
        StringBuffer msg = new StringBuffer("==> OUIInventorySession::endSession(): ");
        this.logDebuggedIds(msg);
        if (this.iSession != null) {
            this.iSession.endSession();
        }
    }

    protected OiiiInstallAreaControl getInstallAreaControl() {
        if (this.iSession != null) {
            return this.iSession.getInstallAreaControl();
        }
        return null;
    }

    private void logDebuggedIds(StringBuffer msg) {
        long pid = OPatchEnv.getProcessID();
        long tid = OLogger.getThreadID();
        msg.append("Process ID: ");
        msg.append(pid);
        msg.append(". Thread ID: ");
        msg.append(tid);
        OLogger.debug(msg);
    }
}

