/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;

public class IPMUtil {
    public static String getCompsXMLLocation(String baseDir) {
        if (baseDir == null) {
            return "";
        }
        String contentsXML = IPMUtil.getContentsXMLLocation(baseDir);
        StringBuffer buff = new StringBuffer(contentsXML);
        buff.append(File.separator);
        buff.append("comps.xml");
        return buff.toString();
    }

    public static String getOneoffsLocation(String baseDir) {
        if (baseDir == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer(baseDir);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("oneoffs");
        return buff.toString();
    }

    public static String getOneoffsLocation(String baseDir, String patchId) {
        if (baseDir == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer(IPMUtil.getOneoffsLocation(baseDir));
        buff.append(File.separator);
        buff.append(patchId);
        return buff.toString();
    }

    private static String getContentsXMLLocation(String baseDir) {
        if (baseDir == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer(baseDir);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("ContentsXML");
        return buff.toString();
    }

    public static boolean canGetLangsForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getLang = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("getLangs")) continue;
                    getLang = true;
                    break;
                }
            }
            return getLang;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean canGetDescForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getLang = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("setDescription")) continue;
                    getLang = true;
                    break;
                }
            }
            return getLang;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean canSetSubsetPatchesForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry");
            boolean setSupercede = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("setSupersededOneOffsList")) continue;
                    setSupercede = true;
                    break;
                }
            }
            return setSupercede;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean canGetUniqueIDForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getUniq = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("getUniqID")) continue;
                    getUniq = true;
                    break;
                }
            }
            return getUniq;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean isGridHome(String oracleHomePath) {
        String crsctlCmd = oracleHomePath + File.separator + StringResource.CRSCTL_COMMAND;
        crsctlCmd = OPatchEnv.isWindows() ? crsctlCmd + ".exe" : crsctlCmd + ".bin";
        File crsctl = new File(crsctlCmd);
        return crsctl.exists();
    }

    public static String getLocalHostName(boolean isFullyQualified) {
        String hostName;
        block4: {
            hostName = null;
            try {
                InetAddress ia = InetAddress.getLocalHost();
                if (ia == null) break block4;
                if (isFullyQualified) {
                    if ((ia = InetAddress.getByName(ia.getHostAddress())) != null) {
                        return ia.getHostName();
                    }
                    break block4;
                }
                return ia.getHostName();
            }
            catch (UnknownHostException e2) {
                OLogger.debug("Could not get local host name.");
            }
        }
        return hostName;
    }
}

