/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.ConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckConflictAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleHomeConflictMap {
    private static OracleHomeConflictMap instance = null;
    private IConflictMap map = null;
    private List<OneOffEntry> subsetPSUTrain = new ArrayList<OneOffEntry>();
    private List<OneOffEntry> subsetPatches = new ArrayList<OneOffEntry>();
    private List<IPatch> subsetIPatches = new ArrayList<IPatch>();
    private Map<String, Set<String>> supersetMap = new HashMap<String, Set<String>>();

    public static OracleHomeConflictMap getInstance(OneOffEntry[] pohOneOffs, String oracleHome) {
        if (instance == null) {
            instance = new OracleHomeConflictMap(pohOneOffs, oracleHome);
        }
        return instance;
    }

    public static OracleHomeConflictMap getInstance() {
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    private OracleHomeConflictMap(OneOffEntry[] pohOneOffs, String oracleHome) {
        boolean isInOH = false;
        boolean skipMissingComp = false;
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        Collection<IPatch> pohs = adapter.convertOneOffEntryToIPatch(pohOneOffs, isInOH, skipMissingComp, oracleHome);
        IConflictMapBuilder builder = ConflictMapBuilder.getInstance();
        this.map = builder.buildOH(pohs);
    }

    public List<OneOffEntry> getSubsetPSUTrain() {
        if (this.subsetPSUTrain != null && !this.subsetPSUTrain.isEmpty()) {
            return this.subsetPSUTrain;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations = this.map.getRelations(poh);
            Collection<NPatchRelation> subSets = relations.getSubsetPSU();
            if (subSets.size() <= 0) continue;
            this.subsetPSUTrain.add(poh.getOneOffEntry());
            for (IPatch subpatch : poh.getSubPatches()) {
                this.subsetPSUTrain.add(subpatch.getOneOffEntry());
            }
        }
        return this.subsetPSUTrain;
    }

    public List<OneOffEntry> getSubsetPatches() {
        if (this.subsetPatches != null && !this.subsetPatches.isEmpty()) {
            return this.subsetPatches;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations;
            Collection<NPatchRelation> subSets;
            if (poh.isComposite() || (subSets = (relations = this.map.getRelations(poh)).getSubsets()).size() <= 0) continue;
            this.subsetPatches.add(poh.getOneOffEntry());
        }
        return this.subsetPatches;
    }

    public List<IPatch> getSubsetIPatches() {
        if (this.subsetIPatches != null && !this.subsetIPatches.isEmpty()) {
            return this.subsetIPatches;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations = this.map.getRelations(poh);
            Collection<NPatchRelation> subSets = relations.getSubsets();
            if (subSets.size() <= 0) continue;
            this.subsetIPatches.add(poh);
        }
        return this.subsetIPatches;
    }

    public List<IPatch> getSupersetPatches(IPatch poh) {
        ArrayList<IPatch> supersets = new ArrayList<IPatch>();
        NPatchRelations relations = this.map.getRelations(poh);
        Collection<NPatchRelation> subSets = relations.getSubsets();
        for (NPatchRelation subRelation : subSets) {
            supersets.add(subRelation.to());
        }
        return supersets;
    }

    public Map<String, Set<String>> getSupersetMap() {
        if (this.supersetMap != null && !this.supersetMap.keySet().isEmpty()) {
            return this.supersetMap;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations = this.map.getRelations(poh);
            Collection<NPatchRelation> supersets = relations.getSupersets();
            for (NPatchRelation supersetRel : supersets) {
                String supersetID = supersetRel.from().getPatchId();
                String subsetID = supersetRel.to().getPatchId();
                if (this.supersetMap.containsKey(supersetID)) {
                    this.supersetMap.get(supersetID).add(subsetID);
                    continue;
                }
                HashSet<String> subsetSets = new HashSet<String>();
                subsetSets.add(subsetID);
                this.supersetMap.put(supersetID, subsetSets);
            }
        }
        return this.supersetMap;
    }

    public List<String> addConflictsWithToActivePatch(List<String> rollbackIds) {
        Collection<IPatch> tpohs = this.map.getPi();
        ArrayList<String> finalRollbackList = new ArrayList<String>(rollbackIds);
        OLogger.debug("Original rollback list: " + rollbackIds);
        for (String rollbackId : rollbackIds) {
            for (IPatch poh : tpohs) {
                NPatchRelations relations;
                if (!poh.getPatchId().equals(rollbackId) || (relations = this.map.getRelations(poh)).getSupersets().isEmpty()) continue;
                for (NPatchRelation relation : relations.getSupersets()) {
                    IPatch toActivePatch = relation.to();
                    boolean toActive = true;
                    NPatchRelations toActiveRelations = this.map.getRelations(toActivePatch);
                    for (NPatchRelation toActiveRelation : toActiveRelations.getSubsets()) {
                        if (finalRollbackList.contains(toActiveRelation.to().getPatchId())) continue;
                        toActive = false;
                        break;
                    }
                    if (!toActive || toActiveRelations.getConflicts().isEmpty()) continue;
                    for (NPatchRelation conflictRelation : toActiveRelations.getConflicts()) {
                        IPatch conflictPatch = conflictRelation.to();
                        if (toActivePatch.getOverlaysID().contains(conflictPatch.getPatchId()) || conflictPatch.getOverlaysID().contains(toActivePatch.getPatchId()) || finalRollbackList.contains(conflictPatch.getPatchId())) continue;
                        if (conflictPatch.isComposite()) {
                            throw new RuntimeException("Please nrollback composite patch " + conflictPatch.getPatchId() + " together with " + poh.getPatchId() + ".\n");
                        }
                        finalRollbackList.add(conflictPatch.getPatchId());
                    }
                }
            }
        }
        OLogger.debug("Extend rollback list: " + finalRollbackList);
        return finalRollbackList;
    }
}

