/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.ConflictResolutionPlanner;
import oracle.opatch.conflicttextualinterpreter.IConfiguration;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConflictResolutionPlanner;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.MergePatch;
import oracle.opatch.conflicttextualinterpreter.OPatchValidationException;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoWeightConflictResolutionPlanner
implements IConflictResolutionPlanner {
    private IConflictMap m_orgMap;
    private ConflictResolutionPlanner m_result;

    public AutoWeightConflictResolutionPlanner(IConflictMap map) {
        this.m_orgMap = map;
        this.m_result = new ConflictResolutionPlanner(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INPatchPlan plan(IConfiguration cfg) throws OPatchValidationException {
        boolean isForceConflict_bk;
        INPatchPlan plan;
        block6: {
            INPatchPlan iNPatchPlan;
            plan = this.m_result.plan(cfg);
            INPatchPlan forcePlan = null;
            isForceConflict_bk = OPatchEnv.isForceConflict();
            ConflictResolutionPlanner forceResult = new ConflictResolutionPlanner(this.m_orgMap);
            try {
                try {
                    if (!this.doNeedAutoForce(plan)) break block6;
                    OPatchEnv.setForceConflict(true);
                    forcePlan = forceResult.plan(cfg);
                    if (this.isBugLost(forcePlan)) break block6;
                    OLogger.debug("There is no bug lost when using -force_conflict, So we return the force plan which is generated with the option -force_conflict.");
                    this.m_result = forceResult;
                    iNPatchPlan = forcePlan;
                    Object var8_8 = null;
                }
                catch (Exception exception) {
                    Object var8_10 = null;
                    OPatchEnv.setForceConflict(isForceConflict_bk);
                    return plan;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OPatchEnv.setForceConflict(isForceConflict_bk);
                throw throwable;
            }
            OPatchEnv.setForceConflict(isForceConflict_bk);
            return iNPatchPlan;
        }
        Object var8_9 = null;
        OPatchEnv.setForceConflict(isForceConflict_bk);
        return plan;
    }

    private boolean doNeedAutoForce(INPatchPlan plan) {
        return plan.getConflictedPatches().size() != 0 && !OPatchEnv.isForceConflict();
    }

    private boolean isBugLost(INPatchPlan forcePlan) {
        if (forcePlan.getConflictedPatches().size() == 0) {
            Set<String> bugs;
            Collection<IPatch> canGo = forcePlan.getCanAppliedPatches();
            Collection<IPatch> arb = forcePlan.getAutoRollbackPatches();
            Collection<IPatch> orginalOh = this.m_orgMap.getPoh();
            HashSet<String> newPohBugs = new HashSet<String>();
            HashSet<String> oldPohBugs = new HashSet<String>();
            for (IPatch patch : canGo) {
                bugs = this.getBugs(patch);
                newPohBugs.addAll(bugs);
            }
            for (IPatch patch : orginalOh) {
                bugs = this.getBugs(patch);
                if (!arb.contains(patch)) {
                    newPohBugs.addAll(bugs);
                }
                oldPohBugs.addAll(bugs);
            }
            return !newPohBugs.containsAll(oldPohBugs);
        }
        return true;
    }

    private Set<String> getBugs(IPatch patch) {
        Set<String> bugs = patch.getBugs();
        if (patch.isComposite()) {
            for (IPatch subPatch : patch.getSubPatches()) {
                bugs.addAll(subPatch.getBugs());
            }
        }
        return bugs;
    }

    @Override
    public IConflictMap getFinalConflictMap() {
        return this.m_result.getFinalConflictMap();
    }

    @Override
    public IConflictMap getOrginalConflictMap() {
        return this.m_result.getOrginalConflictMap();
    }

    @Override
    public HashMap getDependentMap() {
        return this.m_result.getDependentMap();
    }

    @Override
    public List<MergePatch> getMergePatchList() {
        return this.m_result.getMergePatchList();
    }
}

