/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.SetResolution;
import oracle.opatch.opatchlogger.OLogger;

public class AddBackStep
implements IStep {
    public void process(IConflictMap map, INPatchPlan plan) {
        SetResolution setRes = SetResolution.getInstance();
        HashMap reasonMap = setRes.getReasonMap();
        Set removedPatches = reasonMap.keySet();
        for (IPatch removedPatch : removedPatches) {
            OLogger.debug("Patch may be added back: " + removedPatch.getPatchId());
            boolean addBack = true;
            NPatchRelations relations = (NPatchRelations)reasonMap.get(removedPatch);
            if (relations == null || relations.isEmpty()) {
                addBack = false;
            }
            ArrayList<NPatchRelation> allRelations = new ArrayList<NPatchRelation>();
            allRelations.addAll(relations.getBetters());
            allRelations.addAll(relations.getConflicts());
            allRelations.addAll(relations.getDuplicates());
            allRelations.addAll(relations.getSubsets());
            allRelations.addAll(relations.getSupersets());
            allRelations.addAll(relations.getWorses());
            for (NPatchRelation relation : allRelations) {
                IPatch reasonPatch = relation.to();
                if (reasonPatch.isInOh()) {
                    if (plan.getAutoRollbackPatches().contains(reasonPatch)) continue;
                    addBack = false;
                    break;
                }
                if (plan.getNotNeededPatches().contains(reasonPatch)) continue;
                addBack = false;
                break;
            }
            if (!addBack) continue;
            if (!removedPatch.getPrereqsID().isEmpty()) {
                boolean prereqExist = true;
                Collection removedList = setRes.getRemovedList();
                Collection<String> prereqs = removedPatch.getPrereqsID();
                for (String prereq : prereqs) {
                    if (!removedList.contains(prereq)) continue;
                    prereqExist = false;
                    break;
                }
                if (!prereqExist) continue;
            }
            if (removedPatch.isInOh()) {
                OLogger.debug("remove patch" + removedPatch.getPatchId() + "from auto rollback list.");
                plan.getAutoRollbackPatches().remove(removedPatch);
                continue;
            }
            OLogger.debug("remove patch" + removedPatch.getPatchId() + "from no need list.");
            plan.getNotNeededPatches().remove(removedPatch);
        }
    }
}

