/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchZipInputStream;
import oracle.opatch.OUIReplacer;
import oracle.opatch.opatchlogger.OLogger;

public class ZipUtilities {
    static final int BUFFER = 2048;

    public static String unzip(String zipFile, String toLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("ZipUtilities::unzip");
        OLogger.debug(buff);
        BufferedOutputStream dest = null;
        boolean topLevel = true;
        String topLevelDir = "";
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(zipFile);
            OPatchZipInputStream zis = new OPatchZipInputStream((InputStream)new BufferedInputStream(fis), zipFile);
            HashMap externalAttrInfo = zis.getPermissionInfo();
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                OLogger.debug(new StringBuffer("Extracting : " + entry));
                String extractPath = toLocation + File.separator + entry.getName();
                int permissionInfo = Integer.parseInt(externalAttrInfo.get(entry.getName()).toString());
                if (topLevel) {
                    topLevel = false;
                    topLevelDir = entry.getName();
                }
                if (entry.isDirectory()) {
                    File e2 = new File(extractPath);
                    if (!e2.exists()) {
                        e2.mkdirs();
                    }
                    if (OPatchEnv.isWindows()) continue;
                    OUIReplacer.changePermission(extractPath, permissionInfo);
                    continue;
                }
                File entryFile = new File(extractPath);
                if (entryFile.exists()) {
                    entryFile.delete();
                } else if (!entryFile.getParentFile().exists()) {
                    entryFile.getParentFile().mkdirs();
                }
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(extractPath);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                if (OPatchEnv.isWindows()) continue;
                OUIReplacer.changePermission(extractPath, permissionInfo);
            }
            zis.close();
        }
        catch (Exception e3) {
            buff = new StringBuffer("Failed to unzip the given file : ");
            buff.append(zipFile);
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException("Unzip failied", e3);
            throw re;
        }
        return topLevelDir;
    }
}

