/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.LinkedList;
import oracle.opatch.PatchObject;

public class OPatchState {
    protected int stateOrder;
    protected String stateName;
    protected int baseErrorCode;
    protected int currentErrorCode;
    protected int maxErrorCode;
    protected int defaultLevel;
    protected boolean mandatory;
    protected boolean present = true;
    protected boolean visible = true;

    protected OPatchState(int stateOrder, int baseErrorCode, int maxErrorCode, String stateName, int defaultLevel, boolean mandatory) {
        this.stateOrder = stateOrder;
        this.baseErrorCode = baseErrorCode;
        this.currentErrorCode = baseErrorCode;
        this.stateName = stateName;
        this.maxErrorCode = maxErrorCode;
        this.defaultLevel = defaultLevel;
        this.mandatory = mandatory;
    }

    protected int getFileNumberForDirectory(File srcFile) {
        int fileNumber = 0;
        LinkedList<File> list = new LinkedList<File>();
        File[] file = srcFile.listFiles();
        for (int i2 = 0; i2 < file.length; ++i2) {
            if (file[i2].isDirectory()) {
                list.add(file[i2]);
                continue;
            }
            ++fileNumber;
        }
        while (!list.isEmpty()) {
            File tmp = (File)list.removeFirst();
            if (tmp.isDirectory()) {
                file = tmp.listFiles();
                if (file == null) continue;
                for (int i3 = 0; i3 < file.length; ++i3) {
                    if (file[i3].isDirectory()) {
                        list.add(file[i3]);
                        continue;
                    }
                    ++fileNumber;
                }
                continue;
            }
            ++fileNumber;
        }
        return fileNumber;
    }

    protected String getStateAssociatedMessage(String oracleHome, PatchObject[] patchObject) {
        return new String("");
    }

    protected int getStateOrder() {
        return this.stateOrder;
    }

    protected int getBaseErrorCode() {
        return this.baseErrorCode;
    }

    protected String getStateName() {
        return this.stateName;
    }

    protected int getCurrentErrorCode() {
        return this.currentErrorCode;
    }

    protected void setCurrentErrorCode(int errorCode) {
        if (errorCode >= this.baseErrorCode && errorCode <= this.maxErrorCode) {
            this.currentErrorCode = errorCode;
        }
    }

    protected int getDefaultLogLevel() {
        return this.defaultLevel;
    }

    protected boolean isPresent() {
        return this.present;
    }

    protected void setPresent(PatchObject[] po) {
    }

    protected boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean in) {
        this.visible = in;
    }

    protected boolean isMandatory() {
        return this.mandatory;
    }

    protected void setMandatory(boolean in) {
        this.mandatory = in;
    }

    protected String getStateSpecifiedInformation(PatchObject patchObject, String extraMessage) {
        return null;
    }
}

