/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.HashMap;
import oracle.opatch.Applicable;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;

class OHPatchForRollbackState
extends OPatchState {
    public OHPatchForRollbackState() {
        super(10, 102, 114, "Patch Oracle Home for rollback", OLogger.INFO, false);
    }

    protected String getStateAssociatedMessage(String oracleHome, PatchObject[] patchObject) {
        StringBuffer buff = new StringBuffer("");
        String patchLocation = patchObject[0].getPatchLocation();
        String patchID = patchObject[0].getPatchID();
        PatchComponent[] includedComponents = patchObject[0].getIncludedPatchComponents();
        PatchAction[] applicablePatchActions = new PatchAction[]{};
        int includedLen = includedComponents.length;
        int copyFileNumber = 0;
        int makeFileNumber = 0;
        HashMap<String, PatchAction> archiveObjectMap = new HashMap<String, PatchAction>();
        int archiveFileNumber = 0;
        HashMap<String, PatchAction> jarObjectMap = new HashMap<String, PatchAction>();
        int jarFileNumber = 0;
        for (int i2 = 0; i2 < includedLen; ++i2) {
            PatchComponent pc = includedComponents[i2];
            applicablePatchActions = patchObject[0].getImmediatePatchActionsToExecuteForComponent(pc);
            for (int j2 = 0; j2 < applicablePatchActions.length; ++j2) {
                PatchAction p2 = applicablePatchActions[j2];
                if (!(p2 instanceof Applicable)) continue;
                Applicable ap = (Applicable)((Object)p2);
                boolean actionApplicable = p2.isAppliedOK();
                if (!actionApplicable) continue;
                if (p2 instanceof CopyAction) {
                    ++copyFileNumber;
                    continue;
                }
                if (p2 instanceof JarAction) {
                    jarObjectMap.put(((JarAction)p2).getJarName(), p2);
                    ++jarFileNumber;
                    continue;
                }
                if (p2 instanceof ArchiveAction) {
                    archiveObjectMap.put(((ArchiveAction)p2).getArchiveName(), p2);
                    ++archiveFileNumber;
                    continue;
                }
                if (!(p2 instanceof MakeAction)) continue;
                ++makeFileNumber;
            }
        }
        if (copyFileNumber != 0) {
            buff.append("Copy " + copyFileNumber + " file(s) to Oracle Home");
            if (archiveFileNumber + jarFileNumber + makeFileNumber != 0) {
                buff.append(";\n");
            }
        }
        if (archiveFileNumber != 0) {
            buff.append("Archive " + archiveObjectMap.size() + " library file(s) with " + archiveFileNumber + " Object file(s)");
            if (jarFileNumber + makeFileNumber != 0) {
                buff.append(";\n");
            }
        }
        if (jarFileNumber != 0) {
            buff.append("Archive " + jarObjectMap.size() + " jar file(s) with " + jarFileNumber + " class file(s)");
            if (makeFileNumber != 0) {
                buff.append(";\n");
            }
        }
        if (makeFileNumber != 0) {
            buff.append("Do " + makeFileNumber + " relink(s)");
        }
        buff.append(".");
        return buff.toString();
    }
}

