/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionTree;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJarUtil {
    static StringBuffer db;

    protected static boolean foundEntry(String entryToSearch, String entryName) {
        if (OPatchEnv.isWindows()) {
            boolean found = entryToSearch.equalsIgnoreCase(entryName);
            if (!found) {
                String converted = entryToSearch.replace('\\', '/');
                entryName = entryName.replace('\\', '/');
                return converted.equalsIgnoreCase(entryName);
            }
            return true;
        }
        return entryToSearch.equalsIgnoreCase(entryName);
    }

    private static void writeBackEntry(String patchedFile, ZipInputStream parentStream, ZipOutputStream patchedStream, ZipEntry parentEntry) throws IOException {
        String pName = parentEntry.getName();
        StringBuffer buff = new StringBuffer("Not matched, updating patched file \"");
        buff.append(patchedFile);
        buff.append("\" using entry \"");
        buff.append(pName);
        buff.append("\" (write-back)");
        OLogger.debug(buff.toString());
        MultiJarUtil.addOneZipEntryToStreamUsingStream(parentStream, patchedStream, parentEntry);
    }

    private static void closeStreams(ZipInputStream in, ZipOutputStream out) {
        try {
            out.close();
        }
        catch (IOException e2) {
            OLogger.printlnOnLog(e2.getMessage());
        }
        try {
            in.close();
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(e3.getMessage());
        }
    }

    private static void writeOneZipEntryToFile(String fileName, ZipInputStream zin) throws IOException {
        byte[] buff = new byte[1024];
        try {
            FileOutputStream fout = new FileOutputStream(fileName);
            int n2 = 0;
            while ((n2 = zin.read(buff)) > -1) {
                fout.write(buff, 0, n2);
            }
            fout.flush();
            fout.close();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in writeOneZipEntryToStream(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void addOneZipEntryToStreamUsingStream(ZipInputStream zin, ZipOutputStream zout, ZipEntry ze) throws IOException {
        byte[] buff = new byte[1024];
        try {
            String name = ze.getName();
            if (OPatchEnv.isWindows()) {
                name = name.replace('\\', '/');
            }
            ZipEntry newEntry = new ZipEntry(name);
            newEntry.setTime(ze.getTime());
            zout.putNextEntry(newEntry);
            int n2 = 0;
            while ((n2 = zin.read(buff)) > -1) {
                zout.write(buff, 0, n2);
            }
            zout.flush();
            zout.closeEntry();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in addOneZipEntryToStreamUsingStream(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void addOneZipEntryToStreamUsingFile(ZipOutputStream zout, String file, ZipEntry ze) throws IOException {
        byte[] buff = new byte[1024];
        try {
            File f2 = new File(file);
            long fl = f2.length();
            if (fl <= 0L) {
                StringBuffer buffer = new StringBuffer("addOneZipEntryToStreamUsingFile()");
                buffer.append(", file is " + file);
                buffer.append(", file has zero-byte len, skip creating an jarentry for it.\n");
                OLogger.debug(buffer);
                return;
            }
            String name = ze.getName();
            if (OPatchEnv.isWindows()) {
                name = name.replace('\\', '/');
            }
            ZipEntry newEntry = new ZipEntry(name);
            zout.putNextEntry(newEntry);
            FileInputStream fin = new FileInputStream(file);
            int n2 = 0;
            while ((n2 = fin.read(buff)) > -1) {
                zout.write(buff, 0, n2);
            }
            zout.flush();
            zout.closeEntry();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in addOneZipEntryToStreamUsingFile(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void addOneZipEntryToStreamUsingDirectory(ZipOutputStream zout, ZipEntry ze) throws IOException {
        try {
            String name = ze.getName();
            if (OPatchEnv.isWindows()) {
                name = name.replace('\\', '/');
            }
            ZipEntry newEntry = new ZipEntry(name);
            zout.putNextEntry(newEntry);
            zout.flush();
            zout.closeEntry();
        }
        catch (IOException e2) {
            db = new StringBuffer("Error in addOneZipEntryToStreamUsingDirectory(): ");
            db.append(e2.getMessage());
            OLogger.debug(db);
            throw e2;
        }
    }

    protected static void copyFile(String src, String dst) throws IOException {
        try {
            File srcFile = new File(src);
            File dstFile = new File(dst);
            if (dstFile.exists()) {
                dstFile.delete();
            }
            SystemCall.copyFile(srcFile, dstFile);
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
            IOException ie = new IOException(e2.getMessage());
            ie.setStackTrace(e2.getStackTrace());
            throw ie;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void backUpForRollbackBaseOnJarTree(JarActionTree.TreeNode node, String jarIn, String backForRollBackPath, String scratchLocation, String relWorkPath, ArrayList failed) throws RuntimeException {
        JarActionTree.TreeNode curNode;
        StringBuffer buff = new StringBuffer("MultiJarUtil::backUpForRollbackBaseOnJarTree() called");
        OLogger.debug(buff.toString());
        if (node == null || node.isLeaf()) {
            return;
        }
        ArrayList childs = node.getChilds();
        String parentPath = node.getJarPath();
        relWorkPath = MultiJarUtil.combineEntry(relWorkPath, parentPath);
        ZipInputStream targetJarFile = null;
        try {
            File jarFile = new File(jarIn);
            if (!jarFile.exists()) {
                buff = new StringBuffer("backUpForRollbackBaseOnJarTree() failed. Parent jar file for backing up not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                throw new IOException(buff.toString());
            }
            targetJarFile = new ZipInputStream(new FileInputStream(jarFile));
        }
        catch (IOException e2) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.BACKUPFORROLLBACK, true, e2.getMessage());
            OLogger.printlnOnLog(e2.getMessage());
            return;
        }
        ZipEntry entry = null;
        try {
            block8: while (true) {
                if ((entry = targetJarFile.getNextEntry()) == null) {
                    targetJarFile.close();
                    break;
                }
                int i2 = 0;
                while (true) {
                    if (i2 >= childs.size()) continue block8;
                    curNode = (JarActionTree.TreeNode)childs.get(i2);
                    if (MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) {
                        curNode.setEntryExist(true);
                        if (curNode.isLeaf()) {
                            String backupLocation = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, curNode.getJarAction().getClassName());
                            try {
                                File backup = new File(backupLocation);
                                if (!backup.getParentFile().exists()) {
                                    backup.getParentFile().mkdirs();
                                }
                                buff = new StringBuffer("Back up leaf entry \"" + entry.getName() + "\" in Jar File \"");
                                buff.append(jarIn);
                                buff.append("\" to \"" + backupLocation + "\"");
                                OLogger.debug(buff.toString());
                                MultiJarUtil.writeOneZipEntryToFile(backupLocation, targetJarFile);
                                curNode.getJarAction().setTriedToBackUp(true);
                                continue block8;
                            }
                            catch (IOException e3) {
                                curNode.getJarAction().setTriedToBackUp(true);
                                curNode.getJarAction().setErrorMsg(e3.getMessage());
                                failed.add(curNode.getJarAction());
                                buff = new StringBuffer("File not backed up from leaf entry \"" + entry.getName() + "\" in Jar File \"");
                                buff.append(jarIn);
                                buff.append("\" to \"" + backupLocation + "\"");
                                buff.append(e3.getMessage());
                                OLogger.println(buff.toString());
                                throw new RuntimeException(e3);
                            }
                        }
                        String lowLevelRelPath = MultiJarUtil.combineEntry(relWorkPath, curNode.getEntryName());
                        String lowLevelLoc = MultiJarUtil.getWorkPath(scratchLocation, lowLevelRelPath);
                        File lowLevelJarFile = new File(lowLevelLoc);
                        try {
                            buff = new StringBuffer("Unzip Multi-level Jar file \"" + jarIn + "\" to low-level Jar Entry file \"");
                            buff.append(lowLevelLoc + "\"");
                            OLogger.debug(buff.toString());
                            MultiJarUtil.writeOneZipEntryToFile(lowLevelLoc, targetJarFile);
                        }
                        catch (IOException e4) {
                            MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.BACKUPFORROLLBACK, true, e4.getMessage());
                            buff = new StringBuffer("Unzip Multi-level Jar file failed in MultiJarUtil::backUpForRollbackBaseOnJarTree()");
                            OLogger.printlnOnLog(buff.toString());
                            continue block8;
                        }
                        MultiJarUtil.backUpForRollbackBaseOnJarTree(curNode, lowLevelLoc, backForRollBackPath, scratchLocation, relWorkPath, failed);
                        if (!lowLevelJarFile.exists()) continue block8;
                        lowLevelJarFile.delete();
                        continue block8;
                    }
                    ++i2;
                }
                break;
            }
        }
        catch (IOException e1) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.BACKUPFORROLLBACK, true, e1.getMessage());
            buff = new StringBuffer("Backup for rollback failed: ");
            buff.append(e1.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        int i3 = 0;
        while (i3 < childs.size()) {
            curNode = (JarActionTree.TreeNode)childs.get(i3);
            if (!curNode.isEntryExist()) {
                MultiJarUtil.recursiveBackupNewFile(curNode, backForRollBackPath, failed);
            }
            ++i3;
        }
        return;
    }

    public static void recursiveBackupNewFile(JarActionTree.TreeNode node, String backForRollBackPath, ArrayList failed) {
        StringBuffer buff = new StringBuffer("MultiJarUtil::recursiveBackupNewFile() called");
        OLogger.debug(buff.toString());
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            String backupPath = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, node.getJarAction().getClassName());
            File backupFile = new File(backupPath);
            buff = new StringBuffer("Create zero byte file for new files in jar actions as backing up for rollback. ");
            buff.append("Back up zero byte file to \"");
            buff.append(backupPath);
            buff.append("\"");
            OLogger.debug(buff.toString());
            if (!backupFile.getParentFile().exists()) {
                backupFile.getParentFile().mkdirs();
            }
            try {
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                node.getJarAction().setTriedToBackUp(true);
            }
            catch (RuntimeException e2) {
                node.getJarAction().setTriedToBackUp(true);
                node.getJarAction().setErrorMsg(e2.getMessage());
                failed.add(node.getJarAction());
                buff = new StringBuffer("Back up for new files from jar actions failed. ");
                OLogger.printlnOnLog(buff.toString());
            }
        } else {
            ArrayList childs = node.getChilds();
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                JarActionTree.TreeNode child = (JarActionTree.TreeNode)childs.get(i2);
                MultiJarUtil.recursiveBackupNewFile(child, backForRollBackPath, failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String rollbackBaseOnJarTree(JarActionTree.TreeNode node, String parentJarFile, String scratchLocation, String backForRollBackPath, String relativeWorkName, ArrayList failed) throws RuntimeException {
        StringBuffer buff = new StringBuffer("MultiJarUtil::rollbackBaseOnJarTree() called");
        OLogger.debug(buff.toString());
        if (node == null) return null;
        if (node.isLeaf()) {
            return null;
        }
        ArrayList childs = node.getChilds();
        String parentPath = node.getJarPath();
        String relWorkName = MultiJarUtil.combineEntry(relativeWorkName, parentPath);
        String dstPatchedPath = MultiJarUtil.combineEntry(relativeWorkName, node.getEntryName());
        String tempOutput = MultiJarUtil.getPatchedPath(scratchLocation, dstPatchedPath);
        boolean modify = Rules.SystemWrite_continue();
        buff = new StringBuffer("Rollback for Jar Action: Extract entry from file \"" + parentJarFile);
        buff.append("\" to produce file \"");
        buff.append(tempOutput + "\"");
        OLogger.debug(buff.toString());
        ZipInputStream targetJarFile = null;
        JarOutputStream jos = null;
        try {
            File patchedJar = new File(parentJarFile);
            if (!patchedJar.exists()) {
                buff = new StringBuffer("rollbackBaseOnJarTree() failed. Rollbacked Jar file not exist : \"");
                buff.append(parentJarFile);
                buff.append("\"");
                throw new IOException(buff.toString());
            }
            targetJarFile = new ZipInputStream(new FileInputStream(patchedJar));
            if (modify) {
                jos = new JarOutputStream(new FileOutputStream(tempOutput));
            }
        }
        catch (IOException e2) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.ROLLBACK, true, e2.getMessage());
            buff = new StringBuffer("Rollback failed in creating inputstream/outputstream.");
            buff.append(e2.getMessage());
            OLogger.printlnOnLog(buff.toString());
            try {
                if (jos != null) {
                    jos.close();
                }
                if (targetJarFile == null) return null;
                targetJarFile.close();
                return null;
            }
            catch (IOException ioe) {
                OLogger.printlnOnLog("Close stream failed: " + ioe.getMessage());
            }
            return null;
        }
        ZipEntry entry = null;
        while (true) {
            boolean entryInTree;
            try {
                try {}
                catch (IOException e3) {
                    MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.ROLLBACK, true, e3.getMessage());
                    buff = new StringBuffer("Rollback failed: ");
                    buff.append(e3.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                    Object var26_32 = null;
                    if (!modify) return tempOutput;
                    MultiJarUtil.closeStreams(targetJarFile, jos);
                    return tempOutput;
                }
            }
            catch (Throwable throwable) {
                Object var26_33 = null;
                if (!modify) throw throwable;
                MultiJarUtil.closeStreams(targetJarFile, jos);
                throw throwable;
            }
            block17: do {
                if ((entry = targetJarFile.getNextEntry()) != null) {
                    entryInTree = false;
                } else {
                    Object var26_31 = null;
                    if (!modify) return tempOutput;
                    MultiJarUtil.closeStreams(targetJarFile, jos);
                    return tempOutput;
                }
                for (int i2 = 0; i2 < childs.size(); ++i2) {
                    JarActionTree.TreeNode curNode = (JarActionTree.TreeNode)childs.get(i2);
                    if (!MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) continue;
                    entryInTree = true;
                    curNode.setEntryExist(true);
                    if (curNode.isLeaf()) {
                        String backupLocation = MultiJarUtil.getBackupForRollbackPath(backForRollBackPath, curNode.getJarAction().getClassName());
                        try {
                            File backup = new File(backupLocation);
                            buff = new StringBuffer("backupForRollback File: \"" + backup.getAbsolutePath() + "\" Size: " + backup.length());
                            OLogger.debug(buff.toString());
                            if (!backup.exists() || backup.length() == 0L) {
                                curNode.getJarAction().setAlreadyPatched(true);
                                targetJarFile.closeEntry();
                                continue block17;
                            }
                            buff = new StringBuffer("Writing entry file \"" + backupLocation + "\" to Jar File \"" + tempOutput + "\"");
                            OLogger.debug(buff.toString());
                            if (modify) {
                                MultiJarUtil.addOneZipEntryToStreamUsingFile(jos, backupLocation, entry);
                            }
                            curNode.getJarAction().setAlreadyPatched(true);
                        }
                        catch (IOException e4) {
                            curNode.getJarAction().setApplyFailed();
                            curNode.getJarAction().setErrorMsg(e4.getMessage());
                            failed.add(curNode.getJarAction());
                            buff = new StringBuffer("Fail in reading or writing backup for rollback file \"");
                            buff.append(tempOutput);
                            buff.append("\" back. Error Message: ");
                            buff.append(e4.getMessage());
                            OLogger.printlnOnLog(buff.toString());
                        }
                        continue block17;
                    }
                    String lowLevelRelLoc = MultiJarUtil.combineEntry(relativeWorkName, curNode.getEntryName());
                    String lowLevelToLoc = MultiJarUtil.getWorkPath(scratchLocation, lowLevelRelLoc);
                    File tmpLowLevelJar = new File(lowLevelToLoc);
                    buff = new StringBuffer("Rollback : Unzip multi-level jar entry \"");
                    buff.append(entry.getName());
                    buff.append("\" to file \"");
                    buff.append(lowLevelToLoc);
                    buff.append("\"");
                    OLogger.debug(buff.toString());
                    try {
                        MultiJarUtil.writeOneZipEntryToFile(lowLevelToLoc, targetJarFile);
                    }
                    catch (IOException e5) {
                        MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.ROLLBACK, true, e5.getMessage());
                        buff = new StringBuffer("Unzip Multi-level jar to file \"");
                        buff.append(lowLevelToLoc);
                        buff.append("\" fail in MultiJarUtil::rollbackBaseOnJarTree()");
                        buff.append(e5.getStackTrace().toString());
                        OLogger.printlnOnLog(buff.toString());
                        continue block17;
                    }
                    String lowLevelJarPath = MultiJarUtil.rollbackBaseOnJarTree(curNode, lowLevelToLoc, scratchLocation, backForRollBackPath, relWorkName, failed);
                    File lowLevelJar = new File(lowLevelJarPath);
                    try {
                        buff = new StringBuffer("Rollback: Archive low-level Jar File: \"" + lowLevelJarPath + "\" into parent file \"");
                        buff.append(tempOutput + "\"");
                        OLogger.debug(buff.toString());
                        if (modify) {
                            MultiJarUtil.addOneZipEntryToStreamUsingFile(jos, lowLevelJarPath, entry);
                            lowLevelJar.delete();
                        }
                        tmpLowLevelJar.delete();
                    }
                    catch (IOException e6) {
                        MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.ROLLBACK, true, e6.getMessage());
                        buff = new StringBuffer("Write Entry back failed");
                        buff.append(e6.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                    }
                    continue block17;
                }
            } while (entryInTree);
            try {
                if (!modify) continue;
                MultiJarUtil.writeBackEntry(parentJarFile, targetJarFile, jos, entry);
            }
            catch (IOException e7) {
                throw new RuntimeException(e7.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void verifyBaseOnJarTree(JarActionTree.TreeNode node, HashMap result, String jarIn, String scratchLocation, String patchLocation, String relativeWorkName) throws IOException {
        StringBuffer buff = new StringBuffer("MultiJarUtil::verifyBaseOnJarTree called");
        OLogger.debug(buff.toString());
        if (node == null || node.isLeaf()) {
            return;
        }
        ArrayList childs = node.getChilds();
        String parentPath = MultiJarUtil.combineEntry(relativeWorkName, node.getJarPath());
        ZipInputStream patchedJar = null;
        try {
            File patchJarFile = new File(jarIn);
            if (!patchJarFile.exists()) {
                buff = new StringBuffer("verifyBaseOnJarTree() failed. Verified file not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                OLogger.printlnOnLog(buff.toString());
                throw new IOException(buff.toString());
            }
            patchedJar = new ZipInputStream(new FileInputStream(jarIn));
        }
        catch (IOException e2) {
            ArrayList failedEntries = new ArrayList();
            MultiJarUtil.getAllLeavesForNode(node, failedEntries, JarOperation.VERIFY, true, e2.getMessage());
            for (int i2 = 0; i2 < failedEntries.size(); ++i2) {
                result.put(((JarAction)failedEntries.get(i2)).getClassName(), new Boolean(false));
            }
            buff = new StringBuffer("Creating input stream for \"" + jarIn + "\"");
            buff.append(" failed.");
            buff.append(e2.getMessage());
            OLogger.printlnOnLog(buff.toString());
            return;
        }
        ZipEntry entry = null;
        while ((entry = patchedJar.getNextEntry()) != null) {
            boolean entryExist = false;
            for (int i3 = 0; i3 < childs.size(); ++i3) {
                JarActionTree.TreeNode curNode = (JarActionTree.TreeNode)childs.get(i3);
                if (!MultiJarUtil.foundEntry(entry.getName(), curNode.getEntryName())) continue;
                entryExist = true;
                curNode.setEntryExist(true);
                String curEntry = curNode.getEntryName();
                String completeRelativePath = MultiJarUtil.combineEntry(parentPath, curEntry);
                if (curNode.isLeaf()) {
                    boolean ok = false;
                    String classFileLoc = curNode.getJarAction().getSourceFile(patchLocation);
                    buff = new StringBuffer("\n(J+): Comparing nested file \"");
                    buff.append(classFileLoc);
                    buff.append("\" to the class entry \"");
                    buff.append(entry.getName());
                    buff.append("\" inside the jar file \"");
                    buff.append(jarIn);
                    buff.append("\"").append(" using scratch area \"");
                    buff.append(scratchLocation).append("\"");
                    OLogger.log(OLogger.FINE, buff.toString());
                    FileInputStream srcStream = null;
                    FileInputStream patchStream = null;
                    String toCompareFile = MultiJarUtil.getWorkPath(scratchLocation, completeRelativePath);
                    MultiJarUtil.writeOneZipEntryToFile(toCompareFile, patchedJar);
                    File classSourceFile = new File(classFileLoc);
                    srcStream = new FileInputStream(classSourceFile);
                    patchStream = new FileInputStream(new File(toCompareFile));
                    ok = PatchAction.fileCompare(srcStream, patchStream);
                    result.put(curNode.getJarAction().getClassName(), new Boolean(ok));
                    Object var23_32 = null;
                    try {
                        if (srcStream != null) {
                            srcStream.close();
                        }
                        if (patchStream == null) break;
                        patchStream.close();
                    }
                    catch (IOException iOException) {}
                    break;
                    {
                        catch (IOException ioe) {
                            result.put(curNode.getJarAction().getClassName(), new Boolean(false));
                            buff = new StringBuffer("verify() file comparetion failed: ");
                            buff.append(ioe.getMessage());
                            OLogger.printlnOnLog(buff.toString());
                            var23_32 = null;
                            try {
                                if (srcStream != null) {
                                    srcStream.close();
                                }
                                if (patchStream == null) break;
                                patchStream.close();
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        var23_32 = null;
                        try {
                            if (srcStream != null) {
                                srcStream.close();
                            }
                            if (patchStream != null) {
                                patchStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                String workJarFile = MultiJarUtil.getWorkPath(scratchLocation, completeRelativePath);
                buff = new StringBuffer("Unzip multi-level jar : ");
                buff.append("Extract low-level jar to \"" + workJarFile + "\"");
                OLogger.debug(buff.toString());
                try {
                    MultiJarUtil.writeOneZipEntryToFile(workJarFile, patchedJar);
                }
                catch (IOException e3) {
                    buff = new StringBuffer("Unzip multi-level jar failed: \n");
                    buff.append("Failed Jar Action Entries: ");
                    ArrayList failedEntries = new ArrayList();
                    MultiJarUtil.getAllLeavesForNode(curNode, failedEntries, JarOperation.VERIFY, true, e3.getMessage());
                    for (int j2 = 0; j2 < failedEntries.size(); ++j2) {
                        buff.append(" [ \"" + failedEntries.get(j2) + " ] ");
                        result.put(((JarAction)failedEntries.get(j2)).getClassName(), new Boolean(false));
                    }
                    buff.append(e3.getStackTrace());
                    OLogger.printlnOnLog(buff.toString());
                    break;
                }
                MultiJarUtil.verifyBaseOnJarTree(curNode, result, workJarFile, scratchLocation, patchLocation, parentPath);
                break;
            }
            if (entryExist) continue;
            patchedJar.closeEntry();
        }
        try {
            patchedJar.close();
        }
        catch (IOException e4) {
            buff = new StringBuffer("Close Jar File \"" + jarIn);
            buff.append("\" failed");
            buff.append(e4.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        for (int i4 = 0; i4 < childs.size(); ++i4) {
            JarActionTree.TreeNode curNode = (JarActionTree.TreeNode)childs.get(i4);
            if (curNode.isEntryExist() || !curNode.isLeaf()) continue;
            buff = new StringBuffer("The entry " + curNode.getEntryName() + " has not been applied into target Jar File");
            OLogger.printlnOnLog(buff.toString());
            result.put(curNode.getJarAction().getClassName(), new Boolean(false));
        }
    }

    protected static void clearEntryExistFlagRecursively(JarActionTree.TreeNode root) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            root.setEntryExist(false);
        } else {
            ArrayList childs = root.getChilds();
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                MultiJarUtil.clearEntryExistFlagRecursively((JarActionTree.TreeNode)childs.get(i2));
            }
        }
    }

    protected static void getAllLeavesForNode(JarActionTree.TreeNode node, ArrayList leaves, JarOperation jarOp, boolean fail, String errorMsg) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            if (fail) {
                if (jarOp.equals(JarOperation.APPLY)) {
                    node.getJarAction().setApplyFailed();
                } else if (jarOp.equals(JarOperation.ROLLBACK)) {
                    node.getJarAction().setRollbackFailed();
                } else if (jarOp.equals(JarOperation.BACKUPFORROLLBACK)) {
                    StringBuffer buff = new StringBuffer("Didn't back up entry [");
                    JarAction ja = node.getJarAction();
                    buff.append(ja.getChildPath().substring(1)).append(", ");
                    buff.append("] from file ").append(ja.getJarName());
                    ja.setBackupForRollbackDesc(buff.toString());
                    ja.setTriedToBackUp(true);
                }
                node.getJarAction().setErrorMsg(errorMsg);
            }
            leaves.add(node.getJarAction());
        } else {
            ArrayList childs = node.getChilds();
            for (int i2 = 0; i2 < childs.size(); ++i2) {
                MultiJarUtil.getAllLeavesForNode((JarActionTree.TreeNode)childs.get(i2), leaves, jarOp, fail, errorMsg);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String patchingBaseOnJarTree(JarActionTree.TreeNode node, String jarIn, String scratchPath, String patchLocation, String jarOut, String patchedJar, ArrayList failed) {
        if (node == null) return null;
        if (node.isLeaf()) {
            return null;
        }
        buff = new StringBuffer("MultiJarUtil:: patchingBaseOnJarTree() called");
        OLogger.debug(buff.toString());
        childs = node.getChilds();
        parentEntry = node.getEntryName();
        nodeJarPath = MultiJarUtil.combineEntry(jarOut, node.getJarPath());
        completeRelativePath = MultiJarUtil.combineEntry(jarOut, parentEntry);
        outAsInPath = MultiJarUtil.getPatchedPath(scratchPath, completeRelativePath);
        modify = Rules.SystemWrite_continue();
        jar = null;
        outStream = null;
        try {
            inputJarFile = new File(jarIn);
            if (!inputJarFile.exists()) {
                buff = new StringBuffer("patchingBaseOnJarTree() failed. Parent file which needs to be applied not exist : \"");
                buff.append(jarIn);
                buff.append("\"");
                OLogger.printlnOnLog(buff.toString());
                throw new IOException(buff.toString());
            }
            jar = new ZipInputStream(new FileInputStream(jarIn));
            if (modify) {
                outStream = new ZipOutputStream(new FileOutputStream(outAsInPath));
            }
            buff = new StringBuffer("Apply for Jar actions: Archive entry into file \"" + jarIn + "\"");
            buff.append(" to produce file  \"" + outAsInPath + "\"");
            OLogger.debug(buff.toString());
        }
        catch (IOException e) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.APPLY, true, e.getMessage());
            buff = new StringBuffer("Apply failed in creating inputstream/outputstream.");
            buff.append(e.getMessage());
            OLogger.printlnOnLog(buff.toString());
            try {
                if (jar != null) {
                    jar.close();
                }
                if (outStream == null) return null;
                outStream.close();
                return null;
            }
            catch (IOException ioe) {
                OLogger.printlnOnLog("Close stream failed: " + ioe.getMessage());
            }
            return null;
        }
        entry = null;
        jarEntryNameSet = new HashSet<String>();
        block22: while (true) {
            block43: {
                try {
                    while (true) {
                        entry = jar.getNextEntry();
                        if (entry != null) {
                            entryExist = false;
                            break block43;
                        }
                        jar.close();
                        break block22;
                        break;
                    }
                }
                catch (IOException e) {
                    MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.APPLY, true, e.getMessage());
                    buff = new StringBuffer("Apply failed: ");
                    buff.append(e.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                }
                break;
            }
            for (i = 0; i < childs.size(); ++i) {
                curNode = (JarActionTree.TreeNode)childs.get(i);
                entryName = curNode.getEntryName();
                jarEntryName = entry.getName();
                jarEntryNameSet.add(jarEntryName);
                if (!MultiJarUtil.foundEntry(jarEntryName, entryName)) continue;
                curNode.setEntryExist(true);
                if (curNode.isLeaf()) {
                    classSourceFile = curNode.getJarAction().getSourceFile(patchLocation);
                    buff = new StringBuffer("Update jar entry of Jar file \"");
                    buff.append(jarIn);
                    buff.append(" with patch file \"");
                    buff.append(classSourceFile + "\"");
                    OLogger.debug(buff.toString());
                    try {
                        if (modify) {
                            sourceFile = new File(classSourceFile);
                            if (!sourceFile.exists()) {
                                buff = new StringBuffer("Patching file \"");
                                buff.append(curNode.getJarAction().getChildPath());
                                buff.append("\" does not exist in patch location.");
                                throw new IOException(buff.toString());
                            }
                            MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, classSourceFile, entry);
                        }
                        curNode.getJarAction().setAlreadyPatched(true);
                    }
                    catch (IOException e) {
                        curNode.getJarAction().setErrorMsg(e.getMessage());
                        curNode.getJarAction().setApplyFailed();
                        failed.add(curNode.getJarAction());
                        buff = new StringBuffer("Apply failed while adding entry \"" + entry.getName() + "\"");
                        buff.append(" into file \"" + outAsInPath + "\"");
                        buff.append(e.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                        jar.closeEntry();
                    }
                } else {
                    outEntryName = curNode.getEntryName();
                    entInPatchedPath = MultiJarUtil.combineEntry(nodeJarPath, outEntryName);
                    outEntryPath = MultiJarUtil.getWorkPath(scratchPath, entInPatchedPath);
                    outEntryFile = new File(outEntryPath);
                    buff = new StringBuffer("Unzip multi-level jar entry \"");
                    buff.append(entry.getName());
                    buff.append("\" to file \"");
                    buff.append(outEntryPath);
                    buff.append("\"");
                    OLogger.debug(buff.toString());
                    try {
                        MultiJarUtil.writeOneZipEntryToFile(outEntryPath, jar);
                    }
                    catch (IOException e) {
                        MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.APPLY, true, e.getMessage());
                        buff = new StringBuffer("Unzip multi-level jar failed: ");
                        buff.append(e.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                        break;
                    }
                    outAsIn = null;
                    try {
                        outAsIn = MultiJarUtil.patchingBaseOnJarTree(curNode, outEntryPath, scratchPath, patchLocation, nodeJarPath, patchedJar, failed);
                        buff = new StringBuffer("Archive updated low-level jar file \"");
                        buff.append(outEntryPath);
                        buff.append("\" into file \"");
                        buff.append(outAsInPath + "\"");
                        OLogger.debug(buff.toString());
                        if (modify) {
                            MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, outAsIn, entry);
                            new File(outAsIn).delete();
                        }
                        outEntryFile.delete();
                    }
                    catch (IOException e) {
                        MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.APPLY, true, e.getMessage());
                        buff = new StringBuffer("Write low-level jar entry \"" + outAsIn + "\" into file \"" + outAsInPath + "\" failed");
                        buff.append(e.getMessage());
                        OLogger.printlnOnLog(buff.toString());
                    }
                }
                entryExist = true;
                break;
            }
            if (entryExist) ** continue;
            try {
                if (!modify) continue;
                MultiJarUtil.writeBackEntry(outAsInPath, jar, outStream, entry);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        for (i = 0; i < childs.size(); ++i) {
            curNode = (JarActionTree.TreeNode)childs.get(i);
            if (curNode.isEntryExist()) continue;
            buff = new StringBuffer("There is new entry file which will be JAR into file \"");
            buff.append(outAsInPath + "\"");
            newLeafEntry = new ZipEntry(curNode.getEntryName());
            newDirectoryEntrys = MultiJarUtil.getNewDirectoryEntry(jarEntryNameSet, curNode.getEntryName());
            try {
                if (modify) {
                    for (String newDirectoryEntry : newDirectoryEntrys) {
                        MultiJarUtil.addOneZipEntryToStreamUsingDirectory(outStream, new ZipEntry(newDirectoryEntry));
                    }
                }
            }
            catch (IOException e) {
                buff = new StringBuffer("Add new direcoty entry \"" + curNode.getEntryName() + "\" into file \"");
                buff.append(outAsInPath + "\" failed");
                buff.append(e.getMessage());
                OLogger.printlnOnLog(buff.toString());
            }
            if (curNode.isLeaf()) {
                classSourceFile = curNode.getJarAction().getSourceFile(patchLocation);
                try {
                    if (modify) {
                        sourceFile = new File(classSourceFile);
                        if (!sourceFile.exists()) {
                            buff = new StringBuffer("Patching file not exist \"");
                            buff.append(classSourceFile);
                            buff.append("\"");
                            throw new IOException(buff.toString());
                        }
                        buff.append("Add new top-level entry \"" + curNode.getEntryName() + "\" into target jar");
                        MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, classSourceFile, newLeafEntry);
                    }
                    curNode.getJarAction().setAlreadyPatched(true);
                }
                catch (IOException e) {
                    curNode.getJarAction().setErrorMsg(e.getMessage());
                    curNode.getJarAction().setApplyFailed();
                    failed.add(curNode.getJarAction());
                    buff = new StringBuffer("Add new leaf entry file \"" + classSourceFile + "\" into file \"");
                    buff.append(outAsInPath + "\" failed");
                    buff.append(e.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                }
            } else {
                try {
                    relativeJarPath = MultiJarUtil.recursiveJarNewFiles(curNode, patchLocation, scratchPath, nodeJarPath);
                    finalJarPath = MultiJarUtil.getPatchedPath(scratchPath, relativeJarPath);
                    buff.append("Add new jar file \"" + finalJarPath + "\"");
                    buff.append(" to file \"" + outAsInPath + "\"");
                    newFinalJar = new File(finalJarPath);
                    if (modify && finalJarPath != null) {
                        MultiJarUtil.addOneZipEntryToStreamUsingFile(outStream, finalJarPath, newLeafEntry);
                        newFinalJar.delete();
                    }
                    newFinalJar.delete();
                }
                catch (IOException e) {
                    MultiJarUtil.getAllLeavesForNode(curNode, failed, JarOperation.APPLY, true, e.getMessage());
                    buff = new StringBuffer("Archive all new jar action files failed ");
                    buff.append(e.getMessage());
                    OLogger.printlnOnLog(buff.toString());
                }
            }
            OLogger.debug(buff.toString());
        }
        try {
            if (modify == false) return outAsInPath;
            outStream.flush();
            outStream.close();
            return outAsInPath;
        }
        catch (IOException e) {
            MultiJarUtil.getAllLeavesForNode(node, failed, JarOperation.APPLY, true, e.getMessage());
            buff = new StringBuffer("Clode stream failed ");
            buff.append(e.getMessage());
            OLogger.printlnOnLog(buff.toString());
        }
        return outAsInPath;
    }

    private static List<String> getNewDirectoryEntry(Set<String> jarEntryNameSet, String entryName) {
        if (OPatchEnv.isWindows()) {
            entryName = entryName.replace('\\', '/');
        }
        ArrayList<String> newEntryList = new ArrayList<String>();
        String[] directories = entryName.split("/");
        StringBuffer newEntry = new StringBuffer("");
        for (int i2 = 0; i2 < directories.length - 1; ++i2) {
            newEntry.append(directories[i2]);
            newEntry.append(File.separator);
            String temp = newEntry.toString();
            if (jarEntryNameSet.contains(temp)) continue;
            newEntryList.add(temp);
            jarEntryNameSet.add(temp);
        }
        return newEntryList;
    }

    protected static String recursiveJarNewFiles(JarActionTree.TreeNode node, String patchLocation, String scratchPath, String tempJarInPatched) throws FileNotFoundException, IOException {
        if (node == null || node.isLeaf()) {
            return null;
        }
        StringBuffer buff = new StringBuffer("MultiJarUtil:: recursiveJarNewFiles() called");
        OLogger.debug(buff.toString());
        ArrayList childs = node.getChilds();
        String parentEntry = node.getEntryName();
        String relativeJarPath = MultiJarUtil.combineEntry(tempJarInPatched, node.getJarPath());
        String dstJarRelativePath = MultiJarUtil.combineEntry(tempJarInPatched, parentEntry);
        String dstJarPath = MultiJarUtil.getPatchedPath(scratchPath, dstJarRelativePath);
        ZipOutputStream jarOut = new ZipOutputStream(new FileOutputStream(new File(dstJarPath)));
        byte[] data = new byte[1024];
        HashSet<String> newDirectoryEntrySet = new HashSet<String>();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            int count;
            JarActionTree.TreeNode curNode = (JarActionTree.TreeNode)childs.get(i2);
            String entryName = curNode.getEntryName();
            ZipEntry newEntry = new ZipEntry(entryName);
            List<String> newDirectoryEntrys = MultiJarUtil.getNewDirectoryEntry(newDirectoryEntrySet, entryName);
            for (String newDirectoryEntry : newDirectoryEntrys) {
                jarOut.putNextEntry(new ZipEntry(newDirectoryEntry));
            }
            jarOut.putNextEntry(newEntry);
            String sourceFile = null;
            if (curNode.isLeaf()) {
                sourceFile = curNode.getJarAction().getSourceFile(patchLocation);
            } else {
                String generatedJarFilePath = MultiJarUtil.recursiveJarNewFiles(curNode, patchLocation, scratchPath, relativeJarPath);
                sourceFile = MultiJarUtil.getPatchedPath(scratchPath, generatedJarFilePath);
            }
            buff = new StringBuffer("Archive low-level file \"" + sourceFile + "\" into file \"");
            buff.append(dstJarPath + "\"");
            OLogger.debug(buff.toString());
            FileInputStream fis = new FileInputStream(new File(sourceFile));
            while ((count = fis.read(data)) != -1) {
                jarOut.write(data, 0, count);
            }
            jarOut.flush();
            fis.close();
        }
        jarOut.flush();
        jarOut.close();
        return dstJarRelativePath;
    }

    protected static String getPatchedPath(String scratchPath, String subPath) {
        StringBuffer path = new StringBuffer(scratchPath);
        if (!scratchPath.endsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append("patched");
        if (!subPath.startsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append(subPath);
        File patchedFile = new File(path.toString());
        if (!patchedFile.getParentFile().exists()) {
            patchedFile.getParentFile().mkdirs();
        }
        return path.toString();
    }

    protected static String getWorkPath(String scratchPath, String subPath) {
        StringBuffer path = new StringBuffer(scratchPath);
        if (!scratchPath.endsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append("work");
        if (!subPath.startsWith(File.separator)) {
            path.append(File.separator);
        }
        path.append(subPath);
        File workFile = new File(path.toString());
        if (!workFile.getParentFile().exists()) {
            workFile.getParentFile().mkdirs();
        }
        return path.toString();
    }

    protected static String getBackupForRollbackPath(String backForRollBackPath, String childPath) {
        StringBuffer backupForRollbackPath = new StringBuffer(backForRollBackPath);
        if (!backForRollBackPath.endsWith(File.separator)) {
            backupForRollbackPath.append(File.separator);
        }
        if (childPath.startsWith(File.separator)) {
            childPath = childPath.substring(1);
        }
        backupForRollbackPath.append(childPath);
        return backupForRollbackPath.toString();
    }

    protected static String combineEntry(String jarPath, String jarName) {
        StringBuffer entry = new StringBuffer();
        if (jarPath.startsWith(File.separator)) {
            jarPath = jarPath.substring(1);
        }
        if (jarPath.endsWith(File.separator)) {
            int sepIndex = jarPath.lastIndexOf(File.separator);
            jarPath = jarPath.substring(0, sepIndex);
        }
        entry.append(jarPath);
        if (!(jarPath.equals("") || jarName.equals("") || jarName.startsWith(File.separator))) {
            entry.append(File.separator);
        }
        entry.append(jarName);
        return entry.toString();
    }

    public static void main(String[] args) {
    }

    static class JarOperation {
        public static final JarOperation APPLY = new JarOperation(1);
        public static final JarOperation ROLLBACK = new JarOperation(2);
        public static final JarOperation BACKUPFORROLLBACK = new JarOperation(3);
        public static final JarOperation VERIFY = new JarOperation(4);
        private int value;

        private JarOperation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

