/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import oracle.opatch.ArchiveAction;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.LsPatchesPrinter;
import oracle.opatch.MakeAction;
import oracle.opatch.NotFoundException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentHigherVersionFound;
import oracle.opatch.PatchComponentMissing;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchPackageGenerator;
import oracle.opatch.Rules;
import oracle.opatch.Verifiable;
import oracle.opatch.VerifyFailedException;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchsdk.OPatchBundlePatch;
import oracle.opatch.patchsdk.OPatchCompositePatch;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.patchmodel.GenericPatch;
import oracle.opatch.patchsdk.patchmodel.GenericSingletonPatch;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LsPatchesSession
extends OPatchSession {
    protected LsPatchesSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public void process(String oracleHomePath) throws RuntimeException, NotFoundException {
        StringBuffer buff = new StringBuffer("LsPatchesSession::process() invoke");
        OLogger.debug(buff);
        String patchId = OPatchEnv.getRollbackPatchid();
        String patchLoc = OPatchEnv.getPatchloc();
        String qfile = OPatchEnv.getLsp_queryfile();
        int patchFormat = OPatchEnv.getPatchFormat();
        if (patchFormat == 4) {
            throw new RuntimeException(OLogger.getString("OUI-68011") + " Please use opatchauto.");
        }
        boolean required = OPatchEnv.isLsp_Required();
        boolean verify = OPatchEnv.isLsp_Verified();
        boolean bugs = OPatchEnv.isLsp_bugs();
        boolean specifiedID = patchId != null && !patchId.equals("");
        boolean specifiedLoc = patchLoc != null && !patchLoc.equals("");
        boolean queryFile = qfile != null && !qfile.equals("");
        boolean verifyPatchExist = Rules.shouldVerifyPatchExist(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean shouldPrintInstalledPatch = Rules.printInstalledPatchInfo(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean shouldPrintStagedPatch = Rules.printStagedPatchInfo(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean shouldQueryFile = Rules.shouldQueryFile(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        boolean verifyStagedPatch = Rules.verifyStagedPatch(specifiedID, specifiedLoc, required, bugs, verify, queryFile);
        buff = new StringBuffer("Option: [ required:" + required + " ] ");
        buff.append(" [ verify:" + verify + " ] ");
        buff.append(" [ bugs:" + bugs + " ] ");
        buff.append(" [ specifiedID:" + specifiedID + " ] ");
        buff.append(" [ specifiedLoc:" + specifiedLoc + " ] ");
        buff.append(" [ queryFile:" + queryFile + " ] \n");
        buff.append("Rules : [ verifyPatchExist:" + verifyPatchExist + " ] ");
        buff.append("[ shouldPrintInstalledPatch:" + shouldPrintInstalledPatch + " ] ");
        buff.append("[ shouldPrintStagedPatch:" + shouldPrintStagedPatch + " ] ");
        buff.append("[ shouldQueryFile:" + shouldQueryFile + " ] ");
        buff.append("[ verifyStagedPatch:" + verifyStagedPatch + " ] ");
        OLogger.debug(buff);
        if (verifyPatchExist) {
            this.verifyInstalledPatch(oracleHomePath, patchId);
        }
        if (shouldQueryFile) {
            this.verifyFileBelongstoSomePatch(oracleHomePath, qfile);
        }
        if (shouldPrintStagedPatch) {
            this.loadAndPrintStagedPatchMetadata(oracleHomePath, patchLoc, required);
        }
        if (shouldPrintInstalledPatch) {
            this.loadAndPrintInstalledPatchMetadata(oracleHomePath, patchId, bugs, required);
        }
        if (verifyStagedPatch) {
            this.verifyStagedPatch(oracleHomePath, patchLoc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyStagedPatch(String oracleHomePath, String patchLoc) throws RuntimeException, NotFoundException, VerifyFailedException {
        StringBuffer buff = new StringBuffer("LsPatchesSession::verifyStagedPatch() call");
        OLogger.debug(buff);
        boolean patchFound = false;
        boolean patchOK = false;
        RuntimeException re = null;
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            try {
                int i2;
                String patchID = "";
                if (!readServices.isInventoryLoaded()) {
                    boolean alreadyLocked = readServices.isLocked();
                    try {
                        if (!alreadyLocked) {
                            readServices.lock(oracleHomePath);
                        }
                        readServices.loadInventory(oracleHomePath);
                        if (!readServices.isInventoryLoaded()) {
                            buff = new StringBuffer("verifyStagedPatch() was not able to get a Session.");
                            OLogger.log(OLogger.SEVERE, buff.toString());
                            throw new RuntimeException(buff.toString());
                        }
                        Object var12_14 = null;
                        if (!alreadyLocked) {
                            readServices.release();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        if (alreadyLocked) throw throwable;
                        readServices.release();
                        throw throwable;
                    }
                }
                ArrayList<PatchObject> stagedPatches = new ArrayList<PatchObject>();
                int patchFormat = OPatchEnv.getPatchFormat();
                if (patchFormat == 3) {
                    String bundleFile = patchLoc + File.separator + "bundle.xml";
                    Document document = PatchObjectUtil.parseXMLFile(new File(bundleFile));
                    NodeList entityList = document.getElementsByTagName("entity");
                    ArrayList<String[]> giPatchesLocs = new ArrayList<String[]>();
                    ArrayList<String[]> dbPatchesLocs = new ArrayList<String[]>();
                    for (int j2 = 0; j2 < entityList.getLength(); ++j2) {
                        Node entity = entityList.item(j2);
                        String bundleLoc = patchLoc + File.separator + entity.getAttributes().item(0).getNodeValue();
                        PatchObject po = null;
                        try {
                            po = new PatchObject(bundleLoc);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (po == null) continue;
                        if (po.getPatchType().equals("bundle_top")) {
                            giPatchesLocs.add(new String[]{bundleLoc, po.getPatchID()});
                            continue;
                        }
                        dbPatchesLocs.add(new String[]{bundleLoc, po.getPatchID()});
                    }
                    if (dbPatchesLocs.size() == 0 && giPatchesLocs.size() == 0) {
                        throw new NotFoundException(OLogger.getString("OUI-67736", new Object[]{patchLoc}));
                    }
                    OPatchEnv.setPatchFormat(-1);
                    ArrayList<String[]> notFound = new ArrayList<String[]>();
                    ArrayList<String[]> verifyFailed = new ArrayList<String[]>();
                    if (readServices.isCRSHome()) {
                        int i3;
                        String[] dbHomes = OPatchSessionHelper.getDBHomes(oracleHomePath);
                        for (i3 = 0; i3 < giPatchesLocs.size(); ++i3) {
                            String[] locToId = (String[])giPatchesLocs.get(i3);
                            String[] pairs = new String[]{locToId[0], locToId[1], oracleHomePath};
                            try {
                                this.verifyStagedPatch(oracleHomePath, locToId[0]);
                                continue;
                            }
                            catch (NotFoundException e2) {
                                notFound.add(pairs);
                                continue;
                            }
                            catch (VerifyFailedException e3) {
                                verifyFailed.add(pairs);
                            }
                        }
                        for (i3 = 0; i3 < dbPatchesLocs.size(); ++i3) {
                            for (int j3 = 0; j3 < dbHomes.length; ++j3) {
                                String[] locToId = (String[])dbPatchesLocs.get(i3);
                                String[] pairs = new String[]{locToId[0], locToId[1], dbHomes[j3]};
                                try {
                                    this.verifyStagedPatch(dbHomes[j3], locToId[0]);
                                    continue;
                                }
                                catch (NotFoundException e4) {
                                    notFound.add(pairs);
                                    continue;
                                }
                                catch (VerifyFailedException e5) {
                                    verifyFailed.add(pairs);
                                }
                            }
                        }
                    } else {
                        if (dbPatchesLocs.size() == 0) {
                            buff = new StringBuffer("Current oracle home is DB home while Combo Patch doesn't contain DB patches. Please set CRS home as current oracle home.");
                            throw new NotFoundException(buff.toString());
                        }
                        for (int i4 = 0; i4 < dbPatchesLocs.size(); ++i4) {
                            String[] locToId = (String[])dbPatchesLocs.get(i4);
                            String[] pairs = new String[]{locToId[0], locToId[1], oracleHomePath};
                            try {
                                this.verifyStagedPatch(oracleHomePath, locToId[0]);
                                continue;
                            }
                            catch (NotFoundException e6) {
                                notFound.add(pairs);
                                continue;
                            }
                            catch (VerifyFailedException e7) {
                                verifyFailed.add(pairs);
                            }
                        }
                    }
                    if (notFound.size() > 0) {
                        buff = new StringBuffer();
                        int i5 = 0;
                        while (i5 < notFound.size()) {
                            String[] pairs = (String[])notFound.get(i5);
                            buff.append("Patch [ " + pairs[1] + " ] staged in patch location \"" + pairs[0] + "\" is NOT registered in Oracle Home \"" + pairs[2] + "\" or can't load it's metadata.\n");
                            ++i5;
                        }
                        throw new NotFoundException(buff.toString());
                    }
                    if (verifyFailed.size() > 0) {
                        buff = new StringBuffer();
                        int i6 = 0;
                        while (i6 < verifyFailed.size()) {
                            String[] pairs = (String[])verifyFailed.get(i6);
                            buff.append("Patch [ " + pairs[1] + " ] staged in patch location \"" + pairs[0] + "\" have corruptted files in Oracle Home \"" + pairs[2] + "\".\n");
                            ++i6;
                        }
                        throw new VerifyFailedException(buff.toString());
                    }
                    Object var38_78 = null;
                    buff = new StringBuffer("LsPatches::getInstance() returns");
                    OLogger.debug(buff);
                    return;
                }
                if (patchFormat == 1 || patchFormat == 2) {
                    File baseDir = new File(patchLoc);
                    File[] subPatchLocs = baseDir.listFiles();
                    for (int i7 = 0; i7 < subPatchLocs.length; ++i7) {
                        if (!subPatchLocs[i7].isDirectory()) continue;
                        String subPatchLoc = "";
                        try {
                            subPatchLoc = subPatchLocs[i7].getCanonicalPath();
                        }
                        catch (IOException e8) {
                            subPatchLoc = subPatchLocs[i7].getAbsolutePath();
                        }
                        PatchObject tmp = null;
                        try {
                            tmp = new PatchObject(subPatchLoc);
                        }
                        catch (Exception notFound) {
                            // empty catch block
                        }
                        if (tmp == null) continue;
                        stagedPatches.add(tmp);
                    }
                } else if (!OnlinePatchProcessor.isHybridOnlinePatch(patchLoc)) {
                    PatchObject tmp = null;
                    try {
                        tmp = PatchObjectUtil.loadPatch(patchLoc);
                    }
                    catch (Exception subPatchLocs) {
                        // empty catch block
                    }
                    if (tmp != null) {
                        stagedPatches.add(tmp);
                    }
                } else {
                    boolean online = false;
                    if (!OnlinePatchProcessor.isOnlineOnlyPatch(patchLoc)) {
                        OneOffEntry[] actives = readServices.getInstalledPatches();
                        for (int i8 = 0; i8 < actives.length; ++i8) {
                            OneOffEntry oneOff = actives[i8];
                            if (oneOff == null) continue;
                            String id = oneOff.getID();
                            PatchObject tmp = null;
                            try {
                                tmp = PatchObjectUtil.loadPatch(patchLoc);
                            }
                            catch (Exception verifyFailed) {
                                // empty catch block
                            }
                            if (tmp == null || !id.equalsIgnoreCase(tmp.getPatchID()) || !oneOff.isOnlinePatch()) continue;
                            online = true;
                        }
                    } else {
                        online = true;
                    }
                    if (online) {
                        OnlinePatchProcessor.setHybridPatchPart(patchLoc, PatchObject.HybridPatchPart.ONLINE);
                    } else {
                        OnlinePatchProcessor.setHybridPatchPart(patchLoc, PatchObject.HybridPatchPart.OFFLINE);
                    }
                    PatchObject onlinePatch = null;
                    try {
                        onlinePatch = PatchObjectUtil.loadPatch(patchLoc);
                    }
                    catch (Exception i8) {
                        // empty catch block
                    }
                    stagedPatches.add(onlinePatch);
                }
                if (stagedPatches.size() == 0) {
                    throw new NotFoundException(OLogger.getString("OUI-67736", new Object[]{patchLoc}));
                }
                ArrayList<String> notFoundList = new ArrayList<String>();
                ArrayList<String> fileCheckFailedList = new ArrayList<String>();
                for (int len = 0; len < stagedPatches.size(); ++len) {
                    PatchComponent pc;
                    PatchComponent[] presentOptComponents;
                    ArrayList<PatchComponent> compsToVerify;
                    HashMap<PatchAction, String> copyActions;
                    PatchObject po;
                    block92: {
                        po = (PatchObject)stagedPatches.get(len);
                        patchID = po.getPatchID();
                        OneOffEntry[] inactive = readServices.getInactivePatches();
                        for (int i9 = 0; i9 < inactive.length; ++i9) {
                            String id;
                            OneOffEntry inactiveOneoff = inactive[i9];
                            if (inactiveOneoff == null || !(id = inactiveOneoff.getID()).equalsIgnoreCase(patchID)) continue;
                            OLogger.println("Specified patch [ " + patchID + " ] is registered in Oracle Home \"" + oracleHomePath + "\" inventory but it is inactive. Skip verifying patch files.");
                            Object var38_79 = null;
                            buff = new StringBuffer("LsPatches::getInstance() returns");
                            OLogger.debug(buff);
                            return;
                        }
                        OneOffEntry[] actives = readServices.getInstalledPatches();
                        for (int i10 = 0; i10 < actives.length; ++i10) {
                            OneOffEntry oneOff = actives[i10];
                            if (oneOff == null) continue;
                            String id = oneOff.getID();
                            buff = new StringBuffer("Comparing patch ID ");
                            buff.append(patchID);
                            buff.append(" against ");
                            buff.append(id);
                            OLogger.log(OLogger.FINE, buff.toString());
                            if (!id.equalsIgnoreCase(patchID)) continue;
                            patchFound = true;
                            break;
                        }
                        Object[] oneOffs = new OneOffEntry[inactive.length + actives.length];
                        System.arraycopy(actives, 0, oneOffs, 0, actives.length);
                        System.arraycopy(inactive, 0, oneOffs, actives.length, inactive.length);
                        Arrays.sort(oneOffs);
                        copyActions = new HashMap<PatchAction, String>();
                        for (int i11 = oneOffs.length - 1; i11 >= 0; --i11) {
                            Object oneoff = oneOffs[i11];
                            PatchAction[] actions = ((OneOffEntry)oneoff).getPatchActions();
                            for (int j4 = 0; j4 < actions.length; ++j4) {
                                if (!(actions[j4] instanceof CopyAction)) continue;
                                copyActions.put(actions[j4], ((OneOffEntry)oneoff).getID());
                            }
                        }
                        if (patchFound) {
                            buff = new StringBuffer("Patch ID ");
                            buff.append(patchID);
                            buff.append(" is registered in Oracle Home inventory.");
                            OLogger.log(OLogger.FINE, buff.toString());
                            patchFound = false;
                            String oneOffLoc = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, po.getTripletPatchID());
                            buff = new StringBuffer("Search for patch meta-data under \"");
                            buff.append(oneOffLoc);
                            buff.append("\".");
                            OLogger.log(OLogger.FINE, buff.toString());
                            try {
                                PatchObject tmpP = PatchObjectUtil.loadPatch(oracleHomePath, po.getTripletPatchID());
                                buff = new StringBuffer("Successfully loaded the patchobject from \"");
                                buff.append(oneOffLoc);
                                buff.append("\", so patch is found properly, its ID is ");
                                buff.append(tmpP.getPatchID());
                                OLogger.debug(buff);
                                patchFound = true;
                            }
                            catch (Exception e9) {
                                patchFound = false;
                            }
                            if (patchFound) {
                                buff = new StringBuffer("Inventory check OK: Patch ID ");
                                buff.append(patchID);
                                buff.append(" is registered in Oracle Home \"" + oracleHomePath + "\" inventory with proper meta-data.");
                                OLogger.println(buff.toString());
                                compsToVerify = new ArrayList<PatchComponent>();
                                OLogger.log(OLogger.FINE, "Add all required components and their actions to list to be verified. Optional components not present in Oracle Home will be filtered out.");
                                PatchComponent[] optPCs = po.getOptionalPatchComponents();
                                presentOptComponents = readServices.haveComponents(optPCs);
                                break block92;
                            } else {
                                buff = new StringBuffer("Inventory check failed: Patch ID ");
                                buff.append(patchID);
                                buff.append(" is registered in Oracle Home \"" + oracleHomePath + "\" inventory but OPatch can't load its meta-data.");
                                notFoundList.add(patchID);
                                OLogger.println(buff.toString());
                                continue;
                            }
                        }
                        buff = new StringBuffer("Inventory check failed: Patch ID ");
                        buff.append(patchID);
                        buff.append(" is NOT registered in Oracle Home \"" + oracleHomePath + "\" inventory.");
                        notFoundList.add(patchID);
                        OLogger.println(buff.toString());
                        continue;
                    }
                    for (int i12 = 0; i12 < presentOptComponents.length; ++i12) {
                        PatchComponent missingPc;
                        PatchComponent obj = presentOptComponents[i12];
                        if (obj instanceof PatchComponentMissing) {
                            missingPc = (PatchComponentMissing)obj;
                            buff = new StringBuffer("Optional comps. not in OH, no verification: ");
                            buff.append(missingPc.getName());
                            buff.append(", ");
                            buff.append(missingPc.getVersion());
                            OLogger.debug(buff);
                            continue;
                        }
                        if (obj instanceof PatchComponentHigherVersionFound) {
                            missingPc = (PatchComponentHigherVersionFound)obj;
                            buff = new StringBuffer("Optional comps. with higer version in OH, no verification: ");
                            buff.append(missingPc.getName());
                            buff.append(", ");
                            buff.append(missingPc.getVersion());
                            OLogger.debug(buff);
                            continue;
                        }
                        if (!(obj instanceof PatchComponent)) continue;
                        pc = obj;
                        buff = new StringBuffer("VerifyPatch() for ");
                        buff.append(pc.getName());
                        buff.append(", ");
                        buff.append(pc.getVersion());
                        OLogger.debug(buff);
                        compsToVerify.add(pc);
                    }
                    PatchComponent[] pcs = po.getRequiredPatchComponents();
                    for (int i13 = 0; i13 < pcs.length; ++i13) {
                        pc = pcs[i13];
                        compsToVerify.add(pc);
                    }
                    ArrayList<CopyAction> copyActionToVerify = new ArrayList<CopyAction>();
                    ArrayList<JarAction> jarActionToVerify = new ArrayList<JarAction>();
                    ArrayList<ArchiveAction> arActionToVerify = new ArrayList<ArchiveAction>();
                    ArrayList<Verifiable> pluginActionToVerify = new ArrayList<Verifiable>();
                    ArrayList<MakeAction> makeActionToVerify = new ArrayList<MakeAction>();
                    for (int i14 = 0; i14 < compsToVerify.size(); ++i14) {
                        int j5;
                        PatchComponent pc2 = (PatchComponent)compsToVerify.get(i14);
                        LinkedList cList = pc2.getCopyList();
                        LinkedList jList = pc2.getJarList();
                        LinkedList aList = pc2.getArchiveList();
                        LinkedList mList = pc2.getMakeList();
                        LinkedList pList = pc2.getPluginList();
                        for (j5 = 0; j5 < cList.size(); ++j5) {
                            CopyAction ca = (CopyAction)cList.get(j5);
                            if (copyActions.containsKey(ca) && !copyActions.get(ca).toString().equals(patchID)) continue;
                            copyActionToVerify.add(ca);
                        }
                        for (j5 = 0; j5 < jList.size(); ++j5) {
                            JarAction ja = (JarAction)jList.get(j5);
                            jarActionToVerify.add(ja);
                        }
                        for (j5 = 0; j5 < aList.size(); ++j5) {
                            ArchiveAction aa = (ArchiveAction)aList.get(j5);
                            arActionToVerify.add(aa);
                        }
                        for (j5 = 0; j5 < pList.size(); ++j5) {
                            if (!(pList.get(j5) instanceof Verifiable)) continue;
                            Verifiable va = (Verifiable)pList.get(j5);
                            pluginActionToVerify.add(va);
                        }
                        for (j5 = 0; j5 < mList.size(); ++j5) {
                            MakeAction ma = (MakeAction)mList.get(j5);
                            makeActionToVerify.add(ma);
                        }
                    }
                    String finalPatchLoc = patchLoc;
                    if (patchFormat == 1 || patchFormat == 2) {
                        finalPatchLoc = finalPatchLoc + File.separator + po.getPatchID();
                    }
                    if (!(patchOK = OPatchSessionHelper.verifyPatchAction(oracleHomePath, finalPatchLoc, copyActionToVerify, jarActionToVerify, arActionToVerify, pluginActionToVerify, makeActionToVerify, readServices))) {
                        buff = new StringBuffer("Files check failed: Some files under ORACLE_HOME \"" + oracleHomePath + "\" are not patched. ");
                        buff.append("Please see log file for details.");
                        fileCheckFailedList.add(patchID);
                        OLogger.println(buff.toString());
                        continue;
                    }
                    buff = new StringBuffer("Files check OK: Files from Patch ID ");
                    buff.append(patchID);
                    buff.append(" are present in Oracle Home \"" + oracleHomePath + "\".");
                    OLogger.println(buff.toString());
                }
                if (notFoundList.size() > 0) {
                    buff = new StringBuffer("Following patches [ ");
                    i2 = 0;
                    while (true) {
                        if (i2 >= notFoundList.size()) {
                            buff.append("] are NOT registered in Oracle Home \"" + oracleHomePath + "\" inventory or can't load its meta-data");
                            throw new NotFoundException(buff.toString());
                        }
                        buff.append(notFoundList.get(i2) + " ");
                        ++i2;
                    }
                }
                if (fileCheckFailedList.size() > 0) {
                    buff = new StringBuffer("Following patches [ ");
                    i2 = 0;
                    while (true) {
                        if (i2 >= fileCheckFailedList.size()) {
                            buff.append(" ] have corruptted files under Oracle Home \"" + oracleHomePath + "\".");
                            throw new VerifyFailedException(buff.toString());
                        }
                        buff.append(fileCheckFailedList.get(i2) + " ");
                        ++i2;
                    }
                }
            }
            catch (NotFoundException e10) {
                throw e10;
            }
            catch (VerifyFailedException e11) {
                throw e11;
            }
            catch (Throwable t) {
                re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        catch (Throwable throwable) {
            Object var38_81 = null;
            buff = new StringBuffer("LsPatches::getInstance() returns");
            OLogger.debug(buff);
            throw throwable;
        }
        Object var38_80 = null;
        buff = new StringBuffer("LsPatches::getInstance() returns");
        OLogger.debug(buff);
    }

    private void verifyInstalledPatch(String oracleHomePath, String patchID) throws RuntimeException, NotFoundException, VerifyFailedException {
        PatchAction[] actions;
        OneOffEntry[] oneoffs;
        StringBuffer buff = new StringBuffer("LsPatchesSession::verifyInstalledPatch() call");
        OLogger.debug(buff);
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isInventoryLoaded()) {
            boolean alreadyLocked = readServices.isLocked();
            try {
                try {
                    if (!alreadyLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                    if (!readServices.isInventoryLoaded()) {
                        buff = new StringBuffer("verifyInstalledPatch() was not able to get a Session.");
                        OLogger.log(OLogger.SEVERE, buff.toString());
                        throw new RuntimeException(buff.toString());
                    }
                    Object var8_7 = null;
                    if (!alreadyLocked) {
                        readServices.release();
                    }
                }
                catch (Throwable t) {
                    buff = new StringBuffer("Throwable occured: " + t.getMessage());
                    throw new RuntimeException(buff.toString());
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!alreadyLocked) {
                    readServices.release();
                }
                throw throwable;
            }
        }
        if ((oneoffs = readServices.getInstalledPatches()).length == 0) {
            String noOneOff = OLogger.getString("OUI-67095");
            noOneOff = noOneOff.substring(0, noOneOff.length() - 1);
            noOneOff = noOneOff + " \"" + oracleHomePath + "\".";
            throw new NotFoundException(noOneOff);
        }
        OneOffEntry[] inactive = readServices.getInactivePatches();
        for (int i2 = 0; i2 < inactive.length; ++i2) {
            OneOffEntry inactiveOneoff = inactive[i2];
            if (!inactiveOneoff.getID().equals(patchID)) continue;
            OLogger.println("Specified patch [ " + patchID + " ] is registered in Oracle Home \"" + oracleHomePath + "\" inventory but it is inactive. Skip verifying patch files.");
            return;
        }
        HashMap<String, TreeSet<OneOffEntry>> compositePatches = new HashMap<String, TreeSet<OneOffEntry>>();
        for (int i3 = 0; i3 < oneoffs.length; ++i3) {
            OneOffEntry oneoff = oneoffs[i3];
            if (!oneoff.getIsComposite()) continue;
            String active = oneoff.getActiveConstituent();
            if (!oneoff.getID().equals(active) && oneoff.getID().equals(patchID)) {
                OLogger.println("Patch [ " + patchID + " ] is a non-active sub-patch of composite patch [ " + active + " ] installed in \"" + oracleHomePath + "\". Here is the output for 'opatch lspatches -id " + active + " -verify': \n");
                this.verifyInstalledPatch(oracleHomePath, active);
                return;
            }
            TreeSet<OneOffEntry> ids = (TreeSet<OneOffEntry>)compositePatches.get(active);
            if (ids == null) {
                ids = new TreeSet<OneOffEntry>();
            }
            ids.add(oneoff);
            compositePatches.put(active, ids);
        }
        Object[] allPatches = new OneOffEntry[oneoffs.length + inactive.length];
        System.arraycopy(oneoffs, 0, allPatches, 0, oneoffs.length);
        System.arraycopy(inactive, 0, allPatches, oneoffs.length, inactive.length);
        Arrays.sort(allPatches);
        HashMap<PatchAction, String> copyActions = new HashMap<PatchAction, String>();
        ArrayList<Object> foundOneOffList = new ArrayList<Object>();
        for (int i4 = allPatches.length - 1; i4 >= 0; --i4) {
            Object object = allPatches[i4];
            if (patchID.contains("_")) {
                if (((OneOffEntry)object).getID().startsWith(patchID)) {
                    foundOneOffList.add(object);
                }
            } else if (((OneOffEntry)object).getID().equals(patchID)) {
                foundOneOffList.add(object);
            }
            actions = ((OneOffEntry)object).getPatchActions();
            for (int j2 = 0; j2 < actions.length; ++j2) {
                if (!(actions[j2] instanceof CopyAction)) continue;
                copyActions.put(actions[j2], ((OneOffEntry)object).getTripletID());
            }
        }
        if (foundOneOffList.size() == 0) {
            buff = new StringBuffer(OLogger.getString("OUI-67735", new Object[]{patchID}));
            throw new NotFoundException(buff.toString());
        }
        for (OneOffEntry oneOffEntry : foundOneOffList) {
            actions = oneOffEntry.getPatchActions();
            boolean hasFileNotExist = false;
            for (int i5 = 0; i5 < actions.length; ++i5) {
                File f2 = new File(actions[i5].getParentFilePath(oracleHomePath));
                if (f2.exists()) continue;
                hasFileNotExist = true;
                break;
            }
            if (oneOffEntry.getIsComposite()) {
                buff = new StringBuffer("Note: For a composite patch, we only check the files of the active sub-patch");
                OLogger.println(buff.toString());
            }
            if (hasFileNotExist) {
                buff = new StringBuffer("Files check failed: Some patches files under ORACLE_HOME are removed.");
                throw new VerifyFailedException(buff.toString());
            }
            buff = new StringBuffer("Files check OK: Files from Patch ID ");
            buff.append(patchID);
            buff.append(" are present in Oracle Home.");
            OLogger.println(buff.toString());
            ChecksumEntity[] checksums = oneOffEntry.getChecksumList();
            for (int i6 = 0; i6 < checksums.length; ++i6) {
                ChecksumEntity checksum = checksums[i6];
                Iterator copyIte = copyActions.keySet().iterator();
                boolean isOverlay = false;
                while (copyIte.hasNext()) {
                    File checksumFile;
                    CopyAction copyAct = (CopyAction)copyIte.next();
                    File copyFile = new File(copyAct.getParentFilePath(oracleHomePath));
                    if (!copyFile.equals(checksumFile = new File(checksum.getComputeFilePath())) || copyActions.get(copyAct).toString().equals(oneOffEntry.getTripletID())) continue;
                    isOverlay = true;
                    break;
                }
                if (isOverlay) continue;
                String installedChecksum = checksum.getChecksum();
                String currentChecksum = "";
                try {
                    currentChecksum = OPatchSessionHelper.computeChecksum(checksum.getComputeFilePath());
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2.getMessage());
                }
                if (currentChecksum.equals(installedChecksum)) continue;
                buff = new StringBuffer("The patch file \"" + checksum.getComputeFilePath() + "\" of the patch [ " + patchID + " ] installed in \"" + oracleHomePath + "\" was modified after applying. Current checksum of the file is [ " + currentChecksum + " ], while checksum at installed time was [ " + installedChecksum + " ].");
                throw new VerifyFailedException(buff.toString());
            }
            if (oneOffEntry.getIsComposite()) {
                TreeSet subPatches = (TreeSet)compositePatches.get(patchID);
                Iterator subPatchIterator = subPatches.iterator();
                buff = new StringBuffer("");
                while (subPatchIterator.hasNext()) {
                    buff.append("Inventory check OK: ");
                    buff.append("Patch ID ");
                    buff.append(((OneOffEntry)subPatchIterator.next()).getID());
                    buff.append(" is registered in Oracle Home \"");
                    buff.append(oracleHomePath);
                    buff.append("\" inventory. \n");
                }
            } else {
                buff = new StringBuffer("Inventory check OK: ");
                buff.append("Patch ID ");
                buff.append(patchID);
                buff.append(" is registered in Oracle Home \"");
                buff.append(oracleHomePath);
                buff.append("\" inventory.");
            }
            OLogger.println(buff.toString());
        }
    }

    private void verifyFileBelongstoSomePatch(String oracleHomePath, String verifyFile) throws RuntimeException, NotFoundException {
        block28: {
            StringBuffer buff = new StringBuffer("LsPatchesSession::verifyFileBelongstoSomePatch() call");
            OLogger.debug(buff);
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            try {
                int i2;
                if (!readServices.isInventoryLoaded()) {
                    boolean alreadyLocked = readServices.isLocked();
                    try {
                        if (!alreadyLocked) {
                            readServices.lock(oracleHomePath);
                        }
                        readServices.loadInventory(oracleHomePath);
                        if (!readServices.isInventoryLoaded()) {
                            OLogger.printlnres("OUI-67121");
                            Object var8_9 = null;
                            if (!alreadyLocked) {
                                readServices.release();
                            }
                            return;
                        }
                        Object var8_10 = null;
                        if (!alreadyLocked) {
                            readServices.release();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (!alreadyLocked) {
                            readServices.release();
                        }
                        throw throwable;
                    }
                }
                OneOffEntry[] active = readServices.getInstalledPatches();
                OneOffEntry[] inactive = readServices.getInactivePatches();
                if (active == null || inactive == null) {
                    buff = new StringBuffer("Can't get the registered oneoff patches from Oracle Home \"" + oracleHomePath + "\"");
                    throw new NotFoundException(buff.toString());
                }
                Object[] oneoffs = new OneOffEntry[active.length + inactive.length];
                for (i2 = 0; i2 < active.length; ++i2) {
                    oneoffs[i2] = active[i2];
                }
                for (i2 = 0; i2 < inactive.length; ++i2) {
                    oneoffs[i2 + active.length] = inactive[i2];
                }
                Arrays.sort(oneoffs);
                String belongTo = "";
                String tempVersion = "";
                Object oneoff = null;
                boolean isSnowball = false;
                for (int i3 = oneoffs.length - 1; i3 > -1; --i3) {
                    oneoff = oneoffs[i3];
                    buff = new StringBuffer("Search current patch file from patch [ " + ((OneOffEntry)oneoff).getID() + " ]");
                    OLogger.debug(buff);
                    PatchAction[] actions = ((OneOffEntry)oneoff).getPatchActions();
                    boolean found = false;
                    for (int j2 = 0; j2 < actions.length; ++j2) {
                        PatchAction action = actions[j2];
                        File pfile = new File(action.getParentFilePath(oracleHomePath));
                        File vfile = new File(verifyFile);
                        String cpPath = "";
                        String cvPath = "";
                        try {
                            cpPath = pfile.getCanonicalPath();
                            cvPath = vfile.getCanonicalPath();
                        }
                        catch (IOException e2) {
                            cpPath = pfile.getAbsolutePath();
                            cvPath = vfile.getAbsolutePath();
                        }
                        if (!pfile.exists()) {
                            throw new NotFoundException("Destination file \"" + cpPath + "\" does not exist in Oracle Home \"" + oracleHomePath + "\".");
                        }
                        buff = new StringBuffer("File path of registered patch :" + cpPath + "\n");
                        buff.append("Searching file path : " + cvPath);
                        OLogger.debug(buff);
                        if (!cvPath.equals(cpPath)) continue;
                        found = true;
                        if (action instanceof CopyAction) {
                            CopyAction copy = (CopyAction)action;
                            if (!copy.isHasFileVersion()) {
                                belongTo = ((OneOffEntry)oneoff).getID();
                                break;
                            }
                            isSnowball = true;
                            String newVersion = copy.getFileVersion();
                            if (!copy.isSnowBallCopyAction()) {
                                belongTo = ((OneOffEntry)oneoff).getID();
                                tempVersion = newVersion;
                                break;
                            }
                            int ret = OPatchSessionHelper.isGreaterDecimal(newVersion, tempVersion);
                            if (ret != 1) break;
                            belongTo = ((OneOffEntry)oneoff).getID();
                            tempVersion = newVersion;
                            break;
                        }
                        belongTo = ((OneOffEntry)oneoff).getID();
                        break;
                    }
                    if (!isSnowball && found) break;
                }
                if (belongTo != null && !belongTo.equals("")) {
                    if (oneoff != null && ((OneOffEntry)oneoff).getIsComposite()) {
                        buff = new StringBuffer("The specified file \"" + verifyFile + "\" belongs to sub-patch [ ");
                        buff.append(belongTo);
                        buff.append(" ] of the composite patch [ " + ((OneOffEntry)oneoff).getActiveConstituent() + " ] installed in \"");
                        buff.append(oracleHomePath);
                        buff.append("\".");
                        OLogger.println(buff.toString());
                    } else {
                        buff = new StringBuffer("The specified file \"" + verifyFile + "\" belongs to patch [ ");
                        buff.append(belongTo);
                        buff.append(" ] installed in \"");
                        buff.append(oracleHomePath);
                        buff.append("\".");
                        OLogger.println(buff.toString());
                    }
                    break block28;
                }
                buff = new StringBuffer("The specified file \"" + verifyFile + "\" does not belong to any registered patch in \"" + oracleHomePath + "\".");
                throw new NotFoundException(buff.toString());
            }
            catch (NotFoundException e3) {
                throw e3;
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAndPrintInstalledPatchMetadata(String oracleHomePath, String patchId, boolean showbugs, boolean required) throws RuntimeException, NotFoundException {
        StringBuffer buff;
        block39: {
            buff = new StringBuffer("LsPatchesSession::loadAndPrintInstalledPatch() call");
            OLogger.debug(buff);
            RuntimeException re = null;
            OneOffEntry[] oneoffs = null;
            OneOffEntry[] activeOneoff = null;
            OneOffEntry[] inactive = null;
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            try {
                block38: {
                    try {
                        int i2;
                        block34: {
                            boolean alreadyLocked;
                            block35: {
                                block36: {
                                    try {
                                        if (readServices.isInventoryLoaded()) break block34;
                                        alreadyLocked = readServices.isLocked();
                                        try {
                                            if (!alreadyLocked) {
                                                readServices.lock(oracleHomePath);
                                            }
                                            readServices.loadInventory(oracleHomePath);
                                            if (readServices.isInventoryLoaded()) break block35;
                                            OLogger.printlnres("OUI-67121");
                                            Object var14_17 = null;
                                            if (alreadyLocked) break block36;
                                        }
                                        catch (Throwable ti) {
                                            throw ti;
                                        }
                                        catch (Throwable throwable) {
                                            Object var14_19 = null;
                                            if (alreadyLocked) throw throwable;
                                            readServices.release();
                                            throw throwable;
                                        }
                                    }
                                    catch (NotFoundException e2) {
                                        throw e2;
                                    }
                                    catch (Throwable t) {
                                        OLogger.error("OUI-67028", new Object[]{"LsPatchesSession::loadAndPrintInstalledPatch()"});
                                        re = new RuntimeException(t.getMessage());
                                        re.setStackTrace(t.getStackTrace());
                                        throw re;
                                    }
                                    readServices.release();
                                }
                                Object var23_21 = null;
                                break block38;
                            }
                            Object var14_18 = null;
                            if (!alreadyLocked) {
                                readServices.release();
                            }
                        }
                        activeOneoff = readServices.getInstalledPatches();
                        inactive = readServices.getInactivePatches();
                        if (activeOneoff == null || inactive == null) {
                            buff = new StringBuffer("Can't get the registered oneoff patches from Oracle Home \"" + oracleHomePath + "\"");
                            throw new NotFoundException(buff.toString());
                        }
                        oneoffs = new OneOffEntry[activeOneoff.length + inactive.length];
                        for (i2 = 0; i2 < activeOneoff.length; ++i2) {
                            oneoffs[i2] = activeOneoff[i2];
                        }
                        for (i2 = 0; i2 < inactive.length; ++i2) {
                            oneoffs[i2 + activeOneoff.length] = inactive[i2];
                        }
                        OneOffEntry[] validOneOffs = new OneOffEntry[1];
                        ArrayList<OneOffEntry> validOneOffsList = new ArrayList<OneOffEntry>();
                        boolean pidSpecified = false;
                        if (patchId != null && !patchId.equals("")) {
                            boolean exist = false;
                            pidSpecified = true;
                            HashMap<String, TreeSet<OneOffEntry>> compositePatches = new HashMap<String, TreeSet<OneOffEntry>>();
                            for (int i3 = 0; i3 < oneoffs.length; ++i3) {
                                OneOffEntry entry = oneoffs[i3];
                                if (entry.getIsComposite()) {
                                    String active = entry.getActiveConstituent();
                                    if (!entry.getID().equals(active) && entry.getID().equals(patchId)) {
                                        OLogger.println("Patch [ " + patchId + " ] is a non-active sub-patch of composite patch [ " + active + " ]." + "Here is the output for 'opatch lspatches -id " + active + " ': \n");
                                        this.loadAndPrintInstalledPatchMetadata(oracleHomePath, active, showbugs, required);
                                        Object var23_22 = null;
                                        buff = new StringBuffer("LsPatches::getInstance() returns");
                                        OLogger.debug(buff);
                                        return;
                                    }
                                    TreeSet<OneOffEntry> ids = (TreeSet<OneOffEntry>)compositePatches.get(active);
                                    if (ids == null) {
                                        ids = new TreeSet<OneOffEntry>();
                                    }
                                    ids.add(entry);
                                    compositePatches.put(active, ids);
                                }
                                if (patchId.contains("_")) {
                                    if (!entry.getID().startsWith(patchId)) continue;
                                    validOneOffsList.add(entry);
                                    exist = true;
                                    continue;
                                }
                                if (!entry.getID().equals(patchId)) continue;
                                validOneOffsList.add(entry);
                                exist = true;
                            }
                            if (validOneOffsList.size() > 0) {
                                validOneOffs = new OneOffEntry[validOneOffsList.size()];
                                validOneOffsList.toArray(validOneOffs);
                            }
                            if (!exist) {
                                throw new NotFoundException(OLogger.getString("OUI-67735", new Object[]{patchId, oracleHomePath}));
                            }
                            TreeSet constituents = (TreeSet)compositePatches.get(validOneOffs[0].getID());
                            if (constituents != null && constituents.size() > 0) {
                                validOneOffs = new OneOffEntry[constituents.size()];
                                constituents.toArray(validOneOffs);
                                String[] sortedOrder = CompositePatchObject.getConstituentList(CompositePatchObject.getCompositeFilePathFromOH(oracleHomePath, patchId));
                                for (int x = 0; x < sortedOrder.length; ++x) {
                                    int y;
                                    int patchCount = 0;
                                    for (y = 0; y < validOneOffs.length; ++y) {
                                        String currentEntryID = validOneOffs[y].getID();
                                        if (!currentEntryID.equals(sortedOrder[x])) continue;
                                        ++patchCount;
                                        break;
                                    }
                                    if (patchCount != true) throw new Exception();
                                    OneOffEntry currentEntry = validOneOffs[y];
                                    validOneOffs[y] = validOneOffs[x];
                                    validOneOffs[x] = currentEntry;
                                }
                            }
                        } else {
                            validOneOffs = activeOneoff;
                        }
                        if (pidSpecified) {
                            LsPatchesPrinter.printMetadataForPatches(oracleHomePath, validOneOffs, required);
                            break block39;
                        } else {
                            LsPatchesPrinter.printBasicInfoForPatches(oracleHomePath, validOneOffs, showbugs);
                        }
                        break block39;
                    }
                    catch (NotFoundException e3) {
                        throw e3;
                    }
                    catch (Throwable t) {
                        re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        throw re;
                    }
                }
                buff = new StringBuffer("LsPatches::getInstance() returns");
            }
            catch (Throwable throwable) {
                Object var23_24 = null;
                buff = new StringBuffer("LsPatches::getInstance() returns");
                OLogger.debug(buff);
                throw throwable;
            }
            OLogger.debug(buff);
            return;
        }
        Object var23_23 = null;
        buff = new StringBuffer("LsPatches::getInstance() returns");
        OLogger.debug(buff);
    }

    private void loadAndPrintStagedPatchMetadata(String oracleHomePath, String patchLoc, boolean required) throws RuntimeException, NotFoundException {
        RuntimeException re = null;
        ArrayList<OneOffEntry> oneoffsArr = new ArrayList<OneOffEntry>();
        try {
            switch (OPatchEnv.getPatchFormat()) {
                case 3: {
                    List<GenericPatch> subPatches = null;
                    OPatchBundlePatch bpo = (OPatchBundlePatch)PatchPackageGenerator.getPatchInstance(patchLoc);
                    subPatches = bpo.getSubPatches();
                    for (int i2 = 0; i2 < subPatches.size(); ++i2) {
                        PatchPackage subPatch = subPatches.get(i2);
                        if (subPatch instanceof OPatchCompositePatch) {
                            OPatchCompositePatch cpp = (OPatchCompositePatch)subPatch;
                            List<GenericSingletonPatch> subOfComposite = cpp.getSubPatches();
                            for (int j2 = 0; j2 < subOfComposite.size(); ++j2) {
                                PatchObject patchObj = null;
                                OPatchSingletonPatch sigPo = (OPatchSingletonPatch)subOfComposite.get(j2);
                                try {
                                    patchObj = new PatchObject(sigPo.getPatchLocation());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (patchObj == null) continue;
                                oneoffsArr.add(patchObj.toOneOffEntry(oracleHomePath));
                            }
                            String compositeXML = CompositePatchObject.getCompositeFilePath(cpp.getPatchLocation());
                            String[] sortedOrder = CompositePatchObject.getConstituentList(compositeXML);
                            for (int x = 0; x < sortedOrder.length; ++x) {
                                int y;
                                int patchCount = 0;
                                for (y = 0; y < oneoffsArr.size(); ++y) {
                                    String currentEntryID = ((OneOffEntry)oneoffsArr.get(y)).getID();
                                    if (!currentEntryID.equals(sortedOrder[x])) continue;
                                    ++patchCount;
                                    break;
                                }
                                if (patchCount != 1) {
                                    throw new Exception();
                                }
                                OneOffEntry currentEntry = (OneOffEntry)oneoffsArr.get(y);
                                oneoffsArr.set(y, (OneOffEntry)oneoffsArr.get(x));
                                oneoffsArr.set(x, currentEntry);
                            }
                            continue;
                        }
                        String subPatchLoc = subPatch.getPatchLocation();
                        PatchObject po = new PatchObject(subPatchLoc);
                        oneoffsArr.add(po.toOneOffEntry(oracleHomePath));
                    }
                    if (oneoffsArr.size() == 0) {
                        throw new Exception();
                    }
                    break;
                }
                case 1: {
                    File compositeLoc = new File(patchLoc);
                    File[] compPatches = compositeLoc.listFiles();
                    for (int i3 = 0; i3 < compPatches.length; ++i3) {
                        PatchObject patchObj = null;
                        String compPatchLoc = "";
                        try {
                            compPatchLoc = compPatches[i3].getCanonicalPath();
                        }
                        catch (IOException e2) {
                            compPatchLoc = compPatches[i3].getAbsolutePath();
                        }
                        try {
                            patchObj = new PatchObject(compPatchLoc);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        if (patchObj == null) continue;
                        oneoffsArr.add(patchObj.toOneOffEntry(oracleHomePath));
                    }
                    if (oneoffsArr.size() == 0) {
                        throw new Exception();
                    }
                    String[] sortedOrder = CompositePatchObject.getConstituentList(OPatchEnv.getCompositeXMLPath());
                    for (int x = 0; x < sortedOrder.length; ++x) {
                        int y;
                        int patchCount = 0;
                        for (y = 0; y < oneoffsArr.size(); ++y) {
                            String currentEntryID = ((OneOffEntry)oneoffsArr.get(y)).getID();
                            if (!currentEntryID.equals(sortedOrder[x])) continue;
                            ++patchCount;
                            break;
                        }
                        if (patchCount != 1) {
                            throw new Exception();
                        }
                        OneOffEntry currentEntry = (OneOffEntry)oneoffsArr.get(y);
                        oneoffsArr.set(y, (OneOffEntry)oneoffsArr.get(x));
                        oneoffsArr.set(x, currentEntry);
                    }
                    break;
                }
                case 2: {
                    File[] subPatchFiles = new File(patchLoc).listFiles();
                    for (int i4 = 0; i4 < subPatchFiles.length; ++i4) {
                        if (!subPatchFiles[i4].isDirectory()) continue;
                        String subPatchLoc = "";
                        try {
                            subPatchLoc = subPatchFiles[i4].getCanonicalPath();
                        }
                        catch (IOException e3) {
                            subPatchLoc = subPatchFiles[i4].getAbsolutePath();
                        }
                        PatchObject po = null;
                        try {
                            po = new PatchObject(subPatchLoc);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (po == null) continue;
                        oneoffsArr.add(po.toOneOffEntry(oracleHomePath));
                    }
                    if (oneoffsArr.size() == 0) {
                        throw new Exception();
                    }
                    break;
                }
                default: {
                    if (!OnlinePatchProcessor.isOnlineOnlyPatch(patchLoc)) {
                        PatchObject patchObj = new PatchObject(patchLoc);
                        oneoffsArr.add(patchObj.toOneOffEntry(oracleHomePath));
                    }
                    if (OnlinePatchProcessor.isHybridOnlinePatch(patchLoc)) {
                        OnlinePatchProcessor.setHybridPatchPart(patchLoc, PatchObject.HybridPatchPart.ONLINE);
                        PatchObject onlineObj = new PatchObject(patchLoc);
                        oneoffsArr.add(onlineObj.toOneOffEntry(oracleHomePath));
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new NotFoundException(OLogger.getString("OUI-67736", new Object[]{patchLoc}));
        }
        try {
            OneOffEntry[] oneOffs = new OneOffEntry[oneoffsArr.size()];
            oneoffsArr.toArray(oneOffs);
            for (int i5 = 0; i5 < oneOffs.length; ++i5) {
                oneOffs[i5].setAppliedDate(null);
            }
            LsPatchesPrinter.printMetadataForPatches(oracleHomePath, oneOffs, required);
        }
        catch (NotFoundException e4) {
            throw e4;
        }
        catch (Throwable t) {
            re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "lspatches_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

