/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.Crs;
import oracle.opatch.LsInventoryFileFormatter;
import oracle.opatch.LsInventoryPrinter;
import oracle.opatch.LsInventoryToXML;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.Rac;
import oracle.opatch.Rules;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.ops.mgmt.cluster.ClusterCmd;

public class LsInventorySession
extends OPatchSession {
    private FileHandler logFileHandler = null;

    protected LsInventorySession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public boolean isReadOnly() {
        this.readOnly = true;
        return true;
    }

    public void init(String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("LsInventory::init()");
        OLogger.debug(buff);
        Object re = null;
        boolean ok = false;
        String sessionType = this.getSessionName();
        String outputFileName = "";
        try {
            outputFileName = OPatchACL.invokeOLogger(this, "getOutputFileNameForLsInv", new Object[]{oracleHomePath, sessionType}).toString();
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2.getMessage());
        }
        buff = new StringBuffer("LsInventorySession::process(): creates an output file ");
        buff.append(outputFileName);
        OLogger.debug(buff);
        File outputFile = new File(outputFileName);
        try {
            ok = outputFile.createNewFile();
            OUIReplacer.changePermission(outputFileName, 416);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!ok) {
            buff = new StringBuffer("LsInventory cannot create the log directory ");
            buff.append(outputFileName);
            OLogger.debug(buff);
        } else {
            try {
                this.logFileHandler = new FileHandler(outputFileName);
                this.logFileHandler.setFormatter(new LsInventoryFileFormatter());
                this.logFileHandler.setLevel(Level.INFO);
            }
            catch (IOException e3) {
                ok = false;
            }
        }
        if (!ok) {
            buff = new StringBuffer("LsInventory::init() failed to create output file ");
            buff.append(outputFileName);
            OLogger.debug(buff);
        }
        buff = new StringBuffer("LsInventory::init() returns");
        OLogger.debug(buff);
        buff = new StringBuffer("Lsinventory Output file location : ");
        buff.append(outputFileName);
        buff.append("\n");
        OLogger.log(OLogger.INFO, buff.toString());
        try {
            OPatchACL.invokeOLogger(this, "setLsInventoryFileHandler", new Object[]{this.logFileHandler});
            OPatchACL.invokeOLogger(this, "addHandler", new Object[]{this.logFileHandler});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected InstalledComponent[] getMatchedComponent(InstalledComponent[] comps, String regExp) {
        InstalledComponent[] filteredComps = new InstalledComponent[]{};
        ArrayList<InstalledComponent> list = new ArrayList<InstalledComponent>();
        StringBuffer buff = new StringBuffer();
        buff.append("(.*)(");
        buff.append(regExp);
        buff.append(")(.*)");
        Pattern pattern = Pattern.compile(buff.toString(), 2);
        for (int i2 = 0; i2 < comps.length; ++i2) {
            InstalledComponent ic = comps[i2];
            String ID = ic.getID();
            Matcher matcher = pattern.matcher(ID);
            if (!matcher.matches()) continue;
            list.add(ic);
        }
        int len = list.size();
        filteredComps = new InstalledComponent[len];
        for (int i3 = 0; i3 < len; ++i3) {
            InstalledComponent ic;
            filteredComps[i3] = ic = (InstalledComponent)list.get(i3);
        }
        return filteredComps;
    }

    public void process(String oracleHomePath) throws RuntimeException {
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (!readServices.isInventoryLoaded()) {
                boolean alreadyLocked = readServices.isLocked();
                try {
                    if (!alreadyLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                    Object var6_6 = null;
                    if (!alreadyLocked) {
                        readServices.release();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!alreadyLocked) {
                        readServices.release();
                    }
                    throw throwable;
                }
            }
            if (!readServices.isInventoryLoaded()) {
                OLogger.printlnres("OUI-67121");
            } else {
                this.loadAndPrintInventory(oracleHomePath, readServices);
            }
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t) {
            OLogger.error("OUI-67028", new Object[]{"LsInventorySession::process()"});
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAndPrintInventory(String oracleHomePath, IIPMReadServices readServices) throws RuntimeException {
        StringBuffer buff;
        block50: {
            block49: {
                OneOffEntry[] oneOffs = new OneOffEntry[]{};
                String[] nodeList = new String[]{};
                String oracleHomeName = "";
                RuntimeException re = null;
                boolean isCRS = false;
                buff = new StringBuffer("LsInventory::loadAndPrintInventory()");
                OLogger.debug(buff);
                OLogger.debug(new StringBuffer("Retrieving inventory from Oracle Home..."));
                try {
                    try {
                        InstalledComponent[] comps;
                        this.init(oracleHomePath);
                        boolean optPatchChecksum = OPatchEnv.isPatchChecksum();
                        boolean allNodes = OPatchEnv.isAllNode();
                        boolean optAll = OPatchEnv.isLsinv_all();
                        boolean optXML = OPatchEnv.isLsinv_xml();
                        boolean optMatch = OPatchEnv.isLsinv_match();
                        boolean optInactive = OPatchEnv.isLsinv_inactive();
                        boolean optPatch = OPatchEnv.isLsinv_patch();
                        boolean optDetail = OPatchEnv.isLsinv_detail();
                        boolean optBugsFixed = OPatchEnv.isSortByBugsFixed();
                        boolean optTrans = OPatchEnv.isTransPatch();
                        boolean printHome = Rules.printHomes(optAll, optXML, optMatch, optPatch, optDetail);
                        boolean printAllProduct = Rules.printAllProducts(optAll, optXML, optMatch, optPatch, optDetail);
                        boolean printTopLevelProduct = Rules.printTopLevelProducts(optAll, optXML, optMatch, optPatch, optDetail);
                        boolean printMatchedProduct = Rules.printMatchedProducts(optAll, optXML, optMatch, optPatch, optDetail);
                        boolean printPatch = Rules.printOneOffs(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed, optTrans);
                        boolean printDetail = Rules.printDetails(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed, optTrans);
                        boolean printByBugsFixed = Rules.printByBugsFixed(optAll, optXML, optMatch, optPatch, optDetail, optBugsFixed);
                        boolean printLangPatches = Rules.printLangPatch(optAll, optXML, optMatch, optPatch, optDetail, optTrans);
                        boolean printPatchChecksum = optPatchChecksum;
                        if (allNodes) {
                            printHome = false;
                            printAllProduct = false;
                            printTopLevelProduct = false;
                            printMatchedProduct = false;
                            printPatch = false;
                            printDetail = false;
                            printByBugsFixed = false;
                            printLangPatches = false;
                        }
                        if (!optBugsFixed && !optTrans) {
                            OLogger.println("--------------------------------------------------------------------------------");
                        } else {
                            OLogger.println("------------------------------------------------------------------------------------------------------");
                        }
                        Rules rules = new Rules();
                        buff = new StringBuffer(rules.toString());
                        OLogger.debug(buff);
                        OPatchSDK.OracleHome[] oracleHomes = new OPatchSDK.OracleHome[]{};
                        oneOffs = optInactive ? readServices.getInactivePatches() : readServices.getAllInstalledPatches();
                        if (optXML) {
                            boolean ok;
                            String xmlFile;
                            block48: {
                                OutputStream xmlOutputStream = null;
                                xmlFile = OPatchEnv.getLsinv_xml_loc();
                                ok = true;
                                try {
                                    try {
                                        File file = new File(xmlFile);
                                        File parentDir = file.getParentFile();
                                        if (parentDir != null && !parentDir.exists()) {
                                            parentDir.mkdirs();
                                        }
                                        xmlOutputStream = new FileOutputStream(file);
                                        InstalledComponent[] comps2 = readServices.getInstalledComponents();
                                        String localNode = "";
                                        if (nodeList != null && nodeList.length > 1) {
                                            localNode = nodeList[0];
                                        }
                                        LsInventoryToXML.process(xmlOutputStream, oracleHomeName, oracleHomePath, isCRS, localNode, nodeList, comps2, oneOffs, oracleHomes);
                                    }
                                    catch (IOException e2) {
                                        ok = false;
                                        Object var38_53 = null;
                                        xmlOutputStream.flush();
                                        ((FileOutputStream)xmlOutputStream).close();
                                        break block48;
                                    }
                                    Object var38_52 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var38_54 = null;
                                    xmlOutputStream.flush();
                                    ((FileOutputStream)xmlOutputStream).close();
                                    throw throwable;
                                }
                                xmlOutputStream.flush();
                                ((FileOutputStream)xmlOutputStream).close();
                            }
                            if (!ok) {
                                System.out.println("\n\nCannot generate " + xmlFile);
                            } else {
                                System.out.println("\n\nGenerated xml file " + xmlFile + " from Oracle Home inventory shown above.");
                            }
                            Object var40_56 = null;
                            if (this.logFileHandler == null) return;
                            break block49;
                        }
                        LsInventoryPrinter.printLocalMachineInfo(readServices);
                        if (printHome) {
                            oracleHomes = readServices.getOracleHomes();
                            LsInventoryPrinter.printListOfOracleHomes(oracleHomes);
                        }
                        if (printTopLevelProduct) {
                            if (OPatchEnv.isNextGen()) {
                                comps = readServices.getNextGenInstalledDistributions();
                                if (comps == null) {
                                    comps = readServices.getTopLevelInstalledComponents();
                                }
                            } else {
                                comps = readServices.getTopLevelInstalledComponents();
                            }
                            String header = "";
                            Integer len = new Integer(comps.length);
                            header = OLogger.getString("OUI-67097", new Object[]{len});
                            if (comps.length != 0) {
                                LsInventoryPrinter.printInstalledComponents_ProdName_Version(comps, header);
                                OLogger.println("");
                            }
                        }
                        if (printAllProduct) {
                            if (OPatchEnv.isNextGen()) {
                                comps = readServices.getNextGenInstalledComponents();
                                if (comps == null) {
                                    comps = readServices.getInstalledComponents();
                                }
                            } else {
                                comps = readServices.getInstalledComponents();
                            }
                            Integer len = new Integer(comps.length);
                            String header = OLogger.getString("OUI-67130", new Object[]{len});
                            LsInventoryPrinter.printInstalledComponents_ProdName_Version(comps, header);
                            OLogger.println("");
                        }
                        if (printMatchedProduct) {
                            String regExp = OPatchEnv.getLsInvRegExpression();
                            comps = readServices.getInstalledComponents();
                            comps = this.getMatchedComponent(comps, regExp);
                            LsInventoryPrinter.printMatchedInstalledComponents_ProdID_Version_Name(regExp, comps);
                            OLogger.println("");
                        }
                        if (printPatch) {
                            boolean detail = OPatchEnv.isLsinv_detail();
                            if (optInactive) {
                                OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
                                LsInventoryPrinter.printInactivePatches("ORACLE_HOME", oneOffs, installedOneOffs, printDetail);
                            } else {
                                LsInventoryPrinter.printInstalledPatches("ORACLE_HOME", oneOffs, printDetail, oracleHomePath);
                            }
                        }
                        if (printByBugsFixed) {
                            String oracleHome = OPatchEnv.getOracleHome();
                            LsInventoryPrinter.printBugsFixedByPatches(oracleHome, oneOffs);
                        }
                        if (printLangPatches) {
                            String oracleHome = OPatchEnv.getOracleHome();
                            OneOffEntry[] installedPatches = readServices.getInstalledPatches();
                            OneOffEntry[] inactivePatches = readServices.getInactivePatches();
                            LsInventoryPrinter.printTranslationPatches(oracleHome, installedPatches, inactivePatches);
                        }
                        if (printPatchChecksum) {
                            String oracleHome = OPatchEnv.getOracleHome();
                            this.logFileHandler.setLevel(Level.OFF);
                            LsInventoryPrinter.printPatchAndChecksum(oracleHome, oneOffs);
                            this.logFileHandler.setLevel(Level.INFO);
                        }
                        oracleHomeName = readServices.getOracleHomeName();
                        isCRS = readServices.isCRSHome();
                        OLogger.println("");
                        try {
                            nodeList = LsInventorySession.probeAndPrintRACInfo(readServices);
                        }
                        catch (RuntimeException oracleHome) {
                            // empty catch block
                        }
                        if (allNodes) {
                            this.logFileHandler.setLevel(Level.OFF);
                            LsInventorySession.printAllNodesInfo(OPatchEnv.getOracleHome(), readServices);
                            this.logFileHandler.setLevel(Level.INFO);
                        }
                        if (!optBugsFixed && !optTrans) {
                            OLogger.println("--------------------------------------------------------------------------------");
                            break block50;
                        } else {
                            OLogger.println("------------------------------------------------------------------------------------------------------");
                        }
                        break block50;
                    }
                    catch (SecurityException e3) {
                        buff = new StringBuffer("OPatch cannot load inventory for the given Oracle Home.\n");
                        buff.append("Possible causes are:\n");
                        buff.append("  Oracle Home path does not match with entry in inventory.xml\n");
                        buff.append("  Oracle Home was installed with -invPtrLoc option");
                        OLogger.error("OUI-67028", new Object[]{buff.toString()});
                        re = new RuntimeException(e3.getMessage());
                        re.setStackTrace(e3.getStackTrace());
                        throw re;
                    }
                    catch (IllegalArgumentException e4) {
                        buff = new StringBuffer("OPatch cannot load inventory for the given Oracle Home.\n");
                        buff.append("Possible causes are:\n");
                        buff.append("   ORACLE_HOME/oui/jlib does not exist\n");
                        buff.append("   One of the required libraries is missing");
                        OLogger.error("OUI-67028", new Object[]{buff.toString()});
                        re = new RuntimeException(e4.getMessage());
                        re.setStackTrace(e4.getStackTrace());
                        throw re;
                    }
                    catch (NullPointerException e5) {
                        buff = new StringBuffer("OPatch cannot load inventory for the given Oracle Home.\n");
                        buff.append("Possible causes are:\n");
                        buff.append("   Oracle Home dir. path does not exist in Central Inventory\n");
                        buff.append("   Oracle Home is a symbolic link\n");
                        buff.append("   Oracle Home inventory is corrupted");
                        OLogger.error("OUI-67028", new Object[]{buff.toString()});
                        re = new RuntimeException(e5.getMessage());
                        re.setStackTrace(e5.getStackTrace());
                        throw re;
                    }
                    catch (Throwable t) {
                        OLogger.println("\n");
                        OLogger.error("OUI-67028", new Object[]{"OPatch cannot load inventory for the given Oracle Home.\n"});
                        re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        throw re;
                    }
                }
                catch (Throwable throwable) {
                    Object var40_58 = null;
                    if (this.logFileHandler == null) throw throwable;
                    this.logFileHandler.setLevel(Level.OFF);
                    try {
                        OPatchACL.invokeOLogger(this, "rmHandler", new Object[]{this.logFileHandler});
                        throw throwable;
                    }
                    catch (IllegalAccessException e6) {
                        throw new RuntimeException(e6.getMessage());
                    }
                }
            }
            this.logFileHandler.setLevel(Level.OFF);
            try {}
            catch (IllegalAccessException e6) {
                throw new RuntimeException(e6.getMessage());
            }
            OPatchACL.invokeOLogger(this, "rmHandler", new Object[]{this.logFileHandler});
            return;
        }
        Object var40_57 = null;
        if (this.logFileHandler != null) {
            this.logFileHandler.setLevel(Level.OFF);
            try {}
            catch (IllegalAccessException e6) {
                throw new RuntimeException(e6.getMessage());
            }
            OPatchACL.invokeOLogger(this, "rmHandler", new Object[]{this.logFileHandler});
        }
        buff = new StringBuffer("LsInventory::getInstance() returns");
        OLogger.debug(buff);
    }

    protected static String[] probeAndPrintRACInfo(IIPMReadServices readServices) throws RuntimeException {
        StringBuffer buff = new StringBuffer("probeAndPrintRACInfo()");
        String[] retNodes = new String[]{};
        StringBuffer output = new StringBuffer();
        OLogger.debug(buff);
        Rac.RacType racType = null;
        racType = Rac.getInstance(readServices);
        buff = new StringBuffer(racType.getDetail());
        String dscr = buff.toString();
        OLogger.debug(buff);
        String toString = Rac.toString(readServices);
        buff = new StringBuffer(toString);
        OLogger.debug(buff);
        if (racType == Rac.RacType.MULTIPLE_NODE) {
            if (readServices.isDesiredHome()) {
                String oracleHomePath = OPatchEnv.getOracleHome();
                HashMap<String, String> patchingLevels = Crs.getPatchingLevel(oracleHomePath);
                HashMap levelNodeMap = new HashMap();
                Iterator<String> nodes = patchingLevels.keySet().iterator();
                if (!nodes.hasNext()) {
                    throw new RuntimeException("Failed to get patch level information from CRS home");
                }
                int maxLen = 14;
                while (nodes.hasNext()) {
                    String node = nodes.next();
                    String level = patchingLevels.get(node);
                    int n2 = maxLen = maxLen < level.length() ? level.length() : maxLen;
                    if (levelNodeMap.get(level) != null) {
                        ((ArrayList)levelNodeMap.get(level)).add(node);
                        continue;
                    }
                    ArrayList<String> nodesInfo = new ArrayList<String>();
                    nodesInfo.add(node);
                    levelNodeMap.put(level, nodesInfo);
                }
                output = new StringBuffer("Patch level status of Cluster nodes :\n\n");
                String gap = OPatchEnv.getSpaceString(maxLen + 4 - 14);
                output.append(" Patching Level " + gap + "\t\t Nodes\n");
                output.append(" -------------- " + gap + "\t\t -----\n");
                for (String level : levelNodeMap.keySet()) {
                    ArrayList nodesInfo = (ArrayList)levelNodeMap.get(level);
                    output.append(" " + level + OPatchEnv.getSpaceString(maxLen + 4 - level.length()) + " \t\t ");
                    for (int i2 = 0; i2 < nodesInfo.size(); ++i2) {
                        output.append((String)nodesInfo.get(i2) + (i2 != nodesInfo.size() - 1 ? "," : ""));
                    }
                    output.append("\n");
                }
            } else {
                String localNode = racType.getLocalNode();
                String[] nodeList = racType.getRemoteNodes();
                OLogger.println(dscr);
                buff = new StringBuffer("  CRS Home = ");
                buff.append(readServices.isCRSHome());
                buff.append("\n");
                OLogger.log(OLogger.FINE, buff.toString());
                if (localNode != null) {
                    output = new StringBuffer("  Local node = ");
                    output.append(localNode);
                    output.append("\n");
                }
                OLogger.debug(output);
                if (nodeList != null && nodeList.length > 0) {
                    int len = nodeList.length;
                    buff = new StringBuffer("  nodeList != null: len= ");
                    buff.append(len);
                    OLogger.debug(buff);
                    retNodes = new String[len + 1];
                    buff = new StringBuffer("  put ");
                    buff.append(localNode);
                    buff.append(" to retNodes[0]");
                    OLogger.debug(buff);
                    retNodes[0] = localNode;
                    for (int i3 = 0; i3 < len; ++i3) {
                        String node = nodeList[i3];
                        buff = new StringBuffer("  processing node ");
                        buff.append(node);
                        OLogger.debug(buff);
                        if (node.equals(localNode)) continue;
                        output.append("  Remote node = ");
                        output.append(node);
                        output.append("\n");
                        retNodes[i3 + 1] = node;
                        buff = new StringBuffer("  assigning node ");
                        buff.append(node);
                        buff.append(" to retNodes[");
                        buff.append(i3 + 1);
                        buff.append("]");
                        OLogger.debug(buff);
                    }
                }
            }
            OLogger.println(output.toString());
        } else if (racType != Rac.RacType.NO_RAC && racType == Rac.RacType.SINGLE_NODE) {
            OLogger.println(output.toString());
            String localNode = racType.getLocalNode();
            if (localNode != null) {
                retNodes = new String[]{localNode};
            }
        }
        buff = new StringBuffer("probeAndPrintRACInfo() done");
        OLogger.debug(buff);
        return retNodes;
    }

    protected static void printAllNodesInfo(String oracleHomePath, IIPMReadServices readServices) throws RuntimeException {
        StringBuffer buff = new StringBuffer("printAllNodesInfo()");
        OLogger.debug(buff);
        Rac.RacType racType = null;
        racType = Rac.getInstance(readServices);
        if (racType == Rac.RacType.NO_RAC) {
            throw new RuntimeException(OLogger.getString("OUI-67224"));
        }
        if (racType == Rac.RacType.SINGLE_NODE) {
            OLogger.println(OLogger.getString("OUI-67225"));
            return;
        }
        if (racType == Rac.RacType.MULTIPLE_NODE) {
            String warn;
            int count;
            String dstChecksumLogFile;
            String dstPatchLogFile;
            buff = new StringBuffer("Detected as Multiple Node RAC");
            OLogger.debug(buff);
            boolean cleanUpFailure = false;
            String patchStorageLocation = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
            String srcPatchLogFile = patchStorageLocation + File.separator + "patch_info.log";
            String srcChecksumLogFile = patchStorageLocation + File.separator + "checksum_info.log";
            String[] nodeList = racType.getRemoteNodes();
            String localNode = racType.getLocalNode();
            File f2 = new File(srcPatchLogFile);
            if (f2.exists()) {
                f2.delete();
            }
            if ((f2 = new File(srcChecksumLogFile)).exists()) {
                f2.delete();
            }
            for (int count2 = 0; count2 < nodeList.length; ++count2) {
                dstPatchLogFile = patchStorageLocation + File.separator + "patch_info_" + nodeList[count2] + ".log";
                dstChecksumLogFile = patchStorageLocation + File.separator + "checksum_info_" + nodeList[count2] + ".log";
                f2 = new File(dstPatchLogFile);
                if (f2.exists()) {
                    f2.delete();
                }
                if (!(f2 = new File(dstChecksumLogFile)).exists()) continue;
                f2.delete();
            }
            ClusterCmd clusterCmd = null;
            try {
                clusterCmd = new ClusterCmd();
            }
            catch (Exception e2) {
                buff = new StringBuffer("lsinventory::failed for -all_nodes");
                buff.append("\n");
                buff.append(e2.getMessage());
                RuntimeException re = new RuntimeException(buff.toString(), e2);
                throw re;
            }
            String cmd = oracleHomePath + File.separator + "OPatch" + File.separator + "opatch";
            String invPtrLoc = OPatchEnv.getAbsoluteInvPtrLoc();
            if (invPtrLoc.equals("") || invPtrLoc == null) {
                throw new RuntimeException("OPatch finds invalid oraInst.loc location");
            }
            String[] argString = new String[]{" lsinventory ", "-patch_checksum", "-oh", oracleHomePath, "-invPtrLoc", invPtrLoc};
            String[] lNode = new String[]{localNode};
            buff = new StringBuffer("Command to be run with Arguments:");
            buff.append(cmd);
            buff.append(" ");
            buff.append(argString);
            OLogger.debug(buff);
            try {
                clusterCmd.runCmd(cmd, argString, null, nodeList);
                clusterCmd.runCmd(cmd, argString, null, lNode);
            }
            catch (Exception e3) {
                buff = new StringBuffer("Issue with running commands at remote\n");
                buff.append(e3.toString());
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(buff.toString(), e3);
                throw re;
            }
            for (count = 0; count < nodeList.length; ++count) {
                dstPatchLogFile = patchStorageLocation + File.separator + "patch_info_" + nodeList[count] + ".log";
                dstChecksumLogFile = patchStorageLocation + File.separator + "checksum_info_" + nodeList[count] + ".log";
                try {
                    clusterCmd.copyFileFromNode(nodeList[count], srcPatchLogFile, dstPatchLogFile);
                    clusterCmd.copyFileFromNode(nodeList[count], srcChecksumLogFile, dstChecksumLogFile);
                    continue;
                }
                catch (Exception e4) {
                    buff = new StringBuffer("Issue with file propagation\n");
                    buff.append(e4.toString());
                    OLogger.debug(buff);
                    RuntimeException re = new RuntimeException(buff.toString(), e4);
                    throw re;
                }
            }
            String[] patchLogFile = new String[nodeList.length + 1];
            String[] checkSumLogFile = new String[nodeList.length + 1];
            String[] binary = new String[nodeList.length + 1];
            String[] checksum = new String[nodeList.length + 1];
            f2 = new File(srcPatchLogFile);
            patchLogFile[0] = f2.exists() && f2.canRead() ? srcPatchLogFile : "";
            f2 = new File(srcChecksumLogFile);
            checkSumLogFile[0] = f2.exists() && f2.canRead() ? srcChecksumLogFile : "";
            buff = new StringBuffer("start printing of patchlists, binary, checksum information");
            OLogger.debug(buff);
            for (count = 0; count < nodeList.length; ++count) {
                patchLogFile[count + 1] = patchStorageLocation + File.separator + "patch_info_" + nodeList[count] + ".log";
                checkSumLogFile[count + 1] = patchStorageLocation + File.separator + "checksum_info_" + nodeList[count] + ".log";
                f2 = new File(patchLogFile[count + 1]);
                if (!f2.exists() || !f2.canRead()) {
                    patchLogFile[count + 1] = "";
                }
                if ((f2 = new File(checkSumLogFile[count + 1])).exists() && f2.canRead()) continue;
                checkSumLogFile[count + 1] = "";
            }
            StringBuffer warnMsg = new StringBuffer("");
            OLogger.println("\nInstalled Patch List(s)");
            OLogger.println("======================\n");
            for (int count3 = 0; count3 < patchLogFile.length; ++count3) {
                String curNode = "";
                try {
                    String buffer;
                    BufferedReader patchBufferReader = new BufferedReader(new FileReader(patchLogFile[count3]));
                    StringBuffer nodeName = new StringBuffer("Node Name : ");
                    if (count3 == 0) {
                        nodeName.append(lNode[0]);
                        curNode = lNode[0];
                    } else {
                        nodeName.append(nodeList[count3 - 1]);
                        curNode = nodeList[count3 - 1];
                    }
                    nodeName.append("\n");
                    int curLen = nodeName.length();
                    for (int i2 = 0; i2 < curLen - 1; ++i2) {
                        nodeName.append("-");
                    }
                    nodeName.append("\n");
                    OLogger.println(nodeName.toString());
                    while ((buffer = patchBufferReader.readLine()) != null) {
                        OLogger.println(buffer);
                    }
                    OLogger.println("");
                }
                catch (FileNotFoundException e5) {
                    buff = new StringBuffer("");
                    buff.append("Propagated patch log file " + patchLogFile[count3] + "is not found locally for Node : " + curNode);
                    buff.append("\n");
                    buff.append(e5.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e5);
                    throw re;
                }
                catch (IOException e6) {
                    buff = new StringBuffer("");
                    buff.append("Error in reading propagated patch log " + patchLogFile[count3] + "for Node : " + curNode);
                    buff.append("\n");
                    buff.append(e6.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e6);
                    throw re;
                }
                try {
                    BufferedReader checksumBufferReader = new BufferedReader(new FileReader(checkSumLogFile[count3]));
                    binary[count3] = checksumBufferReader.readLine();
                    checksum[count3] = checksumBufferReader.readLine();
                    continue;
                }
                catch (FileNotFoundException e7) {
                    buff = new StringBuffer("");
                    buff.append("Propagated checksum log file " + checkSumLogFile[count3] + "is not found locally for Node :" + curNode);
                    buff.append("\n");
                    buff.append(e7.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e7);
                    throw re;
                }
                catch (IOException e8) {
                    buff = new StringBuffer("");
                    buff.append("Error in reading propagated checksum log " + checkSumLogFile[count3] + "for Node : " + curNode);
                    buff.append("\n");
                    buff.append(e8.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString(), e8);
                    throw re;
                }
            }
            OLogger.println("\nBinary & Checksum Information");
            OLogger.println("==============================");
            OLogger.println("\n Binary Location : " + oracleHomePath + File.separator + "bin" + File.separator + "oracle");
            OLogger.println("\n Node\t\t\tSize\t\t\tChecksum");
            OLogger.println(" ----\t\t\t----\t\t\t--------");
            String refChecksum = checksum[0];
            String refBinary = binary[0];
            boolean oneTimeCheck = true;
            for (int count4 = 0; count4 < binary.length; ++count4) {
                String curNode;
                if (count4 == 0) {
                    curNode = lNode[0];
                    OLogger.println(" " + lNode[0] + "\t\t" + binary[count4] + "\t\t" + checksum[count4]);
                } else {
                    curNode = nodeList[count4 - 1];
                    OLogger.println(" " + nodeList[count4 - 1] + "\t\t" + binary[count4] + "\t\t" + checksum[count4]);
                }
                if (refChecksum.equals(checksum[count4]) || refBinary.equals(binary[count4])) continue;
                if (oneTimeCheck) {
                    warnMsg.append("The binary and checksum values of the following nodes does not match with that of " + lNode[0] + " (local node) : \n" + curNode);
                    oneTimeCheck = false;
                    continue;
                }
                warnMsg.append("\n" + curNode);
            }
            cleanUpFailure = LsInventorySession.cleanUpLogFiles(patchLogFile, checkSumLogFile);
            if (cleanUpFailure) {
                buff = new StringBuffer("Clean up operation for 'lsinventory -all_nodes' failed.");
                OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            }
            if (!(warn = warnMsg.toString()).equals("")) {
                warnMsg.append("\n");
                OLogger.warn("OUI-67124", new Object[]{warnMsg.toString()});
                buff = new StringBuffer("All warnings encountered by printAllNodesInfo()");
                buff.append("\n");
                buff.append(warnMsg.toString());
                OLogger.debug(buff);
            }
            buff = new StringBuffer("printAllNodesInfo returns");
            OLogger.debug(buff);
        }
    }

    private static boolean cleanUpLogFiles(String[] patchLogFile, String[] checkSumLogFile) {
        int count;
        boolean cleanUpFailure = false;
        StringBuffer logMsg = null;
        File f2 = null;
        for (count = 0; count < patchLogFile.length; ++count) {
            f2 = new File(patchLogFile[count]);
            try {
                if (!f2.exists()) continue;
                f2.delete();
                continue;
            }
            catch (Exception e2) {
                cleanUpFailure = true;
                logMsg = new StringBuffer("");
                logMsg.append("OPatch may not have successfully deleted the file '" + patchLogFile[count] + "'");
                logMsg.append("\n");
                OLogger.justlog(OLogger.INFO, logMsg.toString());
                OLogger.printStackTrace(e2);
            }
        }
        for (count = 0; count < checkSumLogFile.length; ++count) {
            f2 = new File(checkSumLogFile[count]);
            try {
                if (!f2.exists()) continue;
                f2.delete();
                continue;
            }
            catch (Exception e3) {
                cleanUpFailure = true;
                logMsg = new StringBuffer("");
                logMsg.append("OPatch may not have successfully deleted the file '" + checkSumLogFile[count] + "'");
                logMsg.append("\n");
                OLogger.justlog(OLogger.INFO, logMsg.toString());
                OLogger.printStackTrace(e3);
            }
        }
        return cleanUpFailure;
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "lsinv_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    public static String getCheckSum(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        int len = 0;
        MessageDigest md = null;
        byte[] buffer = new byte[4096];
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e2) {
            StringBuffer msg = new StringBuffer("LsInventorySession::getCheckSum() failed: ");
            msg.append(e2.getMessage());
            RuntimeException re = new RuntimeException(msg.toString());
            re.setStackTrace(e2.getStackTrace());
            ((InputStream)in).close();
            throw re;
        }
        while ((len = ((InputStream)in).read(buffer)) >= 0) {
            md.update(buffer, 0, len);
        }
        byte[] b2 = md.digest();
        ((InputStream)in).close();
        return PatchAction.getHex(b2);
    }

    public static void main(String[] args) {
        String oracleHomePath = "C:\\oracle\\product\\10.1.0\\Db_1";
        String patchLocation = "U:\\OPatch\\Code\\OPatch\\0118481";
        LsInventorySession session = OPatchSession.LSINVENTORY;
        String patchID = "0118483";
        if (!OPatchEnv.isWindows()) {
            oracleHomePath = "/private/phi_local/home10.1.0.2";
            patchLocation = "/private/phnguyen/OPatch/Code/OPatch/0118483";
            patchID = "0118483";
        }
        oracleHomePath = "/u0a/share/phi/db_phi3";
        String patchStorageDirPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        String sessionType = session.getSessionName();
        try {
            String fileName = OPatchACL.invokeOLogger(session, "getOutputFileNameForLsInv", new Object[]{oracleHomePath, sessionType}).toString();
            System.out.println("LsInventory, if succeeds, will write output to " + fileName);
            StringBuffer ouiLoc = new StringBuffer(oracleHomePath);
            ouiLoc.append(File.separator);
            ouiLoc.append("oui");
            OPatchEnv.setOUILocation(oracleHomePath, ouiLoc.toString());
            OPatchACL.invokeOLogger(session, "setDebug", new Object[]{true});
            session.process(oracleHomePath);
            System.out.println("LsInventorySession::main() done");
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

