/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.BaseTransReln;
import oracle.opatch.Bug;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.LsInventoryFileFormatter;
import oracle.opatch.LsInventorySession;
import oracle.opatch.NameValuePair;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.SystemCall;
import oracle.opatch.UpdateComponent;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchactions.portalAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;

public class LsInventoryPrinter {
    private LsInventoryPrinter() {
    }

    protected static void printPatchAndChecksum(String oracleHomePath, OneOffEntry[] oneOffs) throws NullPointerException {
        String checkSumLogFile;
        String patchLogFile;
        StringBuffer buff = null;
        String oracle = "oracle";
        String binary = "bin";
        FileHandler infoLogFh = null;
        FileHandler checkSumLogFh = null;
        if (oneOffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        LsInventoryPrinter printer = new LsInventoryPrinter();
        try {
            String fileName = "patch_info.log";
            patchLogFile = OPatchACL.invokeOLogger(printer, "getOutputFileNameForLsInvAllNodes", new Object[]{oracleHomePath, fileName}).toString();
            fileName = "checksum_info.log";
            checkSumLogFile = OPatchACL.invokeOLogger(printer, "getOutputFileNameForLsInvAllNodes", new Object[]{oracleHomePath, fileName}).toString();
        }
        catch (IllegalAccessException e2) {
            return;
        }
        File patchOutputFile = new File(patchLogFile);
        File checkSumOutputFile = new File(checkSumLogFile);
        boolean patchFileOk = true;
        boolean checkSumFileOk = true;
        patchOutputFile.delete();
        checkSumOutputFile.delete();
        try {
            patchFileOk = patchOutputFile.createNewFile();
            checkSumFileOk = checkSumOutputFile.createNewFile();
        }
        catch (IOException e3) {
            return;
        }
        try {
            infoLogFh = new FileHandler(patchLogFile);
            infoLogFh.setFormatter(new LsInventoryFileFormatter());
            infoLogFh.setLevel(Level.INFO);
            OPatchACL.invokeOLogger(printer, "addHandler", new Object[]{infoLogFh});
        }
        catch (Exception e4) {
            try {
                OPatchACL.invokeOLogger(printer, "rmHandler", new Object[]{infoLogFh});
            }
            catch (IllegalAccessException ii) {
                OLogger.printStackTrace(ii);
            }
            patchOutputFile.delete();
            return;
        }
        LsInventoryPrinter.printInstalledPatches("ORACLE_HOME", oneOffs, false, oracleHomePath);
        try {
            infoLogFh.setLevel(Level.OFF);
            infoLogFh.close();
            OPatchACL.invokeOLogger(printer, "rmHandler", new Object[]{infoLogFh});
            StringBuffer binaryLocation = new StringBuffer(oracleHomePath);
            binaryLocation.append(File.separator);
            binaryLocation.append(binary);
            binaryLocation.append(File.separator);
            binaryLocation.append(oracle);
            File binaryFile = new File(binaryLocation.toString());
            try {
                checkSumLogFh = new FileHandler(checkSumLogFile);
                checkSumLogFh.setFormatter(new LsInventoryFileFormatter());
                checkSumLogFh.setLevel(Level.INFO);
                OPatchACL.invokeOLogger(printer, "addHandler", new Object[]{checkSumLogFh});
            }
            catch (IOException e5) {
                OPatchACL.invokeOLogger(printer, "rmHandler", new Object[]{checkSumLogFh});
                checkSumOutputFile.delete();
                return;
            }
            if (!binaryFile.exists()) {
                OLogger.justlog(OLogger.INFO, "No binary information present here : " + binaryLocation.toString());
            } else {
                OPatchACL.invokeOLogger(printer, "setLogFileLevel", new Object[]{Level.OFF.intValue()});
                OLogger.justlog(Level.INFO.intValue(), binaryFile.length() + "\n");
            }
            String checkSum = "-1";
            try {
                if (binaryFile.exists()) {
                    checkSum = LsInventorySession.getCheckSum(binaryFile);
                }
            }
            catch (IOException e6) {
                checkSumOutputFile.delete();
            }
            OLogger.justlog(Level.INFO.intValue(), checkSum + "\n");
            OPatchACL.invokeOLogger(printer, "setLogFileLevel", new Object[]{Level.INFO.intValue()});
            checkSumLogFh.setLevel(Level.OFF);
            checkSumLogFh.close();
            OPatchACL.invokeOLogger(printer, "rmHandler", new Object[]{checkSumLogFh});
        }
        catch (IllegalAccessException e7) {
            OLogger.printStackTrace(e7);
        }
    }

    private static String getPortalInventoryStr(boolean detail) {
        String ptlConnect = OPatchEnv.getPtlConnect();
        String ptlSchema = OPatchEnv.getPtlSchema();
        String ptlPassword = OPatchEnv.getPtlPassword();
        if (ptlSchema == null || ptlSchema.equals("")) {
            return "";
        }
        if (ptlConnect == null || ptlConnect.equals("")) {
            return "";
        }
        if (ptlPassword == null || ptlPassword.equals("")) {
            return "";
        }
        StringBuffer buff = new StringBuffer("");
        StringBuffer runCmd = new StringBuffer();
        SystemCall.ExecReturn ret = null;
        String ptlPatchLoc = "";
        try {
            ptlPatchLoc = OPatchSessionHelper.getPtlToolLocation();
            runCmd.append(ptlPatchLoc);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            buff = new StringBuffer("\n'ptlpatch.csh' file could not be accessed to get portal repository");
            buff.append("\ninventory details. Please refer log file.");
            return buff.toString();
        }
        runCmd.append(" ");
        if (detail) {
            runCmd.append("-showlog");
        } else {
            runCmd.append("-show");
        }
        runCmd.append(" -s ");
        runCmd.append(ptlSchema);
        runCmd.append(" -p ");
        runCmd.append(ptlPassword);
        runCmd.append(" -c ");
        runCmd.append(ptlConnect);
        String runDir = portalAction.getRunDirectory(ptlPatchLoc);
        String[] cmd = new String[1];
        if (!OPatchEnv.isWindows()) {
            String cshLoc = portalAction.getCshLocation(ptlPatchLoc);
            cmd[0] = cshLoc + " " + runCmd.toString();
            ret = SystemCall.runtimeExec(cmd, runDir);
        } else {
            cmd[0] = "cmd /C \"" + runCmd.toString() + "\"";
            ret = SystemCall.runtimeExec(cmd, runDir);
        }
        if (!ret.isOK()) {
            buff = new StringBuffer("\nNot able to connect to Portal Repository. Please refer log file.");
            OLogger.printlnOnLog(OLogger.INFO, ret.getNormalMessage());
            OLogger.printlnOnLog(OLogger.INFO, ret.getErrorMessage());
            return buff.toString();
        }
        String patchInfo = ret.getNormalMessage();
        OLogger.printlnOnLog(OLogger.INFO, patchInfo);
        if (detail) {
            int index = patchInfo.indexOf("BugNum");
            if (index == -1) {
                buff = new StringBuffer("\nNot able to show Portal Repository details. Please refer log file.");
                return buff.toString();
            }
            int nextIndex = patchInfo.indexOf("BugNum", index + 1);
            if (nextIndex == -1) {
                buff = new StringBuffer("\nNot able to show Portal Repository details. Please refer log file.");
                return buff.toString();
            }
            String myInvDetail = patchInfo.substring(nextIndex);
            buff = new StringBuffer(OLogger.getString("OUI-67278"));
            buff.append("    ");
            buff.append(myInvDetail);
            return buff.toString();
        }
        boolean isPatch = false;
        String[] parts = patchInfo.split("\n");
        Pattern p2 = Pattern.compile("[0-9]+");
        Matcher m2 = null;
        buff = new StringBuffer(OLogger.getString("OUI-67276"));
        for (int i2 = 0; parts != null && i2 < parts.length; ++i2) {
            String x = parts[i2].trim();
            m2 = p2.matcher(x);
            if (!m2.matches()) continue;
            buff.append("\n");
            buff.append("   ");
            buff.append(x);
            isPatch = true;
        }
        if (!isPatch) {
            buff = new StringBuffer(OLogger.getString("OUI-67277"));
        }
        return buff.toString();
    }

    protected static void printTranslationPatches(String oracleHomePath, OneOffEntry[] installedOneOffs, OneOffEntry[] inactiveOneOffs) throws NullPointerException {
        int i2;
        StringBuffer buff = new StringBuffer("Call printTranslationPatches()");
        OLogger.debug(buff);
        if (installedOneOffs == null && inactiveOneOffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        Object[] oneoffs = new OneOffEntry[installedOneOffs.length + inactiveOneOffs.length];
        for (i2 = 0; i2 < installedOneOffs.length; ++i2) {
            oneoffs[i2] = installedOneOffs[i2];
        }
        for (i2 = 0; i2 < inactiveOneOffs.length; ++i2) {
            oneoffs[installedOneOffs.length + i2] = inactiveOneOffs[i2];
        }
        if (oneoffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        Arrays.sort(oneoffs);
        if (oneoffs.length == 0) {
            String noOneOff = OLogger.getString("OUI-67095");
            OLogger.println(noOneOff);
            return;
        }
        BaseTransReln[] btr = OPatchSessionHelper.getBaseTransRelationship(oracleHomePath, (OneOffEntry[])oneoffs);
        if (btr == null || btr.length == 0) {
            String noTransPatch = OLogger.getString("OUI-67642");
            OLogger.println(noTransPatch);
            return;
        }
        OLogger.println(OLogger.getString("OUI-67643"));
        int col1 = 17;
        int col2 = 23;
        int col3 = 8;
        int col4 = 12;
        int col5 = 10;
        int gapSize1 = 5;
        String gap1 = OPatchEnv.getSpaceString(gapSize1);
        int gapSize2 = 3;
        String gap2 = OPatchEnv.getSpaceString(gapSize2);
        int gapSize3 = 5;
        String gap3 = OPatchEnv.getSpaceString(gapSize3);
        int gapSize4 = 18;
        String gap4 = OPatchEnv.getSpaceString(gapSize4);
        buff = new StringBuffer("Translation Patch" + gap1 + "Unique Patch Identifier" + gap2 + "Language" + gap3 + "Installed at" + gap4 + "Base Patch");
        buff.append("\n-----------------" + gap1 + "-----------------------" + gap2 + "--------" + gap3 + "------------" + gap4 + "----------\n");
        OLogger.println(buff.toString());
        for (int i3 = 0; i3 < btr.length; ++i3) {
            buff = new StringBuffer();
            boolean transLength = false;
            boolean repLength = false;
            boolean baseLength = false;
            boolean lang = false;
            String transPatch = btr[i3].getTransPatch();
            String basePatch = btr[i3].getBasePatch();
            String language = btr[i3].getLanguage();
            String upi = btr[i3].getUPI();
            Date installedTime = btr[i3].getInstalledTime();
            buff.append(transPatch);
            int interGap = col1 + gapSize1 - transPatch.length();
            if (interGap > 0) {
                buff.append(OPatchEnv.getSpaceString(interGap));
            }
            if (upi == null || upi.equals("")) {
                upi = "n/a";
            }
            buff.append(upi);
            interGap = col2 + gapSize2 - upi.length();
            if (interGap > 0) {
                buff.append(OPatchEnv.getSpaceString(interGap));
            }
            buff.append(language);
            interGap = col3 + gapSize3 - language.length();
            if (interGap > 0) {
                buff.append(OPatchEnv.getSpaceString(interGap));
            }
            buff.append(installedTime);
            interGap = col4 + gapSize4 - installedTime.toString().length();
            if (interGap > 0) {
                buff.append(OPatchEnv.getSpaceString(interGap));
            }
            buff.append(basePatch);
            OLogger.println(buff.toString());
        }
    }

    protected static void printBugsFixedByPatches(String oracleHomePath, OneOffEntry[] oneoffs) throws NullPointerException {
        StringBuffer buff = new StringBuffer("Call printBugsFixedByPatches()");
        OLogger.debug(buff);
        if (oneoffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        Arrays.sort(oneoffs);
        if (oneoffs.length == 0) {
            String noOneOff = OLogger.getString("OUI-67095");
            OLogger.println(noOneOff);
            return;
        }
        OLogger.println(OLogger.getString("OUI-67606"));
        int gapSize1 = 8;
        String gap1 = OPatchEnv.getSpaceString(gapSize1);
        int gapSize2 = 2;
        String gap2 = OPatchEnv.getSpaceString(gapSize2);
        int gapSize3 = 19;
        String gap3 = OPatchEnv.getSpaceString(gapSize3);
        int col1 = 3;
        int col2 = 8;
        int col3 = 12;
        int col4 = 11;
        int maxDescSize = 50;
        buff = new StringBuffer("Bug" + gap1 + "Fixed by" + gap2 + "Installed at" + gap3 + "Description");
        buff.append("\n" + OPatchEnv.getSpaceString(3) + gap1 + " Patch " + " " + gap2 + OPatchEnv.getSpaceString(12) + gap3 + OPatchEnv.getSpaceString(11));
        buff.append("\n---" + gap1 + "--------" + gap2 + "------------" + gap3 + "-----------\n");
        OLogger.println(buff.toString());
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            int bugLength = 0;
            int patchLength = 0;
            int timeLength = 0;
            boolean descLength = false;
            int interGap = 0;
            buff = new StringBuffer();
            OneOffEntry entry = oneoffs[i2];
            String patchID = entry.getID();
            Date installedDate = entry.getAppliedDate();
            Object[] b2 = entry.getBugsFixed();
            Arrays.sort(b2);
            for (int j2 = 0; j2 < b2.length; ++j2) {
                buff = new StringBuffer();
                String bugNo = ((Bug)b2[j2]).getBugID();
                String desc = ((Bug)b2[j2]).getDesc();
                buff.append(bugNo);
                bugLength = bugNo.length();
                interGap = col1 + gapSize1 - bugLength;
                if (interGap > 0) {
                    buff.append(OPatchEnv.getSpaceString(interGap));
                }
                buff.append(patchID);
                patchLength = patchID.length();
                interGap = col2 + gapSize2 - patchLength;
                if (interGap > 0) {
                    buff.append(OPatchEnv.getSpaceString(interGap));
                }
                buff.append(installedDate);
                timeLength = installedDate.toString().length();
                interGap = col3 + gapSize3 - timeLength;
                if (interGap > 0) {
                    buff.append(OPatchEnv.getSpaceString(interGap));
                }
                int buffLength = buff.toString().length();
                int startIndex = 0;
                int endIndex = 0;
                String spaceStr = " ";
                desc = desc.replaceAll("\\s+", " ");
                while (desc.length() > maxDescSize) {
                    endIndex = desc.length() > startIndex + maxDescSize ? startIndex + maxDescSize : desc.length();
                    String sub = desc.substring(startIndex, endIndex);
                    String sub1 = "";
                    String sub2 = "";
                    int spaceIndex1 = -1;
                    int spaceIndex2 = -1;
                    spaceIndex1 = sub.lastIndexOf(spaceStr);
                    if (spaceIndex1 != -1) {
                        spaceIndex2 = desc.indexOf(spaceStr, spaceIndex1 + 1);
                    }
                    if (spaceIndex1 != -1 && spaceIndex2 != -1 && spaceIndex2 != endIndex - 1 && spaceIndex1 != endIndex + 1) {
                        sub1 = sub.substring(startIndex, spaceIndex1 + 1);
                        sub2 = sub.substring(spaceIndex1, endIndex);
                        sub = sub1;
                    }
                    buff.append(sub + "\n");
                    buff.append(OPatchEnv.getSpaceString(buffLength));
                    desc = desc.substring(startIndex += sub.length());
                    startIndex = 0;
                }
                buff.append(desc);
                OLogger.println(buff.toString());
            }
        }
    }

    protected static void printInstalledPatches(String oracleHomePath, OneOffEntry[] oneOffs, boolean detail, String OHPath) throws NullPointerException {
        StringBuffer buff = null;
        if (oneOffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        Arrays.sort(oneOffs);
        if (oneOffs.length == 0) {
            String noOneOff = OLogger.getString("OUI-67095");
            OLogger.println(noOneOff);
            buff = new StringBuffer("");
            if (detail) {
                ArrayList noIDs = new ArrayList();
                String notInstalledOnlineInfo = OPatchSessionHelper.getInstancesPatchedForRolledBackPatches(OPatchEnv.getOracleHome(), noIDs);
                buff.append(notInstalledOnlineInfo);
            }
            String noInvPortalInformation = LsInventoryPrinter.getPortalInventoryStr(detail);
            if (buff != null && !buff.toString().equals("") && noInvPortalInformation != null && !noInvPortalInformation.equals("")) {
                buff.append("\n");
            }
            buff.append(noInvPortalInformation);
            OLogger.println(buff.toString());
            return;
        }
        int actualLength = oneOffs.length;
        for (int i2 = 0; i2 < oneOffs.length; ++i2) {
            OneOffEntry currentEntry = oneOffs[i2];
            if (!currentEntry.getIsComposite() || currentEntry.getActiveConstituent().equals(currentEntry.getID())) continue;
            --actualLength;
        }
        Integer len = new Integer(actualLength);
        String noOneOff = OLogger.getString("OUI-67099", new Object[]{len});
        OLogger.println(noOneOff);
        String tmp = "";
        if (OPatchEnv.isGroupByDate()) {
            Date now = new Date(-1L);
            tmp = DateFormat.getInstance().format(now);
            StringTokenizer st = new StringTokenizer(tmp, " ");
            tmp = (String)st.nextElement();
        }
        HashMap compositeBugStorage = new HashMap();
        HashMap compositeFileStorage = new HashMap();
        HashMap<String, ArrayList<NameValuePair>> subPatchMap = new HashMap<String, ArrayList<NameValuePair>>();
        for (int i3 = 0; i3 < oneOffs.length; ++i3) {
            if (!oneOffs[i3].getIsComposite()) continue;
            String activeConstituent = "";
            activeConstituent = CompositePatchObject.getActiveConstituent(OHPath, oneOffs[i3].getID());
            if (oneOffs[i3].getID().equals(activeConstituent)) continue;
            ArrayList<NameValuePair> subPatches = (ArrayList<NameValuePair>)subPatchMap.get(activeConstituent);
            ArrayList<String[]> bugs = (ArrayList<String[]>)compositeBugStorage.get(activeConstituent);
            ArrayList<String[][]> files = (ArrayList<String[][]>)compositeFileStorage.get(activeConstituent);
            if (subPatches == null && bugs == null && files == null) {
                subPatches = new ArrayList<NameValuePair>();
                subPatchMap.put(activeConstituent, subPatches);
                bugs = new ArrayList<String[]>();
                compositeBugStorage.put(activeConstituent, bugs);
                files = new ArrayList<String[][]>();
                compositeFileStorage.put(activeConstituent, files);
            }
            subPatches.add(new NameValuePair(oneOffs[i3].getID(), oneOffs[i3].getPatchDesc()));
            subPatchMap.put(activeConstituent, subPatches);
            bugs.add(oneOffs[i3].getBugIDsFixed());
            compositeBugStorage.put(activeConstituent, bugs);
            files.add(oneOffs[i3].getFilesTouched(OHPath));
            compositeFileStorage.put(activeConstituent, files);
        }
        ArrayList<String> installedIDs = new ArrayList<String>();
        for (int i4 = 0; i4 < oneOffs.length; ++i4) {
            int fEntryLen;
            ArrayList arrayFileList;
            UpdateComponent[] uc;
            ArrayList listOfSubPatches;
            ArrayList arrayBugList;
            boolean isCompositeActive = oneOffs[i4].getID().equals(CompositePatchObject.getActiveConstituent(OHPath, oneOffs[i4].getTripletID()));
            if (oneOffs[i4].getIsComposite() && !isCompositeActive) continue;
            OneOffEntry entry = oneOffs[i4];
            String id = entry.getPatchID();
            String pse = entry.getPSENumber();
            String tpse = entry.getTmpPSENumber();
            Date appliedDate = entry.getAppliedDate();
            String[] bugsFixed = entry.getBugIDsFixed();
            String[] prereqPatches = entry.getPrereqPatchIDs();
            String[] overlayPatches = entry.getOverLayPatchIDs();
            String creationDate = entry.getCreationDate();
            boolean isTranslatable = entry.isTranslatable();
            String patchDescription = entry.getPatchDesc();
            if (oneOffs[i4].getIsComposite() && (arrayBugList = (ArrayList)compositeBugStorage.get(oneOffs[i4].getID())) != null) {
                HashSet<String> realBugList = new HashSet<String>();
                for (int j2 = 0; j2 < arrayBugList.size(); ++j2) {
                    String[] arrayBugs = (String[])arrayBugList.get(j2);
                    for (int k2 = 0; k2 < arrayBugs.length; ++k2) {
                        realBugList.add(arrayBugs[k2]);
                    }
                }
                String[] constituentBugs = new String[realBugList.size()];
                realBugList.toArray(constituentBugs);
                String[] oldBugsFixed = bugsFixed;
                for (int j3 = 0; j3 < oldBugsFixed.length; ++j3) {
                    realBugList.add(oldBugsFixed[j3]);
                }
                bugsFixed = new String[realBugList.size()];
                realBugList.toArray(bugsFixed);
            }
            installedIDs.add(id);
            if (OPatchEnv.isGroupByDate()) {
                String pString = DateFormat.getInstance().format(appliedDate);
                StringTokenizer st = new StringTokenizer(pString, " ");
                if (!tmp.equals(pString = (String)st.nextElement())) {
                    tmp = pString;
                    StringBuffer group = new StringBuffer("-------\n");
                    group.append("Applied on ");
                    group.append(tmp).append(":\n");
                    OLogger.println(group.toString());
                }
            }
            buff = new StringBuffer();
            if (entry.isMiniPatchSet()) {
                buff.append("Patch Set Update  ");
            } else if (entry.isOnlinePatch()) {
                buff.append("Patch (online) ");
            } else {
                buff.append("Patch  ");
            }
            buff.append(id);
            buff.append("");
            int patchIDLen = 20 - buff.length();
            char[] patches = new char[]{};
            if (patchIDLen > 0) {
                patches = new char[patchIDLen];
            }
            for (int j4 = 0; j4 < patches.length; ++j4) {
                patches[j4] = 32;
            }
            buff.append(patches);
            buff.append(": applied on ");
            buff.append(appliedDate);
            buff.append("\n");
            if (pse != null && !pse.equals("")) {
                buff.append("Unique Patch ID:");
                buff.append("  " + pse);
                buff.append("\n");
            }
            if (tpse != null && !tpse.equals("")) {
                StringBuffer logEntry = new StringBuffer("");
                logEntry.append("TUPI=" + tpse + "UPI=" + pse + "\n");
                OLogger.debug(logEntry);
            }
            if (patchDescription != null && !patchDescription.equals("")) {
                buff.append("Patch description:  ");
                buff.append("\"" + patchDescription + "\"");
                buff.append("\n");
            }
            buff.append("   Created on ");
            buff.append(creationDate);
            buff.append("\n");
            if (oneOffs[i4].getIsComposite() && isCompositeActive && (listOfSubPatches = (ArrayList)subPatchMap.get(oneOffs[i4].getID())) != null && listOfSubPatches.size() > 0) {
                String subPatchDesc = "";
                for (int z = 0; z < listOfSubPatches.size(); ++z) {
                    NameValuePair currentSubPatch = (NameValuePair)listOfSubPatches.get(z);
                    buff.append("Sub-patch  " + currentSubPatch.getAttributeName() + ";");
                    subPatchDesc = currentSubPatch.getAttributeValue();
                    if (subPatchDesc != null && !subPatchDesc.equals("")) {
                        buff.append(" \"" + subPatchDesc + "\"");
                    }
                    buff.append("\n");
                }
            }
            buff.append("   Bugs fixed:");
            StringBuffer bugEntry = null;
            for (int j5 = 0; j5 < bugsFixed.length; ++j5) {
                int len2;
                String bug = bugsFixed[j5];
                int n2 = len2 = bugEntry != null ? bugEntry.length() + 2 + 1 : 0;
                if ((len2 += bug.length()) > 80) {
                    buff.append(bugEntry.toString());
                    bugEntry = new StringBuffer("\n     ");
                    bugEntry.append(bug);
                    continue;
                }
                if (bugEntry == null) {
                    bugEntry = new StringBuffer();
                    bugEntry.append("\n     ");
                    bugEntry.append(bug);
                    continue;
                }
                bugEntry.append(", ");
                bugEntry.append(bug);
            }
            if (bugEntry != null) {
                buff.append(bugEntry.toString());
            }
            if (entry.couldBeTranslation()) {
                buff.append("\n   Language = " + entry.getPatchLanguage());
            }
            if (oneOffs[i4].getIsComposite() && isCompositeActive) {
                ArrayList listOfSubPatches2 = (ArrayList)subPatchMap.get(oneOffs[i4].getID());
                ArrayList<String> newOverlayPatches = new ArrayList<String>();
                for (int x = 0; x < overlayPatches.length; ++x) {
                    boolean subPatchExists = false;
                    for (int y = 0; y < listOfSubPatches2.size(); ++y) {
                        String currentSubPatch = ((NameValuePair)listOfSubPatches2.get(y)).getAttributeName();
                        if (!overlayPatches[x].equals(currentSubPatch)) continue;
                        subPatchExists = true;
                    }
                    if (subPatchExists) continue;
                    newOverlayPatches.add(overlayPatches[x]);
                }
                overlayPatches = new String[newOverlayPatches.size()];
                newOverlayPatches.toArray(overlayPatches);
                ArrayList<String> newPrereqPatches = new ArrayList<String>();
                for (int x = 0; x < prereqPatches.length; ++x) {
                    boolean subPatchExists = false;
                    for (int y = 0; y < listOfSubPatches2.size(); ++y) {
                        String currentSubPatch = ((NameValuePair)listOfSubPatches2.get(y)).getAttributeName();
                        if (!prereqPatches[x].equals(currentSubPatch)) continue;
                        subPatchExists = true;
                    }
                    if (subPatchExists) continue;
                    newPrereqPatches.add(prereqPatches[x]);
                }
                prereqPatches = new String[newPrereqPatches.size()];
                newPrereqPatches.toArray(prereqPatches);
            }
            if (overlayPatches != null && overlayPatches.length != 0) {
                buff.append("\n   This patch overlays patches:");
            }
            StringBuffer overlayEntry = null;
            for (int j6 = 0; j6 < overlayPatches.length; ++j6) {
                String nextOverlay;
                String overlay = overlayPatches[j6];
                int len3 = overlayEntry != null ? overlayEntry.length() + 2 + 1 : 0;
                String string = nextOverlay = j6 + 1 < overlayPatches.length ? overlayPatches[j6 + 1] : null;
                if (nextOverlay != null) {
                    len3 += nextOverlay.length();
                }
                if (len3 > 80) {
                    buff.append(overlayEntry.toString());
                    overlayEntry = new StringBuffer("\n     ");
                    overlayEntry.append(overlay);
                    continue;
                }
                if (overlayEntry == null) {
                    overlayEntry = new StringBuffer();
                    overlayEntry.append("\n     ");
                    overlayEntry.append(overlay);
                    continue;
                }
                overlayEntry.append(", ");
                overlayEntry.append(overlay);
            }
            if (overlayEntry != null) {
                buff.append(overlayEntry.toString());
            }
            if (prereqPatches != null && prereqPatches.length != 0) {
                buff.append("\n   This patch needs patches:");
            }
            StringBuffer prereqEntry = null;
            for (int j7 = 0; j7 < prereqPatches.length; ++j7) {
                String nextPrereq;
                String prereq = prereqPatches[j7];
                int len4 = prereqEntry != null ? prereqEntry.length() + 2 + 1 : 0;
                String string = nextPrereq = j7 + 1 < prereqPatches.length ? prereqPatches[j7 + 1] : null;
                if (nextPrereq != null) {
                    len4 += nextPrereq.length();
                }
                if (len4 > 80) {
                    buff.append(prereqEntry.toString());
                    prereqEntry = new StringBuffer("\n     ");
                    prereqEntry.append(prereq);
                    continue;
                }
                if (prereqEntry == null) {
                    prereqEntry = new StringBuffer();
                    prereqEntry.append("\n     ");
                    prereqEntry.append(prereq);
                    continue;
                }
                prereqEntry.append(", ");
                prereqEntry.append(prereq);
            }
            if (prereqEntry != null) {
                buff.append(prereqEntry.toString());
                buff.append("\n   as prerequisites");
            }
            if (entry.isMiniPatchSet() && detail && (uc = entry.getUpdateComps()) != null && uc.length != 0) {
                buff.append("\n");
                buff.append("   Components updated:");
                for (int k3 = 0; k3 < uc.length; ++k3) {
                    String compName = uc[k3].getCompName();
                    String fromVersion = uc[k3].getFromVersion();
                    String toVersion = uc[k3].getToVersion();
                    buff.append("\n");
                    buff.append("     ");
                    buff.append("\"" + compName + "\" from \"" + fromVersion + "\" to \"" + toVersion + "\"");
                }
            }
            if (entry.isTranslatable()) {
                buff.append("\n   Patch is translatable.");
            }
            String[][] filesTouched = entry.getFilesTouched(oracleHomePath);
            if (oneOffs[i4].getIsComposite() && (arrayFileList = (ArrayList)compositeFileStorage.get(oneOffs[i4].getID())) != null) {
                TreeMap<String, String[]> realFileMap = new TreeMap<String, String[]>();
                for (int j8 = 0; j8 < arrayFileList.size(); ++j8) {
                    String[][] arrayFiles = (String[][])arrayFileList.get(j8);
                    for (int k4 = 0; k4 < arrayFiles.length; ++k4) {
                        String key;
                        if (arrayFiles[k4].length != 2 || realFileMap.containsKey(key = arrayFiles[k4][0] + arrayFiles[k4][1])) continue;
                        realFileMap.put(key, arrayFiles[k4]);
                    }
                }
                String[][] oldFilesTouched = filesTouched;
                ArrayList filesTouchedList = new ArrayList(Arrays.asList(filesTouched));
                filesTouched = new String[realFileMap.size() + oldFilesTouched.length][2];
                int index = 0;
                for (index = 0; index < oldFilesTouched.length; ++index) {
                    for (int y = 0; y < 2; ++y) {
                        filesTouched[index][y] = oldFilesTouched[index][y];
                    }
                }
                Collection fileCollection = realFileMap.values();
                Iterator fileIterator = fileCollection.iterator();
                index = oldFilesTouched.length;
                while (fileIterator.hasNext()) {
                    filesTouched[index] = (String[])fileIterator.next();
                    ++index;
                }
            }
            int n3 = fEntryLen = filesTouched != null ? filesTouched.length : 0;
            if (fEntryLen == 0) {
                buff.append("\n * Warning: no filemap entries available.");
            } else if (detail) {
                String procList;
                buff.append("\n   Files Touched:");
                PatchAction[] pa = entry.getPatchActions();
                for (int iFileEntry = 0; iFileEntry < fEntryLen; ++iFileEntry) {
                    int fPathLen;
                    String[] eachPath = filesTouched[iFileEntry];
                    int n4 = fPathLen = eachPath != null ? eachPath.length : 0;
                    if (fPathLen != 2) continue;
                    String K1 = eachPath[0];
                    String K2 = eachPath[1];
                    String oldVer = "";
                    String newVer = "";
                    String diagStr = "";
                    for (int j9 = 0; j9 < pa.length; ++j9) {
                        int retVal;
                        if (!(pa[j9] instanceof CopyAction)) continue;
                        CopyAction ca = (CopyAction)pa[j9];
                        String P1 = ca.getSourceFile();
                        String P2 = ca.getParentFilePath(oracleHomePath);
                        if (!K1.equals(P1) || !K2.equals(P2) || (retVal = OPatchSessionHelper.isGreaterDecimal(newVer = ca.getFileVersion(), oldVer)) != 1) continue;
                        oldVer = newVer;
                        diagStr = ca.getFileDiagStr();
                    }
                    buff.append("\n     ");
                    buff.append(K1);
                    if (!oldVer.equals("")) {
                        buff.append(", version \"" + oldVer + "\"");
                    }
                    buff.append(" --> ");
                    buff.append(K2);
                    if (diagStr.equals("")) continue;
                    buff.append("\n     DiagnosticString = \"" + diagStr + "\"");
                }
                String[] sqlPath = entry.getExecutedSql(OPatchEnv.getOracleHome());
                if (sqlPath != null && sqlPath.length != 0) {
                    buff.append("\n   Sql scripts Executed:");
                    for (int j10 = 0; j10 < sqlPath.length; ++j10) {
                        buff.append("\n     ");
                        buff.append(sqlPath[j10]);
                    }
                }
                if ((procList = entry.getProceduresTouched(OPatchEnv.getOracleHome())) != null && !procList.equals("")) {
                    buff.append("\n   Sql Procedures Touched:");
                    buff.append("\n     ");
                    buff.append(procList);
                }
                if (entry.isOnlinePatch()) {
                    String sidList = OPatchSessionHelper.getInstancesPatched(OPatchEnv.getOracleHome(), entry.getID(), true, "");
                    buff.append("\n   Instances Patched:");
                    buff.append("\n     ");
                    buff.append(sidList);
                }
            }
            if (detail) {
                try {
                    ArrayList subPatches;
                    String oracleHome = OPatchEnv.getOracleHome();
                    String patchLocation = OPatchEnv.getPatchFilemapInfoLoc(oracleHome, entry.getTripletID());
                    if (entry.isMiniPatchSet()) {
                        buff.append("\n   Patch Set Update Location in Inventory:");
                    } else {
                        buff.append("\n   Patch Location in Inventory:");
                    }
                    buff.append("\n     ");
                    buff.append(patchLocation);
                    if (entry.getIsComposite() && isCompositeActive && (subPatches = (ArrayList)subPatchMap.get(entry.getID())) != null) {
                        for (int x = 0; x < subPatches.size(); ++x) {
                            NameValuePair currentSubPatch = (NameValuePair)subPatches.get(x);
                            buff.append("\n     ");
                            buff.append(OPatchEnv.getPatchFilemapInfoLoc(oracleHome, currentSubPatch.getAttributeName()));
                        }
                    }
                    String patchStorageLocation = OPatchEnv.getPatchStorageDirectoryPath(oracleHome, entry.getCookedPatchID());
                    if (entry.isMiniPatchSet()) {
                        buff.append("\n   Patch Set Update Location in Storage area:");
                    } else {
                        buff.append("\n   Patch Location in Storage area:");
                    }
                    buff.append("\n     ");
                    buff.append(patchStorageLocation);
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
            }
            buff.append("\n");
            OLogger.println(buff.toString());
        }
        buff = new StringBuffer();
        if (detail) {
            String notInstalledOnlineInfo = OPatchSessionHelper.getInstancesPatchedForRolledBackPatches(OPatchEnv.getOracleHome(), installedIDs);
            buff.append(notInstalledOnlineInfo);
        }
        String portalInformation = LsInventoryPrinter.getPortalInventoryStr(detail);
        buff.append(portalInformation);
        OLogger.println(buff.toString());
    }

    protected static void printInactivePatches(String oracleHomePath, OneOffEntry[] inactiveOneOffs, OneOffEntry[] installedOneOffs, boolean detail) throws NullPointerException {
        StringBuffer buff = null;
        if (inactiveOneOffs == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        Arrays.sort(inactiveOneOffs);
        if (inactiveOneOffs.length == 0) {
            String noOneOff = OLogger.getString("OUI-67635");
            OLogger.println(noOneOff);
            return;
        }
        Integer len = new Integer(inactiveOneOffs.length);
        String noOneOff = OLogger.getString("OUI-67636", new Object[]{len});
        OLogger.println(noOneOff);
        String tmp = "";
        if (OPatchEnv.isGroupByDate()) {
            Date now = new Date(-1L);
            tmp = DateFormat.getInstance().format(now);
            StringTokenizer st = new StringTokenizer(tmp, " ");
            tmp = (String)st.nextElement();
        }
        ArrayList<String> installedIDs = new ArrayList<String>();
        for (int i2 = 0; i2 < inactiveOneOffs.length; ++i2) {
            String[][] filesTouched;
            int fEntryLen;
            UpdateComponent[] uc;
            OneOffEntry entry = inactiveOneOffs[i2];
            String id = entry.getPatchID();
            String pse = entry.getPSENumber();
            Date appliedDate = entry.getAppliedDate();
            String[] bugsFixed = entry.getBugIDsFixed();
            String[] prereqPatches = entry.getPrereqPatchIDs();
            String[] overlayPatches = entry.getOverLayPatchIDs();
            String creationDate = entry.getCreationDate();
            boolean isTranslatable = entry.isTranslatable();
            String patchDescription = entry.getPatchDesc();
            installedIDs.add(id);
            if (OPatchEnv.isGroupByDate()) {
                String pString = DateFormat.getInstance().format(appliedDate);
                StringTokenizer st = new StringTokenizer(pString, " ");
                if (!tmp.equals(pString = (String)st.nextElement())) {
                    tmp = pString;
                    StringBuffer group = new StringBuffer("-------\n");
                    group.append("Applied on ");
                    group.append(tmp).append(":\n");
                    OLogger.println(group.toString());
                }
            }
            buff = new StringBuffer();
            if (entry.isMiniPatchSet()) {
                buff.append("Patch Set Update  ");
            } else if (entry.isOnlinePatch()) {
                buff.append("Patch (online) ");
            } else {
                buff.append("Patch  ");
            }
            buff.append(id);
            buff.append("");
            int patchIDLen = 20 - buff.length();
            char[] patches = new char[]{};
            if (patchIDLen > 0) {
                patches = new char[patchIDLen];
            }
            for (int j2 = 0; j2 < patches.length; ++j2) {
                patches[j2] = 32;
            }
            buff.append(patches);
            buff.append(": applied on ");
            buff.append(appliedDate);
            buff.append("\n");
            if (pse != null && !pse.equals("")) {
                buff.append("Unique Patch ID:");
                buff.append("  " + pse);
                buff.append("\n");
            }
            if (patchDescription != null && !patchDescription.equals("")) {
                buff.append("Patch description:  ");
                buff.append("\"" + patchDescription + "\"");
                buff.append("\n");
            }
            buff.append("   Created on ");
            buff.append(creationDate);
            buff.append("\n");
            buff.append("   Bugs fixed:");
            StringBuffer bugEntry = null;
            for (int j3 = 0; j3 < bugsFixed.length; ++j3) {
                String nextBug;
                String bug = bugsFixed[j3];
                int len2 = bugEntry != null ? bugEntry.length() + 2 + 1 : 0;
                String string = nextBug = j3 + 1 < bugsFixed.length ? bugsFixed[j3 + 1] : null;
                if (nextBug != null) {
                    len2 += nextBug.length();
                }
                if (len2 > 80) {
                    buff.append(bugEntry.toString());
                    bugEntry = new StringBuffer("\n     ");
                    bugEntry.append(bug);
                    continue;
                }
                if (bugEntry == null) {
                    bugEntry = new StringBuffer();
                    bugEntry.append("\n     ");
                    bugEntry.append(bug);
                    continue;
                }
                bugEntry.append(", ");
                bugEntry.append(bug);
            }
            if (bugEntry != null) {
                buff.append(bugEntry.toString());
            }
            if (entry.couldBeTranslation()) {
                buff.append("\n   Represented as \"" + entry.getID() + "\"");
            }
            if (overlayPatches != null && overlayPatches.length != 0) {
                buff.append("\n   This patch overlays patches:");
            }
            StringBuffer overlayEntry = null;
            for (int j4 = 0; j4 < overlayPatches.length; ++j4) {
                String nextOverlay;
                String overlay = overlayPatches[j4];
                int len3 = overlayEntry != null ? overlayEntry.length() + 2 + 1 : 0;
                String string = nextOverlay = j4 + 1 < overlayPatches.length ? overlayPatches[j4 + 1] : null;
                if (nextOverlay != null) {
                    len3 += nextOverlay.length();
                }
                if (len3 > 80) {
                    buff.append(overlayEntry.toString());
                    overlayEntry = new StringBuffer("\n     ");
                    overlayEntry.append(overlay);
                    continue;
                }
                if (overlayEntry == null) {
                    overlayEntry = new StringBuffer();
                    overlayEntry.append("\n     ");
                    overlayEntry.append(overlay);
                    continue;
                }
                overlayEntry.append(", ");
                overlayEntry.append(overlay);
            }
            if (overlayEntry != null) {
                buff.append(overlayEntry.toString());
            }
            if (prereqPatches != null && prereqPatches.length != 0) {
                buff.append("\n   This patch needs patches:");
            }
            StringBuffer prereqEntry = null;
            for (int j5 = 0; j5 < prereqPatches.length; ++j5) {
                String nextPrereq;
                String prereq = prereqPatches[j5];
                int len4 = prereqEntry != null ? prereqEntry.length() + 2 + 1 : 0;
                String string = nextPrereq = j5 + 1 < prereqPatches.length ? prereqPatches[j5 + 1] : null;
                if (nextPrereq != null) {
                    len4 += nextPrereq.length();
                }
                if (len4 > 80) {
                    buff.append(prereqEntry.toString());
                    prereqEntry = new StringBuffer("\n     ");
                    prereqEntry.append(prereq);
                    continue;
                }
                if (prereqEntry == null) {
                    prereqEntry = new StringBuffer();
                    prereqEntry.append("\n     ");
                    prereqEntry.append(prereq);
                    continue;
                }
                prereqEntry.append(", ");
                prereqEntry.append(prereq);
            }
            if (prereqEntry != null) {
                buff.append(prereqEntry.toString());
                buff.append("\n   as prerequisites");
            }
            if (entry.isMiniPatchSet() && detail && (uc = entry.getUpdateComps()) != null && uc.length != 0) {
                buff.append("\n");
                buff.append("   Components updated:");
                for (int k2 = 0; k2 < uc.length; ++k2) {
                    String compName = uc[k2].getCompName();
                    String fromVersion = uc[k2].getFromVersion();
                    String toVersion = uc[k2].getToVersion();
                    buff.append("\n");
                    buff.append("     ");
                    buff.append("\"" + compName + "\" from \"" + fromVersion + "\" to \"" + toVersion + "\"");
                }
            }
            if (entry.isTranslatable()) {
                buff.append("\n   Patch is translatable.");
            }
            if (detail) {
                try {
                    for (int j6 = 0; j6 < installedOneOffs.length; ++j6) {
                        String[] bugsInSuperset;
                        if (entry.equals(installedOneOffs[j6])) continue;
                        ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
                        OneOffEntry[] insPatch = new OneOffEntry[]{installedOneOffs[j6]};
                        String[] bugsInEntry = entry.getBugIDsFixed();
                        if (!conflictHandler.isBugSubset(insPatch, bugsInEntry, bugsInSuperset = new String[1])) continue;
                        String supersetPatch = installedOneOffs[j6].getPatchID();
                        buff.append("\n   This patch is superseded by the active patch ");
                        buff.append("\"" + supersetPatch + "\"");
                        buff.append("\n");
                        break;
                    }
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
            }
            int n2 = fEntryLen = (filesTouched = entry.getFilesTouched(oracleHomePath)) != null ? filesTouched.length : 0;
            if (fEntryLen == 0) {
                buff.append("\n * Warning: no filemap entries available.");
            } else if (detail) {
                String procList;
                buff.append("\n   Files Touched:");
                PatchAction[] pa = entry.getPatchActions();
                for (int iFileEntry = 0; iFileEntry < fEntryLen; ++iFileEntry) {
                    int fPathLen;
                    String[] eachPath = filesTouched[iFileEntry];
                    int n3 = fPathLen = eachPath != null ? eachPath.length : 0;
                    if (fPathLen != 2) continue;
                    String K1 = eachPath[0];
                    String K2 = eachPath[1];
                    String oldVer = "";
                    String newVer = "";
                    String diagStr = "";
                    for (int j7 = 0; j7 < pa.length; ++j7) {
                        int retVal;
                        if (!(pa[j7] instanceof CopyAction)) continue;
                        CopyAction ca = (CopyAction)pa[j7];
                        String P1 = ca.getSourceFile();
                        String P2 = ca.getParentFilePath(oracleHomePath);
                        if (!K1.equals(P1) || !K2.equals(P2) || (retVal = OPatchSessionHelper.isGreaterDecimal(newVer = ca.getFileVersion(), oldVer)) != 1) continue;
                        oldVer = newVer;
                        diagStr = ca.getFileDiagStr();
                    }
                    buff.append("\n     ");
                    buff.append(K1);
                    if (!oldVer.equals("")) {
                        buff.append(", version \"" + oldVer + "\"");
                    }
                    buff.append(" --> ");
                    buff.append(K2);
                    if (diagStr.equals("")) continue;
                    buff.append("\n     DiagnosticString = \"" + diagStr + "\"");
                }
                String[] sqlPath = entry.getExecutedSql(OPatchEnv.getOracleHome());
                if (sqlPath != null && sqlPath.length != 0) {
                    buff.append("\n   Sql scripts Executed:");
                    for (int j8 = 0; j8 < sqlPath.length; ++j8) {
                        buff.append("\n     ");
                        buff.append(sqlPath[j8]);
                    }
                }
                if ((procList = entry.getProceduresTouched(OPatchEnv.getOracleHome())) != null && !procList.equals("")) {
                    buff.append("\n   Sql Procedures Touched:");
                    buff.append("\n     ");
                    buff.append(procList);
                }
                if (entry.isOnlinePatch()) {
                    String sidList = OPatchSessionHelper.getInstancesPatched(OPatchEnv.getOracleHome(), entry.getID(), true, "");
                    buff.append("\n   Instances Patched:");
                    buff.append("\n     ");
                    buff.append(sidList);
                }
            }
            if (detail) {
                try {
                    String oracleHome = OPatchEnv.getOracleHome();
                    String patchLocation = OPatchEnv.getPatchFilemapInfoLoc(oracleHome, entry.getTripletID());
                    if (entry.isMiniPatchSet()) {
                        buff.append("\n   Patch Set Update Location in Inventory:");
                    } else {
                        buff.append("\n   Patch Location in Inventory:");
                    }
                    buff.append("\n     ");
                    buff.append(patchLocation);
                    String patchStorageLocation = OPatchEnv.getPatchStorageDirectoryPath(oracleHome, entry.getCookedPatchID());
                    if (entry.isMiniPatchSet()) {
                        buff.append("\n   Patch Set Update Location in Storage area:");
                    } else {
                        buff.append("\n   Patch Location in Storage area:");
                    }
                    buff.append("\n     ");
                    buff.append(patchStorageLocation);
                }
                catch (Exception e3) {
                    RuntimeException re = new RuntimeException(e3.getMessage());
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
            }
            buff.append("\n");
            OLogger.println(buff.toString());
        }
        buff = new StringBuffer();
        if (detail) {
            String notInstalledOnlineInfo = OPatchSessionHelper.getInstancesPatchedForRolledBackPatches(OPatchEnv.getOracleHome(), installedIDs);
            buff.append(notInstalledOnlineInfo);
        }
        String portalInformation = LsInventoryPrinter.getPortalInventoryStr(detail);
        buff.append(portalInformation);
        OLogger.println(buff.toString());
    }

    protected static void printInstalledComponents_ProdName_Version(InstalledComponent[] comps, String header) throws NullPointerException {
        LsInventoryPrinter.printInstalledComponents(header, comps, 1);
        Integer len = new Integer(comps.length);
        String total = OLogger.getString("OUI-67098", new Object[]{len});
        if (OPatchEnv.isNextGen()) {
            OLogger.printlnOnLog(total);
        } else {
            OLogger.println(total);
        }
    }

    protected static void printMatchedInstalledComponents_ProdID_Version_Name(String regexp, InstalledComponent[] comps) throws NullPointerException {
        Integer len = new Integer(comps.length);
        String header = OLogger.getString("OUI-67096", new Object[]{len, regexp});
        LsInventoryPrinter.printInstalledComponents(header, comps, 3);
    }

    protected static void printInstalledComponents_CompName_Version(InstalledComponent[] comps, String header) throws NullPointerException {
        Integer len = new Integer(comps.length);
        header = OLogger.getString("OUI-67130", new Object[]{len});
        LsInventoryPrinter.printInstalledComponents(header, comps, 2);
        String total = OLogger.getString("OUI-67098", new Object[]{len});
        if (OPatchEnv.isNextGen()) {
            OLogger.printlnOnLog(total);
        } else {
            OLogger.println(total);
        }
    }

    private static void printInstalledComponents(String header, InstalledComponent[] comps, int code) throws NullPointerException {
        StringBuffer buff = null;
        if (comps == null) {
            buff = new StringBuffer("Array of OneOffEntry is null");
            OLogger.debug(buff);
            throw new NullPointerException(buff.toString());
        }
        Arrays.sort(comps);
        buff = new StringBuffer(header);
        if (code == 1 && OPatchEnv.isNextGen()) {
            OLogger.printlnOnLog(header + "\n");
        } else {
            OLogger.println(header);
        }
        for (int i2 = 0; i2 < comps.length; ++i2) {
            int j2;
            int patchLen;
            InstalledComponent entry = comps[i2];
            String id = entry.getID();
            String name = entry.getName();
            String version = entry.getVersion();
            String desc = entry.getDesc();
            buff = null;
            int firstEntryLen = 0;
            if (code == 1) {
                int versionLen;
                buff = new StringBuffer(name);
                firstEntryLen = name.length();
                patchLen = 80 - firstEntryLen - (versionLen = version.length()) - 1;
                if (patchLen > 0) {
                    char[] chars = new char[patchLen];
                    for (j2 = 0; j2 < patchLen; ++j2) {
                        chars[j2] = 32;
                    }
                    buff.append(chars);
                }
                buff.append(version);
            } else if (code == 2) {
                int versionLen;
                buff = new StringBuffer(id);
                firstEntryLen = id.length();
                patchLen = 80 - firstEntryLen - (versionLen = version.length()) - 1;
                if (patchLen > 0) {
                    char[] chars = new char[patchLen];
                    for (j2 = 0; j2 < patchLen; ++j2) {
                        chars[j2] = 32;
                    }
                    buff.append(chars);
                }
                buff.append(version + "\n");
            } else if (code == 3) {
                buff = new StringBuffer(id);
                buff.append(" (");
                buff.append(name);
                buff.append(")");
                StringBuffer tmp = new StringBuffer(buff.toString());
                tmp.append(", ");
                tmp.append(version);
                int len = tmp.toString().length();
                if (len > 80) {
                    buff = tmp;
                } else {
                    int verLen;
                    firstEntryLen = buff.toString().length();
                    int patchLen2 = 80 - firstEntryLen - (verLen = version.length()) - 1;
                    if (patchLen2 > 0) {
                        char[] chars = new char[patchLen2];
                        for (int j3 = 0; j3 < patchLen2; ++j3) {
                            chars[j3] = 32;
                        }
                        buff.append(chars);
                    }
                    buff.append(version);
                }
            }
            if (code == 1 && OPatchEnv.isNextGen()) {
                OLogger.printlnOnLog(buff.toString() + "\n");
                continue;
            }
            OLogger.println(buff.toString());
        }
    }

    protected static void printListOfOracleHomes(OPatchSDK.OracleHome[] oracleHomes) {
        StringBuffer buff = new StringBuffer("List of Oracle Homes:\n");
        buff.append("  Name          Location\n");
        for (int i2 = 0; i2 < oracleHomes.length; ++i2) {
            OPatchSDK.OracleHome oracleHome = oracleHomes[i2];
            String name = oracleHome.getName();
            String loc = oracleHome.getLocation();
            buff.append("   ");
            buff.append(name);
            buff.append("         ");
            buff.append(loc);
            buff.append("\n");
        }
        OLogger.println(buff.toString());
    }

    protected static void printLocalMachineInfo(IIPMReadServices readServices) {
        StringBuffer buff = new StringBuffer("Local Machine Information::\n");
        String hostName = IPMUtil.getLocalHostName(true);
        if (hostName == null || "".equals(hostName)) {
            hostName = readServices.getLocalNode();
        }
        buff.append("Hostname: " + hostName);
        buff.append("\nARU platform id: " + readServices.getARUID());
        buff.append("\nARU platform description:: " + readServices.getARUIDDescription());
        buff.append("\n");
        OLogger.println(buff.toString());
    }

    public static void main(String[] args) {
        LsInventoryPrinter lsInventoryPrinter = new LsInventoryPrinter();
    }
}

