/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.opatchlogger.OLogger;

public class ChecksumEntity {
    private String completeFilePath = "";
    private String checksum = "-1";
    private String metadataPath = "";

    private ChecksumEntity() {
    }

    public ChecksumEntity(String metadataPath, String checksum) {
        try {
            this.metadataPath = metadataPath;
            this.completeFilePath = "";
            this.checksum = checksum;
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            this.checksum = "-1";
        }
    }

    protected String getMetaDataFilePath() {
        return this.metadataPath;
    }

    public String getComputeFilePath() {
        return this.completeFilePath;
    }

    protected void setComputeFilePath(String oracleHomePath) throws RuntimeException {
        try {
            StringBuffer buff = new StringBuffer(oracleHomePath);
            String filteredFilePath = PatchObjectUtil.filterString(this.metadataPath);
            if (buff.length() != 0) {
                buff.append(File.separator);
            }
            buff.append(filteredFilePath);
            this.completeFilePath = buff.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void setChecksum() throws RuntimeException {
        String path = this.getComputeFilePath();
        String chksum = "";
        try {
            chksum = OPatchSessionHelper.computeChecksum(path);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
        this.checksum = chksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("\n");
        buff.append("[Metadata Path = " + this.getMetaDataFilePath() + ",");
        buff.append("Complete File Path = " + this.getComputeFilePath() + ",");
        buff.append("Checksum value = " + this.getChecksum() + "]");
        return buff.toString();
    }
}

