/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.validator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.resource.ClientErrorCode;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.MachineInfo;

public class SchedulerAgentValidator
implements Validator {
    public static final Resource resource = Application.getInstance().getResource("oracle.install.ivw.client.resource.ClientErrorResID");
    public static Logger logger = Logger.getLogger(SchedulerAgentValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        ClientInstallSettings clientSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        SchedulerAgentValidator.validateSchedulerAgentHost(clientSettings.getSchAgtHost());
        SchedulerAgentValidator.validateSchedulerAgentPort(clientSettings.getSchAgtPort());
    }

    public static void validateSchedulerAgentHost(String hostname) throws ValidationException {
        if (hostname == null || hostname.length() == 0) {
            throw new ValidationException((ErrorCode)ClientErrorCode.INVALID_SCH_AGT_HOST, new Object[0]);
        }
        String badchars = " !@%^&*()+=\\|`~[{]};'\",<>/?#$:";
        String strBadCharsFound = null;
        strBadCharsFound = GenericValidation.validateBadCharGetString((String)badchars, (String)hostname);
        if (strBadCharsFound != null && !strBadCharsFound.equals("")) {
            throw new ValidationException((ErrorCode)ClientErrorCode.BAD_CHARS_IN_HOSTNAME, new Object[0]);
        }
        if (hostname.startsWith("localhost.") || hostname.equalsIgnoreCase("localhost") || hostname.equals("127.0.0.1")) {
            throw new ValidationException((ErrorCode)ClientErrorCode.LOCALHOST_LOOPBACK_IP_INVALID_INPUT, new Object[0]);
        }
        try {
            InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new ValidationException((ErrorCode)ClientErrorCode.SCH_AGT_HOST_NOT_REACHABLE, new Object[0]);
        }
        MachineInfo objMachine = MachineInfo.getInstance();
        if (!objMachine.isLocalHost(hostname)) {
            throw new ValidationException((ErrorCode)ClientErrorCode.HOST_NAME_DOES_NOT_MATCH, new Object[0]);
        }
    }

    public static void validateSchedulerAgentPort(Integer port) throws ValidationException {
        int portNumber = 0;
        if (port == null) {
            throw new ValidationException((ErrorCode)ClientErrorCode.INVALID_SCH_AGT_PORT, new Object[0]);
        }
        portNumber = port;
        if (portNumber < 1024 || portNumber > 65535) {
            throw new ValidationException((ErrorCode)ClientErrorCode.OUT_OF_RANGE_SCH_AGT_PORT, new Object[]{portNumber});
        }
        if (!MachineInfo.getInstance().isLocalPortAvailable(portNumber)) {
            throw new ValidationException((ErrorCode)ClientErrorCode.SCH_AGT_PORT_NOT_AVAILABLE, new Object[]{portNumber});
        }
    }
}

