/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster.range.generator;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.cluster.range.enums.NodeGeneratorType;
import oracle.install.library.util.cluster.range.generator.NodeGenerator;

public class NodeSequenceGenerator
extends NodeGenerator {
    private static final Logger logger = Logger.getLogger(NodeSequenceGenerator.class.getName());
    private String[] stringSequence;
    private int sequencePointer;

    public NodeSequenceGenerator(String[] generatorSequence) {
        this.stringSequence = generatorSequence;
        this.sequencePointer = 0;
        this.setGeneratorType(NodeGeneratorType.SEQUENCE);
        logger.log(Level.INFO, MessageFormat.format("NodeSequenceGenerator created for the sequence {0} with default iteration period.", Arrays.toString(this.stringSequence)));
    }

    public NodeSequenceGenerator(String[] generatorSequence, long period) {
        this(generatorSequence);
        this.setGeneratorPeriod(period);
        logger.log(Level.INFO, MessageFormat.format("NodeSequenceGenerator created for the sequence {0} with iteration period of {1}.", Arrays.toString(this.stringSequence), period));
    }

    @Override
    public void reset() {
        this.sequencePointer = 0;
        this.iterationCounter = 0L;
    }

    @Override
    public long getLength() {
        return this.stringSequence.length;
    }

    @Override
    public boolean hasNext() {
        return (long)this.sequencePointer < this.getLength();
    }

    public String next() {
        ++this.iterationCounter;
        if (this.iterationCounter == this.getGeneratorPeriod()) {
            this.iterationCounter = 0L;
            return this.stringSequence[this.sequencePointer++];
        }
        return this.stringSequence[this.sequencePointer];
    }

    @Override
    public void remove() {
    }
}

