/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.crs.CSSInfo;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.FileParser;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class InventoryInfo {
    private static final Logger logger = Logger.getLogger(InventoryInfo.class.getName());
    private static InventoryInfo instance = null;
    private static boolean s_bIsWindows = PlatformInfo.getInstance().isWindows();
    private static String errorHint = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)"INSTALL_COMMON_HINT_INVENTORY_ERROR"), new Object[0]);
    private OiipgBootstrap bootStrap = new OiipgBootstrap();
    public static final String XML_CONTENTS_DIR = "ContentsXML";
    private ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
    private String crsHome = null;
    public static final String ARCHITECTURE = "ARCHITECTURE";
    HashMap<String, String> agentHomeMap = null;

    protected InventoryInfo() {
    }

    public static InventoryInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (InventoryInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(InventoryInfo.class)) == null) {
            instance = new InventoryInfo();
        }
        return instance;
    }

    public String getDefaultInventoryLoc() {
        String invLoc = null;
        Handler[] handlers = logger.getHandlers();
        if (!OiiiInstallAreaControl.isCleanMachine()) {
            try {
                new OiipgPropertyLoader();
                invLoc = OiipgPropertyLoader.getLocationFileLoc();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "An exception occured while trying to locate existing inventory on the local machine\n" + e);
                e.printStackTrace();
            }
        } else {
            invLoc = new OiipgBootstrap().getDefaultLocationFileLoc();
            if (handlers != null && handlers.length > 0) {
                logger.log(Level.FINEST, "default inventory location calculated");
            }
        }
        if (handlers != null && handlers.length > 0) {
            logger.log(Level.INFO, "inventory location is" + invLoc);
        }
        return invLoc;
    }

    public String[] getOSGroups() {
        String[] osGroups = null;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        switch (curPlatGroup) {
            case -1: {
                osGroups = OiipgEnvironment.getUnixGroups();
            }
        }
        return osGroups;
    }

    public boolean isInventoryExist() {
        return !OiiiInstallAreaControl.isCleanMachine();
    }

    public String getOHNodes(String inputOH) throws InstallException {
        String nodeList = "";
        String invPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
        if (!s_bIsWindows) {
            invPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        }
        if (!s_bIsWindows && (invPtrLoc == null || invPtrLoc.trim().equalsIgnoreCase(""))) {
            return "";
        }
        OiicStandardInventorySession session = new OiicStandardInventorySession("invcloner", "10.2");
        try {
            session.initSession(2);
            OiiiInstallInventory inv = session.getInstallAreaControl().getInstallInventory();
            Vector homes = inv.getHomes();
            for (int i = 0; i < homes.size(); ++i) {
                OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
                String tempOH = homeInfo.getLocation();
                if (!tempOH.equalsIgnoreCase(inputOH)) continue;
                Vector nodes = homeInfo.getNodeList();
                for (int ii = 0; ii < nodes.size(); ++ii) {
                    nodeList = nodeList + (String)nodes.get(ii) + ",";
                }
                if (nodeList.length() > 0) {
                    nodeList = nodeList.substring(0, nodeList.length() - 1);
                }
                break;
            }
        }
        catch (OiiiInventoryDoesNotExistException e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_DOES_NOT_EXIST_ERROR, new Object[0]);
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_UNABLE_TO_LOAD_ERROR, new Object[0]);
        }
        finally {
            session.endSession();
        }
        return nodeList;
    }

    public List<String> getListOfOH(String component, String startVersion, String endVersion) throws InstallException {
        ArrayList<String> oracleHome = new ArrayList<String>();
        try {
            OiiiInstallInventory inv = this.getOUIInventory();
            if (inv != null) {
                Vector homes = inv.getHomes();
                for (int i = 0; i < homes.size(); ++i) {
                    OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
                    OiiiInstallCompInvEntry installCompInv = inv.findCompInRange(homeInfo.getIndex(), component, startVersion, endVersion);
                    if (installCompInv == null || installCompInv.getVersion() == null || Version.parseVersion((String)installCompInv.getVersion().toString()).compareTo(Version.parseVersion((String)startVersion)) < 0 || Version.parseVersion((String)installCompInv.getVersion().toString()).compareTo(Version.parseVersion((String)endVersion)) > 0) continue;
                    oracleHome.add(homeInfo.getLocation());
                }
            }
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_UNABLE_TO_LOAD_ERROR, new Object[0]);
        }
        return oracleHome;
    }

    public boolean isUnixGroupNeeded() {
        return this.bootStrap.isUnixGroupNeeded();
    }

    public String getUnixGroupName() {
        File f;
        String invPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        if (invPtrLoc == null || invPtrLoc.trim().equalsIgnoreCase("")) {
            logger.log(Level.INFO, "could not determine location of oraInst.loc. Will default to /etc/oraInst.loc");
            invPtrLoc = "/etc/oraInst.loc";
        }
        if (!(f = new File(invPtrLoc)).exists()) {
            logger.log(Level.INFO, "oraInst.loc does not exist");
            return "";
        }
        return this.getPropertyFromTextFile(f, "inst_group");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPropertyFromTextFile(File input, String key) {
        String val = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(input));
            String curLine = "";
            while ((curLine = br.readLine()) != null) {
                if ((curLine = curLine.replaceAll(" ", "")).startsWith("#") || curLine.indexOf(key) == -1) continue;
                val = curLine.substring(curLine.indexOf(key) + key.length() + 1);
                break;
            }
        }
        catch (Exception ex) {
            val = "";
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        return val;
    }

    public String getDefaultLocationFileLoc() {
        return this.bootStrap.getDefaultLocationFileLoc();
    }

    public boolean readPlatformFile(String location) {
        return OiiiInstallAreaControl.readPlatformFile((String)location);
    }

    public String getCurrentGroupOfUser(String user) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        switch (curPlatGroup) {
            case -1: {
                return OiixEnvironmentOps.ssgetCurrentGroupOfUserux((String)user);
            }
        }
        return null;
    }

    public String getCurrentActiveUserGroup(String user) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        switch (curPlatGroup) {
            case -1: {
                return OiixEnvironmentOps.ssgetCurrentActiveUserGroupux((String)user);
            }
        }
        return null;
    }

    public static void writePlatformFile(String input) throws IOException {
        OiiiInstallAreaControl.writePlatformFile((String)input);
    }

    public boolean validateInvLocForSetup(String location) {
        try {
            if (this.bootStrap == null) {
                this.bootStrap = new OiipgBootstrap();
            }
            return this.bootStrap.validateInvLocForSetup(location);
        }
        catch (OiiiInventoryException ex) {
            throw new RuntimeException(ex.getLocalizedMessage());
        }
    }

    public String getCRSHome() throws InstallException {
        if (this.crsHome == null) {
            this.crsHome = CRSInfo.getInstance().getCRSHome();
        }
        return this.crsHome;
    }

    public String getCRSNodes() throws InstallException {
        String crsNodes = "";
        try {
            String crsHome;
            if (CRSInfo.getInstance().isCRSConfigured() && (crsHome = this.getCRSHome()) != null && crsHome.length() > 0) {
                crsNodes = this.getOHNodes(crsHome);
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            logger.log(Level.INFO, "Exception while checking for isCRSConfigured", e);
        }
        return crsNodes;
    }

    public Version getProductVersion(String oracleHome) throws InstallException {
        OiiiInstallInventory inventory;
        Version version = null;
        if (oracleHome != null && (inventory = this.getOUIInventory()) != null) {
            OiiiOracleHomeInfo homeInfo = inventory.getHomeWithLocation(oracleHome);
            if (homeInfo != null) {
                OiiiCompInstallID component;
                Vector compVector = inventory.getTopLevelComps(homeInfo.getIndex());
                if (compVector != null && compVector.size() > 0 && compVector.get(0) instanceof OiiiCompInstallID && compVector.get(0) instanceof OiiiCompInstallID && (component = (OiiiCompInstallID)compVector.get(0)) != null) {
                    try {
                        version = Version.parseVersion((String)component.getVersion().toString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_HOME_NOT_FOUND_IN_INVENTORY, oracleHome);
            }
        }
        return version;
    }

    private OiiiInstallInventory getOUIInventory() {
        OiiiInstallInventory inventory = null;
        OiicStandardInventorySession session = null;
        String compName = "oracle.install";
        String invLoc = this.getDefaultInventoryLoc();
        if (invLoc != null && new File(invLoc).exists()) {
            try {
                session = new OiicStandardInventorySession(compName, InstallConstants.VERSION.toString());
                session.initSession(2);
                inventory = session.getInstallAreaControl().getInstallInventory();
            }
            catch (OiitTargetLockNotAvailableException oiitTargetLockNotAvailableException) {
            }
            catch (IOException iOException) {
            }
            catch (OiiiInventoryDoesNotExistException oiiiInventoryDoesNotExistException) {
                // empty catch block
            }
        }
        return inventory;
    }

    public String getToplevelComponentName(String oracleHome) {
        OiiiCompInstallID component;
        Vector compVector;
        OiiiOracleHomeInfo homeInfo;
        String componentName = "";
        OiiiInstallInventory inventory = this.getOUIInventory();
        if (inventory != null && (homeInfo = inventory.getHomeWithLocation(oracleHome)) != null && (compVector = inventory.getTopLevelComps(homeInfo.getIndex())) != null && compVector.size() > 0 && compVector.get(0) instanceof OiiiCompInstallID && compVector.get(0) instanceof OiiiCompInstallID && (component = (OiiiCompInstallID)compVector.get(0)) != null) {
            try {
                componentName = component.getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return componentName;
    }

    public String getOracleHomeForName(String homeName) {
        OiiiInstallInventory installInventory;
        String ret = null;
        OiiiInstallAreaControl installAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        if (installAreaControl != null && (installInventory = installAreaControl.getInstallInventory()) != null) {
            String ORACLE_HOME = null;
            OiiiOracleHomeInfo homeInf = installInventory.getHomeWithName(homeName);
            if (homeInf != null) {
                ORACLE_HOME = homeInf.getLocation();
            }
            return ORACLE_HOME;
        }
        return ret;
    }

    private static String pathify(String input) {
        String sep = File.separator;
        if (input.endsWith(sep)) {
            return input;
        }
        return input + sep;
    }

    public static String computeInventoryLocation(String oracleBase) {
        String defaultInvLocLocation = "";
        InventoryInfo inventoryInfo = InventoryInfo.getInstance();
        if (inventoryInfo.isInventoryExist()) {
            return inventoryInfo.getDefaultInventoryLoc();
        }
        if (PlatformInfo.getInstance().isWindows() || oracleBase == null || oracleBase.trim().length() == 0) {
            defaultInvLocLocation = inventoryInfo.getDefaultLocationFileLoc();
        } else {
            defaultInvLocLocation = InstallHelper.getValue("INVENTORY_LOCATION");
            if (defaultInvLocLocation == null || defaultInvLocLocation.equalsIgnoreCase("")) {
                File file = new File(oracleBase);
                defaultInvLocLocation = file != null && file.getParent() != null ? InventoryInfo.pathify(file.getParent()) + "oraInventory" : InventoryInfo.pathify(oracleBase) + "oraInventory";
            }
        }
        return defaultInvLocLocation;
    }

    public String getOracleHomeArchitecture(String oracleHome) {
        OiiiInstallInventory inv = this.getOUIInventory();
        if (inv != null && inv.getHomeWithLocation(oracleHome) != null) {
            return inv.getHomeWithLocation(oracleHome).getAdditionalOracleHomeProperty(ARCHITECTURE);
        }
        return null;
    }

    public String getPrimaryGroupOfUser(String username) {
        String str = this.getCurrentGroupOfUser(username);
        if (str != null && !str.equals("ErrorException")) {
            return str;
        }
        str = this.getCurrentActiveUserGroup(username);
        if (str != null && !str.equals("ErrorException")) {
            return str;
        }
        return null;
    }

    public String getDefaultOrainventoryGroup(boolean strictlyPrimaryOnly) {
        String defGroup = null;
        List<String> arrOsGroups = Arrays.asList(this.getOSGroups());
        if (!strictlyPrimaryOnly && arrOsGroups != null && arrOsGroups.contains("oinstall")) {
            return "oinstall";
        }
        defGroup = this.getPrimaryGroupOfUser(System.getProperty("user.name"));
        if (defGroup != null) {
            return defGroup;
        }
        if (arrOsGroups != null && arrOsGroups.size() > 0) {
            return arrOsGroups.get(0);
        }
        return defGroup;
    }

    public OiiiCompInstallID getTopLevelComp(String home, String compName) {
        OiiiInstallInventory instInv = this.getOUIInventory();
        OiiiOracleHomeInfo oHome = instInv.getHomeWithLocation(home);
        Vector v = instInv.getTopLevelComps(oHome.getIndex());
        OiiiCompInstallID oInstallComp = null;
        for (int i = 0; i < v.size(); ++i) {
            if (!((OiiiCompInstallID)v.get(i)).getName().equalsIgnoreCase(compName)) continue;
            oInstallComp = (OiiiCompInstallID)v.get(i);
            break;
        }
        return oInstallComp;
    }

    public Version getTopLevelCompVersion(String home, String compName) {
        OiiiCompInstallID oInstallComp = this.getTopLevelComp(home, compName);
        if (oInstallComp != null) {
            return Version.parseVersion((String)oInstallComp.getVersion().toString());
        }
        return null;
    }

    public Version getPatchCompVersion(String home, String compName) throws InstallException {
        OiiiInstallInventory instInv = this.getOUIInventory();
        OiiiInstallPatchInvEntry oPatchComp = null;
        if (instInv != null) {
            OiiiOracleHomeInfo oHome = instInv.getHomeWithLocation(home);
            if (oHome != null) {
                OiiiCompInstallID oInstallComp = this.getTopLevelComp(home, compName);
                if (oInstallComp != null) {
                    oPatchComp = instInv.getInstallCompInvEntry(oInstallComp, oHome.getIndex()).getPatchInvEntry();
                }
            } else {
                throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_HOME_NOT_FOUND_IN_INVENTORY, home);
            }
        }
        if (oPatchComp != null) {
            return Version.parseVersion((String)oPatchComp.getVersion().toString());
        }
        return null;
    }

    public boolean isBugFixAvailableInHome(String home, String sBugNumbersForOneOff) {
        OiiiInstallInventory instInv = this.getOUIInventory();
        OiiiOracleHomeInfo oHome = instInv.getHomeWithLocation(home);
        Vector vAllOneOffsinHome = instInv.getAllOneoffInvEntries(oHome.getIndex());
        for (int i = 0; i < vAllOneOffsinHome.size(); ++i) {
            Vector vBugsForOneOffs = ((OiiiInstallOneoffInvEntry)vAllOneOffsinHome.get(i)).getBugs();
            if (!vBugsForOneOffs.contains(sBugNumbersForOneOff)) continue;
            return true;
        }
        return false;
    }

    public boolean isHomeWithLocationExist(String homeLoc) {
        OiiiInstallInventory installInventory = this.getOUIInventory();
        return installInventory != null && installInventory.getHomeWithLocation(homeLoc) != null;
    }

    private boolean isAgentInstalledOnHome(String oracleHome) {
        boolean ret = false;
        String thisVer = "";
        try {
            Version version = this.getTopLevelCompVersion(oracleHome, "oracle.sysman.top.agent");
            thisVer = version == null ? "" : version.toString();
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "while getting em agent from oracle home: " + oracleHome + "exception is " + ex);
        }
        ret = thisVer.length() > 0;
        return ret;
    }

    public String getEMAgentForOH(String oracleHome) {
        File emdPropsFile;
        String retVal = "";
        if (!this.isAgentInstalledOnHome(oracleHome)) {
            return retVal;
        }
        String sep = File.separator;
        String emdProps = oracleHome + sep + "sysman" + sep + "config" + sep + "emd.properties";
        boolean cluster = this.isClusterHome(oracleHome);
        if (cluster) {
            String localHost = MachineInfo.getInstance().getFullHostName();
            String localNode = MachineInfo.getInstance().getLocalMachineName();
            if (localNode != null && localNode.length() > 0) {
                String emdPropsFile2 = oracleHome + sep + localNode + sep + "sysman" + sep + "config" + sep + "emd.properties";
                if (new File(emdPropsFile2).isFile()) {
                    emdProps = emdPropsFile2;
                } else if (localHost != null && localHost.length() > 0 && new File(emdPropsFile2 = oracleHome + sep + localHost + sep + "sysman" + sep + "config" + sep + "emd.properties").isFile()) {
                    emdProps = emdPropsFile2;
                }
            }
        }
        if ((emdPropsFile = new File(emdProps)).canRead() && emdPropsFile.isFile() && (retVal = FileParser.getPropertyFromTextFile(emdPropsFile, "REPOSITORY_URL")) != null && retVal.length() > 0) {
            return retVal;
        }
        return retVal;
    }

    public Map<String, String> getEMAgentsOnLocalNode() {
        if (this.agentHomeMap == null) {
            String[] oraHomeLocs = null;
            this.agentHomeMap = new HashMap();
            try {
                oraHomeLocs = OFAWrapper.getInstance().getAllOracleHomeLocs();
            }
            catch (InstallException ex) {
                logger.log(Level.INFO, "while getting em agents on system" + (Object)((Object)ex));
            }
            if (oraHomeLocs != null) {
                for (String home : oraHomeLocs) {
                    String agentFound = this.getEMAgentForOH(home);
                    if (agentFound == null || agentFound.length() <= 1) continue;
                    this.agentHomeMap.put(agentFound, home);
                }
            }
        }
        return this.agentHomeMap;
    }

    public List<String> getEMAgentHomes() {
        ArrayList<String> emHomes = new ArrayList<String>();
        String[] oraHomeLocs = null;
        try {
            oraHomeLocs = OFAWrapper.getInstance().getAllOracleHomeLocs();
        }
        catch (InstallException ex) {
            logger.log(Level.INFO, "while getting OH locations on system" + (Object)((Object)ex));
        }
        if (oraHomeLocs != null) {
            for (String home : oraHomeLocs) {
                if (!this.isAgentInstalledOnHome(home)) continue;
                emHomes.add(home);
            }
        }
        return emHomes;
    }

    public OiiiInstallCompInvEntry getCompInvEntryObj(String home, String comp) {
        if (home != null && comp != null) {
            OiiiInstallInventory insInv = this.getOUIInventory();
            int ohIndex = insInv.getHomeWithLocation(home).getIndex();
            OiiiCompInstallID cid = this.getComp(home, comp);
            return insInv.getInstallCompInvEntry(cid, ohIndex);
        }
        return null;
    }

    public OiiiCompInstallID getComp(String home, String compName) {
        if (home != null && compName != null) {
            OiiiInstallInventory instInv = this.getOUIInventory();
            OiiiOracleHomeInfo oHome = instInv.getHomeWithLocation(home);
            Vector v = instInv.getAllCompsVect(oHome.getIndex());
            OiiiCompInstallID oInstallComp = null;
            for (int i = 0; i < v.size(); ++i) {
                OiiiCompInstallID comp = ((OiiiInstallCompInvEntry)v.get(i)).getCompInstallID();
                if (!comp.getName().equalsIgnoreCase(compName)) continue;
                oInstallComp = comp;
                break;
            }
            return oInstallComp;
        }
        return null;
    }

    public int getHomeIndex(String home) {
        if (home != null && home.trim().length() > 0) {
            OiiiOracleHomeInfo homeInfo = this.getOUIInventory().getHomeWithLocation(home);
            if (homeInfo != null) {
                return homeInfo.getIndex();
            }
            return -1;
        }
        return -1;
    }

    public List<String> getNodeList(String home) {
        OiiiInstallInventory instInv;
        OiiiOracleHomeInfo oHome;
        Vector nodes;
        ArrayList<String> nodeList = null;
        if (home != null && this.isHomeWithLocationExist(home) && (nodes = (oHome = (instInv = this.getOUIInventory()).getHomeWithLocation(home)).getNodeList()) != null) {
            nodeList = new ArrayList<String>();
            for (Object node : nodes) {
                nodeList.add(node.toString());
            }
        }
        return nodeList;
    }

    private boolean isClusterHome(String home) {
        OiiiInstallInventory instInv = this.getOUIInventory();
        OiiiOracleHomeInfo oracleHomeInfo = null;
        if (instInv != null) {
            oracleHomeInfo = instInv.getHomeWithLocation(home);
        }
        if (oracleHomeInfo == null) {
            return false;
        }
        Vector nodeList = oracleHomeInfo.getNodeList();
        return nodeList != null && nodeList.size() != 0;
    }

    public String getEligibleHomeToExecuteKFOD() {
        return this.getEligibleHomeToExecuteKFOD("0.0.0.0.0", InstallConstants.VERSION.toString());
    }

    public String getEligibleHomeToExecuteKFOD(String startVersion, String endVersion) {
        String eligibleHome;
        block3: {
            eligibleHome = null;
            try {
                String strCSSVersion;
                List<String> homes = this.getListOfOH("oracle.rdbms", startVersion, endVersion);
                if (homes == null || homes.size() <= 0 || (strCSSVersion = CSSInfo.getCSSVersion()) == null || strCSSVersion.trim().length() <= 0) break block3;
                Version cssVersion = Version.parseVersion((String)strCSSVersion);
                for (String home : homes) {
                    Version homeVersion = this.getCompVersion("oracle.rdbms", home);
                    if (homeVersion.compareTo(cssVersion, 4) != 0) continue;
                    eligibleHome = home;
                    break;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "exception occured while getting elegible home to execute kfod.");
            }
        }
        return eligibleHome;
    }

    public Version getCompVersion(String component, String home) {
        Vector v;
        OiiiInstallInventory instInv = this.getOUIInventory();
        OiiiOracleHomeInfo oHome = instInv.getHomeWithLocation(home);
        if (oHome != null && (v = instInv.getCompInvEntries(component, oHome.getIndex())) != null && v.size() > 0) {
            return Version.parseVersion((String)((OiiiCompInvEntry)v.get(v.size() - 1)).getVersion().toString());
        }
        return null;
    }

    public String[] getUpgradableHomesByTopLevel(String firstVersion, String currentVersion, String topLevel) {
        List<String> allHomes = null;
        ArrayList<String> homes = null;
        try {
            allHomes = this.getListOfOH(topLevel, firstVersion, currentVersion);
        }
        catch (InstallException e) {
            e.printStackTrace();
        }
        OiiiInstallInventory instInv = this.getOUIInventory();
        if (allHomes != null && !allHomes.isEmpty()) {
            homes = new ArrayList<String>(allHomes);
            for (String home : allHomes) {
                OiiiOracleHomeInfo homeInfo = instInv.getHomeWithLocation(home);
                Vector v = instInv.getTopLevelComps(homeInfo.getIndex());
                for (int i = 0; i < v.size(); ++i) {
                    try {
                        if (((OiiiCompInstallID)v.get(i)).getName().equalsIgnoreCase(topLevel) && !this.getProductVersion(home).toString().equalsIgnoreCase(currentVersion)) continue;
                        homes.remove(home);
                        break;
                    }
                    catch (InstallException e) {
                        logger.log(Level.WARNING, "Oracle home value is not found in Oracle Inventory. Reason: ", (Throwable)((Object)e));
                        logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)((Object)e)));
                    }
                }
                if (!homes.isEmpty()) continue;
                break;
            }
        }
        if (homes != null && !homes.isEmpty()) {
            return homes.toArray(new String[0]);
        }
        return null;
    }

    public String[] getAllCompsForHome(String home) {
        OiiiInstallInventory instInv;
        OiiiOracleHomeInfo oHome;
        if (home != null && (oHome = (instInv = this.getOUIInventory()).getHomeWithLocation(home)) != null) {
            Vector v = instInv.getAllCompsVect(oHome.getIndex());
            Vector<String> list = new Vector<String>();
            for (int i = 0; i < v.size(); ++i) {
                OiiiCompInstallID comp = ((OiiiInstallCompInvEntry)v.get(i)).getCompInstallID();
                list.add(comp.getName());
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    public String getComponentInstallType(String home, String comp) {
        if (home != null && this.getHomeIndex(home) != -1) {
            OiiiInstallCompInvEntry icie = this.getCompInvEntryObj(home, comp);
            return icie.getDepInfo().getDepModeName();
        }
        return null;
    }

    public String[] getComponentInstallTypes(String home, String comp) {
        OiiiInstallCompInvEntry icie;
        if (home != null && this.getHomeIndex(home) != -1 && (icie = this.getCompInvEntryObj(home, comp)) != null) {
            return icie.getDepInfo().getDepModeNames();
        }
        return null;
    }

    public String[] getAllHomes() throws InstallException {
        String[] allHomes = null;
        try {
            OiiiInstallInventory inv = this.getOUIInventory();
            if (inv != null) {
                Vector<String> homeLocs = new Vector<String>();
                Vector homes = inv.getHomes();
                if (homes != null && homes.size() > 0) {
                    for (int i = 0; i < homes.size(); ++i) {
                        OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
                        homeLocs.add(homeInfo.getLocation());
                    }
                    allHomes = homeLocs.toArray(new String[0]);
                }
            }
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_UNABLE_TO_LOAD_ERROR, new Object[0]);
        }
        return allHomes;
    }

    public boolean isHomeOfType(String oracleHome, String component, String installType) {
        String[] types = this.getComponentInstallTypes(oracleHome, component);
        boolean isHomeOfInstallType = false;
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals(installType)) continue;
                isHomeOfInstallType = true;
                break;
            }
        }
        return isHomeOfInstallType;
    }
}

