/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.AvailableSpaceInfo;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.SpaceResultSet;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.message.Content;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.library.asm.ACFSUtil;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.install.library.util.cvu.CVUValidationException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixGeneralQueries;

public class FileSystemInfo {
    private static FileSystemInfo instance = null;
    private static Logger logger = Logger.getLogger(FileSystemInfo.class.getName());
    private String localNode = null;

    protected FileSystemInfo() {
    }

    public static FileSystemInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (FileSystemInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(FileSystemInfo.class)) == null) {
            instance = new FileSystemInfo();
        }
        return instance;
    }

    public boolean isLocationOnACFS(String mountPoint) throws InstallException {
        return ACFSUtil.getInstance().isPathOnACFS(mountPoint);
    }

    public boolean isLocationOnCFS(String oraclehome, List<String> nodeList) throws InstallException {
        if (this.localNode == null) {
            for (String node : nodeList) {
                if (!MachineInfo.getInstance().isLocalHost(node)) continue;
                this.localNode = node;
                break;
            }
        }
        if (this.localNode == null) {
            throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TO_CHECK_WHETHER_OH_ON_CFS, new Object[0]);
        }
        String[] nodeListArray = new String[nodeList.size()];
        nodeList.toArray(nodeListArray);
        try {
            if (Cluster.isSharedPath((String)oraclehome, (String[])nodeListArray, (String)this.localNode)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TO_CHECK_WHETHER_OH_ON_CFS, new Object[0]);
        }
        return false;
    }

    public Integer getFreeSpace(String localDirPath, Boolean val) {
        logger.log(Level.FINEST, "The free space of " + localDirPath + " location is: " + OiixGeneralQueries.getFreeSpaceux((String)localDirPath, (Boolean)val));
        return OiixGeneralQueries.getFreeSpaceux((String)localDirPath, (Boolean)val);
    }

    public boolean isDirWritable(String dirPath) {
        return OiixFunctionOps.writablePath((String)dirPath);
    }

    public ErrorMessage checkFreeDiskSpace(String[] nodes, String path, long requiredSizeInMegaBytes) {
        if (!DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.checkSpaceAvailability")) {
            return null;
        }
        SpaceResultSet cvuResult = null;
        try {
            cvuResult = CVUHelper.getInstance().getAvailableSpace(nodes, path, false);
        }
        catch (Exception e) {
            return new ValidationStatusMessage((Throwable)new UnhandledDriverException((Throwable)e, (ErrorCode)CommonErrorCode.FREE_SPACE_CHECK_FAILED, new Object[0]));
        }
        if (cvuResult == null) {
            return new ValidationStatusMessage((Throwable)new UnhandledDriverException((ErrorCode)CommonErrorCode.FREE_SPACE_CHECK_FAILED, new Object[0]));
        }
        if (cvuResult.getOverallStatus() == OverallStatus.OPERATION_FAILED) {
            logger.log(Level.WARNING, "ClusterVerification::checkFreeDiskSpace returned OPERATION_FAILED");
            return new ValidationStatusMessage((Throwable)new UnhandledDriverException((Content)UnhandledDriverException.createExtraDetails((VerificationResultSet)cvuResult), (ErrorCode)CommonErrorCode.FREE_SPACE_CHECK_FAILED, new Object[0]));
        }
        ArrayList<String> failedNodes = new ArrayList<String>();
        for (String node : nodes) {
            AvailableSpaceInfo availableSpaceInfo = cvuResult.getAvailbleSpace(node);
            if (availableSpaceInfo != null) {
                Double availableSpace = availableSpaceInfo.getAvailableSpace(StorageUnit.MBYTE);
                if (!(availableSpace < (double)requiredSizeInMegaBytes)) continue;
                failedNodes.add(node);
                continue;
            }
            failedNodes.add(node);
        }
        if (failedNodes.size() > 0) {
            return new ValidationStatusMessage((Throwable)((Object)new CVUValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INSUFFICIENT_SPACE_AVAILABLE_ERR, path, failedNodes, requiredSizeInMegaBytes)));
        }
        return null;
    }

    public String getLongestValidPathAcrossNodes(String[] nodes, String path) throws Exception, ClusterException {
        if (nodes == null || path == null || nodes.length == 0 || path.trim().length() == 0) {
            throw new Exception();
        }
        ClusterCmd cCmdObj = new ClusterCmd();
        ArrayList<String> listOfValidPathOnEachNode = new ArrayList<String>(nodes.length);
        int i = 0;
        for (String node : nodes) {
            File fileObj = new File(path);
            boolean dirExist = false;
            while (!dirExist) {
                try {
                    dirExist = cCmdObj.dirExists(node, fileObj.getPath());
                }
                catch (ClusterException e) {
                    logger.log(Level.WARNING, "ClusterException occurred while checking whether directory exits or not for path:" + fileObj.getPath());
                    dirExist = false;
                }
                if (!dirExist) {
                    fileObj = fileObj.getParentFile();
                }
                if (fileObj != null && fileObj.getPath().length() != 0) continue;
                throw new Exception();
            }
            boolean dirWritable = false;
            try {
                dirWritable = cCmdObj.isDirWritable(node, fileObj.getPath());
            }
            catch (ClusterException e) {
                logger.log(Level.WARNING, "ClusterException occurred while checking whether the directory is writable or not for path:" + fileObj.getPath());
                dirWritable = false;
            }
            if (!dirWritable) {
                throw new Exception();
            }
            listOfValidPathOnEachNode.add(i, fileObj.getPath());
            ++i;
        }
        String shortestPath = (String)listOfValidPathOnEachNode.get(0);
        for (i = 1; i < listOfValidPathOnEachNode.size(); ++i) {
            if (((String)listOfValidPathOnEachNode.get(i)).length() >= shortestPath.length()) continue;
            shortestPath = (String)listOfValidPathOnEachNode.get(i);
        }
        return shortestPath;
    }

    public String getLocationWithMaxFreespace(List<String> locs) {
        int i;
        String selectedLoc = null;
        long maxMBSizeTillNow = 0L;
        ArrayList<String> listOfValidPaths = new ArrayList<String>();
        for (i = 0; i < locs.size(); ++i) {
            if (locs.get(i) == null || locs.get(i).trim().length() <= 0) continue;
            listOfValidPaths.add(locs.get(i));
        }
        if (listOfValidPaths.size() > 0) {
            selectedLoc = locs.get(0);
            maxMBSizeTillNow = this.getFreeSpace(selectedLoc, true).intValue();
            for (i = 1; i < listOfValidPaths.size(); ++i) {
                long sizeval = this.getFreeSpace((String)listOfValidPaths.get(i), true).intValue();
                if (sizeval <= maxMBSizeTillNow) continue;
                selectedLoc = (String)listOfValidPaths.get(i);
                maxMBSizeTillNow = sizeval;
            }
        }
        return selectedLoc;
    }

    public void checkReadAndExecuteLocal(String inventoryLocation) throws ValidationException {
        File f = new File(inventoryLocation);
        String inventoryParentLocal = null;
        if (f.exists()) {
            inventoryParentLocal = f.getParent();
        }
        while (inventoryParentLocal != null && !inventoryParentLocal.equals("/")) {
            File fP = new File(inventoryParentLocal);
            if (!fP.exists()) {
                throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_LOCAL_INVENTORY_LOC_PERMISSION_ERR, new Object[]{inventoryParentLocal});
            }
            inventoryParentLocal = fP.getParent();
        }
    }

    public void checkReadAndExecuteRemote(String inventoryLocation, List<String> remoteNodes) throws ValidationException {
        File f = new File(inventoryLocation);
        String inventoryParentRemote = null;
        if (f.exists()) {
            inventoryParentRemote = f.getParent();
        }
        while (inventoryParentRemote != null && !inventoryParentRemote.equals("/")) {
            File fP = new File(inventoryParentRemote);
            ClusterCmd clusterCmd = new ClusterCmd();
            String[] remoteNodesArray = new String[remoteNodes.size()];
            remoteNodes.toArray(remoteNodesArray);
            try {
                if (!clusterCmd.dirExists(remoteNodesArray, inventoryParentRemote)) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_REMOTE_INVENTORY_LOC_PERMISSION_ERR, new Object[]{inventoryParentRemote, remoteNodes.toString()});
                }
            }
            catch (ClusterOperationException e) {
                System.out.println("Exception while checking read and execute permission on all parent directories of inventory location");
            }
            catch (ClusterException e) {
                System.out.println("Exception while checking read and execute permission on all parent directories of inventory location");
            }
            inventoryParentRemote = fP.getParent();
        }
    }
}

