/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.UncheckedException;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.PlatformInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixFileOps;

public class FileInfo {
    private static final Logger logger = Logger.getLogger(FileInfo.class.getName());
    private OiipgFileSystem fileSystem = new OiipgFileSystem();
    private static FileInfo instance;

    protected FileInfo() {
    }

    public static FileInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (FileInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(FileInfo.class)) == null) {
            instance = new FileInfo();
        }
        return instance;
    }

    public boolean areLocsSame(String sNatUserHomeLoc, String sNatLoc) {
        return this.fileSystem.areLocsSame(sNatUserHomeLoc, sNatLoc);
    }

    public boolean isRemoteDirWriatble(String node, String dir) {
        try {
            ClusterCmd cc = new ClusterCmd();
            return cc.isDirWritable(node, dir);
        }
        catch (ClusterException ce) {
            ce.printStackTrace();
            logger.severe("occured while checking permissions for " + dir + "on host " + node);
            return false;
        }
    }

    public boolean doesRemoteDirExist(String node, String dir) {
        try {
            ClusterCmd cc = new ClusterCmd();
            return cc.dirExists(node, dir);
        }
        catch (RemoteDirException re) {
            logger.log(Level.WARNING, String.format("Failed while checking for %s directory existance on remote node %s using SRVM API.", dir, node), re);
            throw new UncheckedException((Throwable)re, (ErrorCode)CommonErrorCode.UNEXPECTED_REMOTE_DIR_CHECK_FAILURE, new Object[]{dir, node});
        }
    }

    public boolean doesRemoteFileExists(String node, String file) {
        ClusterCmd cc = new ClusterCmd();
        try {
            return cc.fileExists(node, file);
        }
        catch (ClusterException e) {
            logger.log(Level.SEVERE, "Could not check if file " + file + " exists in node " + node, e);
            return false;
        }
    }

    public boolean isRemoteDirEmpty(String node, String location) {
        if (node != null && location != null) {
            ClusterCmd cc = new ClusterCmd();
            try {
                String[] fileList;
                if (cc.dirExists(node, location) && !(fileList = cc.listDirectory(node, location)).equals(null) && fileList.length != 0) {
                    return false;
                }
            }
            catch (RemoteDirException re) {
                logger.log(Level.WARNING, String.format("Failed while checking for %s directory existance on remote node %s using SRVM API.", location, node), re);
                throw new UncheckedException((Throwable)re, (ErrorCode)CommonErrorCode.UNEXPECTED_REMOTE_DIR_CHECK_FAILURE, new Object[]{location, node});
            }
            catch (ClusterException re) {
                logger.log(Level.WARNING, String.format("Failed while checking for %s directory existance on remote node %s using SRVM API.", location, node), re);
                throw new UncheckedException((Throwable)re, (ErrorCode)CommonErrorCode.UNEXPECTED_REMOTE_DIR_CHECK_FAILURE, new Object[]{location, node});
            }
            return true;
        }
        return false;
    }

    public List<String> checkRemoteNodesEmptyDirs(List<String> nodeLists, String location) {
        if (nodeLists != null && !nodeLists.isEmpty() && location != null) {
            ArrayList<String> nodesWithNonEmptyDirs = new ArrayList<String>();
            for (String s : nodeLists) {
                if (this.isRemoteDirEmpty(s, location)) continue;
                nodesWithNonEmptyDirs.add(s);
            }
            return nodesWithNonEmptyDirs;
        }
        return null;
    }

    public static String getLastExistingParent(String inputPath) {
        if (inputPath != null) {
            logger.info("Getting the last existing parent of: " + inputPath);
            String lastExistingParent = FileInfo._getLastExistingParent(inputPath);
            if (lastExistingParent == null) {
                logger.warning("Could not get the last existing parent of: " + inputPath);
            } else {
                logger.info("Last existing parent: " + lastExistingParent);
            }
            return lastExistingParent;
        }
        logger.warning("Cannot get the last existing parent of a null path");
        return null;
    }

    private static String _getLastExistingParent(String inputPath) {
        if (inputPath != null) {
            logger.info("Path: " + inputPath);
            File f = new File(inputPath);
            if (f.exists() && f.isDirectory()) {
                return inputPath;
            }
            String parent = f.getParent();
            if (parent != null) {
                logger.info("Parent: " + parent);
                return FileInfo._getLastExistingParent(parent);
            }
            logger.warning("Parent is null");
            return null;
        }
        logger.warning("Path is null.");
        return null;
    }

    public String getLastExistingRemoteParent(String node, String location) {
        boolean fileExists = false;
        String dirToCheck = location;
        File file = new File(dirToCheck);
        while (!fileExists) {
            fileExists = this.doesRemoteDirExist(node, dirToCheck);
            file = new File(dirToCheck);
            if (fileExists) continue;
            if (file.getParent() == null) break;
            dirToCheck = file.getParent();
        }
        return dirToCheck;
    }

    public int changeGroup(String loc, String group) {
        int retCode = OiixFileOps.changeGroup((String)loc, (String)group);
        return retCode;
    }

    public int changePermission(File file, String permissions, boolean recursive) throws InstallException {
        if (!file.exists()) {
            throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_FILE_DOESNOT_EXIST, file.getAbsolutePath());
        }
        int retCode = OiixFileOps.changePermissions((String)file.getAbsolutePath(), (String)permissions);
        if (retCode == 0 && recursive && file.isDirectory()) {
            File childFile;
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n && (retCode = this.changePermission(childFile = fileArray[i], permissions, recursive)) == 0; ++i) {
            }
        }
        return retCode;
    }

    public void updateValuesToFile(File sourceFile, File destinationFile, HashMap<String, String> map) {
        try {
            if (sourceFile.exists() && sourceFile.canRead()) {
                Set<String> keys;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));
                String line = "";
                if (map != null && (keys = map.keySet()) != null && keys.size() > 0) {
                    List<String> keyList = Arrays.asList(keys.toArray(new String[0]));
                    BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));
                    while ((line = reader.readLine()) != null) {
                        String[] lineContent = line.split("=");
                        if (keyList.contains(lineContent[0])) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append(lineContent[0]);
                            buffer.append("=");
                            buffer.append(map.get(lineContent[0]));
                            writer.write(buffer.toString());
                        } else {
                            writer.write(line);
                        }
                        writer.newLine();
                    }
                    writer.flush();
                    writer.close();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "IO Exception while replacing values in File", e);
        }
    }

    public String getWindowsShortPath(String longPath) {
        String loc = longPath;
        if (loc != null && loc.length() > 0) {
            Pattern pattern = Pattern.compile("\\s");
            Matcher matcher = pattern.matcher(loc);
            boolean found = matcher.find();
            if (found && PlatformInfo.getInstance().isWindows()) {
                loc = OiixFileOps.getWindowsShortFileName((String)longPath);
            }
            logger.log(Level.FINEST, "returning " + loc + " from getShortNameForLocation API");
        }
        return loc;
    }

    public static String getMountPoint(String path) {
        String mountPoint = null;
        if (path != null && !path.isEmpty()) {
            String lastExistingParent = null;
            try {
                lastExistingParent = FileInfo.getLastExistingParent(path);
            }
            catch (Exception e) {
                logger.warning("Failed to get the mountpoint of: " + path + ". Could not get the last existing parent.");
            }
            if (lastExistingParent != null && !lastExistingParent.isEmpty()) {
                if (PlatformInfo.getInstance().isWindows()) {
                    mountPoint = lastExistingParent;
                } else {
                    ProcessBuilder pb = new ProcessBuilder("df", "-P", lastExistingParent);
                    AbstractLineProcessor stdOutProcessor = new AbstractLineProcessor(){

                        public void processLine(String line, int lineNumber) {
                            this.getLines().add(line);
                            logger.info(line);
                        }
                    };
                    AbstractLineProcessor stdErrProcessor = new AbstractLineProcessor(){

                        public void processLine(String line, int lineNumber) {
                            this.getLines().add(line);
                            logger.info(line);
                        }
                    };
                    ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, (OutputProcessor)stdOutProcessor, (OutputProcessor)stdErrProcessor);
                    int exitCode = 0;
                    boolean succeeded = true;
                    try {
                        exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
                    }
                    catch (InterruptedException e) {
                        succeeded = false;
                        logger.warning(e.getMessage());
                    }
                    catch (IOException e) {
                        succeeded = false;
                        logger.warning(e.getMessage());
                    }
                    if (exitCode != 0) {
                        succeeded = false;
                    }
                    if (succeeded) {
                        List stdOutLines = stdOutProcessor.getLines();
                        if (stdOutLines != null && !stdOutLines.isEmpty()) {
                            String[] tokens = ((String)stdOutLines.get(stdOutLines.size() - 1)).split(" +");
                            if (tokens != null && tokens.length > 0) {
                                mountPoint = tokens[tokens.length - 1];
                            } else {
                                logger.warning("Failed to get the mountpoint of: " + path + ". Last line was empty.");
                                mountPoint = lastExistingParent;
                            }
                        } else {
                            logger.warning("Failed to get the mountpoint of: " + path + ". Stdout had no lines.");
                            mountPoint = lastExistingParent;
                        }
                    } else {
                        logger.warning("Failed to get the mountpoint of: " + path);
                        mountPoint = lastExistingParent;
                    }
                }
            } else {
                logger.warning("Failed to get the mountpoint of: " + path + ". Last existing parent was null or empty.");
            }
        } else {
            logger.warning("Failed to get the mountpoint of: " + path + ". Path was null or empty.");
        }
        return mountPoint;
    }

    public static ArrayList<String> getFilesWithDifferentOwner(String dir, String owner) {
        if (PlatformInfo.getInstance().isWindows()) {
            return null;
        }
        ArrayList<String> mismatchFiles = new ArrayList<String>();
        if (dir != null && !dir.isEmpty() && new File(dir).exists() && owner != null && !owner.isEmpty()) {
            List stdOutLines;
            ProcessBuilder pb = new ProcessBuilder("find", dir, "!", "-user", owner);
            AbstractLineProcessor stdOutProcessor = new AbstractLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    this.getLines().add(line);
                    logger.info(line);
                }
            };
            AbstractLineProcessor stdErrProcessor = new AbstractLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    this.getLines().add(line);
                    logger.info(line);
                }
            };
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, (OutputProcessor)stdOutProcessor, (OutputProcessor)stdErrProcessor);
            int exitCode = 0;
            boolean succeeded = true;
            try {
                exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (InterruptedException e) {
                succeeded = false;
                logger.warning(e.getMessage());
            }
            catch (IOException e) {
                succeeded = false;
                logger.warning(e.getMessage());
            }
            if (exitCode != 0) {
                succeeded = false;
            }
            if (!succeeded) {
                logger.warning("Command to get the files from '" + dir + "' not owned by '" + owner + "' failed.");
            }
            if ((stdOutLines = stdOutProcessor.getLines()) != null && !stdOutLines.isEmpty()) {
                for (String line : stdOutLines) {
                    if (line == null || line.isEmpty() || !new File(line).exists()) continue;
                    mismatchFiles.add(line);
                }
            }
        }
        return mismatchFiles;
    }

    public static ArrayList<String> getFileContentLines(String file) {
        ArrayList<String> lines = new ArrayList<String>();
        if (file != null && !file.isEmpty() && new File(file).exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                logger.warning("Could not find file: " + file + ": " + e.toString());
            }
            catch (IOException e) {
                logger.warning("Could not read file: " + file + ": " + e.toString());
            }
        } else {
            logger.warning("File " + file + " does not exist.");
        }
        return lines;
    }

    public static boolean appendTextToFile(String file, String text) {
        boolean succeed = false;
        if (text != null) {
            if (file != null) {
                File auxFile = new File(file);
                if (auxFile.exists()) {
                    if (auxFile.canWrite()) {
                        FileWriter fw = null;
                        try {
                            fw = new FileWriter(file, true);
                        }
                        catch (IOException e) {
                            logger.warning("Could not open the file " + file);
                        }
                        if (fw != null) {
                            try {
                                fw.write(text);
                                succeed = true;
                            }
                            catch (IOException e) {
                                logger.warning("Could not write to file " + file);
                            }
                            try {
                                fw.close();
                            }
                            catch (IOException e) {
                                logger.warning("Could not close to file " + file);
                            }
                        }
                    } else {
                        logger.warning("File " + file + " does not have write permissions.");
                    }
                } else {
                    logger.warning("File " + file + " does not exist.");
                }
            } else {
                logger.warning("File is null.");
            }
        } else {
            logger.warning("The text was null");
        }
        return succeed;
    }

    public static long getFileSizeBytes(File file) {
        long size = 0L;
        if (file != null) {
            if (file.isDirectory()) {
                File[] subFiles = null;
                try {
                    subFiles = file.listFiles();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the subfiles of: " + file.toString(), e);
                }
                if (subFiles != null && subFiles.length > 0) {
                    for (File subFile : subFiles) {
                        size += FileInfo.getFileSizeBytes(subFile);
                    }
                }
            } else if (file.isFile()) {
                return file.length();
            }
        }
        return size;
    }

    public static List<String> getNonReadableFiles(File file) {
        ArrayList<String> nonReadableFiles = new ArrayList<String>();
        if (file != null) {
            if (!file.canRead()) {
                nonReadableFiles.add(file.getPath());
            }
            if (file.isDirectory()) {
                File[] subFiles = null;
                try {
                    subFiles = file.listFiles();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the subfiles of: " + file.toString(), e);
                }
                if (subFiles != null && subFiles.length > 0) {
                    for (File subFile : subFiles) {
                        nonReadableFiles.addAll(FileInfo.getNonReadableFiles(subFile));
                    }
                }
            }
        }
        return nonReadableFiles;
    }

    public static List<String> getNonReadableFilesInDir(File topLevelFile, List<String> excludePaths, List<String> excludePathPatterns) {
        ArrayList<String> nonReadableFiles = new ArrayList<String>();
        if (topLevelFile != null) {
            logger.fine("Processing " + topLevelFile.getAbsolutePath());
            if (excludePaths == null || excludePaths.isEmpty() || excludePathPatterns == null || excludePathPatterns.isEmpty() || !excludePaths.contains(topLevelFile.getAbsolutePath()) && !FileInfo.regexMatch(topLevelFile.getAbsolutePath(), excludePathPatterns)) {
                if (topLevelFile.isDirectory()) {
                    if (!topLevelFile.canRead()) {
                        nonReadableFiles.add(topLevelFile.getPath());
                    } else {
                        File[] children = null;
                        try {
                            children = topLevelFile.listFiles();
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Could not get the subdirs of: " + children.toString(), e);
                        }
                        if (children != null && children.length > 0) {
                            for (File subDir : children) {
                                if (subDir == null) continue;
                                if (subDir.isDirectory()) {
                                    nonReadableFiles.addAll(FileInfo.getNonReadableFilesInDir(subDir, excludePaths, excludePathPatterns));
                                    continue;
                                }
                                if (!subDir.isFile() || excludePaths.contains(topLevelFile.getAbsolutePath()) || FileInfo.regexMatch(topLevelFile.getAbsolutePath(), excludePathPatterns) || subDir.canRead()) continue;
                                nonReadableFiles.add(subDir.getPath());
                            }
                        }
                    }
                } else if (topLevelFile.isFile() && !excludePaths.contains(topLevelFile.getAbsolutePath()) && !FileInfo.regexMatch(topLevelFile.getAbsolutePath(), excludePathPatterns) && !topLevelFile.canRead()) {
                    nonReadableFiles.add(topLevelFile.getPath());
                }
            }
        }
        return nonReadableFiles;
    }

    private static boolean regexMatch(String checkForMatch, List<String> regexList) {
        if (checkForMatch == null || checkForMatch.length() == 0 || regexList == null || regexList.isEmpty()) {
            return true;
        }
        for (String regex : regexList) {
            if (!Pattern.matches(regex, checkForMatch)) continue;
            logger.info("String : " + checkForMatch + " matches regex " + regex);
            return true;
        }
        return false;
    }
}

