/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.ivw.common.bean.RootConfigurationSettings;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.common.view.RootConfigurationMethodPane;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cvu.CVUHelper;

@ViewDef(id="RootConfigurationMethodUI")
public class RootConfigurationMethodUI
implements View {
    protected RootConfigurationMethodPane rootConfigPane = new RootConfigurationMethodPane();

    public void onEvent(FlowContext flowContext, EventType eventType) {
        RootConfigurationSettings configSettings = (RootConfigurationSettings)((Object)flowContext.getBean(RootConfigurationSettings.class));
        switch (eventType) {
            case INIT: {
                this.initialize(configSettings);
            }
        }
    }

    private void initialize(RootConfigurationSettings configSettings) {
        String powerBrokerUser;
        String sudoUser;
        String sudoPath;
        String value = PreferenceHelper.getProperty("oracle.install.rootAutomation.RootOption");
        if (value != null) {
            this.rootConfigPane.supportRootOption(Boolean.valueOf(value));
        }
        if ((value = PreferenceHelper.getProperty("oracle.install.rootAutomation.SudoOption")) != null) {
            this.rootConfigPane.supportSudoOption(Boolean.valueOf(value));
        }
        if ((value = PreferenceHelper.getProperty("oracle.install.rootAutomation.PBRunOption")) != null) {
            this.rootConfigPane.supportPBRunOption(Boolean.valueOf(value));
        }
        if (GenericValidation.isEmpty(sudoPath = configSettings.getSudoProgramPath())) {
            sudoPath = CVUHelper.getInstance().getSudoPath();
        }
        if (GenericValidation.isEmpty(sudoUser = configSettings.getSudoUserName())) {
            sudoUser = System.getProperty("user.name");
        }
        if (GenericValidation.isEmpty(powerBrokerUser = configSettings.getPowerBrokerUserName())) {
            powerBrokerUser = System.getProperty("user.name");
        }
        this.rootConfigPane.setSudoProgramPath(sudoPath);
        this.rootConfigPane.setSudoUser(sudoUser);
        this.rootConfigPane.setPBUser(powerBrokerUser);
        RootConfigurationSettings.ConfigMethod configMethod = configSettings.getConfigMethod();
        if (configMethod != null) {
            this.rootConfigPane.setConfigMethod(configMethod);
        } else {
            this.rootConfigPane.setConfigMethod(RootConfigurationSettings.ConfigMethod.DEFAULT);
        }
    }

    public void processInput(FlowContext flowContext) throws UncheckedValidationException {
        RootConfigurationSettings configSettings = (RootConfigurationSettings)((Object)flowContext.getBean(RootConfigurationSettings.class));
        RootConfigurationSettings.ConfigMethod configMethod = this.rootConfigPane.getConfigMethod();
        configSettings.setExecuteRootScript(configMethod != RootConfigurationSettings.ConfigMethod.DEFAULT);
        configSettings.setConfigMethod(configMethod);
        switch (configMethod) {
            case ROOT: {
                configSettings.setRootPassword(this.rootConfigPane.getRootPassword());
                break;
            }
            case SUDO: {
                configSettings.setSudoPassword(this.rootConfigPane.getSudoPassword());
                configSettings.setSudoUserName(this.rootConfigPane.getSudoUser());
                configSettings.setSudoProgramPath(this.rootConfigPane.getSudoProgramPath());
                break;
            }
            case PB: {
                configSettings.setPbPassword(this.rootConfigPane.getPBPassword());
                configSettings.setPowerBrokerUserName(this.rootConfigPane.getPBUser());
                configSettings.setPowerBrokerPath(this.rootConfigPane.getPBPath());
            }
        }
        this.invalidateSudoAndRootCredentials(flowContext);
    }

    private void invalidateSudoAndRootCredentials(FlowContext flowContext) {
        List<String> clusterConfigNodes;
        RootConfigurationSettings.ConfigMethod configMethod = this.rootConfigPane.getConfigMethod();
        CVUHelper cvuHelper = CVUHelper.getInstance();
        ArrayList<String> publicNodes = new ArrayList<String>();
        ClusterConfig clusterConfig = (ClusterConfig)((Object)flowContext.getBean(ClusterConfig.class));
        if (clusterConfig != null && (clusterConfigNodes = clusterConfig.getPublicNodeNames(false)) != null && !clusterConfigNodes.isEmpty()) {
            publicNodes.addAll(clusterConfigNodes);
        }
        boolean isLocalHostInList = false;
        MachineInfo machineInfo = MachineInfo.getInstance();
        for (String node : publicNodes) {
            if (!machineInfo.isLocalHost(node)) continue;
            isLocalHostInList = true;
            break;
        }
        if (!isLocalHostInList) {
            publicNodes.add(0, machineInfo.getLocalMachineName());
        }
        String[] nodeList = publicNodes.toArray(new String[publicNodes.size()]);
        if (configMethod != null) {
            if (configMethod != RootConfigurationSettings.ConfigMethod.SUDO) {
                cvuHelper.invalidateSudoCredentialsCache(nodeList);
            }
            if (configMethod != RootConfigurationSettings.ConfigMethod.ROOT) {
                cvuHelper.deleteRootExecutionInfo();
            }
        }
    }

    public Component getView() {
        return this.rootConfigPane;
    }

    public void localize(FlowContext flowContext) {
        this.rootConfigPane.localize();
    }
}

