/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.InstallerPatchBean;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.InventoryInfo;

public class InstallerPatchValidator {
    private InstallerPatchBean installerPatchBean;
    private static Logger logger = Logger.getLogger(InstallerPatchValidator.class.getName());
    private final String instUpdPrefix = "inst";
    private final boolean isWindows = PlatformInfo.getInstance().isWindows();

    public InstallerPatchValidator(InstallerPatchBean installerPatchBean) {
        this.installerPatchBean = installerPatchBean;
    }

    public void validate() throws ValidationException {
        if (this.installerPatchBean.isApplyingInstallerUpdates()) {
            this.validateInstallerUpdates();
        }
        if (this.installerPatchBean.isApplyingPSU()) {
            this.validateApplyPSU();
        }
        if (this.installerPatchBean.isApplyingOneOffs()) {
            this.validateApplyOneOffs();
        }
        if (this.installerPatchBean.isUpdatingOpatch()) {
            this.validateUpdateOpatch();
        }
    }

    private void validateInstallerUpdates() throws ValidationException {
        this.validateOracleHomeNotLocked();
        String[] installerUpdatesPaths = this.installerPatchBean.getInstallerUpdatesPaths();
        if (installerUpdatesPaths != null && installerUpdatesPaths.length > 0) {
            for (String installerUpdate : installerUpdatesPaths) {
                this.validateInstallerUpdate(installerUpdate);
                this.validateUpdateApplicable(installerUpdate);
            }
        }
    }

    private void validateApplyPSU() throws ValidationException {
        boolean isHomeRegistered;
        String psuPath = this.installerPatchBean.getPsuPath();
        String oracleHome = this.installerPatchBean.getOracleHome();
        if (this.isWindows) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_PSU_NOT_SUPPORTED_PLATFORM, new Object[0]);
        }
        InventoryInfo invInfo = InventoryInfo.getInstance();
        if (invInfo.isInventoryExist() && (isHomeRegistered = invInfo.isHomeWithLocationExist(oracleHome))) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_PSU_HOME_REGISTERED, new Object[]{oracleHome});
        }
        if (psuPath == null || psuPath.isEmpty()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_PSU_EMPTY_PATCH_PATH, new Object[]{"-applyPSU"});
        }
        if (psuPath.split(",").length > 1) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_PSU_MULTIPLE_PSU_PATCH_PATHS, new Object[]{"-applyPSU"});
        }
        File psuPathFile = null;
        try {
            psuPathFile = new File(psuPath);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{psuPath});
        }
        if (psuPathFile == null || !psuPathFile.exists()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_PSU_PATCH_PATH_NOT_EXISTS, new Object[]{psuPath, "-applyPSU"});
        }
        File psuPathBundleFile = null;
        String psuPathBundle = psuPath + File.separator + "bundle.xml";
        try {
            psuPathBundleFile = new File(psuPathBundle);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{psuPathBundle});
        }
        if (psuPathBundleFile == null || !psuPathBundleFile.exists()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_PSU_PATCH_PATH_NOT_EXISTS, new Object[]{psuPathBundle, "-applyPSU"});
        }
    }

    private void validateApplyOneOffs() throws ValidationException {
        boolean isHomeRegistered;
        String[] oneOffsPaths = this.installerPatchBean.getOneOffsPaths();
        String oracleHome = this.installerPatchBean.getOracleHome();
        InventoryInfo invInfo = InventoryInfo.getInstance();
        if (invInfo.isInventoryExist() && (isHomeRegistered = invInfo.isHomeWithLocationExist(oracleHome))) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_ONEOFFS_HOME_REGISTERED, new Object[]{oracleHome});
        }
        if (oneOffsPaths == null || oneOffsPaths.length == 0) {
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_ONEOFFS_EMPTY_PATCH_PATH, new Object[]{"-applyOneOffs"});
        }
        for (int i = 0; i < oneOffsPaths.length; ++i) {
            String oneOffPath = oneOffsPaths[i];
            if (oneOffPath == null || oneOffPath.isEmpty()) {
                throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_ONEOFFS_EMPTY_PATCH_PATH, new Object[]{"-applyOneOffs"});
            }
            File oneOffPathFile = null;
            try {
                oneOffPathFile = new File(oneOffPath);
            }
            catch (Exception e) {
                throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{oneOffPath});
            }
            if (oneOffPathFile == null || !oneOffPathFile.exists()) {
                throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_ONEOFFS_PATCH_PATH_NOT_EXISTS, new Object[]{oneOffPath, "-applyOneOffs"});
            }
            if (i >= oneOffsPaths.length + 2) continue;
            for (int j = i + 1; j < oneOffsPaths.length; ++j) {
                String nextOneOffPath = oneOffsPaths[j];
                File nextPath = null;
                try {
                    nextPath = new File(nextOneOffPath);
                }
                catch (Exception e) {
                    throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{nextOneOffPath});
                }
                if (nextPath == null) continue;
                boolean duplicated = false;
                try {
                    duplicated = Files.isSameFile(oneOffPathFile.toPath(), nextPath.toPath());
                }
                catch (IOException e) {
                    throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{nextOneOffPath});
                }
                if (!duplicated) continue;
                throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_ONEOFFS_DUPLICATE_PATCH_PATHS, new Object[]{"-applyOneOffs"});
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateUpdateOpatch() throws ValidationException {
        List<String> nonReadableFiles;
        String opatchLoc = this.installerPatchBean.getOpatchLoc();
        if (!this.installerPatchBean.isApplyingPSU() && !this.installerPatchBean.isApplyingOneOffs()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_NO_PSU_OR_ONEOFFS, new Object[0]);
        }
        if (opatchLoc == null || opatchLoc.isEmpty()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_EMPTY_OPATCH_PATCH, new Object[]{"-opatchLocation"});
        }
        File opatchLocFile = null;
        try {
            opatchLocFile = new File(opatchLoc);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{opatchLoc});
        }
        if (opatchLocFile == null || !opatchLocFile.exists()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_PATH_NOT_EXISTS, new Object[]{opatchLoc, "-opatchLocation"});
        }
        if (!opatchLocFile.isDirectory()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_PATH_NOT_DIRECTORY, new Object[]{"-opatchLocation"});
        }
        String opatchBinary = "opatch";
        if (this.isWindows) {
            opatchBinary = "opatch.bat";
        }
        String opatchBinaryPath = opatchLoc + File.separator + opatchBinary;
        File opatchBinaryFile = null;
        try {
            opatchBinaryFile = new File(opatchBinaryPath);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{opatchBinaryPath});
        }
        if (opatchBinaryFile == null || !opatchBinaryFile.exists()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_PATH_NOT_VALID, new Object[]{opatchBinary, opatchLoc});
        }
        if (!this.isWindows && (nonReadableFiles = FileInfo.getNonReadableFiles(opatchLocFile)) != null && !nonReadableFiles.isEmpty()) {
            String userName = System.getProperty("user.name");
            throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_PATH_CONTAINS_NONREADABLE_FILES, new Object[]{opatchLoc, userName});
        }
        if (this.installerPatchBean.isSkipOpatchVersionCheck()) return;
        String oracleHome = this.installerPatchBean.getOracleHome();
        String ohOpatch = oracleHome + File.separator + "OPatch";
        String currentVersion = this.getOPatchVersion(ohOpatch, opatchBinary);
        if (currentVersion == null) throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_COULD_NOT_GET_VERSION, new Object[]{ohOpatch});
        String newVersion = this.getOPatchVersion(opatchLoc, opatchBinary);
        if (newVersion == null) throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_COULD_NOT_GET_VERSION, new Object[]{opatchLoc});
        Version currentVer = null;
        try {
            currentVer = Version.parseVersion((String)currentVersion);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.UPDATE_OPATCH_COULD_NOT_GET_VERSION, new Object[]{ohOpatch});
        }
        if (currentVer == null) return;
        Version newVer = null;
        try {
            newVer = Version.parseVersion((String)newVersion);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.UPDATE_OPATCH_COULD_NOT_GET_VERSION, new Object[]{opatchLoc});
        }
        if (newVer == null || newVer.compareTo(currentVer) >= 0) return;
        throw new ValidationException((ErrorCode)CommonErrorCode.UPDATE_OPATCH_LOWER_VERSION, new Object[]{opatchLoc, newVersion, oracleHome, currentVersion});
    }

    private String getOPatchVersion(String opatchLoc, String opatchBinary) {
        List outLines;
        String version = null;
        ProcessBuilder pb = new ProcessBuilder(opatchLoc + File.separator + opatchBinary, "version");
        AbstractLineProcessor stdoutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
            }
        };
        AbstractLineProcessor stderrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
            }
        };
        ProcessLaunchInfo pli = new ProcessLaunchInfo(pb, (OutputProcessor)stdoutProcessor, (OutputProcessor)stderrProcessor);
        int exitCode = 0;
        ProcessLauncher pl = ProcessLauncher.getInstance();
        try {
            exitCode = pl.launchProcess(pli);
        }
        catch (Exception e) {
            exitCode = Application.CommonExitStatus.FAILURE.getIntValue();
        }
        if (stdoutProcessor.getLines() != null && !stdoutProcessor.getLines().isEmpty()) {
            logger.log(Level.INFO, stdoutProcessor.getLines().toString());
        }
        if (stderrProcessor.getLines() != null && !stderrProcessor.getLines().isEmpty()) {
            logger.log(Level.WARNING, stderrProcessor.getLines().toString());
        }
        if (exitCode == 0 && (outLines = stdoutProcessor.getLines()) != null && !outLines.isEmpty()) {
            String firstLine = (String)stdoutProcessor.getLines().get(0);
            String versionLinePrefix = "OPatch Version: ";
            version = firstLine.substring(versionLinePrefix.length());
        }
        return version;
    }

    private void validateUpdateApplicable(String installerUpdate) throws ValidationException {
        File[] files;
        String filesLoc = installerUpdate + File.separator + "files";
        File filesLocFile = new File(filesLoc);
        for (File file : files = filesLocFile.listFiles()) {
            List<String> nonCopyableFiles = this.validateFileCopyRecursive(file, installerUpdate, filesLoc);
            if (nonCopyableFiles == null || nonCopyableFiles.isEmpty()) continue;
            throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_INSTALLER_UPDATES_CANNOT_COPY, new Object[]{installerUpdate, nonCopyableFiles});
        }
    }

    private List<String> validateFileCopyRecursive(File file, String installerUpdate, String filesLoc) throws ValidationException {
        String oracleHome = this.installerPatchBean.getOracleHome();
        ArrayList<String> nonCopyableFiles = new ArrayList<String>();
        if (file != null) {
            if (file.isDirectory()) {
                File[] subFiles = null;
                try {
                    subFiles = file.listFiles();
                }
                catch (Exception e) {
                    throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{file.getAbsolutePath()});
                }
                if (subFiles != null && subFiles.length > 0) {
                    for (File subFile : subFiles) {
                        nonCopyableFiles.addAll(this.validateFileCopyRecursive(subFile, installerUpdate, filesLoc));
                    }
                }
            } else {
                String filePath = file.getAbsolutePath();
                String relPath = filePath.substring(filesLoc.length() + 1);
                String destPath = oracleHome + File.separator + relPath;
                String destPathLastExistingParent = FileInfo.getLastExistingParent(destPath);
                File destPathLastExistingParentFile = null;
                try {
                    destPathLastExistingParentFile = new File(destPathLastExistingParent);
                }
                catch (Exception e) {
                    throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{destPathLastExistingParent});
                }
                if (destPathLastExistingParentFile != null && !destPathLastExistingParentFile.canWrite()) {
                    nonCopyableFiles.add(filePath);
                }
            }
        }
        return nonCopyableFiles;
    }

    private void validateInstallerUpdate(String installerUpdate) throws ValidationException {
        if (installerUpdate != null && !installerUpdate.isEmpty()) {
            List<String> nonReadableFiles;
            File installerUpdateFile = null;
            try {
                installerUpdateFile = new File(installerUpdate);
            }
            catch (Exception e) {
                throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{installerUpdate});
            }
            if (installerUpdateFile != null && (nonReadableFiles = FileInfo.getNonReadableFiles(installerUpdateFile)) != null && !nonReadableFiles.isEmpty()) {
                throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_INSTALLER_UPDATES_NON_READABLE_FILES, new Object[]{installerUpdate, nonReadableFiles});
            }
            boolean instUpdFound = false;
            String installLoc = installerUpdate + File.separator + "files" + File.separator + "install";
            File installLocFile = null;
            try {
                installLocFile = new File(installLoc);
            }
            catch (Exception e) {
                throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{installLoc});
            }
            if (installLocFile != null) {
                if (installLocFile.exists() && installLocFile.isDirectory()) {
                    String[] installFiles = installLocFile.list();
                    if (installFiles != null && installFiles.length > 0) {
                        for (String installFile : installFiles) {
                            if (installFile == null || !installFile.startsWith(this.instUpdPrefix)) continue;
                            instUpdFound = true;
                            break;
                        }
                    }
                } else {
                    throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_INSTALLER_UPDATES_IS_ONE_OFF, new Object[]{installerUpdate, "-applyInstallerUpdates", "-applyOneOffs"});
                }
            }
            if (!instUpdFound) {
                throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_INSTALLER_UPDATES_IS_ONE_OFF, new Object[]{installerUpdate, "-applyInstallerUpdates", "-applyOneOffs"});
            }
        }
    }

    private void validateOracleHomeNotLocked() throws ValidationException {
        String oracleHome = this.installerPatchBean.getOracleHome();
        String[] installerUpdatesPaths = this.installerPatchBean.getInstallerUpdatesPaths();
        if (!this.isWindows) {
            String[] paths;
            for (String path : paths = new String[]{oracleHome, oracleHome + File.separator + "lib", oracleHome + File.separator + "bin"}) {
                File pathFile = null;
                try {
                    pathFile = new File(path);
                }
                catch (Exception e) {
                    throw new ValidationException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_FILE_OBJECT_EXCEPTION, new Object[]{path});
                }
                if (pathFile == null || pathFile.canWrite()) continue;
                throw new ValidationException((ErrorCode)CommonErrorCode.APPLY_INSTALLER_UPDATES_HOME_IS_LOCKED, new Object[]{Arrays.asList(installerUpdatesPaths), oracleHome});
            }
        }
    }
}

